/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef NLAMAROK_H
#define NLAMAROK_H

#include <QObject>
#include <QProcess>
#include <QTimer>

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class NLAmarok : public QObject
{
  Q_OBJECT

  private:
    bool          m_updated;
    QTimer*       m_updateTimer;
    QProcess*     m_processArtist;
    QProcess*     m_processAlbum;
    QProcess*     m_processTitle;
    QString       m_artist;
    QString       m_album;
    QString       m_title;
    int           m_nRequests;

  public:
    NLAmarok(QObject *parent = 0);
    ~NLAmarok();

    const QString & artist() const {return m_artist;}
    const QString & album () const {return m_album ;}
    const QString & title () const {return m_title ;}

    void requestArtist();
    void requestAlbum ();
    void requestTitle ();

  public slots:
    void updateAlbum (int);
    void updateArtist(int);
    void updateTitle (int);
    void update(){if(!m_nRequests){requestArtist(); requestAlbum (); requestTitle ();}}

  signals:
    void updated(const QString &, const QString &, const QString &);
};

#endif
