/***************************************************************************
                          camera.h  -  description
                             -------------------
    begin                : Sat May 10 2003
    copyright            : (C) 2003-2007 by Roland Schwarz
    email                : roland.schwarz@chello.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CAMERA_H
#define CAMERA_H

/**Camera manipulator class for use with plib. Featuring zoom-to-point and tilt about object point.
  *@author Roland Schwarz
  */

#include <plib/ssg.h>

class Camera : public ssgContext {
public: 
  Camera();
  ~Camera();
  void setFOV(const float fovy);
  void setAspect(const float a);
  void setPOI(const sgVec3 p);
  void setPOI(const int x, const int y);

  int  getPOI(sgVec3* eye);
  void getEyePoint(sgVec3* point);
     
  void tilt(const SGfloat a, const sgVec3 axis = Yaxis);
  void tiltglobal(const SGfloat a, const sgVec3 axis = Yaxis);
  void pan(const int x, const int y);
  void walk(const SGfloat d);
  
  static const sgVec3 Xaxis, Yaxis, Zaxis;


protected:
  sgVec3 POI; // point of interest
  int valid;
private:  
  void translate(const sgVec3 dist);
  void rotate(const SGfloat a, const sgVec3 axis);
  void unproject(sgVec3* upt, const sgVec3 pt);
};

#endif
