# Copyright 2010 Michael Murr
#
# This file is part of LibForensics.
#
# LibForensics is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# LibForensics is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with LibForensics.  If not, see <http://www.gnu.org/licenses/>.

"""Constants for Locale IDs. (LCIDs)"""

__docformat__ = "restructuredtext en"
__all__ = [
    "LANGID_AFRIKAANS", "LANGID_ALBANIAN", "LANGID_AMHARIC", "LANGID_ARABIC",
    "LANGID_ARABIC_ALGERIA", "LANGID_ARABIC_BAHRAIN", "LANGID_ARABIC_EGYPT",
    "LANGID_ARABIC_IRAQ", "LANGID_ARABIC_JORDAN", "LANGID_ARABIC_KUWAIT",
    "LANGID_ARABIC_LEBANON", "LANGID_ARABIC_LIBYA", "LANGID_ARABIC_MOROCCO",
    "LANGID_ARABIC_OMAN", "LANGID_ARABIC_QATAR", "LANGID_ARABIC_SYRIA",
    "LANGID_ARABIC_TUNISIA", "LANGID_ARABIC_UAE", "LANGID_ARABIC_YEMEN",
    "LANGID_ARMENIAN", "LANGID_ASSAMESE", "LANGID_AZERI_CYRILLIC",
    "LANGID_AZERI_LATIN", "LANGID_BASQUE", "LANGID_BELGIAN_DUTCH",
    "LANGID_BELGIAN_FRENCH", "LANGID_BENGALI", "LANGID_BULGARIAN",
    "LANGID_BURMESE", "LANGID_BYELORUSSIAN", "LANGID_CATALAN",
    "LANGID_CHEROKEE", "LANGID_CHINESE_HONG_KONG_SAR",
    "LANGID_CHINESE_MACAO_SAR", "LANGID_CHINESE_SINGAPORE", "LANGID_CROATIAN",
    "LANGID_CZECH", "LANGID_DANISH", "LANGID_DIVEHI", "LANGID_DUTCH",
    "LANGID_EDO", "LANGID_ENGLISH_AUS", "LANGID_ENGLISH_BELIZE",
    "LANGID_ENGLISH_CANADIAN", "LANGID_ENGLISH_CARIBBEAN",
    "LANGID_ENGLISH_INDONESIA", "LANGID_ENGLISH_IRELAND",
    "LANGID_ENGLISH_JAMAICA", "LANGID_ENGLISH_NEW_ZEALAND",
    "LANGID_ENGLISH_PHILIPPINES", "LANGID_ENGLISH_SOUTH_AFRICA",
    "LANGID_ENGLISH_TRINIDAD_TOBAGO", "LANGID_ENGLISH_UK", "LANGID_ENGLISH_US",
    "LANGID_ENGLISH_ZIMBABWE", "LANGID_ESTONIAN", "LANGID_FAEROESE",
    "LANGID_FILIPINO", "LANGID_FINNISH", "LANGID_FRENCH",
    "LANGID_FRENCH_CAMEROON", "LANGID_FRENCH_CANADIAN",
    "LANGID_FRENCH_CONGO_D_R_C", "LANGID_FRENCH_COTED_IVOIRE",
    "LANGID_FRENCH_HAITI", "LANGID_FRENCH_LUXEMBOURG", "LANGID_FRENCH_MALI",
    "LANGID_FRENCH_MONACO", "LANGID_FRENCH_MOROCCO", "LANGID_FRENCH_REUNION",
    "LANGID_FRENCH_SENEGAL", "LANGID_FRENCH_WEST_INDIES",
    "LANGID_FRISIAN_NETHERLANDS", "LANGID_FULFULDE", "LANGID_GAELIC_IRELAND",
    "LANGID_GAELIC_SCOTLAND", "LANGID_GALICIAN", "LANGID_GEORGIAN",
    "LANGID_GERMAN", "LANGID_GERMAN_AUSTRIA", "LANGID_GERMAN_LIECHTENSTEIN",
    "LANGID_GERMAN_LUXEMBOURG", "LANGID_GREEK", "LANGID_GUARANI",
    "LANGID_GUJARATI", "LANGID_HAUSA", "LANGID_HAWAIIAN", "LANGID_HEBREW",
    "LANGID_HINDI", "LANGID_HUNGARIAN", "LANGID_IBIBIO", "LANGID_ICELANDIC",
    "LANGID_IGBO", "LANGID_INDONESIAN", "LANGID_INUKTITUT", "LANGID_ITALIAN",
    "LANGID_JAPANESE", "LANGID_KANNADA", "LANGID_KANURI", "LANGID_KASHMIRI",
    "LANGID_KAZAKH", "LANGID_KHMER", "LANGID_KIRGHIZ", "LANGID_KONKANI",
    "LANGID_KOREAN", "LANGID_KYRGYZ", "LANGID_LANGUAGE_NONE", "LANGID_LAO",
    "LANGID_LATIN", "LANGID_LATVIAN", "LANGID_LITHUANIAN",
    "LANGID_MACEDONIAN_FYROM", "LANGID_MALAYALAM", "LANGID_MALAYSIAN",
    "LANGID_MALAY_BRUNEI_DARUSSALAM", "LANGID_MALTESE", "LANGID_MANIPURI",
    "LANGID_MARATHI", "LANGID_MEXICAN_SPANISH", "LANGID_MONGOLIAN",
    "LANGID_NEPALI", "LANGID_NORWEGIAN_BOKMOL", "LANGID_NORWEGIAN_NYNORSK",
    "LANGID_NO_PROOFING", "LANGID_ORIYA", "LANGID_OROMO", "LANGID_PASHTO",
    "LANGID_PERSIAN", "LANGID_POLISH", "LANGID_PORTUGUESE",
    "LANGID_PORTUGUESE_BRAZIL", "LANGID_PUNJABI", "LANGID_RHAETO_ROMANIC",
    "LANGID_ROMANIAN", "LANGID_ROMANIAN_MOLDOVA", "LANGID_RUSSIAN",
    "LANGID_RUSSIAN_MOLDOVA", "LANGID_SAMI_LAPPISH", "LANGID_SANSKRIT",
    "LANGID_SERBIAN_CYRILLIC", "LANGID_SERBIAN_LATIN", "LANGID_SESOTHO",
    "LANGID_SIMPLIFIED_CHINESE", "LANGID_SINDHI", "LANGID_SINDHI_PAKISTAN",
    "LANGID_SINHALESE", "LANGID_SLOVAK", "LANGID_SLOVENIAN", "LANGID_SOMALI",
    "LANGID_SORBIAN", "LANGID_SPANISH", "LANGID_SPANISH_ARGENTINA",
    "LANGID_SPANISH_BOLIVIA", "LANGID_SPANISH_CHILE",
    "LANGID_SPANISH_COLOMBIA", "LANGID_SPANISH_COSTA_RICA",
    "LANGID_SPANISH_DOMINICAN_REPUBLIC", "LANGID_SPANISH_ECUADOR",
    "LANGID_SPANISH_EL_SALVADOR", "LANGID_SPANISH_GUATEMALA",
    "LANGID_SPANISH_HONDURAS", "LANGID_SPANISH_MODERN_SORT",
    "LANGID_SPANISH_NICARAGUA", "LANGID_SPANISH_PANAMA",
    "LANGID_SPANISH_PARAGUAY", "LANGID_SPANISH_PERU",
    "LANGID_SPANISH_PUERTO_RICO", "LANGID_SPANISH_URUGUAY",
    "LANGID_SPANISH_VENEZUELA", "LANGID_SUTU", "LANGID_SWAHILI",
    "LANGID_SWEDISH", "LANGID_SWEDISH_FINLAND", "LANGID_SWISS_FRENCH",
    "LANGID_SWISS_GERMAN", "LANGID_SWISS_ITALIAN", "LANGID_SYRIAC",
    "LANGID_TAJIK", "LANGID_TAMAZIGHT", "LANGID_TAMAZIGHT_LATIN",
    "LANGID_TAMIL", "LANGID_TATAR", "LANGID_TELUGU", "LANGID_THAI",
    "LANGID_TIBETAN", "LANGID_TIGRIGNA_ERITREA", "LANGID_TIGRIGNA_ETHIOPIC",
    "LANGID_TRADITIONAL_CHINESE", "LANGID_TSONGA", "LANGID_TSWANA",
    "LANGID_TURKISH", "LANGID_TURKMEN", "LANGID_UKRAINIAN", "LANGID_URDU",
    "LANGID_UZBEK_CYRILLIC", "LANGID_UZBEK_LATIN", "LANGID_VENDA",
    "LANGID_VIETNAMESE", "LANGID_WELSH", "LANGID_XHOSA", "LANGID_YI",
    "LANGID_YIDDISH", "LANGID_YORUBA", "LANGID_ZULU",

    "lang_id_names"
]

LANGID_AFRIKAANS = 1078
LANGID_ALBANIAN = 1052
LANGID_AMHARIC = 1118
LANGID_ARABIC = 1025
LANGID_ARABIC_ALGERIA = 5121
LANGID_ARABIC_BAHRAIN = 15361
LANGID_ARABIC_EGYPT = 3073
LANGID_ARABIC_IRAQ = 2049
LANGID_ARABIC_JORDAN = 11265
LANGID_ARABIC_KUWAIT = 13313
LANGID_ARABIC_LEBANON = 12289
LANGID_ARABIC_LIBYA = 4097
LANGID_ARABIC_MOROCCO = 6145
LANGID_ARABIC_OMAN = 8193
LANGID_ARABIC_QATAR = 16385
LANGID_ARABIC_SYRIA = 10241
LANGID_ARABIC_TUNISIA = 7169
LANGID_ARABIC_UAE = 14337
LANGID_ARABIC_YEMEN = 9217
LANGID_ARMENIAN = 1067
LANGID_ASSAMESE = 1101
LANGID_AZERI_CYRILLIC = 2092
LANGID_AZERI_LATIN = 1068
LANGID_BASQUE = 1069
LANGID_BELGIAN_DUTCH = 2067
LANGID_BELGIAN_FRENCH = 2060
LANGID_BENGALI = 1093
LANGID_BULGARIAN = 1026
LANGID_BURMESE = 1109
LANGID_BYELORUSSIAN = 1059
LANGID_CATALAN = 1027
LANGID_CHEROKEE = 1116
LANGID_CHINESE_HONG_KONG_SAR = 3076
LANGID_CHINESE_MACAO_SAR = 5124
LANGID_CHINESE_SINGAPORE = 4100
LANGID_CROATIAN = 1050
LANGID_CZECH = 1029
LANGID_DANISH = 1030
LANGID_DIVEHI = 1125
LANGID_DUTCH = 1043
LANGID_EDO = 1126
LANGID_ENGLISH_AUS = 3081
LANGID_ENGLISH_BELIZE = 10249
LANGID_ENGLISH_CANADIAN = 4105
LANGID_ENGLISH_CARIBBEAN = 9225
LANGID_ENGLISH_INDONESIA = 14345
LANGID_ENGLISH_IRELAND = 6153
LANGID_ENGLISH_JAMAICA = 8201
LANGID_ENGLISH_NEW_ZEALAND = 5129
LANGID_ENGLISH_PHILIPPINES = 13321
LANGID_ENGLISH_SOUTH_AFRICA = 7177
LANGID_ENGLISH_TRINIDAD_TOBAGO = 11273
LANGID_ENGLISH_UK = 2057
LANGID_ENGLISH_US = 1033
LANGID_ENGLISH_ZIMBABWE = 12297
LANGID_ESTONIAN = 1061
LANGID_FAEROESE = 1080
LANGID_FILIPINO = 1124
LANGID_FINNISH = 1035
LANGID_FRENCH = 1036
LANGID_FRENCH_CAMEROON = 11276
LANGID_FRENCH_CANADIAN = 3084
LANGID_FRENCH_CONGO_D_R_C = 9228
LANGID_FRENCH_COTED_IVOIRE = 12300
LANGID_FRENCH_HAITI = 15372
LANGID_FRENCH_LUXEMBOURG = 5132
LANGID_FRENCH_MALI = 13324
LANGID_FRENCH_MONACO = 6156
LANGID_FRENCH_MOROCCO = 14348
LANGID_FRENCH_REUNION = 8204
LANGID_FRENCH_SENEGAL = 10252
LANGID_FRENCH_WEST_INDIES = 7180
LANGID_FRISIAN_NETHERLANDS = 1122
LANGID_FULFULDE = 1127
LANGID_GAELIC_IRELAND = 2108
LANGID_GAELIC_SCOTLAND = 1084
LANGID_GALICIAN = 1110
LANGID_GEORGIAN = 1079
LANGID_GERMAN = 1031
LANGID_GERMAN_AUSTRIA = 3079
LANGID_GERMAN_LIECHTENSTEIN = 5127
LANGID_GERMAN_LUXEMBOURG = 4103
LANGID_GREEK = 1032
LANGID_GUARANI = 1140
LANGID_GUJARATI = 1095
LANGID_HAUSA = 1128
LANGID_HAWAIIAN = 1141
LANGID_HEBREW = 1037
LANGID_HINDI = 1081
LANGID_HUNGARIAN = 1038
LANGID_IBIBIO = 1129
LANGID_ICELANDIC = 1039
LANGID_IGBO = 1136
LANGID_INDONESIAN = 1057
LANGID_INUKTITUT = 1117
LANGID_ITALIAN = 1040
LANGID_JAPANESE = 1041
LANGID_KANNADA = 1099
LANGID_KANURI = 1137
LANGID_KASHMIRI = 1120
LANGID_KAZAKH = 1087
LANGID_KHMER = 1107
LANGID_KIRGHIZ = 1088
LANGID_KONKANI = 1111
LANGID_KOREAN = 1042
LANGID_KYRGYZ = 1088
LANGID_LANGUAGE_NONE = 0
LANGID_LAO = 1108
LANGID_LATIN = 1142
LANGID_LATVIAN = 1062
LANGID_LITHUANIAN = 1063
LANGID_MACEDONIAN_FYROM = 1071
LANGID_MALAYALAM = 1100
LANGID_MALAY_BRUNEI_DARUSSALAM = 2110
LANGID_MALAYSIAN = 1086
LANGID_MALTESE = 1082
LANGID_MANIPURI = 1112
LANGID_MARATHI = 1102
LANGID_MEXICAN_SPANISH = 2058
LANGID_MONGOLIAN = 1104
LANGID_NEPALI = 1121
LANGID_NO_PROOFING = 1024
LANGID_NORWEGIAN_BOKMOL = 1044
LANGID_NORWEGIAN_NYNORSK = 2068
LANGID_ORIYA = 1096
LANGID_OROMO = 1138
LANGID_PASHTO = 1123
LANGID_PERSIAN = 1065
LANGID_POLISH = 1045
LANGID_PORTUGUESE = 2070
LANGID_PORTUGUESE_BRAZIL = 1046
LANGID_PUNJABI = 1094
LANGID_RHAETO_ROMANIC = 1047
LANGID_ROMANIAN = 1048
LANGID_ROMANIAN_MOLDOVA = 2072
LANGID_RUSSIAN = 1049
LANGID_RUSSIAN_MOLDOVA = 2073
LANGID_SAMI_LAPPISH = 1083
LANGID_SANSKRIT = 1103
LANGID_SERBIAN_CYRILLIC = 3098
LANGID_SERBIAN_LATIN = 2074
LANGID_SESOTHO = 1072
LANGID_SIMPLIFIED_CHINESE = 2052
LANGID_SINDHI = 1113
LANGID_SINDHI_PAKISTAN = 2137
LANGID_SINHALESE = 1115
LANGID_SLOVAK = 1051
LANGID_SLOVENIAN = 1060
LANGID_SOMALI = 1143
LANGID_SORBIAN = 1070
LANGID_SPANISH = 1034
LANGID_SPANISH_ARGENTINA = 11274
LANGID_SPANISH_BOLIVIA = 16394
LANGID_SPANISH_CHILE = 13322
LANGID_SPANISH_COLOMBIA = 9226
LANGID_SPANISH_COSTA_RICA = 5130
LANGID_SPANISH_DOMINICAN_REPUBLIC = 7178
LANGID_SPANISH_ECUADOR = 12298
LANGID_SPANISH_EL_SALVADOR = 17418
LANGID_SPANISH_GUATEMALA = 4106
LANGID_SPANISH_HONDURAS = 18442
LANGID_SPANISH_MODERN_SORT = 3082
LANGID_SPANISH_NICARAGUA = 19466
LANGID_SPANISH_PANAMA = 6154
LANGID_SPANISH_PARAGUAY = 15370
LANGID_SPANISH_PERU = 10250
LANGID_SPANISH_PUERTO_RICO = 20490
LANGID_SPANISH_URUGUAY = 14346
LANGID_SPANISH_VENEZUELA = 8202
LANGID_SUTU = 1072
LANGID_SWAHILI = 1089
LANGID_SWEDISH = 1053
LANGID_SWEDISH_FINLAND = 2077
LANGID_SWISS_FRENCH = 4108
LANGID_SWISS_GERMAN = 2055
LANGID_SWISS_ITALIAN = 2064
LANGID_SYRIAC = 1114
LANGID_TAJIK = 1064
LANGID_TAMAZIGHT = 1119
LANGID_TAMAZIGHT_LATIN = 2143
LANGID_TAMIL = 1097
LANGID_TATAR = 1092
LANGID_TELUGU = 1098
LANGID_THAI = 1054
LANGID_TIBETAN = 1105
LANGID_TIGRIGNA_ERITREA = 2163
LANGID_TIGRIGNA_ETHIOPIC = 1139
LANGID_TRADITIONAL_CHINESE = 1028
LANGID_TSONGA = 1073
LANGID_TSWANA = 1074
LANGID_TURKISH = 1055
LANGID_TURKMEN = 1090
LANGID_UKRAINIAN = 1058
LANGID_URDU = 1056
LANGID_UZBEK_CYRILLIC = 2115
LANGID_UZBEK_LATIN = 1091
LANGID_VENDA = 1075
LANGID_VIETNAMESE = 1066
LANGID_WELSH = 1106
LANGID_XHOSA = 1076
LANGID_YI = 1144
LANGID_YIDDISH = 1085
LANGID_YORUBA = 1130
LANGID_ZULU = 1077

lang_id_names = {
    LANGID_AFRIKAANS: "African",
    LANGID_ALBANIAN: "Albanian",
    LANGID_AMHARIC: "Amharic",
    LANGID_ARABIC: "Arabic",
    LANGID_ARABIC_ALGERIA: "Arabic Algerian",
    LANGID_ARABIC_BAHRAIN: "Arabic Bahraini",
    LANGID_ARABIC_EGYPT: "Arabic Egyptian",
    LANGID_ARABIC_IRAQ: "Arabic Iraqi",
    LANGID_ARABIC_JORDAN: "Arabic Jordanian",
    LANGID_ARABIC_KUWAIT: "Arabic Kuwaiti",
    LANGID_ARABIC_LEBANON: "Arabic Lebanese",
    LANGID_ARABIC_LIBYA: "Arabic Libyan",
    LANGID_ARABIC_MOROCCO: "Arabic Moroccan",
    LANGID_ARABIC_OMAN: "Arabic Omani",
    LANGID_ARABIC_QATAR: "Arabic Qatari",
    LANGID_ARABIC_SYRIA: "Arabic Syrian",
    LANGID_ARABIC_TUNISIA: "Arabic Tunisian",
    LANGID_ARABIC_UAE: "Arabic United Arab Emirates",
    LANGID_ARABIC_YEMEN: "Arabic Yemeni",
    LANGID_ARMENIAN: "Armenian",
    LANGID_ASSAMESE: "Assamese",
    LANGID_AZERI_CYRILLIC: "Azeri Cyrillic",
    LANGID_AZERI_LATIN: "Azeri Latin",
    LANGID_BASQUE: "Basque",
    LANGID_BELGIAN_DUTCH: "Belgian Dutch",
    LANGID_BELGIAN_FRENCH: "Belgian French",
    LANGID_BENGALI: "Bengali",
    LANGID_BULGARIAN: "Bulgarian",
    LANGID_BURMESE: "Burmese",
    LANGID_BYELORUSSIAN: "Byelorussian",
    LANGID_CATALAN: "Catalan",
    LANGID_CHEROKEE: "Cherokee",
    LANGID_CHINESE_HONG_KONG_SAR: "Chinese Hong Kong SAR",
    LANGID_CHINESE_MACAO_SAR: "Chinese Macao SAR",
    LANGID_CHINESE_SINGAPORE: "Chinese Singapore",
    LANGID_CROATIAN: "Croatian",
    LANGID_CZECH: "Czech",
    LANGID_DANISH: "Danish",
    LANGID_DIVEHI: "Divehi",
    LANGID_DUTCH: "Dutch",
    LANGID_EDO: "Edo",
    LANGID_ENGLISH_AUS: "Australian English",
    LANGID_ENGLISH_BELIZE: "Belize English",
    LANGID_ENGLISH_CANADIAN: "Canadian English",
    LANGID_ENGLISH_CARIBBEAN: "Caribbean English",
    LANGID_ENGLISH_INDONESIA: "Indonesian English",
    LANGID_ENGLISH_IRELAND: "Irish English",
    LANGID_ENGLISH_JAMAICA: "Jamaican English",
    LANGID_ENGLISH_NEW_ZEALAND: "New Zealand English",
    LANGID_ENGLISH_PHILIPPINES: "Filipino English",
    LANGID_ENGLISH_SOUTH_AFRICA: "South African English",
    LANGID_ENGLISH_TRINIDAD_TOBAGO: "Tobago Trinidad English",
    LANGID_ENGLISH_UK: "United Kingdom English",
    LANGID_ENGLISH_US: "United States English",
    LANGID_ENGLISH_ZIMBABWE: "Zimbabwe English",
    LANGID_ESTONIAN: "Estonian",
    LANGID_FAEROESE: "Faeroese",
    LANGID_FILIPINO: "Filipino",
    LANGID_FINNISH: "Finnish",
    LANGID_FRENCH: "French",
    LANGID_FRENCH_CAMEROON: "French Cameroon",
    LANGID_FRENCH_CANADIAN: "French Canadian",
    LANGID_FRENCH_CONGO_D_R_C: "French (Congo (DRC))",
    LANGID_FRENCH_COTED_IVOIRE: "French Cote d'Ivoire",
    LANGID_FRENCH_HAITI: "French Haiti",
    LANGID_FRENCH_LUXEMBOURG: "French Luxembourg",
    LANGID_FRENCH_MALI: "French Mali",
    LANGID_FRENCH_MONACO: "French Monaco",
    LANGID_FRENCH_MOROCCO: "French Morocco",
    LANGID_FRENCH_REUNION: "French Reunion",
    LANGID_FRENCH_SENEGAL: "French Senegal",
    LANGID_FRENCH_WEST_INDIES: "French West Indies",
    LANGID_FRISIAN_NETHERLANDS: "Frisian Netherlands",
    LANGID_FULFULDE: "Fulfulde",
    LANGID_GAELIC_IRELAND: "Gaelic Irish",
    LANGID_GAELIC_SCOTLAND: "Gaelic Scottish",
    LANGID_GALICIAN: "Galician",
    LANGID_GEORGIAN: "Georgian",
    LANGID_GERMAN: "German",
    LANGID_GERMAN_AUSTRIA: "German Austrian",
    LANGID_GERMAN_LIECHTENSTEIN: "German Liechtenstein",
    LANGID_GERMAN_LUXEMBOURG: "German Luxembourg",
    LANGID_GREEK: "Greek",
    LANGID_GUARANI: "Guarani",
    LANGID_GUJARATI: "Gujarati",
    LANGID_HAUSA: "Hausa",
    LANGID_HAWAIIAN: "Hawaiian",
    LANGID_HEBREW: "Hebrew",
    LANGID_HINDI: "Hindi",
    LANGID_HUNGARIAN: "Hungarian",
    LANGID_IBIBIO: "Ibibio",
    LANGID_ICELANDIC: "Icelandic",
    LANGID_IGBO: "Igbo",
    LANGID_INDONESIAN: "Indonesian",
    LANGID_INUKTITUT: "Inuktitut",
    LANGID_ITALIAN: "Italian",
    LANGID_JAPANESE: "Japanese",
    LANGID_KANNADA: "Kannada",
    LANGID_KANURI: "Kanuri",
    LANGID_KASHMIRI: "Kashmiri",
    LANGID_KAZAKH: "Kazakh",
    LANGID_KHMER: "Khmer",
    LANGID_KIRGHIZ: "Kirghiz",
    LANGID_KONKANI: "Konkani",
    LANGID_KOREAN: "Korean",
    LANGID_KYRGYZ: "Kyrgyz",
    LANGID_LANGUAGE_NONE: "No specified",
    LANGID_LAO: "Lao",
    LANGID_LATIN: "Latin",
    LANGID_LATVIAN: "Latvian",
    LANGID_LITHUANIAN: "Lithuanian",
    LANGID_MACEDONIAN_FYROM: "Macedonian (FYROM)",
    LANGID_MALAYALAM: "Malayalam",
    LANGID_MALAY_BRUNEI_DARUSSALAM: "Malay Brunei Darussalam",
    LANGID_MALAYSIAN: "Malaysian",
    LANGID_MALTESE: "Maltese",
    LANGID_MANIPURI: "Manipuri",
    LANGID_MARATHI: "Marathi",
    LANGID_MEXICAN_SPANISH: "Mexican Spanish",
    LANGID_MONGOLIAN: "Mongolian",
    LANGID_NEPALI: "Nepali",
    LANGID_NO_PROOFING: "Disables proofing",
    LANGID_NORWEGIAN_BOKMOL: "Norwegian Bokmol",
    LANGID_NORWEGIAN_NYNORSK: "Norwegian Nynorsk",
    LANGID_ORIYA: "Oriya",
    LANGID_OROMO: "Oromo",
    LANGID_PASHTO: "Pashto",
    LANGID_PERSIAN: "Persian",
    LANGID_POLISH: "Polish",
    LANGID_PORTUGUESE: "Portuguese",
    LANGID_PORTUGUESE_BRAZIL: "Portuguese (Brazil)",
    LANGID_PUNJABI: "Punjabi",
    LANGID_RHAETO_ROMANIC: "Rhaeto Romanic",
    LANGID_ROMANIAN: "Romanian",
    LANGID_ROMANIAN_MOLDOVA: "Romanian Moldova",
    LANGID_RUSSIAN: "Russian",
    LANGID_RUSSIAN_MOLDOVA: "Russian Moldova",
    LANGID_SAMI_LAPPISH: "Sami Lappish",
    LANGID_SANSKRIT: "Sanskrit",
    LANGID_SERBIAN_CYRILLIC: "Serbian Cyrillic",
    LANGID_SERBIAN_LATIN: "Serbian Latin",
    LANGID_SESOTHO: "Sesotho",
    LANGID_SIMPLIFIED_CHINESE: "Simplified Chinese",
    LANGID_SINDHI: "Sindhi",
    LANGID_SINDHI_PAKISTAN: "Sindhi (Pakistan)",
    LANGID_SINHALESE: "Sinhalese",
    LANGID_SLOVAK: "Slovakian",
    LANGID_SLOVENIAN: "Slovenian",
    LANGID_SOMALI: "Somali",
    LANGID_SORBIAN: "Sorbian",
    LANGID_SPANISH: "Spanish",
    LANGID_SPANISH_ARGENTINA: "Spanish Argentina",
    LANGID_SPANISH_BOLIVIA: "Spanish Bolivian",
    LANGID_SPANISH_CHILE: "Spanish Chilean",
    LANGID_SPANISH_COLOMBIA: "Spanish Colombian",
    LANGID_SPANISH_COSTA_RICA: "Spanish Costa Rican",
    LANGID_SPANISH_DOMINICAN_REPUBLIC: "Spanish Dominican Republic",
    LANGID_SPANISH_ECUADOR: "Spanish Ecuadorian",
    LANGID_SPANISH_EL_SALVADOR: "Spanish El Salvadorian",
    LANGID_SPANISH_GUATEMALA: "Spanish Guatemala",
    LANGID_SPANISH_HONDURAS: "Spanish Honduran",
    LANGID_SPANISH_MODERN_SORT: "Spanish Modern Sort",
    LANGID_SPANISH_NICARAGUA: "Spanish Nicaraguan",
    LANGID_SPANISH_PANAMA: "Spanish Panamanian",
    LANGID_SPANISH_PARAGUAY: "Spanish Paraguayan",
    LANGID_SPANISH_PERU: "Spanish Peruvian",
    LANGID_SPANISH_PUERTO_RICO: "Spanish Puerto Rican",
    LANGID_SPANISH_URUGUAY: "Spanish Uruguayan",
    LANGID_SPANISH_VENEZUELA: "Spanish Venezuelan",
    LANGID_SUTU: "Sutu",
    LANGID_SWAHILI: "Swahili",
    LANGID_SWEDISH: "Swedish",
    LANGID_SWEDISH_FINLAND: "Swedish Finnish",
    LANGID_SWISS_FRENCH: "Swiss French",
    LANGID_SWISS_GERMAN: "Swiss German",
    LANGID_SWISS_ITALIAN: "Swiss Italian",
    LANGID_SYRIAC: "Syriac",
    LANGID_TAJIK: "Tajik",
    LANGID_TAMAZIGHT: "Tamazight",
    LANGID_TAMAZIGHT_LATIN: "Tamazight Latin",
    LANGID_TAMIL: "Tamil",
    LANGID_TATAR: "Tatar",
    LANGID_TELUGU: "Telugu",
    LANGID_THAI: "Thai",
    LANGID_TIBETAN: "Tibetan",
    LANGID_TIGRIGNA_ERITREA: "Tigrigna Eritrea",
    LANGID_TIGRIGNA_ETHIOPIC: "Tigrigna Ethiopic",
    LANGID_TRADITIONAL_CHINESE: "Traditional Chinese",
    LANGID_TSONGA: "Tsonga",
    LANGID_TSWANA: "Tswana",
    LANGID_TURKISH: "Turkish",
    LANGID_TURKMEN: "Turkmen",
    LANGID_UKRAINIAN: "Ukrainian",
    LANGID_URDU: "Urdu",
    LANGID_UZBEK_CYRILLIC: "Uzbek Cyrillic",
    LANGID_UZBEK_LATIN: "Uzbek Latin",
    LANGID_VENDA: "Venda",
    LANGID_VIETNAMESE: "Vietnamese",
    LANGID_WELSH: "Welsh",
    LANGID_XHOSA: "Xhosa",
    LANGID_YI: "Yi",
    LANGID_YIDDISH: "Yiddish",
    LANGID_YORUBA: "Yoruba",
    LANGID_ZULU: "Zulu"
}
