(*
    Title:      Standard Basis Library: Imperative IO Signature
    Copyright   David C.J. Matthews 2000

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*)

(* G&R 2004 status: checked, no change *)

signature IMPERATIVE_IO =
sig
	structure StreamIO : STREAM_IO
	type vector = StreamIO.vector
	type elem = StreamIO.elem

	type instream
	type outstream
	val input : instream -> vector
	val input1 : instream -> elem Option.option
	val inputN : instream * int -> vector
	val inputAll : instream -> vector
	val canInput : instream * int -> int Option.option
	val lookahead : instream -> elem Option.option
	val closeIn : instream -> unit
	val endOfStream : instream -> bool
	val output : outstream * vector -> unit
	val output1 : outstream * elem -> unit
	val flushOut : outstream -> unit
	val closeOut : outstream -> unit
	val mkInstream : StreamIO.instream -> instream
	val getInstream : instream -> StreamIO.instream
	val setInstream : instream * StreamIO.instream -> unit
	val mkOutstream : StreamIO.outstream -> outstream
	val getOutstream : outstream -> StreamIO.outstream
	val setOutstream : outstream * StreamIO.outstream -> unit
	val getPosOut : outstream -> StreamIO.out_pos
	val setPosOut : outstream * StreamIO.out_pos -> unit
end;
