/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "commandemesg.h"

Resultat commandemesg_initialisation(TRAVAIL(CommandeMesg) commandemesg)
{
	/* Cre une commande mesg vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */
	if((S_T(commandemesg)=(STOCKAGE(CommandeMesg))(malloc(SIZEOF(CONTENEUR(CommandeMesg)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	CHAMP(commandemesg , localisation)=NULL;
	return RESULTAT_OK;
}

Resultat commandemesg_definition_localisationfichier(TRAVAIL(CommandeMesg) commandemesg , TRAVAIL(LocalisationFichier) localisationfichier)
{
	/* Indique la position d'une commande mesg dans le source.
	 * Renvoie RESULTAT_ERREUR si commandemesg est NULL.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */
	DEBUTZONESECURISEE
	if(S_T(commandemesg)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(localisationfichier_copie_commande(localisationfichier,CHAMP_TRAVAIL(commandemesg , localisation)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandemesg_lecture_localisationfichier(TRAVAIL(CommandeMesg) commandemesg , REFERENCE(LocalisationFichier) localisationfichier)
{
	/* Indique la position d'une commande mesg dans le source.
	 * Renvoie RESULTAT_ERREUR si commandemesg est NULL.
	 */
	if(S_T(commandemesg)==NULL)
		return RESULTAT_ERREUR;
	T_R(localisationfichier)=CHAMP_TRAVAIL(commandemesg , localisation);
	return RESULTAT_OK;
}

Resultat commandemesg_parcours(TRAVAIL(CommandeMesg) commandemesg , TRAVAIL(ActionFlux) action , TRAVAIL(General) general)
{
	/* Ralise un parcours des flux inclus dans la commande spcifie.
	 * Renvoie les mmes erreurs que flux_parcours,
	 * ainsi que RESULTAT_ERREUR si commande est NULL,
	 * rien ne se passe si action est NULL.
	 */
	if(S_T(commandemesg)==NULL)
		return RESULTAT_ERREUR;
	return RESULTAT_OK;
}

Resultat commandemesg_copie(TRAVAIL(CommandeMesg) commandemesg , TRAVAIL(CommandeMesg) copie)
{
	/* Cre une copie de la commande mesg.
	 * Renvoie RESULTAT_ERREUR si commandemesg est NULL, et
	 * RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 * Si la copie est non vide, elle est au pralable supprime.
	 */
	DEBUTZONESECURISEE
	if(S_T(commandemesg)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(commandemesg_destruction(copie));
	SECURISE(commandemesg_initialisation(copie));
	SECURISE(commandemesg_definition_localisationfichier(copie,CHAMP_TRAVAIL(commandemesg , localisation)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandemesg_destruction(TRAVAIL(CommandeMesg) commandemesg)
{
	/* Dtruit une commande mesg.
	 */
	DEBUTZONESECURISEE
	if(S_T(commandemesg)==NULL)
		return RESULTAT_OK;
	SECURISE(localisationfichier_destruction(CHAMP_TRAVAIL(commandemesg , localisation)));
	free(S_T(commandemesg));
	S_T(commandemesg)=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

