/*	Conductor_Table

PIRL CVS ID: Conductor_Table.java,v 1.15 2012/04/16 06:04:11 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package PIRL.Conductor.Maestro;

import	PIRL.Conductor.Conductor;
import	PIRL.Conductor.Colors;

import	org.jdesktop.swingx.JXTable;

import	javax.swing.JTable;
import	javax.swing.ListSelectionModel;
import	javax.swing.table.TableCellRenderer;
import	javax.swing.JLabel;
import	javax.swing.BorderFactory;
import	java.awt.Component;
import	java.awt.Color;
import	java.awt.Font;


/**	A <i>Conductor_Table</i> is a table view of a Conductor_Table_Model.
<p>
	@author	Bradford Castalia, UA/PIRL
	@version 1.15
*/
public class Conductor_Table
	extends JXTable
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Conductor.Maestro.Conductor_Table (1.15 2012/04/16 06:04:11)";


public static final int
	RUN_TO_WAIT_STATE	= Conductor.RUN_TO_WAIT,
	RUNNING_STATE		= Conductor.RUNNING,
	POLLING_STATE		= Conductor.POLLING,
	WAITING_STATE		= Conductor.WAITING,
	HALTED_STATE		= Conductor.HALTED;

private Font
	Emphasis_Font;


//  DEBUG control.
private static final int
	DEBUG_OFF			= 0,
	DEBUG_CONSTRUCTOR	= 1 << 0,
	DEBUG_ACCESSORS		= 1 << 1,
	DEBUG_RENDERER		= 1 << 2,
	DEBUG_ALL			= -1,

	DEBUG				= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
public Conductor_Table
	(
	Conductor_Table_Model	table_model
	)
{
super (table_model);
if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		(">>> Conductor_Table");

//setColumnSelectionAllowed (false);
//setRowSelectionAllowed (true);
setSelectionMode (ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
setAutoResizeMode (JTable.AUTO_RESIZE_LAST_COLUMN);
setBackground (Colors.TABLE);
Emphasis_Font = getFont ().deriveFont (Font.BOLD);
getTableHeader ().setBackground (Colors.TABLE_HEADER);
/*
	WARNING: This is a JXTable specific method.
*/
setColumnControlVisible (true);

setDefaultRenderer (String.class, new Conductor_Table_Cell_Renderer ());
if ((DEBUG & DEBUG_CONSTRUCTOR) != 0)
	System.out.println
		("<<< Conductor_Table");
}

/*==============================================================================
	Accessors
*/
/*	If not provided by the base class.
public int convertRowIndexToModel
	(
	int		view_row
	)
{return view_row;}

public int convertRowIndextoView
	(
	int		model_row
	)
{return model_row;}
*/

/*==============================================================================
	Conductor_Table_Cell_Renderer
*/
private class Conductor_Table_Cell_Renderer
	extends JLabel
	implements TableCellRenderer
{
public Conductor_Table_Cell_Renderer ()
{
setOpaque (true);
//setFont (Emphasis_Font);
setBorder (BorderFactory.createEmptyBorder (0, 5, 0, 0));
}

public Component getTableCellRendererComponent
	(
	JTable	table,
	Object	value,
	boolean	selected,
	boolean	focused,
	int		row,
	int		column
	)
{
row = ((JXTable)table).convertRowIndexToModel (row);
column = table.convertColumnIndexToModel (column);
Color
	color = table.getBackground ();
if (column == 1)
	{
	switch (((Conductor_Table_Model)table.getModel ()).Processing_State (row))
		{
		case RUN_TO_WAIT_STATE:	color = Colors.RUN_TO_WAIT; break;
		case RUNNING_STATE:	color = Colors.RUNNING_STATE; break;
		case POLLING_STATE:	color = Colors.POLLING_STATE; break;
		case WAITING_STATE:	color = Colors.WAITING_STATE; break;
		case HALTED_STATE:	color = Colors.HALTED_STATE; break;
		}
	}

setBackground (Colors.Selected_Color (selected, color));
setValue (value);
return this;
}


public void setValue
	(
	Object	value
	)
{setText ((value == null) ? "" : value.toString ());}

}	//	Conductor_Table_Cell_Renderer


}
