/*	Evaluate

PIRL CVS ID: Evaluate.java,v 1.6 2012/04/16 06:04:10 castalia Exp

Copyright (C) 2004-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

package	PIRL.Conductor;

import	edu.hws.jcm.data.*;

/**	Evaluates a mathematical expression.
<p>
	This class is a wrapper for the mathematical expression evaluator.
	It is provided to confirm that expressions processed by a
	Reference_Resolver will correctly evaluate; and if not, why not.
<p>
	The arguments on the command line are taken to be the expression.
	This may be contained in one argument or multiple arguments;
	multiple arguments are concatenated with spaces separating them to
	form a single expression.
<p>
	The expression is evaluated and the results are listed. If the
	expression can not be evaulated the expression evaluator's
	description of the problem is listed.
<p>
	@author	Bradford Castalia
	@version 1.6
	@see	edu.hws.jcm.data.Parser#Parser()
*/
public class Evaluate
{
public static void main
	(
	String[]	args
	)
{
String
	expression = "";
if (args.length == 0)
	{
	System.out.println ("Usage: Evaluate <expression>");
	System.exit (1);
	}
else
	{
	expression = args[0];
	for (int count = 1;
			 count < args.length;
			 count++)
		expression += ' ' + args[count];
	}

Parser
	parser = new Parser ();
double
	result;
try
	{
	result = parser.parseLogical (expression).getVal ();
	System.out.println
		("Logical expression = " + ((result == 0.0) ? "false" : " true"));
	}
catch (ParseError exception)
	{
	try
		{
		result = parser.parse (expression).getVal ();
		System.out.println
			("Numeric expression = " + result);
		}
	catch (ParseError parse_error)
		{
		System.out.println
			("Unable to evaluate the expression -\n"
			+"\"" + parse_error.context.data + "\"\n"
			+"at index " + parse_error.context.pos
				+ ((parse_error.context.tokenString == null) ?
					"" :
					(" for token \"" + parse_error.context.tokenString + '"'))
				+ ":\n"
			+ parse_error.getMessage ());
		System.exit (-1);
		}
	}
System.exit (0);
}

}
