/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtSimulationInformation.h>
#include <DataNode.h>
#include <avtSimulationCommandSpecification.h>
#include <avtSimulationCommandSpecification.h>

//
// Enum conversion methods for avtSimulationInformation::RunMode
//

static const char *RunMode_strings[] = {
"Unknown", "Running", "Stopped"
};

std::string
avtSimulationInformation::RunMode_ToString(avtSimulationInformation::RunMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return RunMode_strings[index];
}

std::string
avtSimulationInformation::RunMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return RunMode_strings[index];
}

bool
avtSimulationInformation::RunMode_FromString(const std::string &s, avtSimulationInformation::RunMode &val)
{
    val = avtSimulationInformation::Unknown;
    for(int i = 0; i < 3; ++i)
    {
        if(s == RunMode_strings[i])
        {
            val = (RunMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: avtSimulationInformation::avtSimulationInformation
//
// Purpose: 
//   Init utility for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtSimulationInformation::Init()
{
    port = 0;
    mode = Unknown;

    avtSimulationInformation::SelectAll();
}

// ****************************************************************************
// Method: avtSimulationInformation::avtSimulationInformation
//
// Purpose: 
//   Copy utility for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtSimulationInformation::Copy(const avtSimulationInformation &obj)
{
    AttributeGroupVector::const_iterator pos;

    host = obj.host;
    port = obj.port;
    securityKey = obj.securityKey;
    otherNames = obj.otherNames;
    otherValues = obj.otherValues;
    // *** Copy the genericCommands field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = genericCommands.begin(); pos != genericCommands.end(); ++pos)
        delete *pos;
    genericCommands.clear();
    if(obj.genericCommands.size() > 0)
        genericCommands.reserve(obj.genericCommands.size());
    // Duplicate the genericCommands from obj.
    for(pos = obj.genericCommands.begin(); pos != obj.genericCommands.end(); ++pos)
    {
        avtSimulationCommandSpecification *oldavtSimulationCommandSpecification = (avtSimulationCommandSpecification *)(*pos);
        avtSimulationCommandSpecification *newavtSimulationCommandSpecification = new avtSimulationCommandSpecification(*oldavtSimulationCommandSpecification);
        genericCommands.push_back(newavtSimulationCommandSpecification);
    }

    mode = obj.mode;
    // *** Copy the customCommands field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = customCommands.begin(); pos != customCommands.end(); ++pos)
        delete *pos;
    customCommands.clear();
    if(obj.customCommands.size() > 0)
        customCommands.reserve(obj.customCommands.size());
    // Duplicate the customCommands from obj.
    for(pos = obj.customCommands.begin(); pos != obj.customCommands.end(); ++pos)
    {
        avtSimulationCommandSpecification *oldavtSimulationCommandSpecification = (avtSimulationCommandSpecification *)(*pos);
        avtSimulationCommandSpecification *newavtSimulationCommandSpecification = new avtSimulationCommandSpecification(*oldavtSimulationCommandSpecification);
        customCommands.push_back(newavtSimulationCommandSpecification);
    }


    avtSimulationInformation::SelectAll();
}

// Type map format string
const char *avtSimulationInformation::TypeMapFormatString = AVTSIMULATIONINFORMATION_TMFS;
const AttributeGroup::private_tmfs_t avtSimulationInformation::TmfsStruct = {AVTSIMULATIONINFORMATION_TMFS};


// ****************************************************************************
// Method: avtSimulationInformation::avtSimulationInformation
//
// Purpose: 
//   Default constructor for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSimulationInformation::avtSimulationInformation() : 
    AttributeSubject(avtSimulationInformation::TypeMapFormatString)
{
    avtSimulationInformation::Init();
}

// ****************************************************************************
// Method: avtSimulationInformation::avtSimulationInformation
//
// Purpose: 
//   Constructor for the derived classes of avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSimulationInformation::avtSimulationInformation(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    avtSimulationInformation::Init();
}

// ****************************************************************************
// Method: avtSimulationInformation::avtSimulationInformation
//
// Purpose: 
//   Copy constructor for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSimulationInformation::avtSimulationInformation(const avtSimulationInformation &obj) : 
    AttributeSubject(avtSimulationInformation::TypeMapFormatString)
{
    avtSimulationInformation::Copy(obj);
}

// ****************************************************************************
// Method: avtSimulationInformation::avtSimulationInformation
//
// Purpose: 
//   Copy constructor for derived classes of the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSimulationInformation::avtSimulationInformation(const avtSimulationInformation &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    avtSimulationInformation::Copy(obj);
}

// ****************************************************************************
// Method: avtSimulationInformation::~avtSimulationInformation
//
// Purpose: 
//   Destructor for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSimulationInformation::~avtSimulationInformation()
{
    AttributeGroupVector::iterator pos;

    // Destroy the genericCommands field.
    for(pos = genericCommands.begin(); pos != genericCommands.end(); ++pos)
        delete *pos;
    // Destroy the customCommands field.
    for(pos = customCommands.begin(); pos != customCommands.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: avtSimulationInformation::operator = 
//
// Purpose: 
//   Assignment operator for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSimulationInformation& 
avtSimulationInformation::operator = (const avtSimulationInformation &obj)
{
    if (this == &obj) return *this;

    avtSimulationInformation::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtSimulationInformation::operator == 
//
// Purpose: 
//   Comparison operator == for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSimulationInformation::operator == (const avtSimulationInformation &obj) const
{
    bool genericCommands_equal = (obj.genericCommands.size() == genericCommands.size());
    for(size_t i = 0; (i < genericCommands.size()) && genericCommands_equal; ++i)
    {
        // Make references to avtSimulationCommandSpecification from AttributeGroup *.
        const avtSimulationCommandSpecification &genericCommands1 = *((const avtSimulationCommandSpecification *)(genericCommands[i]));
        const avtSimulationCommandSpecification &genericCommands2 = *((const avtSimulationCommandSpecification *)(obj.genericCommands[i]));
        genericCommands_equal = (genericCommands1 == genericCommands2);
    }

    bool customCommands_equal = (obj.customCommands.size() == customCommands.size());
    for(size_t i = 0; (i < customCommands.size()) && customCommands_equal; ++i)
    {
        // Make references to avtSimulationCommandSpecification from AttributeGroup *.
        const avtSimulationCommandSpecification &customCommands1 = *((const avtSimulationCommandSpecification *)(customCommands[i]));
        const avtSimulationCommandSpecification &customCommands2 = *((const avtSimulationCommandSpecification *)(obj.customCommands[i]));
        customCommands_equal = (customCommands1 == customCommands2);
    }

    // Create the return value
    return ((host == obj.host) &&
            (port == obj.port) &&
            (securityKey == obj.securityKey) &&
            (otherNames == obj.otherNames) &&
            (otherValues == obj.otherValues) &&
            genericCommands_equal &&
            (mode == obj.mode) &&
            customCommands_equal);
}

// ****************************************************************************
// Method: avtSimulationInformation::operator != 
//
// Purpose: 
//   Comparison operator != for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSimulationInformation::operator != (const avtSimulationInformation &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtSimulationInformation::TypeName
//
// Purpose: 
//   Type name method for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtSimulationInformation::TypeName() const
{
    return "avtSimulationInformation";
}

// ****************************************************************************
// Method: avtSimulationInformation::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtSimulationInformation::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtSimulationInformation *tmp = (const avtSimulationInformation *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtSimulationInformation::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtSimulationInformation::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtSimulationInformation(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtSimulationInformation::NewInstance
//
// Purpose: 
//   NewInstance method for the avtSimulationInformation class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtSimulationInformation::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtSimulationInformation(*this);
    else
        retval = new avtSimulationInformation;

    return retval;
}

// ****************************************************************************
// Method: avtSimulationInformation::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtSimulationInformation::SelectAll()
{
    Select(ID_host,            (void *)&host);
    Select(ID_port,            (void *)&port);
    Select(ID_securityKey,     (void *)&securityKey);
    Select(ID_otherNames,      (void *)&otherNames);
    Select(ID_otherValues,     (void *)&otherValues);
    Select(ID_genericCommands, (void *)&genericCommands);
    Select(ID_mode,            (void *)&mode);
    Select(ID_customCommands,  (void *)&customCommands);
}

// ****************************************************************************
// Method: avtSimulationInformation::CreateSubAttributeGroup
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
avtSimulationInformation::CreateSubAttributeGroup(int attr_id)
{
    AttributeGroup *retval = 0;
    switch(attr_id)
    {
    case ID_genericCommands:
        retval = new avtSimulationCommandSpecification;
        break;
    case ID_customCommands:
        retval = new avtSimulationCommandSpecification;
        break;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
avtSimulationInformation::SetHost(const std::string &host_)
{
    host = host_;
    Select(ID_host, (void *)&host);
}

void
avtSimulationInformation::SetPort(int port_)
{
    port = port_;
    Select(ID_port, (void *)&port);
}

void
avtSimulationInformation::SetSecurityKey(const std::string &securityKey_)
{
    securityKey = securityKey_;
    Select(ID_securityKey, (void *)&securityKey);
}

void
avtSimulationInformation::SetOtherNames(const stringVector &otherNames_)
{
    otherNames = otherNames_;
    Select(ID_otherNames, (void *)&otherNames);
}

void
avtSimulationInformation::SetOtherValues(const stringVector &otherValues_)
{
    otherValues = otherValues_;
    Select(ID_otherValues, (void *)&otherValues);
}

void
avtSimulationInformation::SetMode(avtSimulationInformation::RunMode mode_)
{
    mode = mode_;
    Select(ID_mode, (void *)&mode);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
avtSimulationInformation::GetHost() const
{
    return host;
}

std::string &
avtSimulationInformation::GetHost()
{
    return host;
}

int
avtSimulationInformation::GetPort() const
{
    return port;
}

const std::string &
avtSimulationInformation::GetSecurityKey() const
{
    return securityKey;
}

std::string &
avtSimulationInformation::GetSecurityKey()
{
    return securityKey;
}

const stringVector &
avtSimulationInformation::GetOtherNames() const
{
    return otherNames;
}

stringVector &
avtSimulationInformation::GetOtherNames()
{
    return otherNames;
}

const stringVector &
avtSimulationInformation::GetOtherValues() const
{
    return otherValues;
}

stringVector &
avtSimulationInformation::GetOtherValues()
{
    return otherValues;
}

const AttributeGroupVector &
avtSimulationInformation::GetGenericCommands() const
{
    return genericCommands;
}

AttributeGroupVector &
avtSimulationInformation::GetGenericCommands()
{
    return genericCommands;
}

avtSimulationInformation::RunMode
avtSimulationInformation::GetMode() const
{
    return RunMode(mode);
}

const AttributeGroupVector &
avtSimulationInformation::GetCustomCommands() const
{
    return customCommands;
}

AttributeGroupVector &
avtSimulationInformation::GetCustomCommands()
{
    return customCommands;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
avtSimulationInformation::SelectHost()
{
    Select(ID_host, (void *)&host);
}

void
avtSimulationInformation::SelectSecurityKey()
{
    Select(ID_securityKey, (void *)&securityKey);
}

void
avtSimulationInformation::SelectOtherNames()
{
    Select(ID_otherNames, (void *)&otherNames);
}

void
avtSimulationInformation::SelectOtherValues()
{
    Select(ID_otherValues, (void *)&otherValues);
}

void
avtSimulationInformation::SelectGenericCommands()
{
    Select(ID_genericCommands, (void *)&genericCommands);
}

void
avtSimulationInformation::SelectCustomCommands()
{
    Select(ID_customCommands, (void *)&customCommands);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: avtSimulationInformation::AddGenericCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtSimulationInformation::AddGenericCommands(const avtSimulationCommandSpecification &obj)
{
    avtSimulationCommandSpecification *newavtSimulationCommandSpecification = new avtSimulationCommandSpecification(obj);
    genericCommands.push_back(newavtSimulationCommandSpecification);

    // Indicate that things have changed by selecting it.
    Select(ID_genericCommands, (void *)&genericCommands);
}

// ****************************************************************************
// Method: avtSimulationInformation::ClearGenericCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtSimulationInformation::ClearGenericCommands()
{
    AttributeGroupVector::iterator pos;

    for(pos = genericCommands.begin(); pos != genericCommands.end(); ++pos)
        delete *pos;
    genericCommands.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_genericCommands, (void *)&genericCommands);
}

// ****************************************************************************
// Method: avtSimulationInformation::RemoveGenericCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtSimulationInformation::RemoveGenericCommands(int index)
{
    AttributeGroupVector::iterator pos = genericCommands.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != genericCommands.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != genericCommands.end())
    {
        delete *pos;
        genericCommands.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_genericCommands, (void *)&genericCommands);
}

// ****************************************************************************
// Method: avtSimulationInformation::GetNumGenericCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
avtSimulationInformation::GetNumGenericCommands() const
{
    return (int)genericCommands.size();
}

// ****************************************************************************
// Method: avtSimulationInformation::GetGenericCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSimulationCommandSpecification &
avtSimulationInformation::GetGenericCommands(int i)
{
    return *((avtSimulationCommandSpecification *)genericCommands[i]);
}

// ****************************************************************************
// Method: avtSimulationInformation::GetGenericCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const avtSimulationCommandSpecification &
avtSimulationInformation::GetGenericCommands(int i) const
{
    return *((avtSimulationCommandSpecification *)genericCommands[i]);
}

// ****************************************************************************
// Method: avtSimulationInformation::AddCustomCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtSimulationInformation::AddCustomCommands(const avtSimulationCommandSpecification &obj)
{
    avtSimulationCommandSpecification *newavtSimulationCommandSpecification = new avtSimulationCommandSpecification(obj);
    customCommands.push_back(newavtSimulationCommandSpecification);

    // Indicate that things have changed by selecting it.
    Select(ID_customCommands, (void *)&customCommands);
}

// ****************************************************************************
// Method: avtSimulationInformation::ClearCustomCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtSimulationInformation::ClearCustomCommands()
{
    AttributeGroupVector::iterator pos;

    for(pos = customCommands.begin(); pos != customCommands.end(); ++pos)
        delete *pos;
    customCommands.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_customCommands, (void *)&customCommands);
}

// ****************************************************************************
// Method: avtSimulationInformation::RemoveCustomCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtSimulationInformation::RemoveCustomCommands(int index)
{
    AttributeGroupVector::iterator pos = customCommands.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != customCommands.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != customCommands.end())
    {
        delete *pos;
        customCommands.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_customCommands, (void *)&customCommands);
}

// ****************************************************************************
// Method: avtSimulationInformation::GetNumCustomCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
avtSimulationInformation::GetNumCustomCommands() const
{
    return (int)customCommands.size();
}

// ****************************************************************************
// Method: avtSimulationInformation::GetCustomCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtSimulationCommandSpecification &
avtSimulationInformation::GetCustomCommands(int i)
{
    return *((avtSimulationCommandSpecification *)customCommands[i]);
}

// ****************************************************************************
// Method: avtSimulationInformation::GetCustomCommands
//
// Purpose: 
//   Contains information about simulation connections
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const avtSimulationCommandSpecification &
avtSimulationInformation::GetCustomCommands(int i) const
{
    return *((avtSimulationCommandSpecification *)customCommands[i]);
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

