/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.enveffects;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseBindableNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseTextureBackground
extends BaseBindableNode
implements VRMLBackgroundNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{5};
    protected static final int FIELD_GROUND_ANGLE = 4;
    protected static final int FIELD_GROUND_COLOR = 5;
    protected static final int FIELD_SKY_ANGLE = 6;
    protected static final int FIELD_SKY_COLOR = 7;
    protected static final int FIELD_BACK_TEXTURE = 8;
    protected static final int FIELD_FRONT_TEXTURE = 9;
    protected static final int FIELD_LEFT_TEXTURE = 10;
    protected static final int FIELD_RIGHT_TEXTURE = 11;
    protected static final int FIELD_BOTTOM_TEXTURE = 12;
    protected static final int FIELD_TOP_TEXTURE = 13;
    protected static final int FIELD_TRANSPARENCY = 14;
    protected static final int LAST_BACKGROUND_INDEX = 14;
    protected static final int NUM_FIELDS = 15;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected static final String[] EMPTY_LIST;
    protected static final int BACK = 0;
    protected static final int FRONT = 1;
    protected static final int LEFT = 2;
    protected static final int RIGHT = 3;
    protected static final int TOP = 4;
    protected static final int BOTTOM = 5;
    protected static final int SKY_SPHERE = 6;
    protected static final int GROUND_SPHERE = 7;
    protected static final int NUM_BG_OBJECTS = 8;
    protected VRMLNodeType vfBackTexture;
    protected VRMLNodeType vfFrontTexture;
    protected VRMLNodeType vfLeftTexture;
    protected VRMLNodeType vfRightTexture;
    protected VRMLNodeType vfTopTexture;
    protected VRMLNodeType vfBottomTexture;
    protected float[] vfGroundAngle;
    protected float[] vfGroundColor;
    protected float[] vfSkyAngle;
    protected float[] vfSkyColor;
    protected float vfTransparency;
    protected int numGroundAngle;
    protected int numGroundColor;
    protected int numSkyAngle;
    protected int numSkyColor;

    protected BaseTextureBackground() {
        super("Background");
        this.hasChanged = new boolean[15];
        this.vfSkyColor = new float[]{0.0f, 0.0f, 0.0f};
        this.vfGroundAngle = FieldConstants.EMPTY_MFFLOAT;
        this.vfGroundColor = FieldConstants.EMPTY_MFFLOAT;
        this.vfSkyAngle = FieldConstants.EMPTY_MFFLOAT;
        this.vfTransparency = 0.0f;
        this.numGroundAngle = 0;
        this.numGroundColor = 0;
        this.numSkyAngle = 0;
        this.numSkyColor = 3;
    }

    protected BaseTextureBackground(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("transparency");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTransparency = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("groundAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGroundAngle = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfGroundAngle, 0, vRMLFieldData.numElements);
                this.numGroundAngle = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("groundColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGroundColor = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfGroundColor, 0, vRMLFieldData.numElements);
                this.numGroundColor = vRMLFieldData.numElements * 3;
            }
            n = vRMLNodeType.getFieldIndex("skyAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfSkyAngle = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfSkyAngle, 0, vRMLFieldData.numElements);
                this.numSkyAngle = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("skyColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfSkyColor = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfSkyColor, 0, vRMLFieldData.numElements);
                this.numSkyColor = vRMLFieldData.numElements * 3;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public float getTransparency() {
        return this.vfTransparency;
    }

    public void setTransparency(float f) {
        this.vfTransparency = f;
        if (!this.inSetup) {
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    public int getNumSkyColors() {
        return this.numSkyColor / 3;
    }

    public int getNumGroundColors() {
        return this.numGroundColor / 3;
    }

    public void getSkyValues(float[] fArray, float[] fArray2) {
        System.arraycopy(this.vfSkyColor, 0, fArray, 0, this.numSkyColor);
        if (this.numSkyAngle != 0) {
            System.arraycopy(this.vfSkyAngle, 0, fArray2, 0, this.numSkyAngle);
        }
    }

    public void getGroundValues(float[] fArray, float[] fArray2) {
        System.arraycopy(this.vfGroundColor, 0, fArray, 0, this.numGroundColor);
        if (this.numGroundAngle != 0) {
            System.arraycopy(this.vfGroundAngle, 0, fArray2, 0, this.numGroundAngle);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 14) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 4;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSkyColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numSkyColor / 3;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfSkyAngle;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numSkyAngle;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfGroundColor;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numGroundColor / 3;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfGroundAngle;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = this.numGroundAngle;
                break;
            }
            case 14: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfTransparency;
                vRMLFieldData.dataType = (short)4;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.vfFrontTexture;
                vRMLFieldData.dataType = (short)7;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.vfBackTexture;
                vRMLFieldData.dataType = (short)7;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.vfLeftTexture;
                vRMLFieldData.dataType = (short)7;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.vfRightTexture;
                vRMLFieldData.dataType = (short)7;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.vfTopTexture;
                vRMLFieldData.dataType = (short)7;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.nodeValue = this.vfBottomTexture;
                vRMLFieldData.dataType = (short)7;
                vRMLFieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfGroundAngle, this.numGroundAngle);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfGroundColor, this.numGroundColor);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfSkyAngle, this.numSkyAngle);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfSkyColor, this.numSkyColor);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfTransparency);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfFrontTexture);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfBackTexture);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfLeftTexture);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfRightTexture);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfTopTexture);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfBottomTexture);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 14: {
                this.setTransparency(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                if (n2 > this.vfGroundAngle.length) {
                    this.vfGroundAngle = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfGroundAngle, 0, n2);
                this.numGroundAngle = n2;
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            case 5: {
                FieldValidator.checkColorArray("Background.GroundColor", fArray);
                if (n2 > this.vfGroundColor.length) {
                    this.vfGroundColor = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfGroundColor, 0, n2);
                this.numGroundColor = n2;
                if (this.inSetup) break;
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
                break;
            }
            case 6: {
                if (fArray.length > this.vfSkyAngle.length) {
                    this.vfSkyAngle = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfSkyAngle, 0, n2);
                this.numSkyAngle = n2;
                if (this.inSetup) break;
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            case 7: {
                FieldValidator.checkColorArray("Background.SkyColor", fArray);
                if (n2 > this.vfSkyColor.length) {
                    this.vfSkyColor = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfSkyColor, 0, n2);
                this.numSkyColor = n2;
                if (this.inSetup) break;
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            default: 
        }
        super.setValue(n, stringArray, n2);
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        boolean bl = false;
        switch (n) {
            case 9: {
                this.vfFrontTexture = vRMLNodeType;
                if (this.inSetup) break;
                this.hasChanged[9] = true;
                this.fireFieldChanged(9);
                break;
            }
            case 8: {
                this.vfBackTexture = vRMLNodeType;
                if (this.inSetup) break;
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
                break;
            }
            case 10: {
                this.vfLeftTexture = vRMLNodeType;
                if (this.inSetup) break;
                this.hasChanged[10] = true;
                this.fireFieldChanged(10);
                break;
            }
            case 11: {
                this.vfRightTexture = vRMLNodeType;
                if (this.inSetup) break;
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
                break;
            }
            case 13: {
                this.vfTopTexture = vRMLNodeType;
                if (this.inSetup) break;
                this.hasChanged[13] = true;
                this.fireFieldChanged(13);
                break;
            }
            case 12: {
                this.vfBottomTexture = vRMLNodeType;
                if (this.inSetup) break;
                this.hasChanged[12] = true;
                this.fireFieldChanged(12);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    static {
        EMPTY_LIST = new String[0];
        nodeFields = new int[]{0, 9, 8, 10, 11, 13, 12};
        fieldDecl = new VRMLFieldDeclaration[15];
        fieldMap = new HashMap(15);
        BaseTextureBackground.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTextureBackground.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "set_bind");
        BaseTextureBackground.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "isBound");
        BaseTextureBackground.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFTime", "bindTime");
        BaseTextureBackground.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFFloat", "groundAngle");
        BaseTextureBackground.fieldDecl[5] = new VRMLFieldDeclaration(3, "MFColor", "groundColor");
        BaseTextureBackground.fieldDecl[6] = new VRMLFieldDeclaration(3, "MFFloat", "skyAngle");
        BaseTextureBackground.fieldDecl[7] = new VRMLFieldDeclaration(3, "MFColor", "skyColor");
        BaseTextureBackground.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFNode", "backTexture");
        BaseTextureBackground.fieldDecl[9] = new VRMLFieldDeclaration(3, "MFNode", "frontTexture");
        BaseTextureBackground.fieldDecl[10] = new VRMLFieldDeclaration(3, "MFNode", "leftTexture");
        BaseTextureBackground.fieldDecl[11] = new VRMLFieldDeclaration(3, "MFNode", "rightTexture");
        BaseTextureBackground.fieldDecl[13] = new VRMLFieldDeclaration(3, "MFNode", "topTexture");
        BaseTextureBackground.fieldDecl[12] = new VRMLFieldDeclaration(3, "MFNode", "bottomTexture");
        BaseTextureBackground.fieldDecl[14] = new VRMLFieldDeclaration(3, "SFFloat", "transparency");
        fieldMap.put("set_bind", new Integer(1));
        fieldMap.put("isBound", new Integer(3));
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("bindTime", n);
        fieldMap.put("bindTime_changed", n);
        n = new Integer(8);
        fieldMap.put("backTexture", n);
        fieldMap.put("set_backTexture", n);
        fieldMap.put("backTexture_changed", n);
        n = new Integer(9);
        fieldMap.put("frontTexture", n);
        fieldMap.put("set_frontTexture", n);
        fieldMap.put("frontTexture_changed", n);
        n = new Integer(10);
        fieldMap.put("leftTexture", n);
        fieldMap.put("set_leftTexture", n);
        fieldMap.put("leftTexture_changed", n);
        n = new Integer(11);
        fieldMap.put("rightTexture", n);
        fieldMap.put("set_rightTexture", n);
        fieldMap.put("rightTexture_changed", n);
        n = new Integer(13);
        fieldMap.put("topTexture", n);
        fieldMap.put("set_topTexture", n);
        fieldMap.put("topTexture_changed", n);
        n = new Integer(12);
        fieldMap.put("bottomTexture", n);
        fieldMap.put("set_bottomTexture", n);
        fieldMap.put("bottomTexture_changed", n);
        n = new Integer(4);
        fieldMap.put("groundAngle", n);
        fieldMap.put("set_groundAngle", n);
        fieldMap.put("groundAngle_changed", n);
        n = new Integer(5);
        fieldMap.put("groundColor", n);
        fieldMap.put("set_groundColor", n);
        fieldMap.put("groundColor_changed", n);
        n = new Integer(6);
        fieldMap.put("skyAngle", n);
        fieldMap.put("set_skyAngle", n);
        fieldMap.put("skyAngle_changed", n);
        n = new Integer(7);
        fieldMap.put("skyColor", n);
        fieldMap.put("set_skyColor", n);
        fieldMap.put("skyColor_changed", n);
        n = new Integer(14);
        fieldMap.put("transparency", n);
        fieldMap.put("set_transparency", n);
        fieldMap.put("transparency_changed", n);
    }
}

