Minutes from 9th OpenVDB TSC meeting, Feb. 28, 2019

Attendees: *Ken* M., *Nick* A., *Dan* B., *Peter* C., *Jeff* L.

Additional Attendees: Bruce Chernia (Intel), Thanh Ha

Retrospective Agenda:

1) Confirmation of quorum
2) Selection of secretary
3) Update from TAC
4) Adding Libraries
4a) Adding Eigen
4b) 3rd party reporting
4c) Adding CLI library
5) Deprecation policy
6) OpenVDB and Houdini Unification
7) Next Meeting

1) A quorum was confirmed.

2) Secretary - Jeff Lait

3) Dan gave an update from the TAC meeting.  They are considering
Circle CI rather than Travis.

Circle Upsides
 - No 50 min limit; instead a 5hr limit
 - Can produce build artifacts
 - 2x as fast (despite same hardware?)
 - Doesn't lock your step order
Circle Downsides
 - No commit vs PR build.   Might need to setup for PR builds only, which
   may require extra merges to force a PR build before sending to master.
 - Randomizes job order
 - 4gb limit.  But this can be addressed if non-free version is used.

Concerns were raised about the 4gb limit and VDBs notorious use of memory.
In any case, decision will be made pending the results of the TACs
investigation.

4a) Ken requires Eigen for some new tools so would like to add as
dependency.  It is header only, and several parties are already using it
internally.  But it likely can't be confined to a .cpp file.

MKL was suggested as an Eigen alternative.  While the license is likely
now compliant, concerns were raised about the library install size.

Ken moved that we adopt Eigen.
Dan amended that it should be gated by a USE_EIGEN compile time flag.
Passed with unanimous consent.

4b) An ongoing problem is for people to determine what dependencies are
required to build VDB.  Different people pick different versions of the
library, either causing direct build failures, or failures when mixing
together.   Blosc in particular has issues if latests versions are used.

Since the CI must already know the true versions for its install, this
is a documentation problem to provide it for users.  Two action items
are:
1) Update the install file to reflect the current versions in the CI
2) Add 3rd party list on the website modeled after:
http://www.sidefx.com/docs/houdini/licenses/index

4c) Ken suggested we include the CLI library to make the command line
programs less fully of boilerplate.   boost::options was suggested as
another alternative as boost already is included.   Suggestion was
tabled for later.

5) Dan moved that the deprecation policy forwarded by email should
be adopted.
Support will consist of current and last two years of the VFX platform.
Currently this is 2019, 2018, and 2017.  This will make a minimum Houdini
version of 16.5.
Next year will be 2020, 2019, and 2018, and will unlock C++14.

Passed with unanimous consent.

6) Dan moved we adopt the proposals for renaming OpenVDB nodes
user-facing labels to match Houdini's and add a (aswf) suffix, along
with built-in policies to allow auto-hiding of duplicate nodes.

General agreement, but concerns were raised about the specific names
to use.  Many have got used to OpenVDB prefixes, so change will cause
friction.  Likewise, many do not know what "ASWF" means.  Though,
alternatively, it might be good to start the education about ASWF
in this manner.

Dan moved that he prepare a PR and we can continue the bike-shedding
when we have something concrete.

Passed with unanimous consent.

7) Next Meeting

Next meeting is scheduled for March 7th, 2019, 11am-12pm PST.
