/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_DNSElementSettingData.h"

CMPIObjectPath* DNS_OpenDRIM_DNSElementSettingData_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_DNSElementSettingData& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_DNSElementSettingData_classnames[0], OpenDRIM_DNSElementSettingData_NAMESPACE);

	if (!instance.ManagedElement_isNULL)
		op.addKey("ManagedElement", instance.ManagedElement);

	if (!instance.SettingData_isNULL)
		op.addKey("SettingData", instance.SettingData);

	_L_;
	return op.getHdl();
}

CMPIInstance* DNS_OpenDRIM_DNSElementSettingData_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_DNSElementSettingData& instance) {
	_E_;
	Objectpath op(broker, DNS_OpenDRIM_DNSElementSettingData_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.IsDefault_isNULL)
		ci.setProperty("IsDefault", instance.IsDefault);

	if (!instance.IsCurrent_isNULL)
		ci.setProperty("IsCurrent", instance.IsCurrent);

	if (!instance.IsNext_isNULL)
		ci.setProperty("IsNext", instance.IsNext);

	_L_;
	return ci.getHdl();
}

void DNS_OpenDRIM_DNSElementSettingData_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_DNSElementSettingData& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("SettingData", instance.SettingData) == OK)
		instance.SettingData_isNULL = false;

	if (op.getKey("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	_L_;
}

void DNS_OpenDRIM_DNSElementSettingData_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_DNSElementSettingData& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("ManagedElement", instance.ManagedElement) == OK)
		instance.ManagedElement_isNULL = false;

	if (inst.getProperty("SettingData", instance.SettingData) == OK)
		instance.SettingData_isNULL = false;

	if (inst.getProperty("IsDefault", instance.IsDefault) == OK)
		instance.IsDefault_isNULL = false;

	if (inst.getProperty("IsCurrent", instance.IsCurrent) == OK)
		instance.IsCurrent_isNULL = false;

	if (inst.getProperty("IsNext", instance.IsNext) == OK)
		instance.IsNext_isNULL = false;

	_L_;
}

