/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef CMPIOPENDRIM_PROCESSOR_H_
#define CMPIOPENDRIM_PROCESSOR_H_

#include "OpenDRIM_Processor.h"

CMPIObjectPath* CPU_OpenDRIM_Processor_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_Processor& instance);

CMPIInstance* CPU_OpenDRIM_Processor_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_Processor& instance);

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_Processor& instance);

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_Processor& instance);

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_RequestStateChange_In& args);

void CPU_OpenDRIM_Processor_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_Processor_RequestStateChange_Out& args);

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_SetPowerState_In& args);

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_EnableDevice_In& args);

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_OnlineDevice_In& args);

void CPU_OpenDRIM_Processor_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_Processor_QuiesceDevice_In& args);


#endif /*CMPIOPENDRIM_PROCESSOR_H_*/
