/* NVTV I2C wrapper -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: tv_i2c.c,v 1.10 2004/01/27 17:05:25 dthierbach Exp $
 *
 * Contents:
 *
 * I2C wrapper for the TV-I2C routines. All I2C access go through this
 * wrapper, for error bookkeeping and to allow testing. No file should
 * access xf86i2c routines directly.
 *
 */

#include "local.h" /* before everything else */

#include <stdio.h>

#include "xf86i2c.h"
#include "tv_i2c.h"

/* -------- */

Bool tvBusOk = TRUE;

/* -------- I2C bus access -------- */

Bool TVProbeBus (I2CBusPtr bus, I2CSlaveAddr addr)
{
  return xf86I2CProbeAddress(bus, addr);
}

void TVWriteBus (I2CDevPtr d, I2CByte subaddr, I2CByte data)
{
#ifndef FAKE_I2C
  if (!xf86I2CWriteByte (d, subaddr, data)) tvBusOk = FALSE;
#else
  FPRINTF (" %02x=%02x", subaddr, data);
#endif
}

void TVWriteSeqBus (I2CDevPtr d, I2CByte subaddr, I2CByte *buf, int len)
{
#ifndef FAKE_I2C
  if (!xf86I2CWriteBytes (d, subaddr, buf, len)) tvBusOk = FALSE;
#else
  FPRINTF (" %02x=[%i]", subaddr, len);
#endif
}

void TVReadBus (I2CDevPtr d, I2CByte subaddr, I2CByte *data)
{
#ifndef FAKE_I2C
  if (!xf86I2CReadByte (d, subaddr, data)) tvBusOk = FALSE;
#else
  FPRINTF (" %02x?", subaddr);
  data = 0x00;
#endif
}

void TVReadSeqBus (I2CDevPtr d, I2CByte subaddr, I2CByte *data, int len)
{
#ifndef FAKE_I2C
  if (!xf86I2CWriteRead (d, &subaddr, 1, data, len)) tvBusOk = FALSE;
#else
  FPRINTF (" %02x/%i?", subaddr, len);
  data = 0x00;
#endif
}

void TVStatusBus (I2CDevPtr d, I2CByte *data)
{
#ifndef FAKE_I2C
  if (!xf86I2CReadStatus(d, data)) tvBusOk = FALSE;
#else
  FPRINTF (" ss?");
  data = 0x00;
#endif
}

void TVStatusSeqBus (I2CDevPtr d, I2CByte *buf, int len)
{
#ifndef FAKE_I2C
  if (!xf86I2CWriteRead (d, NULL, 0, buf, len)) tvBusOk = FALSE;
#else
  FPRINTF (" ss%i?", len);
#endif
}

