require "rake/testtask"

#SUBDIRS = %w( * base cli data_sources extra filters helpers ).freeze
SUBDIRS = %w(base cli data_sources filters helpers ).freeze


namespace :test do
  SUBDIRS.each do |dir|
    Rake::TestTask.new(dir == '*' ? 'all' : dir) do |t|
      t.test_files = Dir["test/#{dir}/**/*_spec.rb"] + Dir["test/#{dir}/**/test_*.rb"]
      t.ruby_opts = ['-r./test/helper']
    end
  end
end



task default: SUBDIRS.map {|x| "test:#{x}".to_sym}
