/*

  xmunipack - tune panel colour look-up table (LUT)

  Copyright © 2018-9 F.Hroch (hroch@physics.muni.cz)

  This file is part of Munipack.

  Munipack is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Munipack is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Munipack.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "tune.h"
#include <wx/wx.h>
#include <wx/dcbuffer.h>
#include <algorithm>

using namespace std;

// ---- MuniLUTus  ---------------------------------------------

MuniLUTus::MuniLUTus(wxWindow *w): wxPanel(w)
{
  SetBackgroundStyle(wxBG_STYLE_CUSTOM);
  Bind(wxEVT_PAINT,&MuniLUTus::OnPaint,this);
}

wxSize MuniLUTus::DoGetBestSize() const
{
  return wxSize(256,60);
}

void MuniLUTus::SetPalette(const wxString& l)
{
  pal.SetPalette(l);
  Refresh();
}

void MuniLUTus::SetPalette(const FitsPalette& p)
{
  pal = p;
  Refresh();
}

void MuniLUTus::SetInversePalette(bool b)
{
  pal.SetInverse(b);
  Refresh();
}

void MuniLUTus::OnPaint(wxPaintEvent& event)
{
  wxAutoBufferedPaintDC dc(this);
  dc.SetPen(wxNullPen);

  int n = pal.GetColors();
  int dx = 1;
  int dy = 20;

  n--;
  for(int j = 0; j < 3; j++)
    for(int i = 0; i < 256; i++) {
      dc.SetBrush(wxColor(pal.R(n),pal.G(n),pal.B(n)));
      dc.DrawRectangle(i*dx,j*dy,dx,dy);
      n--;
    }
}
