/* Rzwrapper.c generated by valac 0.16.1, the Vala compiler
 * generated from Rzwrapper.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */
/*Class for communicating with the rz program*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>


#define MOSERIAL_TYPE_RZWRAPPER (moserial_rzwrapper_get_type ())
#define MOSERIAL_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapper))
#define MOSERIAL_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))
#define MOSERIAL_IS_RZWRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_IS_RZWRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_RZWRAPPER))
#define MOSERIAL_RZWRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperClass))

typedef struct _moserialRzwrapper moserialRzwrapper;
typedef struct _moserialRzwrapperClass moserialRzwrapperClass;
typedef struct _moserialRzwrapperPrivate moserialRzwrapperPrivate;

#define MOSERIAL_RZWRAPPER_TYPE_PROTOCOL (moserial_rzwrapper_protocol_get_type ())

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _moserialRzwrapper {
	GObject parent_instance;
	moserialRzwrapperPrivate * priv;
	gboolean running;
};

struct _moserialRzwrapperClass {
	GObjectClass parent_class;
};

typedef enum  {
	MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM,
	MOSERIAL_RZWRAPPER_PROTOCOL_NULL
} moserialRzwrapperProtocol;

struct _moserialRzwrapperPrivate {
	moserialRzwrapperProtocol _protocol;
	moserialSerialConnection* _sc;
	GIOChannel* IOChannelInput;
	GIOChannel* IOChannelOutput;
	GIOChannel* IOChannelError;
	guint outputChannelId;
	guint errorChannelId;
	GPid pid;
	gchar* _path;
	gchar* _filename;
};


static gpointer moserial_rzwrapper_parent_class = NULL;

GType moserial_rzwrapper_get_type (void) G_GNUC_CONST;
GType moserial_rzwrapper_protocol_get_type (void) G_GNUC_CONST;
GType moserial_serial_connection_get_type (void) G_GNUC_CONST;
#define MOSERIAL_RZWRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MOSERIAL_TYPE_RZWRAPPER, moserialRzwrapperPrivate))
enum  {
	MOSERIAL_RZWRAPPER_DUMMY_PROPERTY,
	MOSERIAL_RZWRAPPER_PROTOCOL,
	MOSERIAL_RZWRAPPER_SC,
	MOSERIAL_RZWRAPPER_PATH,
	MOSERIAL_RZWRAPPER_FILENAME
};
moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename);
moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename);
void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte);
static void moserial_rzwrapper_shutdown (moserialRzwrapper* self);
void moserial_rzwrapper_flush (moserialRzwrapper* self);
static gboolean moserial_rzwrapper_readError (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition);
gchar* mo_utils_getLastMessage (const gchar* messages);
void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o);
moserialRzwrapperProtocol moserial_rzwrapper_get_protocol (moserialRzwrapper* self);
moserialSerialConnection* moserial_rzwrapper_get_sc (moserialRzwrapper* self);
void moserial_serial_connection_sendByte (moserialSerialConnection* self, guchar byte);
static gboolean moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self);
static gboolean _moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self);
static gboolean moserial_rzwrapper_readBytes (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition);
static void moserial_rzwrapper_set_protocol (moserialRzwrapper* self, moserialRzwrapperProtocol value);
static void moserial_rzwrapper_set_sc (moserialRzwrapper* self, moserialSerialConnection* value);
const gchar* moserial_rzwrapper_get_path (moserialRzwrapper* self);
static void moserial_rzwrapper_set_path (moserialRzwrapper* self, const gchar* value);
const gchar* moserial_rzwrapper_get_filename (moserialRzwrapper* self);
static void moserial_rzwrapper_set_filename (moserialRzwrapper* self, const gchar* value);
static GObject * moserial_rzwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _moserial_rzwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static gboolean _moserial_rzwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void moserial_rzwrapper_finalize (GObject* obj);
static void _vala_moserial_rzwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_moserial_rzwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gchar* MOSERIAL_RZWRAPPER_ProtocolStrings[3] = {"Xmodem", "Ymodem", "Zmodem"};

GType moserial_rzwrapper_protocol_get_type (void) {
	static volatile gsize moserial_rzwrapper_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_rzwrapper_protocol_type_id__volatile)) {
		static const GEnumValue values[] = {{MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM", "xmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM", "ymodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM, "MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM", "zmodem"}, {MOSERIAL_RZWRAPPER_PROTOCOL_NULL, "MOSERIAL_RZWRAPPER_PROTOCOL_NULL", "null"}, {0, NULL, NULL}};
		GType moserial_rzwrapper_protocol_type_id;
		moserial_rzwrapper_protocol_type_id = g_enum_register_static ("moserialRzwrapperProtocol", values);
		g_once_init_leave (&moserial_rzwrapper_protocol_type_id__volatile, moserial_rzwrapper_protocol_type_id);
	}
	return moserial_rzwrapper_protocol_type_id__volatile;
}


moserialRzwrapper* moserial_rzwrapper_construct (GType object_type, moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename) {
	moserialRzwrapper * self = NULL;
	moserialRzwrapperProtocol* _tmp0_;
	moserialRzwrapperProtocol pro;
	moserialSerialConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = protocol;
	pro = *_tmp0_;
	_tmp1_ = sc;
	_tmp2_ = p;
	_tmp3_ = filename;
	self = (moserialRzwrapper*) g_object_new (object_type, "protocol", pro, "sc", _tmp1_, "path", _tmp2_, "filename", _tmp3_, NULL);
	return self;
}


moserialRzwrapper* moserial_rzwrapper_new (moserialRzwrapperProtocol* protocol, moserialSerialConnection* sc, const gchar* p, const gchar* filename) {
	return moserial_rzwrapper_construct (MOSERIAL_TYPE_RZWRAPPER, protocol, sc, p, filename);
}


void moserial_rzwrapper_writeChar (moserialRzwrapper* self, guchar byte) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		gsize bytesWritten = 0UL;
		gchar* _tmp1_ = NULL;
		gchar* b;
		gint b_length1;
		gint _b_size_;
		gchar* _tmp2_;
		gint _tmp2__length1;
		guchar _tmp3_;
		gchar _tmp4_;
		_tmp1_ = g_new0 (gchar, 1);
		b = _tmp1_;
		b_length1 = 1;
		_b_size_ = b_length1;
		_tmp2_ = b;
		_tmp2__length1 = b_length1;
		_tmp3_ = byte;
		_tmp2_[0] = (gchar) _tmp3_;
		_tmp4_ = _tmp2_[0];
		{
			gboolean _tmp5_;
			_tmp5_ = self->running;
			if (_tmp5_) {
				GIOChannel* _tmp6_;
				gchar* _tmp7_;
				gint _tmp7__length1;
				gsize _tmp8_ = 0UL;
				_tmp6_ = self->priv->IOChannelInput;
				_tmp7_ = b;
				_tmp7__length1 = b_length1;
				g_io_channel_write_chars (_tmp6_, _tmp7_, _tmp7__length1, &_tmp8_, &_inner_error_);
				bytesWritten = _tmp8_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch15_g_io_channel_error;
					}
					if (_inner_error_->domain == G_CONVERT_ERROR) {
						goto __catch15_g_convert_error;
					}
					b = (g_free (b), NULL);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		goto __finally15;
		__catch15_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			moserial_rzwrapper_shutdown (self);
			_tmp9_ = stdout;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			fprintf (_tmp9_, "writeChar() %s\n", _tmp11_);
			_g_error_free0 (e);
		}
		goto __finally15;
		__catch15_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp12_;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = stdout;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			fprintf (_tmp12_, "%s\n", _tmp14_);
			_g_error_free0 (e);
		}
		__finally15:
		if (_inner_error_ != NULL) {
			b = (g_free (b), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		b = (g_free (b), NULL);
	}
}


void moserial_rzwrapper_flush (moserialRzwrapper* self) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		{
			gboolean _tmp1_;
			_tmp1_ = self->running;
			if (_tmp1_) {
				GIOChannel* _tmp2_;
				_tmp2_ = self->priv->IOChannelInput;
				g_io_channel_flush (_tmp2_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
						goto __catch16_g_io_channel_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		goto __finally16;
		__catch16_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp3_;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error_;
			_inner_error_ = NULL;
			moserial_rzwrapper_shutdown (self);
			_tmp3_ = stdout;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			fprintf (_tmp3_, "flush() %s\n", _tmp5_);
			_g_error_free0 (e);
		}
		__finally16:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean moserial_rzwrapper_readError (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->running;
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* m_buf;
		gint m_buf_length1;
		gint _m_buf_size_;
		gchar* _tmp2_;
		gchar* message;
		gchar* _tmp3_;
		gchar* messages;
		gsize bytesRead;
		GIOCondition _tmp4_;
		const gchar* _tmp35_;
		gchar* _tmp36_ = NULL;
		const gchar* _tmp37_;
		const gchar* _tmp39_;
		gint _tmp40_ = 0;
		const gchar* _tmp41_;
		gint _tmp42_ = 0;
		_tmp1_ = g_new0 (gchar, 1000);
		m_buf = _tmp1_;
		m_buf_length1 = 1000;
		_m_buf_size_ = m_buf_length1;
		_tmp2_ = g_strdup ("");
		message = _tmp2_;
		_tmp3_ = g_strdup ("");
		messages = _tmp3_;
		bytesRead = (gsize) 0;
		_tmp4_ = condition;
		if (!(_tmp4_ == G_IO_IN)) {
			result = TRUE;
			_g_free0 (messages);
			_g_free0 (message);
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			GIOChannel* _tmp5_;
			gchar* _tmp6_;
			gint _tmp6__length1;
			gsize _tmp7_ = 0UL;
			_tmp5_ = source;
			_tmp6_ = m_buf;
			_tmp6__length1 = m_buf_length1;
			g_io_channel_read_chars (_tmp5_, _tmp6_, _tmp6__length1, &_tmp7_, &_inner_error_);
			bytesRead = _tmp7_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch17_g_convert_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch17_g_io_channel_error;
				}
				_g_free0 (messages);
				_g_free0 (message);
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally17;
		__catch17_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp8_;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp8_ = stdout;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			fprintf (_tmp8_, "readError() %s\n", _tmp10_);
			_g_error_free0 (e);
		}
		goto __finally17;
		__catch17_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = stdout;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			fprintf (_tmp11_, "readError() %s\n", _tmp13_);
			_g_error_free0 (e);
		}
		__finally17:
		if (_inner_error_ != NULL) {
			_g_free0 (messages);
			_g_free0 (message);
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			gint x;
			x = 0;
			{
				gboolean _tmp14_;
				_tmp14_ = TRUE;
				while (TRUE) {
					gboolean _tmp15_;
					gint _tmp17_;
					gsize _tmp18_;
					gchar* _tmp19_;
					gint _tmp19__length1;
					gint _tmp20_;
					gchar _tmp21_;
					gunichar c;
					gboolean _tmp22_ = FALSE;
					gunichar _tmp23_;
					gboolean _tmp24_ = FALSE;
					gboolean _tmp27_;
					_tmp15_ = _tmp14_;
					if (!_tmp15_) {
						gint _tmp16_;
						_tmp16_ = x;
						x = _tmp16_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp17_ = x;
					_tmp18_ = bytesRead;
					if (!(((gsize) _tmp17_) < _tmp18_)) {
						break;
					}
					_tmp19_ = m_buf;
					_tmp19__length1 = m_buf_length1;
					_tmp20_ = x;
					_tmp21_ = _tmp19_[_tmp20_];
					c = (gunichar) _tmp21_;
					_tmp23_ = c;
					_tmp24_ = g_unichar_isprint (_tmp23_);
					if (_tmp24_) {
						_tmp22_ = TRUE;
					} else {
						gunichar _tmp25_;
						gboolean _tmp26_ = FALSE;
						_tmp25_ = c;
						_tmp26_ = g_unichar_isspace (_tmp25_);
						_tmp22_ = _tmp26_;
					}
					_tmp27_ = _tmp22_;
					if (_tmp27_) {
						const gchar* _tmp28_;
						gchar* _tmp29_;
						gint _tmp29__length1;
						gint _tmp30_;
						gchar _tmp31_;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_;
						gchar* _tmp34_;
						_tmp28_ = messages;
						_tmp29_ = m_buf;
						_tmp29__length1 = m_buf_length1;
						_tmp30_ = x;
						_tmp31_ = _tmp29_[_tmp30_];
						_tmp32_ = g_strdup_printf ("%c", (gint) _tmp31_);
						_tmp33_ = _tmp32_;
						_tmp34_ = g_strconcat (_tmp28_, _tmp33_, NULL);
						_g_free0 (messages);
						messages = _tmp34_;
						_g_free0 (_tmp33_);
					}
				}
			}
		}
		_tmp35_ = messages;
		_tmp36_ = mo_utils_getLastMessage (_tmp35_);
		_g_free0 (message);
		message = _tmp36_;
		_tmp37_ = message;
		if (!(g_strcmp0 (_tmp37_, "") == 0)) {
			const gchar* _tmp38_;
			_tmp38_ = message;
			g_signal_emit_by_name (self, "update-status", _tmp38_);
		}
		_tmp39_ = messages;
		_tmp40_ = string_index_of (_tmp39_, "Transfer complete", 0);
		if (_tmp40_ >= 0) {
			moserial_rzwrapper_shutdown (self);
		}
		_tmp41_ = messages;
		_tmp42_ = string_index_of (_tmp41_, "Transfer incomplete", 0);
		if (_tmp42_ >= 0) {
			moserial_rzwrapper_shutdown (self);
		}
		result = TRUE;
		_g_free0 (messages);
		_g_free0 (message);
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gboolean _moserial_rzwrapper_shutdown_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = moserial_rzwrapper_shutdown_timeout (self);
	return result;
}


void moserial_rzwrapper_transferCanceled (moserialRzwrapper* self, GObject* o) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		g_signal_emit_by_name (self, "update-status", "canceled");
		{
			gint x;
			x = 0;
			{
				gboolean _tmp1_;
				_tmp1_ = TRUE;
				while (TRUE) {
					gboolean _tmp2_;
					gint _tmp4_;
					moserialRzwrapperProtocol _tmp5_;
					_tmp2_ = _tmp1_;
					if (!_tmp2_) {
						gint _tmp3_;
						_tmp3_ = x;
						x = _tmp3_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp4_ = x;
					if (!(_tmp4_ < 20)) {
						break;
					}
					_tmp5_ = self->priv->_protocol;
					if (_tmp5_ == MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM) {
						moserialSerialConnection* _tmp6_;
						_tmp6_ = self->priv->_sc;
						moserial_serial_connection_sendByte (_tmp6_, (guchar) ('X' & 037));
						moserial_rzwrapper_writeChar (self, (guchar) ('X' & 037));
					} else {
						moserialSerialConnection* _tmp7_;
						_tmp7_ = self->priv->_sc;
						moserial_serial_connection_sendByte (_tmp7_, (guchar) 0x18);
					}
				}
			}
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 2000, _moserial_rzwrapper_shutdown_timeout_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gboolean moserial_rzwrapper_shutdown_timeout (moserialRzwrapper* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	moserial_rzwrapper_shutdown (self);
	result = FALSE;
	return result;
}


static void moserial_rzwrapper_shutdown (moserialRzwrapper* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->running;
	if (_tmp0_) {
		guint _tmp1_;
		guint _tmp2_;
		GPid _tmp3_;
		self->running = FALSE;
		_tmp1_ = self->priv->outputChannelId;
		g_source_remove (_tmp1_);
		_tmp2_ = self->priv->errorChannelId;
		g_source_remove (_tmp2_);
		_tmp3_ = self->priv->pid;
		g_spawn_close_pid (_tmp3_);
		g_signal_emit_by_name (self, "transfer-complete");
	}
}


static gboolean moserial_rzwrapper_readBytes (moserialRzwrapper* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = self->running;
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* m_buf;
		gint m_buf_length1;
		gint _m_buf_size_;
		gsize bytesRead;
		GIOCondition _tmp2_;
		_tmp1_ = g_new0 (gchar, 1000);
		m_buf = _tmp1_;
		m_buf_length1 = 1000;
		_m_buf_size_ = m_buf_length1;
		bytesRead = (gsize) 0;
		_tmp2_ = condition;
		if (!(_tmp2_ == G_IO_IN)) {
			result = TRUE;
			m_buf = (g_free (m_buf), NULL);
			return result;
		}
		{
			GIOChannel* _tmp3_;
			gchar* _tmp4_;
			gint _tmp4__length1;
			gsize _tmp5_ = 0UL;
			_tmp3_ = source;
			_tmp4_ = m_buf;
			_tmp4__length1 = m_buf_length1;
			g_io_channel_read_chars (_tmp3_, _tmp4_, _tmp4__length1, &_tmp5_, &_inner_error_);
			bytesRead = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch18_g_convert_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch18_g_io_channel_error;
				}
				m_buf = (g_free (m_buf), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally18;
		__catch18_g_convert_error:
		{
			GError* e = NULL;
			FILE* _tmp6_;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp6_ = stdout;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			fprintf (_tmp6_, "readBytes() %s\n", _tmp8_);
			_g_error_free0 (e);
		}
		goto __finally18;
		__catch18_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = stdout;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			fprintf (_tmp9_, "readError() %s\n", _tmp11_);
			_g_error_free0 (e);
		}
		__finally18:
		if (_inner_error_ != NULL) {
			m_buf = (g_free (m_buf), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		{
			gint x;
			x = 0;
			{
				gboolean _tmp12_;
				_tmp12_ = TRUE;
				while (TRUE) {
					gboolean _tmp13_;
					gint _tmp15_;
					gsize _tmp16_;
					moserialSerialConnection* _tmp17_;
					gchar* _tmp18_;
					gint _tmp18__length1;
					gint _tmp19_;
					gchar _tmp20_;
					_tmp13_ = _tmp12_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = x;
						x = _tmp14_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp15_ = x;
					_tmp16_ = bytesRead;
					if (!(((gsize) _tmp15_) < _tmp16_)) {
						break;
					}
					_tmp17_ = self->priv->_sc;
					_tmp18_ = m_buf;
					_tmp18__length1 = m_buf_length1;
					_tmp19_ = x;
					_tmp20_ = _tmp18_[_tmp19_];
					moserial_serial_connection_sendByte (_tmp17_, (guchar) _tmp20_);
				}
			}
		}
		result = TRUE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


moserialRzwrapperProtocol moserial_rzwrapper_get_protocol (moserialRzwrapper* self) {
	moserialRzwrapperProtocol result;
	moserialRzwrapperProtocol _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}


static void moserial_rzwrapper_set_protocol (moserialRzwrapper* self, moserialRzwrapperProtocol value) {
	moserialRzwrapperProtocol _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_protocol = _tmp0_;
	g_object_notify ((GObject *) self, "protocol");
}


moserialSerialConnection* moserial_rzwrapper_get_sc (moserialRzwrapper* self) {
	moserialSerialConnection* result;
	moserialSerialConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sc;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void moserial_rzwrapper_set_sc (moserialRzwrapper* self, moserialSerialConnection* value) {
	moserialSerialConnection* _tmp0_;
	moserialSerialConnection* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_sc);
	self->priv->_sc = _tmp1_;
	g_object_notify ((GObject *) self, "sc");
}


const gchar* moserial_rzwrapper_get_path (moserialRzwrapper* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	result = _tmp0_;
	return result;
}


static void moserial_rzwrapper_set_path (moserialRzwrapper* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_path);
	self->priv->_path = _tmp1_;
	g_object_notify ((GObject *) self, "path");
}


const gchar* moserial_rzwrapper_get_filename (moserialRzwrapper* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}


static void moserial_rzwrapper_set_filename (moserialRzwrapper* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
	g_object_notify ((GObject *) self, "filename");
}


static gboolean _moserial_rzwrapper_readBytes_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_rzwrapper_readBytes (self, source, condition);
	return result;
}


static gboolean _moserial_rzwrapper_readError_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = moserial_rzwrapper_readError (self, source, condition);
	return result;
}


static GObject * moserial_rzwrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	moserialRzwrapper * self;
	gboolean _tmp0_ = FALSE;
	moserialRzwrapperProtocol _tmp1_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (moserial_rzwrapper_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOSERIAL_RZWRAPPER (obj);
	_tmp1_ = self->priv->_protocol;
	if (_tmp1_ == MOSERIAL_RZWRAPPER_PROTOCOL_NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_path;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		self->running = FALSE;
	} else {
		gchar** argv = NULL;
		gint argv_length1 = 0;
		gint _argv_size_ = 0;
		moserialRzwrapperProtocol _tmp4_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		gchar* _tmp8_;
		gchar* _tmp9_;
		moserialRzwrapperProtocol _tmp10_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		gchar* _tmp22_;
		moserialRzwrapperProtocol _tmp23_;
		gint output = 0;
		gint _error_ = 0;
		gint input = 0;
		_tmp4_ = self->priv->_protocol;
		if (_tmp4_ == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
			gchar** _tmp5_ = NULL;
			_tmp5_ = g_new0 (gchar*, 4 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp5_;
			argv_length1 = 4;
			_argv_size_ = argv_length1;
		} else {
			gchar** _tmp6_ = NULL;
			_tmp6_ = g_new0 (gchar*, 3 + 1);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			argv = _tmp6_;
			argv_length1 = 3;
			_argv_size_ = argv_length1;
		}
		_tmp7_ = argv;
		_tmp7__length1 = argv_length1;
		_tmp8_ = g_strdup ("rz");
		_g_free0 (_tmp7_[0]);
		_tmp7_[0] = _tmp8_;
		_tmp9_ = _tmp7_[0];
		_tmp10_ = self->priv->_protocol;
		switch (_tmp10_) {
			case MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM:
			{
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = argv;
				_tmp11__length1 = argv_length1;
				_tmp12_ = g_strdup ("--xmodem");
				_g_free0 (_tmp11_[1]);
				_tmp11_[1] = _tmp12_;
				_tmp13_ = _tmp11_[1];
				break;
			}
			case MOSERIAL_RZWRAPPER_PROTOCOL_YMODEM:
			{
				gchar** _tmp14_;
				gint _tmp14__length1;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = argv;
				_tmp14__length1 = argv_length1;
				_tmp15_ = g_strdup ("--ymodem");
				_g_free0 (_tmp14_[1]);
				_tmp14_[1] = _tmp15_;
				_tmp16_ = _tmp14_[1];
				break;
			}
			default:
			case MOSERIAL_RZWRAPPER_PROTOCOL_ZMODEM:
			{
				gchar** _tmp17_;
				gint _tmp17__length1;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp17_ = argv;
				_tmp17__length1 = argv_length1;
				_tmp18_ = g_strdup ("--zmodem");
				_g_free0 (_tmp17_[1]);
				_tmp17_[1] = _tmp18_;
				_tmp19_ = _tmp17_[1];
				break;
			}
		}
		_tmp20_ = argv;
		_tmp20__length1 = argv_length1;
		_tmp21_ = g_strdup ("-vv");
		_g_free0 (_tmp20_[2]);
		_tmp20_[2] = _tmp21_;
		_tmp22_ = _tmp20_[2];
		_tmp23_ = self->priv->_protocol;
		if (_tmp23_ == MOSERIAL_RZWRAPPER_PROTOCOL_XMODEM) {
			gchar** _tmp24_;
			gint _tmp24__length1;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp24_ = argv;
			_tmp24__length1 = argv_length1;
			_tmp25_ = self->priv->_filename;
			_tmp26_ = g_strdup (_tmp25_);
			_g_free0 (_tmp24_[3]);
			_tmp24_[3] = _tmp26_;
			_tmp27_ = _tmp24_[3];
		}
		{
			const gchar* _tmp28_;
			gchar** _tmp29_;
			gint _tmp29__length1;
			GPid _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			gint _tmp34_;
			GIOChannel* _tmp35_;
			gint _tmp36_;
			GIOChannel* _tmp37_;
			gint _tmp38_;
			GIOChannel* _tmp39_;
			GIOChannel* _tmp40_;
			GIOChannel* _tmp41_;
			GIOChannel* _tmp42_;
			GIOChannel* _tmp43_;
			GIOChannel* _tmp44_;
			GIOChannel* _tmp45_;
			guint _tmp46_ = 0U;
			GIOChannel* _tmp47_;
			guint _tmp48_ = 0U;
			_tmp28_ = self->priv->_path;
			_tmp29_ = argv;
			_tmp29__length1 = argv_length1;
			g_spawn_async_with_pipes (_tmp28_, _tmp29_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp30_, &_tmp31_, &_tmp32_, &_tmp33_, &_inner_error_);
			self->priv->pid = _tmp30_;
			input = _tmp31_;
			output = _tmp32_;
			_error_ = _tmp33_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch19_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch19_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp34_ = output;
			_tmp35_ = g_io_channel_unix_new (_tmp34_);
			_g_io_channel_unref0 (self->priv->IOChannelOutput);
			self->priv->IOChannelOutput = _tmp35_;
			_tmp36_ = input;
			_tmp37_ = g_io_channel_unix_new (_tmp36_);
			_g_io_channel_unref0 (self->priv->IOChannelInput);
			self->priv->IOChannelInput = _tmp37_;
			_tmp38_ = _error_;
			_tmp39_ = g_io_channel_unix_new (_tmp38_);
			_g_io_channel_unref0 (self->priv->IOChannelError);
			self->priv->IOChannelError = _tmp39_;
			_tmp40_ = self->priv->IOChannelOutput;
			g_io_channel_set_encoding (_tmp40_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch19_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch19_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp41_ = self->priv->IOChannelOutput;
			g_io_channel_set_flags (_tmp41_, G_IO_FLAG_NONBLOCK, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch19_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch19_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp42_ = self->priv->IOChannelError;
			g_io_channel_set_encoding (_tmp42_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch19_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch19_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp43_ = self->priv->IOChannelError;
			g_io_channel_set_flags (_tmp43_, G_IO_FLAG_NONBLOCK, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch19_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch19_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp44_ = self->priv->IOChannelInput;
			g_io_channel_set_encoding (_tmp44_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_SPAWN_ERROR) {
					goto __catch19_g_spawn_error;
				}
				if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch19_g_io_channel_error;
				}
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
			}
			_tmp45_ = self->priv->IOChannelOutput;
			_tmp46_ = g_io_add_watch (_tmp45_, G_IO_IN, _moserial_rzwrapper_readBytes_gio_func, self);
			self->priv->outputChannelId = _tmp46_;
			_tmp47_ = self->priv->IOChannelError;
			_tmp48_ = g_io_add_watch (_tmp47_, G_IO_IN, _moserial_rzwrapper_readError_gio_func, self);
			self->priv->errorChannelId = _tmp48_;
			self->running = TRUE;
		}
		goto __finally19;
		__catch19_g_spawn_error:
		{
			GError* e = NULL;
			FILE* _tmp49_;
			GError* _tmp50_;
			const gchar* _tmp51_;
			GError* _tmp52_;
			const gchar* _tmp53_;
			GtkMessageDialog* _tmp54_;
			GtkMessageDialog* _tmp55_;
			GtkMessageDialog* errorDialog;
			GtkMessageDialog* _tmp56_;
			GtkMessageDialog* _tmp57_;
			e = _inner_error_;
			_inner_error_ = NULL;
			self->running = FALSE;
			_tmp49_ = stdout;
			_tmp50_ = e;
			_tmp51_ = _tmp50_->message;
			fprintf (_tmp49_, "spawn error: %s\n", _tmp51_);
			_tmp52_ = e;
			_tmp53_ = _tmp52_->message;
			_tmp54_ = (GtkMessageDialog*) gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp53_);
			_tmp55_ = g_object_ref_sink (_tmp54_);
			errorDialog = _tmp55_;
			_tmp56_ = errorDialog;
			gtk_dialog_run ((GtkDialog*) _tmp56_);
			_tmp57_ = errorDialog;
			gtk_widget_destroy ((GtkWidget*) _tmp57_);
			_g_object_unref0 (errorDialog);
			_g_error_free0 (e);
		}
		goto __finally19;
		__catch19_g_io_channel_error:
		{
			GError* e = NULL;
			FILE* _tmp58_;
			GError* _tmp59_;
			const gchar* _tmp60_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp58_ = stdout;
			_tmp59_ = e;
			_tmp60_ = _tmp59_->message;
			fprintf (_tmp58_, "readError() %s\n", _tmp60_);
			_g_error_free0 (e);
		}
		__finally19:
		if (_inner_error_ != NULL) {
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	}
	return obj;
}


static void moserial_rzwrapper_class_init (moserialRzwrapperClass * klass) {
	moserial_rzwrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (moserialRzwrapperPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_moserial_rzwrapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_moserial_rzwrapper_set_property;
	G_OBJECT_CLASS (klass)->constructor = moserial_rzwrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = moserial_rzwrapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PROTOCOL, g_param_spec_enum ("protocol", "protocol", "protocol", MOSERIAL_RZWRAPPER_TYPE_PROTOCOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_SC, g_param_spec_object ("sc", "sc", "sc", MOSERIAL_TYPE_SERIAL_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOSERIAL_RZWRAPPER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("transfer_complete", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("update_status", MOSERIAL_TYPE_RZWRAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void moserial_rzwrapper_instance_init (moserialRzwrapper * self) {
	self->priv = MOSERIAL_RZWRAPPER_GET_PRIVATE (self);
	self->running = FALSE;
}


static void moserial_rzwrapper_finalize (GObject* obj) {
	moserialRzwrapper * self;
	self = MOSERIAL_RZWRAPPER (obj);
	_g_object_unref0 (self->priv->_sc);
	_g_io_channel_unref0 (self->priv->IOChannelInput);
	_g_io_channel_unref0 (self->priv->IOChannelOutput);
	_g_io_channel_unref0 (self->priv->IOChannelError);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_filename);
	G_OBJECT_CLASS (moserial_rzwrapper_parent_class)->finalize (obj);
}


GType moserial_rzwrapper_get_type (void) {
	static volatile gsize moserial_rzwrapper_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_rzwrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (moserialRzwrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_rzwrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialRzwrapper), 0, (GInstanceInitFunc) moserial_rzwrapper_instance_init, NULL };
		GType moserial_rzwrapper_type_id;
		moserial_rzwrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialRzwrapper", &g_define_type_info, 0);
		g_once_init_leave (&moserial_rzwrapper_type_id__volatile, moserial_rzwrapper_type_id);
	}
	return moserial_rzwrapper_type_id__volatile;
}


static void _vala_moserial_rzwrapper_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	moserialRzwrapper * self;
	self = MOSERIAL_RZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL:
		g_value_set_enum (value, moserial_rzwrapper_get_protocol (self));
		break;
		case MOSERIAL_RZWRAPPER_SC:
		g_value_set_object (value, moserial_rzwrapper_get_sc (self));
		break;
		case MOSERIAL_RZWRAPPER_PATH:
		g_value_set_string (value, moserial_rzwrapper_get_path (self));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME:
		g_value_set_string (value, moserial_rzwrapper_get_filename (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_moserial_rzwrapper_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	moserialRzwrapper * self;
	self = MOSERIAL_RZWRAPPER (object);
	switch (property_id) {
		case MOSERIAL_RZWRAPPER_PROTOCOL:
		moserial_rzwrapper_set_protocol (self, g_value_get_enum (value));
		break;
		case MOSERIAL_RZWRAPPER_SC:
		moserial_rzwrapper_set_sc (self, g_value_get_object (value));
		break;
		case MOSERIAL_RZWRAPPER_PATH:
		moserial_rzwrapper_set_path (self, g_value_get_string (value));
		break;
		case MOSERIAL_RZWRAPPER_FILENAME:
		moserial_rzwrapper_set_filename (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



