//------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All rights reserved.
//------------------------------------------------------------

namespace System.IdentityModel.Configuration
{
    static class ConfigurationStrings
    {
        public const string Add                                             = "add";
        public const string ApplicationService                              = "applicationService";
        public const string AudienceUris                                    = "audienceUris";
        public const string AudienceUriMode                                 = "audienceUriMode";
        public const string Caches                                          = "caches";
        public const string Capacity                                        = "capacity";
        public const string CertificateReference                            = "certificateReference";
        public const string ClaimsAuthenticationManager                     = "claimsAuthenticationManager";
        public const string ClaimsAuthorizationManager                      = "claimsAuthorizationManager";
        public const string Clear                                           = "clear";
        public const string Compression                                     = "compression";
        public const string CookieTransforms                                = "cookieTransforms";
        public const string DefaultCollectionName                           = ""; // String.Empty        
        public const string DefaultConfigurationElementName                 = ""; // String.Empty        
        public const string DefaultServiceName                              = ""; // String.Empty        
        public const string DetectReplayedTokens                            = "detectReplayedTokens";
        public const string Enabled                                         = "enabled";
        public const string ExpirationPeriod                                = "expirationPeriod";
        public const string FederatedAuthentication                         = "federatedAuthentication";
        public const string FindValue                                       = "findValue"; 
        public const string IsChainIncluded                                 = "isChainIncluded"; 
        public const string IssuerNameRegistry                              = "issuerNameRegistry";
        public const string IssuerTokenResolver                             = "issuerTokenResolver";
        public const string IssuerCertificateRevocationMode                 = "issuerCertificateRevocationMode";
        public const string IssuerCertificateTrustedStoreLocation           = "issuerCertificateTrustedStoreLocation";
        public const string IssuerCertificateValidationMode                 = "issuerCertificateValidationMode";
        public const string IssuerCertificateValidator                      = "issuerCertificateValidator";
        public const string KerberosTokenHandlerRequirement                 = "kerberosTokenHandlerRequirement";
        public const string Lifetime                                        = "lifetime";
        public const string MapToWindows                                    = "mapToWindows";
        public const string MaximumClockSkew                                = "maximumClockSkew";
        public const string MembershipProviderName                          = "membershipProviderName";
        public const string Mode                                            = "mode";
        public const string IdentityConfiguration                           = "identityConfiguration";
        public const string SystemIdentityModel                             = "system.identityModel";
        public const string Name                                            = "name";
        public const string NameClaimType                                   = "nameClaimType";
        public const string PersistentSessionLifetime                       = "persistentSessionLifetime";
        public const string Protection                                      = "protection";
        public const string PurgeInterval                                   = "purgeInterval";        
        public const string Remove                                          = "remove";
        public const string RoleClaimType                                   = "roleClaimType";
        public const string ServiceCertificate                              = "serviceCertificate";
        public const string SamlSecurityTokenRequirement                    = "samlSecurityTokenRequirement";
        public const string SaveBootstrapContext                            = "saveBootstrapContext";
        public const string ServiceTokenResolver                            = "serviceTokenResolver";
        public const string SecurityTokenHandlerConfiguration               = "securityTokenHandlerConfiguration";
        public const string SecurityTokenHandlers                           = "securityTokenHandlers";
        public const string SessionSecurityTokenCache                       = "sessionSecurityTokenCache";
        public const string SessionTokenRequirement                         = "sessionTokenRequirement";
        public const string SecurityTokenCacheType                          = "securityTokenCacheType";
        public const string SecurityTokenCacheSize                          = "securityTokenCacheSize";
        public const string StoreLocation                                   = "storeLocation";
        public const string StoreName                                       = "storeName";
        public const string Thumbprint                                      = "thumbprint";
        public const string TimeSpanZero                                    = "00:00:00";
        public const string TimeSpanMaxValue                                = "10675199.02:48:05.4775807"; // TimeSpan.MaxValue is 10675199.02:48:05.4775807
        public const string TokenReplayCache                                = "tokenReplayCache";
        public const string TokenReplayDetection                            = "tokenReplayDetection";
        public const string TransientSessionLifetime                        = "transientSessionLifetime";
        public const string TrustedIssuers                                  = "trustedIssuers";
        public const string Type                                            = "type";
        public const string UserNameSecurityTokenHandlerRequirement         = "userNameSecurityTokenHandlerRequirement";
        public const string UseWindowsTokenService                          = "useWindowsTokenService";
        public const string Value                                           = "value";
        public const string WindowsClaimsIdentity                           = "windowsClaimsIdentity";
        public const string X509CertificateRevocationMode                   = "revocationMode";
        public const string X509CertificateValidation                       = "certificateValidation";
        public const string X509CertificateValidationMode                   = "certificateValidationMode";
        public const string X509CertificateValidationModeChainTrust         = "ChainTrust";
        public const string X509CertificateValidationModeCustom             = "Custom";
        public const string X509CertificateValidationModeNone               = "None";
        public const string X509CertificateValidationModePeerTrust          = "PeerTrust";
        public const string X509CertificateValidationModePeerOrChainTrust   = "PeerOrChainTrust";
        public const string X509CertificateValidator                        = "certificateValidator";
        public const string X509FindType                                    = "x509FindType"; 
        public const string X509RevocationModeNoCheck                       = "NoCheck";
        public const string X509RevocationModeOnline                        = "Online";
        public const string X509RevocationModeOffline                       = "Offline";
        public const string X509SecurityTokenHandlerRequirement             = "x509SecurityTokenHandlerRequirement";
        public const string X509TrustedStoreLocation                        = "trustedStoreLocation";
        public const string X509TrustedStoreLocationCurrentUser             = "CurrentUser";
        public const string X509TrustedStoreLocationLocalMachine            = "LocalMachine";
      
    }
}
