C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq5HJ (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=9)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ5HJ                                          
C       PARAMETER (ISET=4)
        DATA  DrI, FlI, AlI /   2.,   5.,  .2260 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.300,    4.500,  180.000 /
C        DATA  NX,  NT, NfMx /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .100000E+01, .100000E+05,
     +  .100000E+01, .130000E+01, .167097E+01, .222659E+01, .309171E+01,
     +  .450000E+01, .754288E+01, .138228E+02, .281243E+02, .646894E+02,
     +  .171811E+03, .540159E+03, .206963E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                                  
        DATA (UPDI(I),I=1,52) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .218875E+06,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=469,520) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=521,572) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .121417E+06, .926265E+05,
     +  .695419E+05, .521635E+05, .391008E+05, .292798E+05,
     +  .219089E+05, .163761E+05, .122304E+05, .912381E+04,
     +  .680024E+04, .506218E+04, .376471E+04, .279607E+04,
     +  .207449E+04, .153692E+04, .113736E+04, .840370E+03,
     +  .620163E+03, .456894E+03, .336165E+03, .246897E+03,
     +  .181073E+03, .132548E+03, .968730E+02, .706682E+02 /
        DATA (UPDI(I),I=573,624) /
     +  .514877E+02, .372650E+02, .270548E+02, .196027E+02,
     +  .141865E+02, .102489E+02, .739719E+01, .533739E+01,
     +  .384770E+01, .277267E+01, .200003E+01, .144346E+01,
     +  .104406E+01, .756407E+00, .550141E+00, .401255E+00,
     +  .293943E+00, .216144E+00, .159784E+00, .118607E+00,
     +  .886379E-01, .663749E-01, .500949E-01, .378767E-01,
     +  .288156E-01, .219942E-01, .168675E-01, .129748E-01,
     +  .100233E-01, .776071E-02, .602959E-02, .469374E-02,
     +  .366661E-02, .286833E-02, .225066E-02, .176809E-02,
     +  .139217E-02, .109870E-02, .866893E-03, .683512E-03,
     +  .538821E-03, .423836E-03, .332627E-03, .259695E-03,
     +  .201582E-03, .154999E-03, .117793E-03, .879986E-04,
     +  .647685E-04, .463223E-04, .320809E-04, .212718E-04 /
        DATA (UPDI(I),I=625,676) /
     +  .133069E-04, .763976E-05, .381347E-05, .142555E-05,
     +  .789486E-07, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .280801E+06, .213515E+06, .159690E+06,
     +  .119324E+06, .890956E+05, .664568E+05, .495305E+05,
     +  .368749E+05, .274290E+05, .203789E+05, .151266E+05,
     +  .112138E+05, .830464E+04, .614186E+04, .453726E+04,
     +  .334697E+04, .246595E+04, .181397E+04, .133261E+04,
     +  .977311E+03, .715734E+03, .523212E+03, .381888E+03,
     +  .278198E+03, .202322E+03, .146853E+03, .106446E+03,
     +  .766375E+02, .553441E+02, .398850E+02, .287053E+02,
     +  .206220E+02, .147983E+02, .106156E+02, .760664E+01,
     +  .544809E+01, .390525E+01, .280072E+01, .201261E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .144860E+01, .104653E+01, .758191E+00, .551620E+00,
     +  .402862E+00, .295749E+00, .218021E+00, .161796E+00,
     +  .120323E+00, .901741E-01, .677098E-01, .511534E-01,
     +  .387785E-01, .295360E-01, .225676E-01, .173170E-01,
     +  .133210E-01, .102835E-01, .795659E-02, .617865E-02,
     +  .480690E-02, .375224E-02, .293406E-02, .230071E-02,
     +  .180935E-02, .142365E-02, .112045E-02, .882550E-03,
     +  .694500E-03, .545991E-03, .427745E-03, .333812E-03,
     +  .258700E-03, .198756E-03, .150782E-03, .113245E-03,
     +  .833161E-04, .600106E-04, .420832E-04, .285867E-04,
     +  .186624E-04, .116103E-04, .681392E-05, .368477E-05,
     +  .180762E-05, .773541E-06, .270791E-06, .691132E-07,
     +  .914073E-08, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .486224E+06, .368478E+06, .274507E+06, .204312E+06,
     +  .151946E+06, .112885E+06, .837930E+05, .621294E+05,
     +  .460241E+05, .340530E+05, .251704E+05, .185809E+05,
     +  .137016E+05, .100897E+05, .742113E+04, .545022E+04,
     +  .399761E+04, .292742E+04, .214074E+04, .156274E+04,
     +  .113909E+04, .828743E+03, .601969E+03, .436379E+03,
     +  .315783E+03, .228046E+03, .164444E+03, .117766E+03,
     +  .845900E+02, .606324E+02, .433947E+02, .309998E+02,
     +  .221167E+02, .157729E+02, .112341E+02, .799721E+01,
     +  .569653E+01, .405961E+01, .289836E+01, .207258E+01,
     +  .148736E+01, .107038E+01, .773469E+00, .561076E+00,
     +  .409072E+00, .299510E+00, .220742E+00, .163049E+00,
     +  .121354E+00, .905066E-01, .679110E-01, .511410E-01 /
        DATA (UPDI(I),I=781,832) /
     +  .386918E-01, .293706E-01, .223890E-01, .171127E-01,
     +  .131266E-01, .100939E-01, .779007E-02, .602471E-02,
     +  .467512E-02, .363505E-02, .283439E-02, .221688E-02,
     +  .173487E-02, .135834E-02, .106452E-02, .833662E-03,
     +  .652320E-03, .508824E-03, .395464E-03, .305388E-03,
     +  .233937E-03, .177156E-03, .132941E-03, .979166E-04,
     +  .707793E-04, .499907E-04, .343696E-04, .228738E-04,
     +  .146598E-04, .899844E-05, .521853E-05, .285127E-05,
     +  .144689E-05, .670696E-06, .277157E-06, .962611E-07,
     +  .228865E-07, .108265E-08, .000000E+00, .746829E+06,
     +  .564043E+06, .418514E+06, .310242E+06, .229789E+06,
     +  .170019E+06, .125682E+06, .928020E+05, .684570E+05,
     +  .504373E+05, .371215E+05, .272856E+05, .200328E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .146873E+05, .107547E+05, .786312E+04, .574123E+04,
     +  .418503E+04, .304619E+04, .221330E+04, .160561E+04,
     +  .116254E+04, .840297E+03, .606135E+03, .436421E+03,
     +  .313552E+03, .224923E+03, .160217E+03, .114463E+03,
     +  .815987E+02, .580743E+02, .412523E+02, .292608E+02,
     +  .207459E+02, .146870E+02, .103917E+02, .735587E+01,
     +  .520916E+01, .369512E+01, .262526E+01, .187153E+01,
     +  .133794E+01, .960319E+00, .691962E+00, .501080E+00,
     +  .364408E+00, .266754E+00, .195716E+00, .144681E+00,
     +  .107187E+00, .798891E-01, .597686E-01, .449222E-01,
     +  .338809E-01, .256600E-01, .194891E-01, .148552E-01,
     +  .113531E-01, .870763E-02, .669391E-02, .516299E-02,
     +  .399071E-02, .309316E-02, .240494E-02, .187071E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .145600E-02, .113419E-02, .882914E-03, .686663E-03,
     +  .532407E-03, .411305E-03, .315768E-03, .240537E-03,
     +  .181241E-03, .135371E-03, .993438E-04, .716366E-04,
     +  .505653E-04, .348252E-04, .232955E-04, .150721E-04,
     +  .939218E-05, .557401E-05, .314481E-05, .166415E-05,
     +  .811298E-06, .352737E-06, .127109E-06, .308657E-07,
     +  .204104E-08, .000000E+00, .107240E+07, .807135E+06,
     +  .596447E+06, .440337E+06, .324802E+06, .239322E+06,
     +  .176172E+06, .129535E+06, .951471E+05, .698016E+05,
     +  .511511E+05, .374339E+05, .273625E+05, .199720E+05,
     +  .145587E+05, .105961E+05, .770121E+04, .558778E+04,
     +  .404813E+04, .292737E+04, .211342E+04, .152280E+04,
     +  .109527E+04, .786120E+03, .563147E+03, .402516E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .287228E+03, .203499E+03, .144600E+03, .102520E+03,
     +  .725568E+02, .512487E+02, .361410E+02, .254743E+02,
     +  .179261E+02, .126065E+02, .886821E+01, .624082E+01,
     +  .439863E+01, .310500E+01, .219905E+01, .156178E+01,
     +  .111353E+01, .797049E+00, .573315E+00, .414167E+00,
     +  .301154E+00, .219495E+00, .161177E+00, .118623E+00,
     +  .878315E-01, .652875E-01, .487526E-01, .365365E-01,
     +  .274945E-01, .207520E-01, .157191E-01, .119400E-01,
     +  .910139E-02, .695447E-02, .533133E-02, .409619E-02,
     +  .315561E-02, .243858E-02, .188509E-02, .145812E-02,
     +  .112868E-02, .873066E-03, .674621E-03, .519708E-03,
     +  .398883E-03, .304273E-03, .230340E-03, .172549E-03,
     +  .128163E-03, .936025E-04, .672325E-04, .473329E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .325665E-04, .218117E-04, .141666E-04, .888971E-05,
     +  .533344E-05, .305233E-05, .164217E-05, .813724E-06,
     +  .357481E-06, .128443E-06, .307454E-07, .226331E-08,
     +  .000000E+00, .147315E+07, .110491E+07, .813133E+06,
     +  .597835E+06, .439139E+06, .322215E+06, .236189E+06,
     +  .172926E+06, .126474E+06, .923827E+05, .674030E+05,
     +  .491109E+05, .357382E+05, .259687E+05, .188443E+05,
     +  .136527E+05, .987690E+04, .713303E+04, .514322E+04,
     +  .370158E+04, .265946E+04, .190689E+04, .136475E+04,
     +  .974635E+03, .694648E+03, .493943E+03, .350620E+03,
     +  .247077E+03, .174618E+03, .123128E+03, .866554E+02,
     +  .608619E+02, .426727E+02, .299032E+02, .209171E+02,
     +  .146212E+02, .102219E+02, .714875E+01, .500663E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .351168E+01, .247096E+01, .174350E+01, .123493E+01,
     +  .878165E+00, .627490E+00, .450324E+00, .325291E+00,
     +  .235537E+00, .171822E+00, .125638E+00, .924221E-01,
     +  .682629E-01, .506494E-01, .377199E-01, .282062E-01,
     +  .211576E-01, .159274E-01, .120248E-01, .911003E-02,
     +  .691927E-02, .527216E-02, .402647E-02, .308298E-02,
     +  .236789E-02, .181903E-02, .139825E-02, .107548E-02,
     +  .826618E-03, .634594E-03, .485720E-03, .370374E-03,
     +  .280723E-03, .211198E-03, .157288E-03, .116178E-03,
     +  .844350E-04, .603978E-04, .423922E-04, .291159E-04,
     +  .194988E-04, .126856E-04, .798880E-05, .481972E-05,
     +  .277676E-05, .150329E-05, .747523E-06, .327312E-06,
     +  .115874E-06, .271033E-07, .211947E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .195942E+07, .146452E+07, .107334E+07, .785874E+06,
     +  .574851E+06, .420019E+06, .306575E+06, .223502E+06,
     +  .162759E+06, .118371E+06, .859861E+05, .623745E+05,
     +  .451878E+05, .326878E+05, .236122E+05, .170289E+05,
     +  .122623E+05, .881439E+04, .632551E+04, .453077E+04,
     +  .323947E+04, .231144E+04, .164610E+04, .116968E+04,
     +  .829434E+03, .586740E+03, .414313E+03, .290394E+03,
     +  .204128E+03, .143154E+03, .100191E+03, .699736E+02,
     +  .487803E+02, .339854E+02, .236317E+02, .164197E+02,
     +  .114092E+02, .792990E+01, .551889E+01, .384658E+01,
     +  .268929E+01, .188537E+01, .132677E+01, .937372E+00,
     +  .665434E+00, .474456E+00, .340500E+00, .244959E+00,
     +  .177540E+00, .128988E+00, .942812E-01, .691989E-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .510210E-01, .377612E-01, .280616E-01, .209206E-01,
     +  .156528E-01, .117464E-01, .884527E-02, .667810E-02,
     +  .505778E-02, .383973E-02, .292219E-02, .223079E-02,
     +  .170312E-02, .130109E-02, .994496E-03, .759600E-03,
     +  .579461E-03, .440743E-03, .333971E-03, .251584E-03,
     +  .188164E-03, .139360E-03, .102398E-03, .740788E-04,
     +  .527839E-04, .369387E-04, .253217E-04, .169466E-04,
     +  .110306E-04, .695745E-05, .420750E-05, .242922E-05,
     +  .131567E-05, .652037E-06, .282606E-06, .980466E-07,
     +  .223430E-07, .182234E-08, .000000E+00, .254140E+07,
     +  .189293E+07, .138159E+07, .100738E+07, .733801E+06,
     +  .533905E+06, .388047E+06, .281691E+06, .204249E+06,
     +  .147903E+06, .106967E+06, .772520E+05, .557166E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .401232E+05, .288518E+05, .207124E+05, .148458E+05,
     +  .106217E+05, .758655E+04, .540816E+04, .384816E+04,
     +  .273239E+04, .193628E+04, .136902E+04, .965881E+03,
     +  .679751E+03, .477492E+03, .332891E+03, .232751E+03,
     +  .162346E+03, .112997E+03, .784782E+02, .543983E+02,
     +  .376821E+02, .260485E+02, .179916E+02, .124259E+02,
     +  .858391E+01, .593708E+01, .411226E+01, .285688E+01,
     +  .199018E+01, .139157E+01, .976885E+00, .689032E+00,
     +  .488137E+00, .348082E+00, .248819E+00, .179190E+00,
     +  .129366E+00, .939625E-01, .685377E-01, .502203E-01,
     +  .369412E-01, .272839E-01, .202180E-01, .150360E-01,
     +  .112164E-01, .839565E-02, .630121E-02, .474397E-02,
     +  .358030E-02, .270848E-02, .205532E-02, .155966E-02 /
        DATA (UPDI(I),I=1249,1300) /
     +  .118432E-02, .899754E-03, .683087E-03, .517936E-03,
     +  .391596E-03, .294973E-03, .220935E-03, .164342E-03,
     +  .121096E-03, .885551E-04, .637973E-04, .452971E-04,
     +  .316122E-04, .216282E-04, .144594E-04, .940780E-05,
     +  .593400E-05, .358847E-05, .206948E-05, .111680E-05,
     +  .549193E-06, .234640E-06, .795459E-07, .176441E-07,
     +  .148701E-08, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .278191E+05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .293926E+05, .229792E+05, .177476E+05, .136977E+05,
     +  .105664E+05, .814481E+04, .627459E+04, .482988E+04,
     +  .371548E+04, .285568E+04, .219334E+04, .168298E+04,
     +  .129042E+04, .988371E+03, .756409E+03, .578208E+03,
     +  .441600E+03, .336832E+03, .256672E+03, .195314E+03,
     +  .148475E+03, .112700E+03, .854514E+02, .646872E+02,
     +  .489112E+02, .369259E+02, .278538E+02, .208898E+02,
     +  .157159E+02, .118038E+02, .886065E+01, .664227E+01,
     +  .497820E+01, .373089E+01, .279613E+01, .209538E+01,
     +  .157317E+01, .118198E+01, .890754E+00, .672423E+00,
     +  .509935E+00, .387760E+00, .296318E+00, .227211E+00,
     +  .175228E+00, .135617E+00, .105681E+00, .824755E-01,
     +  .648709E-01, .510815E-01, .404668E-01, .321310E-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .256332E-01, .204915E-01, .164509E-01, .132237E-01,
     +  .106647E-01, .861037E-02, .697691E-02, .565760E-02,
     +  .460331E-02, .374952E-02, .306350E-02, .251052E-02,
     +  .206026E-02, .169204E-02, .139269E-02, .114693E-02,
     +  .945742E-03, .778802E-03, .640533E-03, .524471E-03,
     +  .427163E-03, .343929E-03, .274869E-03, .215521E-03,
     +  .165565E-03, .123789E-03, .894369E-04, .618621E-04,
     +  .403715E-04, .245059E-04, .131593E-04, .591919E-05,
     +  .178118E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .711209E+05,
     +  .553488E+05, .425248E+05, .326491E+05, .250537E+05,
     +  .192104E+05, .147213E+05, .112719E+05, .862526E+04,
     +  .659409E+04, .503773E+04, .384493E+04, .293232E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .223392E+04, .170046E+04, .129286E+04, .982073E+03,
     +  .745032E+03, .564645E+03, .427334E+03, .323078E+03,
     +  .243891E+03, .183904E+03, .138449E+03, .104102E+03,
     +  .781535E+02, .586195E+02, .437111E+02, .326952E+02,
     +  .244151E+02, .182193E+02, .135772E+02, .101138E+02,
     +  .753377E+01, .561063E+01, .417804E+01, .311624E+01,
     +  .232606E+01, .174103E+01, .130542E+01, .983026E+00,
     +  .742306E+00, .563173E+00, .428775E+00, .328261E+00,
     +  .252240E+00, .195119E+00, .151191E+00, .118049E+00,
     +  .922976E-01, .725930E-01, .572437E-01, .453504E-01,
     +  .360140E-01, .287206E-01, .229426E-01, .183900E-01,
     +  .147646E-01, .118991E-01, .960309E-02, .777930E-02,
     +  .631302E-02, .514180E-02, .420305E-02, .344274E-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .282441E-02, .232380E-02, .191435E-02, .157991E-02,
     +  .130301E-02, .107388E-02, .881808E-03, .720547E-03,
     +  .582992E-03, .468563E-03, .370301E-03, .287582E-03,
     +  .218288E-03, .161203E-03, .115040E-03, .787659E-04,
     +  .513632E-04, .312286E-04, .175738E-04, .891027E-05,
     +  .392209E-05, .143652E-05, .409739E-06, .428622E-07,
     +  .000000E+00, .000000E+00, .127700E+06, .989573E+05,
     +  .756584E+05, .578035E+05, .441384E+05, .336771E+05,
     +  .256800E+05, .195653E+05, .148969E+05, .113320E+05,
     +  .861400E+04, .654142E+04, .496364E+04, .376232E+04,
     +  .284933E+04, .215532E+04, .162884E+04, .122936E+04,
     +  .926901E+03, .697874E+03, .524869E+03, .394157E+03,
     +  .295646E+03, .221398E+03, .165585E+03, .123646E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .922380E+02, .683997E+02, .508783E+02, .377824E+02,
     +  .280341E+02, .207721E+02, .153828E+02, .113914E+02,
     +  .843210E+01, .624096E+01, .462562E+01, .343103E+01,
     +  .255141E+01, .190066E+01, .142171E+01, .106646E+01,
     +  .803586E+00, .607716E+00, .462053E+00, .352655E+00,
     +  .270923E+00, .208528E+00, .161706E+00, .125598E+00,
     +  .981246E-01, .768826E-01, .605159E-01, .477609E-01,
     +  .378515E-01, .300583E-01, .239529E-01, .191257E-01,
     +  .153296E-01, .123094E-01, .992215E-02, .801507E-02,
     +  .649880E-02, .528956E-02, .431430E-02, .352523E-02,
     +  .288864E-02, .237012E-02, .194778E-02, .159948E-02,
     +  .131213E-02, .107232E-02, .871733E-03, .701857E-03,
     +  .561116E-03, .441234E-03, .341087E-03, .257905E-03 /
        DATA (UPDI(I),I=1717,1768) /
     +  .189969E-03, .135474E-03, .929816E-04, .610131E-04,
     +  .376301E-04, .217091E-04, .114873E-04, .544051E-05,
     +  .224609E-05, .765738E-06, .154167E-06, .000000E+00,
     +  .000000E+00, .174712E+06, .156057E+06, .118759E+06,
     +  .903092E+05, .686362E+05, .521224E+05, .395574E+05,
     +  .299955E+05, .227296E+05, .172076E+05, .130176E+05,
     +  .983787E+04, .742884E+04, .560355E+04, .422301E+04,
     +  .317877E+04, .239044E+04, .179525E+04, .134683E+04,
     +  .100898E+04, .755028E+03, .564132E+03, .420980E+03,
     +  .313642E+03, .233361E+03, .173346E+03, .128630E+03,
     +  .948729E+02, .701891E+02, .518403E+02, .382518E+02,
     +  .281853E+02, .207535E+02, .152808E+02, .112443E+02,
     +  .827319E+01, .609446E+01, .449296E+01, .332011E+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .245782E+01, .182664E+01, .136144E+01, .101916E+01,
     +  .765777E+00, .578397E+00, .438602E+00, .334746E+00,
     +  .256008E+00, .197237E+00, .152230E+00, .118178E+00,
     +  .920310E-01, .719955E-01, .564864E-01, .445017E-01,
     +  .351399E-01, .278456E-01, .221161E-01, .176327E-01,
     +  .140883E-01, .112996E-01, .908496E-02, .733165E-02,
     +  .593987E-02, .482188E-02, .392169E-02, .319798E-02,
     +  .261096E-02, .213431E-02, .174297E-02, .142131E-02,
     +  .115425E-02, .932030E-03, .745298E-03, .591481E-03,
     +  .461682E-03, .354228E-03, .265894E-03, .194494E-03,
     +  .137837E-03, .941173E-04, .615249E-04, .379202E-04,
     +  .219414E-04, .117083E-04, .563764E-05, .238513E-05,
     +  .833667E-06, .179993E-06, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .318864E+06, .244973E+06, .185445E+06, .140279E+06,
     +  .106049E+06, .801071E+05, .604705E+05, .456080E+05,
     +  .343733E+05, .258820E+05, .194727E+05, .146359E+05,
     +  .109909E+05, .824461E+04, .617868E+04, .462489E+04,
     +  .345826E+04, .258253E+04, .192637E+04, .143489E+04,
     +  .106751E+04, .792980E+03, .588270E+03, .435695E+03,
     +  .322232E+03, .237920E+03, .175467E+03, .128612E+03,
     +  .945538E+02, .693981E+02, .508781E+02, .372475E+02,
     +  .272446E+02, .199276E+02, .145635E+02, .106421E+02,
     +  .778419E+01, .569834E+01, .418031E+01, .307236E+01,
     +  .226647E+01, .167690E+01, .124590E+01, .929263E+00,
     +  .696605E+00, .524361E+00, .397222E+00, .301588E+00,
     +  .230646E+00, .176750E+00, .136228E+00, .105359E+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .818485E-01, .637886E-01, .499143E-01, .391589E-01,
     +  .308276E-01, .243309E-01, .192736E-01, .153034E-01,
     +  .121949E-01, .974219E-02, .780889E-02, .628259E-02,
     +  .506174E-02, .408444E-02, .330218E-02, .267134E-02,
     +  .216167E-02, .174618E-02, .140701E-02, .112798E-02,
     +  .898113E-03, .707513E-03, .552437E-03, .423708E-03,
     +  .318943E-03, .234496E-03, .167651E-03, .115837E-03,
     +  .768406E-04, .485786E-04, .287737E-04, .158638E-04,
     +  .796701E-05, .355066E-05, .136145E-05, .419256E-06,
     +  .731637E-07, .000000E+00, .000000E+00, .473599E+06,
     +  .362237E+06, .272804E+06, .205298E+06, .154397E+06,
     +  .116020E+06, .871203E+05, .653615E+05, .489995E+05,
     +  .366984E+05, .274625E+05, .205298E+05, .153332E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .114392E+05, .852565E+04, .634643E+04, .471910E+04,
     +  .350439E+04, .259926E+04, .192513E+04, .142403E+04,
     +  .105173E+04, .775682E+03, .571138E+03, .419903E+03,
     +  .308183E+03, .225910E+03, .164562E+03, .120235E+03,
     +  .876985E+02, .638867E+02, .464725E+02, .337704E+02,
     +  .245392E+02, .178131E+02, .129289E+02, .939142E+01,
     +  .682727E+01, .497300E+01, .362909E+01, .265784E+01,
     +  .195233E+01, .143995E+01, .106625E+01, .793443E+00,
     +  .592949E+00, .445924E+00, .336155E+00, .255236E+00,
     +  .194223E+00, .148645E+00, .114181E+00, .880982E-01,
     +  .682067E-01, .530185E-01, .413296E-01, .323307E-01,
     +  .253621E-01, .199680E-01, .157622E-01, .124867E-01,
     +  .991862E-02, .790436E-02, .632281E-02, .506387E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .406178E-02, .326341E-02, .262304E-02, .210812E-02,
     +  .169086E-02, .135214E-02, .107545E-02, .849143E-03,
     +  .663266E-03, .513259E-03, .390094E-03, .290937E-03,
     +  .211968E-03, .150208E-03, .102937E-03, .677875E-04,
     +  .426064E-04, .251646E-04, .138898E-04, .702646E-05,
     +  .318469E-05, .125477E-05, .399240E-06, .763546E-07,
     +  .000000E+00, .000000E+00, .674469E+06, .513652E+06,
     +  .384892E+06, .288189E+06, .215636E+06, .161210E+06,
     +  .120432E+06, .898871E+05, .670351E+05, .499437E+05,
     +  .371774E+05, .276450E+05, .205372E+05, .152394E+05,
     +  .112964E+05, .836323E+04, .618464E+04, .456735E+04,
     +  .336881E+04, .248112E+04, .182492E+04, .134013E+04,
     +  .982703E+03, .719377E+03, .525791E+03, .383611E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .279516E+03, .202363E+03, .146949E+03, .106522E+03,
     +  .771123E+02, .557381E+02, .402423E+02, .290523E+02,
     +  .209493E+02, .151035E+02, .108962E+02, .786700E+01,
     +  .569039E+01, .412363E+01, .299862E+01, .218707E+01,
     +  .160154E+01, .117749E+01, .869949E+00, .645520E+00,
     +  .482021E+00, .360828E+00, .272050E+00, .205596E+00,
     +  .156273E+00, .119242E+00, .913918E-01, .702995E-01,
     +  .542929E-01, .420589E-01, .326979E-01, .254968E-01,
     +  .199542E-01, .156602E-01, .123340E-01, .974183E-02,
     +  .771874E-02, .613862E-02, .488701E-02, .389626E-02,
     +  .311072E-02, .248403E-02, .198265E-02, .157882E-02,
     +  .125295E-02, .988649E-03, .774124E-03, .599539E-03,
     +  .459826E-03, .346343E-03, .255958E-03, .184816E-03 /
        DATA (UPDI(I),I=2081,2132) /
     +  .129829E-03, .882539E-04, .577016E-04, .360588E-04,
     +  .212324E-04, .117251E-04, .596505E-05, .273901E-05,
     +  .110061E-05, .358262E-06, .725516E-07, .111253E-08,
     +  .000000E+00, .930609E+06, .705740E+06, .526226E+06,
     +  .392066E+06, .291900E+06, .217133E+06, .161391E+06,
     +  .119846E+06, .889203E+05, .659080E+05, .488066E+05,
     +  .361031E+05, .266796E+05, .196924E+05, .145194E+05,
     +  .106916E+05, .786363E+04, .577560E+04, .423656E+04,
     +  .310293E+04, .226950E+04, .165721E+04, .120829E+04,
     +  .879435E+03, .639047E+03, .463500E+03, .335720E+03,
     +  .241577E+03, .174361E+03, .125620E+03, .903717E+02,
     +  .649124E+02, .465670E+02, .334023E+02, .239280E+02,
     +  .171369E+02, .122800E+02, .880612E+01, .632592E+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .455261E+01, .328747E+01, .238103E+01, .173132E+01,
     +  .126401E+01, .927318E+00, .683299E+00, .506691E+00,
     +  .376690E+00, .282061E+00, .211724E+00, .159853E+00,
     +  .121177E+00, .922714E-01, .705256E-01, .541236E-01,
     +  .416707E-01, .321996E-01, .249602E-01, .194194E-01,
     +  .151533E-01, .118663E-01, .931954E-02, .734175E-02,
     +  .580501E-02, .459386E-02, .364034E-02, .288808E-02,
     +  .229117E-02, .181614E-02, .143587E-02, .113090E-02,
     +  .885321E-03, .687549E-03, .528031E-03, .401458E-03,
     +  .299718E-03, .219534E-03, .157131E-03, .109446E-03,
     +  .738094E-04, .479139E-04, .297670E-04, .174638E-04,
     +  .963520E-05, .491523E-05, .227303E-05, .921856E-06,
     +  .302232E-06, .625844E-07, .206790E-08, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .125180E+07, .945422E+06, .701537E+06, .520147E+06,
     +  .385365E+06, .285248E+06, .210968E+06, .155879E+06,
     +  .115074E+06, .848610E+05, .625209E+05, .460100E+05,
     +  .338243E+05, .248357E+05, .182152E+05, .133419E+05,
     +  .976038E+04, .713007E+04, .520164E+04, .378889E+04,
     +  .275587E+04, .200114E+04, .145083E+04, .104995E+04,
     +  .758572E+03, .546986E+03, .393859E+03, .281707E+03,
     +  .202104E+03, .144725E+03, .103475E+03, .738629E+02,
     +  .526535E+02, .375280E+02, .267093E+02, .190038E+02,
     +  .135273E+02, .963574E+01, .687503E+01, .491417E+01,
     +  .352419E+01, .253494E+01, .183050E+01, .132724E+01,
     +  .966984E+00, .707649E+00, .521172E+00, .384838E+00,
     +  .286225E+00, .213426E+00, .160079E+00, .120570E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .912232E-01, .692893E-01, .528453E-01, .404408E-01,
     +  .310630E-01, .239389E-01, .185169E-01, .143671E-01,
     +  .111868E-01, .873648E-02, .684310E-02, .537951E-02,
     +  .423184E-02, .333318E-02, .262779E-02, .207113E-02,
     +  .163053E-02, .127999E-02, .100064E-02, .777305E-03,
     +  .598854E-03, .456163E-03, .343897E-03, .254563E-03,
     +  .184870E-03, .131213E-03, .906538E-04, .606757E-04,
     +  .391197E-04, .241661E-04, .141239E-04, .777921E-05,
     +  .397142E-05, .184210E-05, .748866E-06, .244930E-06,
     +  .509349E-07, .228563E-08, .000000E+00, .164825E+07,
     +  .123984E+07, .915650E+06, .675667E+06, .498184E+06,
     +  .366975E+06, .270091E+06, .198584E+06, .145874E+06,
     +  .107039E+06, .784637E+05, .574502E+05, .420188E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .306938E+05, .223948E+05, .163175E+05, .118742E+05,
     +  .862807E+04, .626068E+04, .453560E+04, .328096E+04,
     +  .236927E+04, .170815E+04, .122923E+04, .883047E+03,
     +  .633071E+03, .453192E+03, .322215E+03, .229793E+03,
     +  .163567E+03, .116235E+03, .824618E+02, .584166E+02,
     +  .413740E+02, .292581E+02, .206829E+02, .146261E+02,
     +  .103498E+02, .733525E+01, .520802E+01, .370968E+01,
     +  .265031E+01, .190080E+01, .136889E+01, .990567E+00,
     +  .720025E+00, .526739E+00, .386364E+00, .285462E+00,
     +  .211470E+00, .157590E+00, .117945E+00, .886785E-01,
     +  .669427E-01, .507446E-01, .386023E-01, .294767E-01,
     +  .225858E-01, .173703E-01, .134018E-01, .103764E-01,
     +  .805845E-02, .627618E-02, .490555E-02, .383624E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .300344E-02, .235312E-02, .184273E-02, .144099E-02,
     +  .112333E-02, .871795E-03, .672138E-03, .513841E-03,
     +  .388321E-03, .290388E-03, .213208E-03, .153581E-03,
     +  .108142E-03, .741436E-04, .492732E-04, .315642E-04,
     +  .193939E-04, .112909E-04, .620440E-05, .316477E-05,
     +  .146769E-05, .595121E-06, .192984E-06, .399102E-07,
     +  .213712E-08, .000000E+00, .213030E+07, .159617E+07,
     +  .117333E+07, .861766E+06, .632405E+06, .463635E+06,
     +  .339599E+06, .248486E+06, .181643E+06, .132632E+06,
     +  .967437E+05, .704818E+05, .512909E+05, .372770E+05,
     +  .270589E+05, .196142E+05, .141989E+05, .102632E+05,
     +  .740768E+04, .533790E+04, .384048E+04, .275822E+04,
     +  .197763E+04, .141525E+04, .101097E+04, .720658E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .512929E+03, .362543E+03, .257038E+03, .181877E+03,
     +  .128471E+03, .905901E+02, .637800E+02, .448926E+02,
     +  .315461E+02, .221584E+02, .155684E+02, .109450E+02,
     +  .770618E+01, .543529E+01, .384582E+01, .272928E+01,
     +  .194436E+01, .139094E+01, .999815E+00, .721932E+00,
     +  .524663E+00, .382326E+00, .280646E+00, .206570E+00,
     +  .152964E+00, .113771E+00, .850135E-01, .637880E-01,
     +  .480636E-01, .363486E-01, .275952E-01, .210241E-01,
     +  .160779E-01, .123357E-01, .949792E-02, .733539E-02,
     +  .568091E-02, .441506E-02, .343255E-02, .267144E-02,
     +  .208018E-02, .161870E-02, .125749E-02, .973634E-03,
     +  .750291E-03, .574263E-03, .435761E-03, .326821E-03,
     +  .242514E-03, .176682E-03, .126293E-03, .882622E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .600802E-04, .396613E-04, .252531E-04, .154363E-04,
     +  .895101E-05, .490402E-05, .249563E-05, .115405E-05,
     +  .464951E-06, .148849E-06, .304391E-07, .183581E-08,
     +  .000000E+00, .270812E+07, .202135E+07, .147910E+07,
     +  .108137E+07, .789892E+06, .576397E+06, .420210E+06,
     +  .306014E+06, .222626E+06, .161775E+06, .117428E+06,
     +  .851318E+05, .616456E+05, .445793E+05, .321966E+05,
     +  .232200E+05, .167231E+05, .120252E+05, .863420E+04,
     +  .618897E+04, .442913E+04, .316392E+04, .225622E+04,
     +  .160577E+04, .114073E+04, .808587E+03, .572254E+03,
     +  .402131E+03, .283458E+03, .199401E+03, .140017E+03,
     +  .981415E+02, .686778E+02, .480449E+02, .335515E+02,
     +  .234193E+02, .163498E+02, .114209E+02, .798932E+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .559842E+01, .393535E+01, .277453E+01, .196362E+01,
     +  .139552E+01, .996537E+00, .714877E+00, .516181E+00,
     +  .373725E+00, .272585E+00, .199373E+00, .146715E+00,
     +  .108456E+00, .805512E-01, .600800E-01, .450029E-01,
     +  .338374E-01, .255423E-01, .193510E-01, .147160E-01,
     +  .112288E-01, .859813E-02, .660415E-02, .508619E-02,
     +  .393070E-02, .303843E-02, .235091E-02, .181959E-02,
     +  .140717E-02, .108616E-02, .835435E-03, .639401E-03,
     +  .485968E-03, .366137E-03, .272611E-03, .200803E-03,
     +  .145220E-03, .103051E-03, .715108E-04, .483489E-04,
     +  .317163E-04, .200778E-04, .122110E-04, .705092E-05,
     +  .384870E-05, .195115E-05, .897529E-06, .358191E-06,
     +  .112862E-06, .227450E-07, .149704E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .783282E+04, .265842E+04, .219791E+04, .181717E+04,
     +  .150239E+04, .124214E+04, .102698E+04, .849091E+03,
     +  .702018E+03, .580424E+03, .479894E+03, .396779E+03,
     +  .328063E+03, .271251E+03, .224281E+03, .185448E+03,
     +  .153342E+03, .126798E+03, .104852E+03, .867084E+02,
     +  .717075E+02, .593052E+02, .490512E+02, .405734E+02,
     +  .335641E+02, .277688E+02, .229771E+02, .189642E+02,
     +  .156982E+02, .129974E+02, .107636E+02, .891602E+01,
     +  .738766E+01, .612662E+01, .508037E+01, .421472E+01,
     +  .349823E+01, .290487E+01, .241313E+01, .200508E+01,
     +  .166662E+01, .138508E+01, .115069E+01, .955292E+00,
     +  .792208E+00, .655972E+00, .542485E+00, .446999E+00,
     +  .367666E+00, .301004E+00, .245636E+00, .199565E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .161338E+00, .129728E+00, .103694E+00, .823535E-01,
     +  .649519E-01, .508460E-01, .394861E-01, .304024E-01,
     +  .231945E-01, .175223E-01, .130983E-01, .969448E-02,
     +  .707533E-02, .509627E-02, .361886E-02, .253033E-02,
     +  .173969E-02, .117430E-02, .776830E-03, .502601E-03,
     +  .317182E-03, .194587E-03, .116243E-03, .668537E-04,
     +  .369731E-04, .195485E-04, .980999E-05, .463026E-05,
     +  .203167E-05, .817438E-06, .293473E-06, .921126E-07,
     +  .241173E-07, .493057E-08, .704525E-09, .571549E-10,
     +  .165068E-11, .381378E-14, .000000E+00, .205298E+05,
     +  .199446E+05, .157261E+05, .123973E+05, .977315E+04,
     +  .770276E+04, .607108E+04, .478400E+04, .376995E+04,
     +  .297020E+04, .234029E+04, .184358E+04, .145246E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .114410E+04, .901359E+03, .709998E+03, .559395E+03,
     +  .440677E+03, .347262E+03, .273631E+03, .215708E+03,
     +  .170050E+03, .134133E+03, .105815E+03, .835359E+02,
     +  .659730E+02, .521550E+02, .411165E+02, .325635E+02,
     +  .258072E+02, .204851E+02, .162763E+02, .129561E+02,
     +  .103329E+02, .825478E+01, .660510E+01, .529874E+01,
     +  .425806E+01, .343085E+01, .276874E+01, .224040E+01,
     +  .181518E+01, .147340E+01, .119680E+01, .973196E+00,
     +  .791207E+00, .643823E+00, .522565E+00, .424333E+00,
     +  .343350E+00, .277491E+00, .223563E+00, .179609E+00,
     +  .143740E+00, .114625E+00, .909876E-01, .719192E-01,
     +  .565624E-01, .442890E-01, .344973E-01, .267523E-01,
     +  .206446E-01, .158668E-01, .121621E-01, .928005E-02 /
        DATA (UPDI(I),I=2705,2756) /
     +  .706055E-02, .536550E-02, .407441E-02, .309735E-02,
     +  .235727E-02, .179851E-02, .137377E-02, .105097E-02,
     +  .800560E-03, .609179E-03, .457362E-03, .337133E-03,
     +  .241742E-03, .166055E-03, .107451E-03, .628097E-04,
     +  .312096E-04, .959427E-05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .542110E+05, .427357E+05,
     +  .333243E+05, .259769E+05, .202457E+05, .157735E+05,
     +  .122868E+05, .956743E+04, .744855E+04, .579678E+04,
     +  .451053E+04, .350835E+04, .272843E+04, .212107E+04,
     +  .164871E+04, .128107E+04, .995320E+03, .773030E+03,
     +  .600368E+03, .466126E+03, .361932E+03, .280963E+03,
     +  .218149E+03, .169357E+03, .131521E+03, .102152E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .793976E+02, .615077E+02, .478647E+02, .372669E+02,
     +  .290547E+02, .226723E+02, .177221E+02, .138808E+02,
     +  .108905E+02, .855991E+01, .674698E+01, .532923E+01,
     +  .422234E+01, .335254E+01, .267072E+01, .213174E+01,
     +  .170588E+01, .136713E+01, .109773E+01, .881944E+00,
     +  .709838E+00, .570278E+00, .458807E+00, .368095E+00,
     +  .295227E+00, .236244E+00, .188683E+00, .150256E+00,
     +  .119346E+00, .944538E-01, .745169E-01, .585637E-01,
     +  .458838E-01, .358121E-01, .278727E-01, .216253E-01,
     +  .167415E-01, .129527E-01, .999680E-02, .770956E-02,
     +  .595045E-02, .459775E-02, .356115E-02, .276345E-02,
     +  .214953E-02, .167275E-02, .130127E-02, .100605E-02,
     +  .775011E-03, .587697E-03, .436996E-03, .315929E-03 /
        DATA (UPDI(I),I=2809,2860) /
     +  .219445E-03, .144400E-03, .875007E-04, .470688E-04,
     +  .197242E-04, .591970E-05, .178118E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .957211E+05, .749301E+05, .579625E+05,
     +  .448184E+05, .346458E+05, .267700E+05, .206789E+05,
     +  .159662E+05, .123240E+05, .950811E+04, .733344E+04,
     +  .565333E+04, .435687E+04, .335600E+04, .258433E+04,
     +  .198906E+04, .153050E+04, .117704E+04, .905009E+03,
     +  .695505E+03, .534424E+03, .410475E+03, .315252E+03,
     +  .242037E+03, .185836E+03, .142670E+03, .109582E+03,
     +  .838527E+02, .644476E+02, .495479E+02, .381336E+02,
     +  .293698E+02, .226532E+02, .175071E+02, .135504E+02,
     +  .105072E+02, .817010E+01, .636714E+01, .497793E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .390129E+01, .306854E+01, .241929E+01, .191303E+01,
     +  .151577E+01, .120389E+01, .957317E+00, .763056E+00,
     +  .607438E+00, .484572E+00, .385703E+00, .307108E+00,
     +  .244135E+00, .193830E+00, .153552E+00, .121415E+00,
     +  .957341E-01, .753058E-01, .590648E-01, .462274E-01,
     +  .360810E-01, .281148E-01, .218665E-01, .169919E-01,
     +  .132144E-01, .102658E-01, .798011E-02, .621609E-02,
     +  .485260E-02, .380007E-02, .298263E-02, .234643E-02,
     +  .184634E-02, .145105E-02, .113313E-02, .881011E-03,
     +  .674449E-03, .506999E-03, .371575E-03, .263318E-03,
     +  .178594E-03, .114157E-03, .676372E-04, .356708E-04,
     +  .175746E-04, .891027E-05, .392209E-05, .143652E-05,
     +  .409739E-06, .428622E-07, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .152094E+06, .118373E+06, .909647E+05, .698688E+05,
     +  .536479E+05, .411715E+05, .315858E+05, .242187E+05,
     +  .185632E+05, .142203E+05, .108894E+05, .833375E+04,
     +  .637544E+04, .487433E+04, .372521E+04, .284520E+04,
     +  .217224E+04, .165739E+04, .126410E+04, .963527E+03,
     +  .734202E+03, .559133E+03, .425702E+03, .323947E+03,
     +  .246478E+03, .187478E+03, .142638E+03, .108079E+03,
     +  .822451E+02, .625927E+02, .476751E+02, .363323E+02,
     +  .277219E+02, .211917E+02, .162207E+02, .124377E+02,
     +  .956255E+01, .736884E+01, .569662E+01, .441526E+01,
     +  .343498E+01, .267944E+01, .209675E+01, .164472E+01,
     +  .129370E+01, .101924E+01, .805282E+00, .635697E+00,
     +  .503138E+00, .397526E+00, .314344E+00, .248306E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .195994E+00, .154454E+00, .121555E+00, .954565E-01,
     +  .748290E-01, .585312E-01, .457172E-01, .356396E-01,
     +  .277596E-01, .216007E-01, .168076E-01, .130994E-01,
     +  .102063E-01, .796290E-02, .622839E-02, .488390E-02,
     +  .384151E-02, .302772E-02, .239036E-02, .188625E-02,
     +  .148504E-02, .116101E-02, .902792E-03, .690947E-03,
     +  .519319E-03, .380835E-03, .270624E-03, .184716E-03,
     +  .119738E-03, .728527E-04, .406784E-04, .217099E-04,
     +  .114873E-04, .544051E-05, .224609E-05, .765738E-06,
     +  .154167E-06, .000000E+00, .000000E+00, .167685E+06,
     +  .175314E+06, .133939E+06, .102275E+06, .780667E+05,
     +  .595542E+05, .454136E+05, .346096E+05, .263648E+05,
     +  .200714E+05, .152735E+05, .116148E+05, .882843E+04 /
        DATA (UPDI(I),I=3017,3068) /
     +  .670589E+04, .509122E+04, .386257E+04, .292901E+04,
     +  .221945E+04, .168097E+04, .127220E+04, .962417E+03,
     +  .727552E+03, .549782E+03, .415180E+03, .313432E+03,
     +  .236509E+03, .178479E+03, .134098E+03, .101177E+03,
     +  .763324E+02, .576230E+02, .435155E+02, .328946E+02,
     +  .249098E+02, .188835E+02, .143392E+02, .109163E+02,
     +  .832941E+01, .637570E+01, .489327E+01, .376993E+01,
     +  .291271E+01, .225796E+01, .175511E+01, .136835E+01,
     +  .106891E+01, .837657E+00, .656106E+00, .515457E+00,
     +  .404410E+00, .317681E+00, .249405E+00, .195739E+00,
     +  .153448E+00, .120188E+00, .939820E-01, .733975E-01,
     +  .572304E-01, .445846E-01, .346884E-01, .269817E-01,
     +  .209806E-01, .163229E-01, .127268E-01, .992444E-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .775250E-02, .607223E-02, .476806E-02, .375448E-02,
     +  .296103E-02, .233752E-02, .184297E-02, .144832E-02,
     +  .112950E-02, .875255E-03, .667238E-03, .499401E-03,
     +  .364768E-03, .258401E-03, .176130E-03, .114425E-03,
     +  .701868E-04, .400351E-04, .219421E-04, .117083E-04,
     +  .563764E-05, .238513E-05, .833667E-06, .179993E-06,
     +  .000000E+00, .000000E+00, .342833E+06, .264048E+06,
     +  .200481E+06, .152131E+06, .115389E+06, .874673E+05,
     +  .662700E+05, .501772E+05, .379730E+05, .287176E+05,
     +  .217063E+05, .163951E+05, .123765E+05, .933586E+04,
     +  .703809E+04, .530171E+04, .399128E+04, .300231E+04,
     +  .225699E+04, .169531E+04, .127265E+04, .954596E+03,
     +  .715618E+03, .536056E+03, .401345E+03, .300299E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .224669E+03, .167302E+03, .125094E+03, .935141E+02,
     +  .699300E+02, .523052E+02, .391513E+02, .293538E+02,
     +  .220261E+02, .165539E+02, .124708E+02, .941607E+01,
     +  .713143E+01, .541596E+01, .412899E+01, .315734E+01,
     +  .242271E+01, .186456E+01, .143961E+01, .111410E+01,
     +  .865205E+00, .671821E+00, .523440E+00, .407445E+00,
     +  .317676E+00, .247661E+00, .193091E+00, .150454E+00,
     +  .117176E+00, .911575E-01, .708590E-01, .550237E-01,
     +  .427083E-01, .331254E-01, .256966E-01, .199373E-01,
     +  .154813E-01, .120505E-01, .938150E-02, .731590E-02,
     +  .571839E-02, .447858E-02, .351432E-02, .275930E-02,
     +  .216579E-02, .169552E-02, .132101E-02, .102000E-02,
     +  .781278E-03, .587811E-03, .433479E-03, .311431E-03 /
        DATA (UPDI(I),I=3173,3224) /
     +  .216572E-03, .144570E-03, .916937E-04, .546912E-04,
     +  .302007E-04, .158645E-04, .796701E-05, .355066E-05,
     +  .136145E-05, .419256E-06, .731637E-07, .000000E+00,
     +  .000000E+00, .497343E+06, .381133E+06, .287698E+06,
     +  .217037E+06, .163648E+06, .123309E+06, .928638E+05,
     +  .698865E+05, .525641E+05, .395063E+05, .296740E+05,
     +  .222716E+05, .167050E+05, .125195E+05, .937635E+04,
     +  .701633E+04, .524663E+04, .391980E+04, .292639E+04,
     +  .218276E+04, .162693E+04, .121154E+04, .901571E+03,
     +  .670317E+03, .498052E+03, .369769E+03, .274458E+03,
     +  .202709E+03, .150321E+03, .111431E+03, .826132E+02,
     +  .612524E+02, .454381E+02, .337589E+02, .250964E+02,
     +  .186844E+02, .139415E+02, .104255E+02, .781947E+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .588115E+01, .444033E+01, .336299E+01, .255607E+01,
     +  .194897E+01, .149109E+01, .114374E+01, .880606E+00,
     +  .678105E+00, .524117E+00, .404848E+00, .313339E+00,
     +  .242590E+00, .187892E+00, .145501E+00, .112661E+00,
     +  .871765E-01, .674290E-01, .521264E-01, .402949E-01,
     +  .311420E-01, .240814E-01, .186333E-01, .144337E-01,
     +  .112110E-01, .871026E-02, .677938E-02, .528809E-02,
     +  .413203E-02, .323334E-02, .253022E-02, .197789E-02,
     +  .154095E-02, .119379E-02, .916006E-03, .696664E-03,
     +  .520207E-03, .380606E-03, .271308E-03, .187275E-03,
     +  .124232E-03, .784834E-04, .468297E-04, .260974E-04,
     +  .138903E-04, .702646E-05, .318469E-05, .125477E-05,
     +  .399240E-06, .763546E-07, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .697992E+06, .532371E+06, .399646E+06, .299817E+06,
     +  .224799E+06, .168430E+06, .126121E+06, .943683E+05,
     +  .705650E+05, .527240E+05, .393671E+05, .293695E+05,
     +  .218952E+05, .163088E+05, .121385E+05, .902626E+04,
     +  .670669E+04, .497839E+04, .369245E+04, .273595E+04,
     +  .202557E+04, .149814E+04, .110713E+04, .817363E+03,
     +  .602965E+03, .444395E+03, .327399E+03, .239958E+03,
     +  .176571E+03, .129864E+03, .955066E+02, .702342E+02,
     +  .516661E+02, .380615E+02, .280500E+02, .207006E+02,
     +  .153082E+02, .113450E+02, .843203E+01, .628445E+01,
     +  .470179E+01, .352897E+01, .265825E+01, .200908E+01,
     +  .152377E+01, .115893E+01, .884973E+00, .676017E+00,
     +  .518465E+00, .397496E+00, .305445E+00, .234868E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .180726E+00, .139090E+00, .107067E+00, .823965E-01,
     +  .634067E-01, .487870E-01, .375494E-01, .289059E-01,
     +  .222713E-01, .171765E-01, .132645E-01, .102732E-01,
     +  .795910E-02, .617723E-02, .480388E-02, .374130E-02,
     +  .291653E-02, .227248E-02, .176756E-02, .136931E-02,
     +  .105407E-02, .803214E-03, .606245E-03, .449077E-03,
     +  .325850E-03, .230370E-03, .157775E-03, .103953E-03,
     +  .653593E-04, .389602E-04, .218390E-04, .117255E-04,
     +  .596505E-05, .273901E-05, .110061E-05, .358262E-06,
     +  .725516E-07, .111253E-08, .000000E+00, .953913E+06,
     +  .724284E+06, .540841E+06, .403583E+06, .300976E+06,
     +  .224283E+06, .167024E+06, .124284E+06, .924158E+05,
     +  .686611E+05, .509748E+05, .378105E+05, .280240E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .207510E+05, .153529E+05, .113478E+05, .838023E+04,
     +  .618229E+04, .455671E+04, .335496E+04, .246790E+04,
     +  .181339E+04, .133124E+04, .976217E+03, .715233E+03,
     +  .523469E+03, .382927E+03, .278609E+03, .203510E+03,
     +  .148562E+03, .108426E+03, .791184E+02, .577418E+02,
     +  .421969E+02, .308433E+02, .225733E+02, .165526E+02,
     +  .121631E+02, .896265E+01, .662259E+01, .491213E+01,
     +  .365529E+01, .272995E+01, .204595E+01, .153887E+01,
     +  .116091E+01, .879455E+00, .666597E+00, .507401E+00,
     +  .386183E+00, .294670E+00, .225062E+00, .172063E+00,
     +  .131610E+00, .100717E+00, .770819E-01, .590085E-01,
     +  .451827E-01, .346170E-01, .265364E-01, .203651E-01,
     +  .156488E-01, .120423E-01, .929501E-02, .717670E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .555076E-02, .430087E-02, .333626E-02, .258927E-02,
     +  .200756E-02, .155285E-02, .119559E-02, .914139E-03,
     +  .691541E-03, .517873E-03, .380483E-03, .273763E-03,
     +  .191935E-03, .130407E-03, .853206E-04, .533652E-04,
     +  .317501E-04, .178571E-04, .963552E-05, .491523E-05,
     +  .227303E-05, .921856E-06, .302232E-06, .625844E-07,
     +  .206790E-08, .000000E+00, .127489E+07, .963792E+06,
     +  .716015E+06, .531555E+06, .394355E+06, .292330E+06,
     +  .216547E+06, .160274E+06, .118535E+06, .875870E+05,
     +  .646675E+05, .477003E+05, .351552E+05, .258835E+05,
     +  .190401E+05, .139912E+05, .102715E+05, .753241E+04,
     +  .551831E+04, .403812E+04, .295201E+04, .215548E+04,
     +  .157228E+04, .114552E+04, .833756E+03, .606127E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .440377E+03, .318164E+03, .230770E+03, .167259E+03,
     +  .121183E+03, .877727E+02, .635743E+02, .461041E+02,
     +  .334360E+02, .242774E+02, .176593E+02, .128713E+02,
     +  .940695E+01, .689389E+01, .507129E+01, .374278E+01,
     +  .277247E+01, .206104E+01, .153784E+01, .115102E+01,
     +  .865277E+00, .650913E+00, .491837E+00, .371672E+00,
     +  .281647E+00, .213692E+00, .162328E+00, .123407E+00,
     +  .938864E-01, .714560E-01, .544138E-01, .414581E-01,
     +  .316142E-01, .241279E-01, .184394E-01, .141131E-01,
     +  .108187E-01, .831897E-02, .639858E-02, .492965E-02,
     +  .380388E-02, .293769E-02, .226889E-02, .174981E-02,
     +  .134554E-02, .102934E-02, .781590E-03, .586911E-03,
     +  .436070E-03, .317776E-03, .226749E-03, .157673E-03 /
        DATA (UPDI(I),I=3537,3588) /
     +  .106296E-03, .690700E-04, .429782E-04, .255146E-04,
     +  .143781E-04, .777945E-05, .397142E-05, .184210E-05,
     +  .748866E-06, .244930E-06, .509349E-07, .228563E-08,
     +  .000000E+00, .167112E+07, .125804E+07, .929991E+06,
     +  .686967E+06, .507087E+06, .373989E+06, .275616E+06,
     +  .202936E+06, .149301E+06, .109738E+06, .805890E+05,
     +  .591236E+05, .433363E+05, .317309E+05, .232112E+05,
     +  .169600E+05, .123799E+05, .902604E+04, .657384E+04,
     +  .478200E+04, .347481E+04, .252177E+04, .182810E+04,
     +  .132355E+04, .957211E+03, .691368E+03, .499008E+03,
     +  .358086E+03, .257965E+03, .185683E+03, .133588E+03,
     +  .960690E+02, .690785E+02, .497277E+02, .357938E+02,
     +  .257921E+02, .186165E+02, .134636E+02, .976266E+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .709822E+01, .518031E+01, .379308E+01, .278761E+01,
     +  .205615E+01, .152234E+01, .113075E+01, .843701E+00,
     +  .630026E+00, .472653E+00, .354685E+00, .266958E+00,
     +  .201227E+00, .151895E+00, .114776E+00, .868111E-01,
     +  .657040E-01, .497685E-01, .377282E-01, .286319E-01,
     +  .217526E-01, .165518E-01, .126156E-01, .963114E-02,
     +  .737581E-02, .564982E-02, .433445E-02, .332980E-02,
     +  .255942E-02, .196661E-02, .150829E-02, .115282E-02,
     +  .876167E-03, .660660E-03, .492454E-03, .363056E-03,
     +  .262461E-03, .185769E-03, .128158E-03, .857546E-04,
     +  .553611E-04, .342800E-04, .203063E-04, .114547E-04,
     +  .620458E-05, .316477E-05, .146769E-05, .595121E-06,
     +  .192984E-06, .399102E-07, .213712E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .215295E+07, .161420E+07, .118753E+07, .872958E+06,
     +  .641223E+06, .470581E+06, .345070E+06, .252796E+06,
     +  .185036E+06, .135304E+06, .988478E+05, .721383E+05,
     +  .525948E+05, .383034E+05, .278667E+05, .202500E+05,
     +  .146992E+05, .106568E+05, .771732E+04, .558145E+04,
     +  .403203E+04, .290884E+04, .209604E+04, .150832E+04,
     +  .108410E+04, .778094E+03, .558027E+03, .397815E+03,
     +  .284706E+03, .203567E+03, .145462E+03, .103888E+03,
     +  .741780E+02, .530204E+02, .378881E+02, .271015E+02,
     +  .194165E+02, .139371E+02, .100296E+02, .723693E+01,
     +  .524125E+01, .380844E+01, .277761E+01, .203330E+01,
     +  .149415E+01, .110160E+01, .815985E+00, .604965E+00,
     +  .450682E+00, .335885E+00, .251129E+00, .188079E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .141086E+00, .105968E+00, .796842E-01, .599754E-01,
     +  .451878E-01, .340820E-01, .257391E-01, .194641E-01,
     +  .147442E-01, .111893E-01, .850579E-02, .648635E-02,
     +  .494704E-02, .377851E-02, .288926E-02, .220989E-02,
     +  .168908E-02, .128810E-02, .978517E-03, .738847E-03,
     +  .553280E-03, .409422E-03, .299561E-03, .214886E-03,
     +  .150917E-03, .103329E-03, .686544E-04, .440525E-04,
     +  .271539E-04, .160506E-04, .905627E-05, .490415E-05,
     +  .249563E-05, .115405E-05, .464951E-06, .148849E-06,
     +  .304391E-07, .183581E-08, .000000E+00, .273057E+07,
     +  .203921E+07, .149317E+07, .109246E+07, .798625E+06,
     +  .583276E+06, .425628E+06, .310281E+06, .225986E+06,
     +  .164420E+06, .119510E+06, .867714E+05, .629361E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .455950E+05, .329959E+05, .238489E+05, .172179E+05,
     +  .124144E+05, .894029E+04, .642966E+04, .461835E+04,
     +  .331264E+04, .237308E+04, .169756E+04, .121280E+04,
     +  .865146E+03, .616620E+03, .436790E+03, .310610E+03,
     +  .220655E+03, .156637E+03, .111125E+03, .788076E+02,
     +  .559435E+02, .396978E+02, .281953E+02, .200553E+02,
     +  .142915E+02, .102095E+02, .731266E+01, .525701E+01,
     +  .379169E+01, .274500E+01, .199470E+01, .145511E+01,
     +  .106508E+01, .783349E+00, .576703E+00, .426688E+00,
     +  .315869E+00, .234622E+00, .174603E+00, .130171E+00,
     +  .971873E-01, .726611E-01, .543870E-01, .407595E-01,
     +  .305855E-01, .229853E-01, .173000E-01, .130452E-01,
     +  .985610E-02, .745943E-02, .566354E-02, .430026E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .326953E-02, .248815E-02, .189354E-02, .143954E-02,
     +  .109154E-02, .824142E-03, .618266E-03, .459848E-03,
     +  .337870E-03, .245398E-03, .174722E-03, .121800E-03,
     +  .827973E-04, .546483E-04, .348668E-04, .214012E-04,
     +  .126227E-04, .711833E-05, .384879E-05, .195115E-05,
     +  .897529E-06, .358191E-06, .112862E-06, .227450E-07,
     +  .149704E-08, .000000E+00, .583956E+04, .665365E+04,
     +  .550188E+04, .454958E+04, .376219E+04, .311115E+04,
     +  .257284E+04, .212773E+04, .175969E+04, .145537E+04,
     +  .120373E+04, .995650E+03, .823584E+03, .681296E+03,
     +  .563631E+03, .466325E+03, .385852E+03, .319299E+03,
     +  .264255E+03, .218729E+03, .181073E+03, .149924E+03,
     +  .124157E+03, .102841E+03, .852044E+02, .706116E+02 /
        DATA (UPDI(I),I=3849,3900) /
     +  .585361E+02, .484136E+02, .401671E+02, .333397E+02,
     +  .276863E+02, .230040E+02, .191252E+02, .159200E+02,
     +  .132564E+02, .110489E+02, .921853E+01, .770004E+01,
     +  .643940E+01, .539148E+01, .452079E+01, .379529E+01,
     +  .319024E+01, .268483E+01, .226188E+01, .190719E+01,
     +  .160992E+01, .135735E+01, .114426E+01, .961014E+00,
     +  .803754E+00, .667229E+00, .548171E+00, .444501E+00,
     +  .355067E+00, .279194E+00, .216191E+00, .165055E+00,
     +  .124432E+00, .927541E-01, .684270E-01, .499806E-01,
     +  .361438E-01, .259068E-01, .183266E-01, .128082E-01,
     +  .883324E-02, .600327E-02, .401440E-02, .263672E-02,
     +  .169773E-02, .106922E-02, .656778E-03, .392075E-03,
     +  .227875E-03, .127412E-03, .684587E-04, .351351E-04 /
        DATA (UPDI(I),I=3901,3952) /
     +  .170977E-04, .781622E-05, .331713E-05, .128890E-05,
     +  .445985E-06, .134655E-06, .338339E-07, .662021E-08,
     +  .902577E-09, .696180E-10, .190388E-11, .414545E-14,
     +  .000000E+00, .184852E+05, .240235E+05, .190994E+05,
     +  .151869E+05, .120802E+05, .961076E+04, .764917E+04,
     +  .608923E+04, .484957E+04, .386324E+04, .307905E+04,
     +  .245474E+04, .195811E+04, .156247E+04, .124755E+04,
     +  .996480E+03, .796500E+03, .636932E+03, .509730E+03,
     +  .408141E+03, .327092E+03, .262297E+03, .210546E+03,
     +  .169124E+03, .136000E+03, .109461E+03, .882120E+02,
     +  .709416E+02, .573102E+02, .463471E+02, .375408E+02,
     +  .304448E+02, .247328E+02, .201323E+02, .164112E+02,
     +  .133999E+02, .109649E+02, .898847E+01, .738510E+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .607856E+01, .501561E+01, .414575E+01, .343388E+01,
     +  .284877E+01, .236740E+01, .196942E+01, .164090E+01,
     +  .136532E+01, .113619E+01, .941740E+00, .777479E+00,
     +  .637210E+00, .517261E+00, .414891E+00, .328408E+00,
     +  .256402E+00, .197604E+00, .150513E+00, .113504E+00,
     +  .848529E-01, .629685E-01, .464201E-01, .340151E-01,
     +  .248257E-01, .179945E-01, .129836E-01, .933570E-02,
     +  .669574E-02, .479887E-02, .344131E-02, .247472E-02,
     +  .178589E-02, .129557E-02, .941382E-03, .687962E-03,
     +  .499653E-03, .358877E-03, .252386E-03, .170973E-03,
     +  .109575E-03, .636555E-04, .315159E-04, .969191E-05,
     +  .000000E+00, .108420E-18, .000000E+00, .203288E-19,
     +  .000000E+00, .169407E-20, .794093E-22, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .591912E+05, .468756E+05, .367479E+05, .288081E+05,
     +  .225872E+05, .177098E+05, .138883E+05, .108920E+05,
     +  .854412E+04, .670295E+04, .526011E+04, .412840E+04,
     +  .324138E+04, .254544E+04, .199983E+04, .157158E+04,
     +  .123572E+04, .971969E+03, .765018E+03, .602403E+03,
     +  .474742E+03, .374354E+03, .295475E+03, .233387E+03,
     +  .184551E+03, .146077E+03, .115787E+03, .915790E+02,
     +  .727886E+02, .579279E+02, .461866E+02, .368812E+02,
     +  .295109E+02, .236704E+02, .190203E+02, .153154E+02,
     +  .123649E+02, .100051E+02, .811818E+01, .660189E+01,
     +  .538486E+01, .440174E+01, .360707E+01, .296165E+01,
     +  .243667E+01, .200729E+01, .165652E+01, .136518E+01,
     +  .112540E+01, .923988E+00, .755721E+00, .613762E+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .493963E+00, .393135E+00, .309117E+00, .240051E+00,
     +  .184274E+00, .140014E+00, .105481E+00, .788929E-01,
     +  .586643E-01, .434088E-01, .319859E-01, .235264E-01,
     +  .172283E-01, .125943E-01, .920386E-02, .673204E-02,
     +  .493736E-02, .363436E-02, .268901E-02, .199922E-02,
     +  .149363E-02, .111597E-02, .836033E-03, .620195E-03,
     +  .453565E-03, .323971E-03, .223126E-03, .145975E-03,
     +  .881209E-04, .472906E-04, .197910E-04, .591971E-05,
     +  .178118E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .100772E+06,
     +  .791285E+05, .614344E+05, .476894E+05, .370201E+05,
     +  .287335E+05, .223027E+05, .173092E+05, .134348E+05,
     +  .104268E+05, .809331E+04, .628184E+04, .487678E+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .378607E+04, .294011E+04, .228338E+04, .177401E+04,
     +  .137851E+04, .107171E+04, .833437E+03, .648564E+03,
     +  .504927E+03, .393420E+03, .306729E+03, .239381E+03,
     +  .186990E+03, .146268E+03, .114139E+03, .895226E+02,
     +  .703083E+02, .553237E+02, .436043E+02, .344421E+02,
     +  .272773E+02, .216461E+02, .172178E+02, .137357E+02,
     +  .109859E+02, .881397E+01, .708980E+01, .572203E+01,
     +  .462981E+01, .375657E+01, .305493E+01, .249004E+01,
     +  .203255E+01, .166237E+01, .135776E+01, .110941E+01,
     +  .902801E+00, .731953E+00, .589421E+00, .470568E+00,
     +  .371782E+00, .290470E+00, .224394E+00, .171565E+00,
     +  .129998E+00, .977879E-01, .731192E-01, .544265E-01,
     +  .403707E-01, .298639E-01, .220894E-01, .162984E-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .120298E-01, .889620E-02, .659944E-02, .491894E-02,
     +  .368587E-02, .277897E-02, .210621E-02, .160303E-02,
     +  .121930E-02, .928465E-03, .699510E-03, .519664E-03,
     +  .377666E-03, .266079E-03, .179763E-03, .114612E-03,
     +  .677976E-04, .357160E-04, .175746E-04, .891027E-05,
     +  .392209E-05, .143652E-05, .409739E-06, .428622E-07,
     +  .000000E+00, .000000E+00, .157212E+06, .122628E+06,
     +  .944833E+05, .727784E+05, .560541E+05, .431613E+05,
     +  .332313E+05, .255795E+05, .196887E+05, .151511E+05,
     +  .116592E+05, .897043E+04, .690205E+04, .530988E+04,
     +  .408547E+04, .314318E+04, .241873E+04, .186127E+04,
     +  .143275E+04, .110303E+04, .849600E+03, .654586E+03,
     +  .504659E+03, .389256E+03, .300497E+03, .232158E+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .179591E+03, .138555E+03, .107449E+03, .834339E+02,
     +  .649077E+02, .505792E+02, .395001E+02, .309336E+02,
     +  .242752E+02, .190980E+02, .150718E+02, .119277E+02,
     +  .947098E+01, .754191E+01, .602758E+01, .483084E+01,
     +  .388352E+01, .312983E+01, .252870E+01, .204633E+01,
     +  .165946E+01, .134391E+01, .108891E+01, .878707E+00,
     +  .706557E+00, .564433E+00, .447221E+00, .350909E+00,
     +  .272513E+00, .209467E+00, .159519E+00, .120525E+00,
     +  .904960E-01, .676138E-01, .503414E-01, .373914E-01,
     +  .277287E-01, .205861E-01, .152653E-01, .113387E-01,
     +  .844885E-02, .632213E-02, .475680E-02, .359923E-02,
     +  .273949E-02, .209454E-02, .160599E-02, .122908E-02,
     +  .939988E-03, .710434E-03, .529083E-03, .385490E-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .272714E-03, .185592E-03, .120074E-03, .729696E-04,
     +  .407094E-04, .217099E-04, .114873E-04, .544051E-05,
     +  .224609E-05, .765738E-06, .154167E-06, .000000E+00,
     +  .000000E+00, .165494E+06, .179625E+06, .137504E+06,
     +  .105222E+06, .805041E+05, .615697E+05, .470803E+05,
     +  .359879E+05, .275046E+05, .210140E+05, .160530E+05,
     +  .122594E+05, .936156E+04, .714677E+04, .545584E+04,
     +  .416410E+04, .317838E+04, .242566E+04, .185150E+04,
     +  .141321E+04, .107902E+04, .823955E+03, .629485E+03,
     +  .481066E+03, .367893E+03, .281519E+03, .215672E+03,
     +  .164742E+03, .126491E+03, .972377E+02, .748837E+02,
     +  .577627E+02, .446519E+02, .346151E+02, .268901E+02,
     +  .209440E+02, .163651E+02, .128253E+02, .100863E+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .795683E+01, .630107E+01, .500503E+01, .398848E+01,
     +  .318707E+01, .255346E+01, .204939E+01, .164849E+01,
     +  .132423E+01, .106439E+01, .852060E+00, .679759E+00,
     +  .538907E+00, .423935E+00, .330461E+00, .255153E+00,
     +  .195170E+00, .148048E+00, .111525E+00, .835645E-01,
     +  .623604E-01, .464147E-01, .344940E-01, .256166E-01,
     +  .190622E-01, .141810E-01, .105763E-01, .791855E-02,
     +  .595670E-02, .450621E-02, .342742E-02, .262056E-02,
     +  .201069E-02, .154504E-02, .118354E-02, .904563E-03,
     +  .682473E-03, .506972E-03, .368347E-03, .259993E-03,
     +  .176791E-03, .114676E-03, .702725E-04, .400567E-04,
     +  .219421E-04, .117083E-04, .563764E-05, .238513E-05,
     +  .833667E-06, .179993E-06, .397047E-22, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .348097E+06, .268424E+06, .204099E+06, .155123E+06,
     +  .117863E+06, .895129E+05, .679615E+05, .515759E+05,
     +  .391296E+05, .296740E+05, .224972E+05, .170490E+05,
     +  .129172E+05, .978293E+04, .740775E+04, .560733E+04,
     +  .424396E+04, .321120E+04, .242967E+04, .183803E+04,
     +  .139061E+04, .105207E+04, .796151E+03, .602580E+03,
     +  .456287E+03, .345664E+03, .262115E+03, .198116E+03,
     +  .150513E+03, .114474E+03, .872055E+02, .665370E+02,
     +  .508704E+02, .390047E+02, .299668E+02, .230855E+02,
     +  .178422E+02, .138329E+02, .107634E+02, .840268E+01,
     +  .658614E+01, .517922E+01, .408678E+01, .323431E+01,
     +  .256682E+01, .204096E+01, .162662E+01, .129468E+01,
     +  .103121E+01, .818052E+00, .646862E+00, .508464E+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .396776E+00, .307028E+00, .235525E+00, .179164E+00,
     +  .135289E+00, .101549E+00, .758848E-01, .565244E-01,
     +  .420251E-01, .312212E-01, .231932E-01, .172747E-01,
     +  .128691E-01, .961466E-02, .721153E-02, .543342E-02,
     +  .411408E-02, .312881E-02, .238843E-02, .182649E-02,
     +  .139598E-02, .106156E-02, .803642E-03, .599341E-03,
     +  .439160E-03, .314093E-03, .217745E-03, .145053E-03,
     +  .918747E-04, .547517E-04, .302152E-04, .158645E-04,
     +  .796701E-05, .355066E-05, .136145E-05, .419256E-06,
     +  .731637E-07, .000000E+00, .000000E+00, .502687E+06,
     +  .385575E+06, .291370E+06, .220073E+06, .166158E+06,
     +  .125385E+06, .945803E+05, .713057E+05, .537376E+05,
     +  .404765E+05, .304762E+05, .229348E+05, .172532E+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .129727E+05, .975102E+04, .732602E+04, .550259E+04,
     +  .413132E+04, .310117E+04, .232715E+04, .174621E+04,
     +  .131004E+04, .982900E+03, .737445E+03, .553443E+03,
     +  .415460E+03, .312129E+03, .233668E+03, .175822E+03,
     +  .132425E+03, .998851E+02, .754524E+02, .571050E+02,
     +  .433431E+02, .329608E+02, .251342E+02, .192285E+02,
     +  .147578E+02, .113685E+02, .878780E+01, .682120E+01,
     +  .531298E+01, .415295E+01, .325637E+01, .256076E+01,
     +  .201779E+01, .159381E+01, .125724E+01, .992529E+00,
     +  .780436E+00, .611787E+00, .476887E+00, .369198E+00,
     +  .283617E+00, .216154E+00, .163506E+00, .122880E+00,
     +  .918779E-01, .684452E-01, .508639E-01, .377544E-01,
     +  .280212E-01, .208082E-01, .155010E-01, .115552E-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .864184E-02, .648949E-02, .489488E-02, .370905E-02,
     +  .282112E-02, .215183E-02, .164247E-02, .125143E-02,
     +  .947691E-03, .713568E-03, .528843E-03, .384822E-03,
     +  .273263E-03, .188128E-03, .124578E-03, .786116E-04,
     +  .468716E-04, .261069E-04, .138903E-04, .702646E-05,
     +  .318469E-05, .125477E-05, .399240E-06, .763546E-07,
     +  .000000E+00, .000000E+00, .703416E+06, .536879E+06,
     +  .403373E+06, .302899E+06, .227347E+06, .170537E+06,
     +  .127862E+06, .958082E+05, .717554E+05, .537081E+05,
     +  .401807E+05, .300420E+05, .224511E+05, .167682E+05,
     +  .125182E+05, .933998E+04, .696590E+04, .519251E+04,
     +  .386930E+04, .288199E+04, .214613E+04, .159763E+04,
     +  .118921E+04, .885060E+03, .658772E+03, .490379E+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .365266E+03, .271035E+03, .202131E+03, .150870E+03,
     +  .112756E+03, .843861E+02, .632665E+02, .475669E+02,
     +  .358281E+02, .270599E+02, .205039E+02, .155872E+02,
     +  .118938E+02, .910788E+01, .700420E+01, .540570E+01,
     +  .418727E+01, .325404E+01, .253634E+01, .198105E+01,
     +  .155119E+01, .121297E+01, .949315E+00, .740039E+00,
     +  .575232E+00, .444745E+00, .341660E+00, .260597E+00,
     +  .197339E+00, .148436E+00, .111017E+00, .826717E-01,
     +  .613802E-01, .454904E-01, .336943E-01, .249688E-01,
     +  .185211E-01, .137877E-01, .102741E-01, .768247E-02,
     +  .576811E-02, .434920E-02, .329286E-02, .250089E-02,
     +  .190309E-02, .144778E-02, .109826E-02, .827303E-03,
     +  .618985E-03, .455526E-03, .328968E-03, .231802E-03 /
        DATA (UPDI(I),I=4629,4680) /
     +  .158393E-03, .104201E-03, .654497E-04, .389891E-04,
     +  .218452E-04, .117255E-04, .596505E-05, .273901E-05,
     +  .110061E-05, .358262E-06, .725516E-07, .111253E-08,
     +  .000000E+00, .959418E+06, .728859E+06, .544624E+06,
     +  .406711E+06, .303561E+06, .226421E+06, .168792E+06,
     +  .125744E+06, .936233E+05, .696592E+05, .517997E+05,
     +  .384923E+05, .285874E+05, .212166E+05, .157375E+05,
     +  .116655E+05, .864264E+04, .639897E+04, .473559E+04,
     +  .350258E+04, .258969E+04, .191384E+04, .141404E+04,
     +  .104444E+04, .771421E+03, .569715E+03, .420960E+03,
     +  .309777E+03, .229104E+03, .169559E+03, .125634E+03,
     +  .932055E+02, .692613E+02, .516113E+02, .385246E+02,
     +  .288339E+02, .216502E+02, .163099E+02, .123332E+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .935990E+01, .713412E+01, .545761E+01, .419066E+01,
     +  .322860E+01, .249495E+01, .193210E+01, .150005E+01,
     +  .116300E+01, .902526E+00, .697649E+00, .537816E+00,
     +  .412511E+00, .314507E+00, .238211E+00, .179246E+00,
     +  .134072E+00, .997848E-01, .739957E-01, .547420E-01,
     +  .404487E-01, .298850E-01, .221007E-01, .163662E-01,
     +  .121668E-01, .905565E-02, .676408E-02, .507268E-02,
     +  .381937E-02, .288616E-02, .218640E-02, .165815E-02,
     +  .125607E-02, .947927E-03, .709801E-03, .527446E-03,
     +  .385285E-03, .276062E-03, .192980E-03, .130853E-03,
     +  .854974E-04, .534287E-04, .317698E-04, .178611E-04,
     +  .963553E-05, .491523E-05, .227303E-05, .921856E-06,
     +  .302232E-06, .625844E-07, .206790E-08, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .128047E+07, .968436E+06, .719854E+06, .534729E+06,
     +  .396978E+06, .294499E+06, .218340E+06, .161756E+06,
     +  .119760E+06, .885991E+05, .655040E+05, .483915E+05,
     +  .357262E+05, .263552E+05, .194296E+05, .143129E+05,
     +  .105371E+05, .775160E+04, .569916E+04, .418728E+04,
     +  .307500E+04, .225683E+04, .165576E+04, .121423E+04,
     +  .890286E+03, .652598E+03, .478545E+03, .349395E+03,
     +  .256373E+03, .188224E+03, .138329E+03, .101778E+03,
     +  .749984E+02, .554152E+02, .410106E+02, .304311E+02,
     +  .226523E+02, .169177E+02, .126825E+02, .954246E+01,
     +  .721121E+01, .546984E+01, .416467E+01, .318174E+01,
     +  .243825E+01, .187249E+01, .144173E+01, .110849E+01,
     +  .853111E+00, .654022E+00, .500120E+00, .380612E+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .288041E+00, .216668E+00, .162016E+00, .120507E+00,
     +  .892472E-01, .658963E-01, .485668E-01, .357690E-01,
     +  .263530E-01, .194413E-01, .143660E-01, .106593E-01,
     +  .791949E-02, .590499E-02, .441996E-02, .332055E-02,
     +  .250243E-02, .188943E-02, .142712E-02, .107583E-02,
     +  .807343E-03, .600710E-03, .443241E-03, .321340E-03,
     +  .228438E-03, .158433E-03, .106616E-03, .691957E-04,
     +  .430227E-04, .255281E-04, .143807E-04, .777945E-05,
     +  .397142E-05, .184210E-05, .748866E-06, .244930E-06,
     +  .509349E-07, .228563E-08, .000000E+00, .167679E+07,
     +  .126275E+07, .933887E+06, .690188E+06, .509750E+06,
     +  .376189E+06, .277434E+06, .204439E+06, .150543E+06,
     +  .110764E+06, .814369E+05, .598241E+05, .439148E+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .322087E+05, .236056E+05, .172856E+05, .126486E+05,
     +  .924769E+04, .675661E+04, .493266E+04, .359893E+04,
     +  .262397E+04, .191220E+04, .139272E+04, .101404E+04,
     +  .738029E+03, .537277E+03, .389350E+03, .283550E+03,
     +  .206593E+03, .150653E+03, .109975E+03, .803927E+02,
     +  .589235E+02, .432516E+02, .318309E+02, .234987E+02,
     +  .174049E+02, .129398E+02, .965576E+01, .723680E+01,
     +  .544430E+01, .411137E+01, .311550E+01, .236810E+01,
     +  .180384E+01, .137763E+01, .105056E+01, .801981E+00,
     +  .609862E+00, .462669E+00, .349423E+00, .262520E+00,
     +  .196138E+00, .145757E+00, .107810E+00, .794479E-01,
     +  .584026E-01, .428756E-01, .314683E-01, .231131E-01,
     +  .170043E-01, .125336E-01, .927794E-02, .687753E-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .511630E-02, .382017E-02, .286195E-02, .214980E-02,
     +  .161697E-02, .121582E-02, .911779E-03, .680229E-03,
     +  .502849E-03, .368410E-03, .265097E-03, .187007E-03,
     +  .128709E-03, .859846E-04, .554501E-04, .343109E-04,
     +  .203154E-04, .114564E-04, .620458E-05, .316477E-05,
     +  .146769E-05, .595121E-06, .192984E-06, .399102E-07,
     +  .213712E-08, .000000E+00, .215871E+07, .161898E+07,
     +  .119149E+07, .876226E+06, .643924E+06, .472814E+06,
     +  .346915E+06, .254320E+06, .186296E+06, .136344E+06,
     +  .997072E+05, .728480E+05, .531809E+05, .387872E+05,
     +  .282660E+05, .205794E+05, .149709E+05, .108808E+05,
     +  .790196E+04, .573354E+04, .415724E+04, .301185E+04,
     +  .218073E+04, .157788E+04, .114119E+04, .824907E+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .596363E+03, .429081E+03, .310246E+03, .224398E+03,
     +  .162425E+03, .117678E+03, .853679E+02, .620890E+02,
     +  .452196E+02, .330178E+02, .241821E+02, .177689E+02,
     +  .131054E+02, .970152E+01, .721330E+01, .538356E+01,
     +  .403328E+01, .303213E+01, .228647E+01, .172782E+01,
     +  .130910E+01, .990314E+00, .749986E+00, .565807E+00,
     +  .425923E+00, .319264E+00, .238154E+00, .176750E+00,
     +  .130547E+00, .960248E-01, .704100E-01, .515272E-01,
     +  .376760E-01, .275519E-01, .201701E-01, .147946E-01,
     +  .108743E-01, .802811E-02, .593535E-02, .440350E-02,
     +  .327846E-02, .244826E-02, .183235E-02, .137245E-02,
     +  .102703E-02, .766048E-03, .568103E-03, .417228E-03,
     +  .303546E-03, .216829E-03, .151821E-03, .103728E-03 /
        DATA (UPDI(I),I=4993,5044) /
     +  .688188E-04, .441152E-04, .271754E-04, .160567E-04,
     +  .905735E-05, .490415E-05, .249563E-05, .115405E-05,
     +  .464951E-06, .148849E-06, .304391E-07, .183581E-08,
     +  .000000E+00, .273641E+07, .204406E+07, .149718E+07,
     +  .109577E+07, .801366E+06, .585541E+06, .427499E+06,
     +  .311827E+06, .227263E+06, .165475E+06, .120381E+06,
     +  .874905E+05, .635297E+05, .460848E+05, .334000E+05,
     +  .241822E+05, .174926E+05, .126408E+05, .912673E+04,
     +  .658311E+04, .474458E+04, .341640E+04, .245829E+04,
     +  .176748E+04, .127011E+04, .912069E+03, .654987E+03,
     +  .468027E+03, .336078E+03, .241384E+03, .173479E+03,
     +  .124782E+03, .898590E+02, .648732E+02, .468937E+02,
     +  .339818E+02, .246988E+02, .180100E+02, .131813E+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .968274E+01, .714395E+01, .529076E+01, .393320E+01,
     +  .293407E+01, .219539E+01, .164608E+01, .123747E+01,
     +  .928775E+00, .697895E+00, .522416E+00, .390270E+00,
     +  .290390E+00, .215100E+00, .158596E+00, .116431E+00,
     +  .851697E-01, .621387E-01, .452684E-01, .329635E-01,
     +  .240154E-01, .175206E-01, .128101E-01, .938708E-02,
     +  .690984E-02, .509367E-02, .376775E-02, .279620E-02,
     +  .208082E-02, .155126E-02, .115681E-02, .861385E-03,
     +  .638979E-03, .471042E-03, .343714E-03, .248355E-03,
     +  .176151E-03, .122458E-03, .830840E-04, .547653E-04,
     +  .349109E-04, .214160E-04, .126268E-04, .711902E-05,
     +  .384879E-05, .195115E-05, .897529E-06, .358191E-06,
     +  .112862E-06, .227450E-07, .149704E-08, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .581325E+04, .663609E+04, .548570E+04, .453466E+04,
     +  .374844E+04, .309847E+04, .256116E+04, .211697E+04,
     +  .174978E+04, .144623E+04, .119531E+04, .987897E+03,
     +  .816443E+03, .674721E+03, .557577E+03, .460752E+03,
     +  .380723E+03, .314580E+03, .259914E+03, .214736E+03,
     +  .177401E+03, .146549E+03, .121055E+03, .999907E+02,
     +  .825865E+02, .682077E+02, .563291E+02, .463904E+02,
     +  .383102E+02, .316356E+02, .261222E+02, .215682E+02,
     +  .178065E+02, .147077E+02, .121409E+02, .100210E+02,
     +  .826952E+01, .682172E+01, .562412E+01, .463216E+01,
     +  .381085E+01, .312888E+01, .256219E+01, .209079E+01,
     +  .169846E+01, .137209E+01, .110203E+01, .877252E+00,
     +  .693746E+00, .543741E+00, .424209E+00, .330418E+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .258375E+00, .204024E+00, .163312E+00, .132501E+00,
     +  .108511E+00, .891302E-01, .729632E-01, .592311E-01,
     +  .475252E-01, .376157E-01, .293361E-01, .225570E-01,
     +  .170438E-01, .126687E-01, .925786E-02, .664612E-02,
     +  .468249E-02, .323373E-02, .218573E-02, .144334E-02,
     +  .928853E-03, .580686E-03, .353239E-03, .206797E-03,
     +  .116374E-03, .625900E-04, .319435E-04, .153310E-04,
     +  .683941E-05, .279757E-05, .102112E-05, .325827E-06,
     +  .867312E-07, .180283E-07, .261942E-08, .216106E-09,
     +  .634807E-11, .149201E-13, .000000E+00, .184557E+05,
     +  .240012E+05, .190789E+05, .151681E+05, .120629E+05,
     +  .959485E+04, .763454E+04, .607579E+04, .483723E+04,
     +  .385190E+04, .306864E+04, .244518E+04, .194933E+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .155442E+04, .124016E+04, .989708E+03, .790291E+03,
     +  .631242E+03, .504516E+03, .403367E+03, .322721E+03,
     +  .258297E+03, .206886E+03, .165778E+03, .132941E+03,
     +  .106666E+03, .856592E+02, .686139E+02, .551852E+02,
     +  .444078E+02, .357710E+02, .288297E+02, .232581E+02,
     +  .187851E+02, .151794E+02, .122723E+02, .993097E+01,
     +  .803843E+01, .650988E+01, .527001E+01, .426616E+01,
     +  .344889E+01, .278387E+01, .224097E+01, .179817E+01,
     +  .143636E+01, .114270E+01, .902372E+00, .709713E+00,
     +  .554498E+00, .432475E+00, .337474E+00, .264752E+00,
     +  .209596E+00, .167855E+00, .135783E+00, .110563E+00,
     +  .901240E-01, .732202E-01, .590455E-01, .471738E-01,
     +  .372818E-01, .291390E-01, .225488E-01, .172360E-01 /
        DATA (UPDI(I),I=5253,5304) /
     +  .130367E-01, .976719E-02, .725293E-02, .534597E-02,
     +  .391446E-02, .285258E-02, .207017E-02, .149897E-02,
     +  .108029E-02, .779002E-03, .556523E-03, .392738E-03,
     +  .271529E-03, .181181E-03, .114672E-03, .660096E-04,
     +  .325097E-04, .100648E-04, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .591628E+05, .468496E+05,
     +  .367240E+05, .287861E+05, .225670E+05, .176914E+05,
     +  .138714E+05, .108764E+05, .852987E+04, .668989E+04,
     +  .524814E+04, .411744E+04, .323135E+04, .253626E+04,
     +  .199142E+04, .156389E+04, .122869E+04, .965541E+03,
     +  .759145E+03, .597040E+03, .469846E+03, .369886E+03,
     +  .291401E+03, .229673E+03, .181167E+03, .142996E+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .112983E+03, .890305E+02, .704705E+02, .558204E+02,
     +  .442706E+02, .351396E+02, .279272E+02, .222296E+02,
     +  .177087E+02, .141203E+02, .112741E+02, .900794E+01,
     +  .720438E+01, .576251E+01, .461158E+01, .368752E+01,
     +  .294574E+01, .234826E+01, .186734E+01, .147940E+01,
     +  .116850E+01, .917109E+00, .717935E+00, .559102E+00,
     +  .435295E+00, .339456E+00, .266250E+00, .210626E+00,
     +  .168318E+00, .135622E+00, .109829E+00, .889659E-01,
     +  .718276E-01, .575978E-01, .458137E-01, .361020E-01,
     +  .281848E-01, .218310E-01, .167405E-01, .127343E-01,
     +  .962212E-02, .722858E-02, .540796E-02, .403259E-02,
     +  .300196E-02, .223156E-02, .165794E-02, .122697E-02,
     +  .908035E-03, .664719E-03, .479808E-03, .338658E-03 /
        DATA (UPDI(I),I=5357,5408) /
     +  .230876E-03, .149803E-03, .898663E-04, .480171E-04,
     +  .200461E-04, .591973E-05, .178118E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .100739E+06, .790985E+05, .614070E+05,
     +  .476643E+05, .369971E+05, .287125E+05, .222834E+05,
     +  .172915E+05, .134186E+05, .104120E+05, .807979E+04,
     +  .626949E+04, .486549E+04, .377575E+04, .293069E+04,
     +  .227478E+04, .176617E+04, .137136E+04, .106519E+04,
     +  .827498E+03, .643157E+03, .500007E+03, .388945E+03,
     +  .302661E+03, .235685E+03, .183635E+03, .143223E+03,
     +  .111381E+03, .870221E+02, .680425E+02, .532709E+02,
     +  .417450E+02, .327577E+02, .257507E+02, .202619E+02,
     +  .159619E+02, .125945E+02, .994739E+01, .786696E+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .622452E+01, .492947E+01, .390238E+01, .308764E+01,
     +  .243922E+01, .192335E+01, .151199E+01, .118603E+01,
     +  .925289E+00, .720847E+00, .559312E+00, .434353E+00,
     +  .338144E+00, .264831E+00, .209094E+00, .166580E+00,
     +  .133631E+00, .107622E+00, .866533E-01, .695450E-01,
     +  .554697E-01, .439291E-01, .345107E-01, .268991E-01,
     +  .208367E-01, .160084E-01, .122252E-01, .929394E-02,
     +  .704102E-02, .532453E-02, .402222E-02, .303925E-02,
     +  .229695E-02, .173637E-02, .130840E-02, .985661E-03,
     +  .734514E-03, .540080E-03, .388972E-03, .271978E-03,
     +  .182643E-03, .115907E-03, .683277E-04, .358886E-04,
     +  .175746E-04, .891027E-05, .392209E-05, .143652E-05,
     +  .409739E-06, .428622E-07, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .157175E+06, .122594E+06, .944523E+05, .727501E+05,
     +  .560282E+05, .431376E+05, .332096E+05, .255597E+05,
     +  .196706E+05, .151346E+05, .116441E+05, .895667E+04,
     +  .688949E+04, .529843E+04, .407504E+04, .313368E+04,
     +  .241007E+04, .185340E+04, .142559E+04, .109652E+04,
     +  .843688E+03, .649219E+03, .499789E+03, .384841E+03,
     +  .296497E+03, .228535E+03, .176312E+03, .135595E+03,
     +  .104774E+03, .810168E+02, .627248E+02, .486086E+02,
     +  .377211E+02, .293271E+02, .228240E+02, .177865E+02,
     +  .138850E+02, .108524E+02, .849514E+01, .665484E+01,
     +  .521955E+01, .409369E+01, .321016E+01, .251458E+01,
     +  .196703E+01, .153498E+01, .119610E+01, .927716E+00,
     +  .719239E+00, .555897E+00, .430413E+00, .334285E+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .261218E+00, .205683E+00, .163265E+00, .130361E+00,
     +  .104413E+00, .835805E-01, .666958E-01, .529222E-01,
     +  .417289E-01, .326734E-01, .254115E-01, .196665E-01,
     +  .151158E-01, .115647E-01, .882043E-02, .671338E-02,
     +  .510658E-02, .388408E-02, .295681E-02, .225189E-02,
     +  .171480E-02, .130104E-02, .985723E-03, .738149E-03,
     +  .545087E-03, .394262E-03, .277242E-03, .187778E-03,
     +  .121044E-03, .733592E-04, .408279E-04, .217100E-04,
     +  .114873E-04, .544051E-05, .224609E-05, .765737E-06,
     +  .154167E-06, .000000E+00, .000000E+00, .165454E+06,
     +  .179587E+06, .137469E+06, .105191E+06, .804752E+05,
     +  .615433E+05, .470562E+05, .359659E+05, .274846E+05,
     +  .209957E+05, .160363E+05, .122442E+05, .934771E+04 /
        DATA (UPDI(I),I=5565,5616) /
     +  .713418E+04, .544438E+04, .415368E+04, .316891E+04,
     +  .241706E+04, .184370E+04, .140613E+04, .107260E+04,
     +  .818144E+03, .624224E+03, .476308E+03, .363592E+03,
     +  .277635E+03, .212166E+03, .161585E+03, .123645E+03,
     +  .946746E+02, .725760E+02, .556861E+02, .427833E+02,
     +  .329335E+02, .253766E+02, .195812E+02, .151369E+02,
     +  .117173E+02, .908545E+01, .705151E+01, .548088E+01,
     +  .426120E+01, .331344E+01, .257471E+01, .199883E+01,
     +  .154883E+01, .119919E+01, .924822E+00, .713521E+00,
     +  .549252E+00, .423863E+00, .328266E+00, .255795E+00,
     +  .200765E+00, .158723E+00, .126125E+00, .100470E+00,
     +  .799697E-01, .634617E-01, .501022E-01, .393332E-01,
     +  .306900E-01, .238075E-01, .183961E-01, .141311E-01 /
        DATA (UPDI(I),I=5617,5668) /
     +  .108162E-01, .826129E-02, .630214E-02, .480775E-02,
     +  .366894E-02, .280240E-02, .214086E-02, .163412E-02,
     +  .124187E-02, .941287E-03, .704516E-03, .519579E-03,
     +  .375189E-03, .263489E-03, .178460E-03, .115407E-03,
     +  .705600E-04, .401388E-04, .219422E-04, .117083E-04,
     +  .563764E-05, .238513E-05, .833667E-06, .179993E-06,
     +  .000000E+00, .000000E+00, .348050E+06, .268381E+06,
     +  .204060E+06, .155087E+06, .117831E+06, .894832E+05,
     +  .679344E+05, .515512E+05, .391071E+05, .296535E+05,
     +  .224785E+05, .170321E+05, .129018E+05, .976893E+04,
     +  .739504E+04, .559580E+04, .423351E+04, .320173E+04,
     +  .242109E+04, .183027E+04, .138359E+04, .104573E+04,
     +  .790427E+03, .597417E+03, .451633E+03, .341473E+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .258343E+03, .194730E+03, .147471E+03, .111743E+03,
     +  .847554E+02, .643402E+02, .489012E+02, .372395E+02,
     +  .283846E+02, .216672E+02, .165700E+02, .126910E+02,
     +  .973739E+01, .748002E+01, .575552E+01, .443116E+01,
     +  .341306E+01, .262825E+01, .202295E+01, .155503E+01,
     +  .119521E+01, .915722E+00, .702478E+00, .538120E+00,
     +  .413535E+00, .319067E+00, .247679E+00, .193567E+00,
     +  .152259E+00, .120286E+00, .952078E-01, .752864E-01,
     +  .593635E-01, .465905E-01, .363833E-01, .282611E-01,
     +  .218412E-01, .168271E-01, .128966E-01, .985537E-02,
     +  .751850E-02, .573022E-02, .436699E-02, .332791E-02,
     +  .253627E-02, .193104E-02, .146674E-02, .110741E-02,
     +  .832214E-03, .616318E-03, .448771E-03, .319256E-03 /
        DATA (UPDI(I),I=5721,5772) /
     +  .220355E-03, .146284E-03, .924062E-04, .549560E-04,
     +  .302707E-04, .158645E-04, .796701E-05, .355066E-05,
     +  .136145E-05, .419256E-06, .731637E-07, .000000E+00,
     +  .000000E+00, .502634E+06, .385526E+06, .291326E+06,
     +  .220033E+06, .166122E+06, .125352E+06, .945499E+05,
     +  .712781E+05, .537125E+05, .404537E+05, .304555E+05,
     +  .229160E+05, .172362E+05, .129573E+05, .973701E+04,
     +  .731333E+04, .549111E+04, .412094E+04, .309179E+04,
     +  .231869E+04, .173857E+04, .130316E+04, .976703E+03,
     +  .731870E+03, .548432E+03, .410959E+03, .308090E+03,
     +  .230054E+03, .172586E+03, .129529E+03, .972957E+02,
     +  .731391E+02, .550391E+02, .414985E+02, .313144E+02,
     +  .236647E+02, .179166E+02, .135861E+02, .103214E+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .785171E+01, .598387E+01, .456412E+01, .348367E+01,
     +  .265933E+01, .202991E+01, .154824E+01, .118145E+01,
     +  .899261E+00, .685852E+00, .522703E+00, .399866E+00,
     +  .307223E+00, .237462E+00, .184712E+00, .144515E+00,
     +  .113488E+00, .892519E-01, .701185E-01, .549380E-01,
     +  .428638E-01, .332952E-01, .257436E-01, .198178E-01,
     +  .152200E-01, .116356E-01, .887526E-02, .676160E-02,
     +  .514825E-02, .391999E-02, .298436E-02, .227133E-02,
     +  .172592E-02, .130726E-02, .983465E-03, .735621E-03,
     +  .541804E-03, .392079E-03, .277117E-03, .190052E-03,
     +  .125474E-03, .789923E-04, .470139E-04, .261432E-04,
     +  .138903E-04, .702646E-05, .318469E-05, .125477E-05,
     +  .399240E-06, .763546E-07, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .703356E+06, .536825E+06, .403324E+06, .302854E+06,
     +  .227306E+06, .170500E+06, .127829E+06, .957775E+05,
     +  .717276E+05, .536829E+05, .401578E+05, .300213E+05,
     +  .224323E+05, .167512E+05, .125028E+05, .932609E+04,
     +  .695335E+04, .518119E+04, .385910E+04, .287280E+04,
     +  .213786E+04, .159019E+04, .118253E+04, .879067E+03,
     +  .653399E+03, .485566E+03, .360961E+03, .267194E+03,
     +  .198702E+03, .147812E+03, .110031E+03, .819598E+02,
     +  .611078E+02, .456470E+02, .341216E+02, .255436E+02,
     +  .191565E+02, .143899E+02, .108297E+02, .816224E+01,
     +  .616378E+01, .465937E+01, .352540E+01, .266860E+01,
     +  .202060E+01, .152944E+01, .115888E+01, .876362E+00,
     +  .664490E+00, .503770E+00, .383546E+00, .293354E+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .225694E+00, .174682E+00, .135908E+00, .106082E+00,
     +  .828946E-01, .647047E-01, .503780E-01, .390754E-01,
     +  .301895E-01, .232312E-01, .178089E-01, .136280E-01,
     +  .103865E-01, .790205E-02, .600662E-02, .456403E-02,
     +  .346791E-02, .263417E-02, .199932E-02, .151416E-02,
     +  .114217E-02, .855124E-03, .635950E-03, .465389E-03,
     +  .334429E-03, .234669E-03, .159807E-03, .104850E-03,
     +  .657210E-04, .390876E-04, .218688E-04, .117255E-04,
     +  .596505E-05, .273901E-05, .110061E-05, .358262E-06,
     +  .725515E-07, .111253E-08, .000000E+00, .959351E+06,
     +  .728799E+06, .544569E+06, .406661E+06, .303516E+06,
     +  .226380E+06, .168754E+06, .125710E+06, .935925E+05,
     +  .696314E+05, .517745E+05, .384695E+05, .285668E+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .211980E+05, .157207E+05, .116504E+05, .862899E+04,
     +  .638668E+04, .472453E+04, .349265E+04, .258077E+04,
     +  .190583E+04, .140687E+04, .103803E+04, .765682E+03,
     +  .564588E+03, .416387E+03, .305709E+03, .225484E+03,
     +  .166340E+03, .122776E+03, .906703E+02, .670141E+02,
     +  .496205E+02, .367626E+02, .272753E+02, .202718E+02,
     +  .150914E+02, .112562E+02, .840853E+01, .629416E+01,
     +  .471701E+01, .353899E+01, .265710E+01, .199616E+01,
     +  .149973E+01, .112850E+01, .847911E+00, .639163E+00,
     +  .481984E+00, .365148E+00, .277954E+00, .212803E+00,
     +  .163845E+00, .126750E+00, .983297E-01, .763468E-01,
     +  .592132E-01, .458157E-01, .353289E-01, .271473E-01,
     +  .207882E-01, .158659E-01, .120937E-01, .918486E-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .696594E-02, .527966E-02, .400035E-02, .303071E-02,
     +  .229474E-02, .173534E-02, .130868E-02, .982331E-03,
     +  .731362E-03, .540453E-03, .392764E-03, .280157E-03,
     +  .195105E-03, .131889E-03, .859664E-04, .536212E-04,
     +  .318376E-04, .178764E-04, .963554E-05, .491523E-05,
     +  .227303E-05, .921856E-06, .302231E-06, .625844E-07,
     +  .206790E-08, .000000E+00, .128040E+07, .968368E+06,
     +  .719793E+06, .534674E+06, .396928E+06, .294453E+06,
     +  .218299E+06, .161718E+06, .119726E+06, .885685E+05,
     +  .654763E+05, .483665E+05, .357037E+05, .263349E+05,
     +  .194113E+05, .142965E+05, .105223E+05, .773829E+04,
     +  .568722E+04, .417658E+04, .306540E+04, .224825E+04,
     +  .164809E+04, .120739E+04, .884178E+03, .647157E+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .473705E+03, .345103E+03, .252564E+03, .184849E+03,
     +  .135343E+03, .991380E+02, .726673E+02, .533583E+02,
     +  .391977E+02, .288347E+02, .212473E+02, .156821E+02,
     +  .115967E+02, .858913E+01, .637511E+01, .473799E+01,
     +  .352580E+01, .262628E+01, .195798E+01, .146038E+01,
     +  .109142E+01, .814838E+00, .610649E+00, .457995E+00,
     +  .345216E+00, .261485E+00, .199179E+00, .152530E+00,
     +  .117312E+00, .904490E-01, .697825E-01, .537795E-01,
     +  .413549E-01, .317032E-01, .242289E-01, .184610E-01,
     +  .140254E-01, .106464E-01, .805472E-02, .608718E-02,
     +  .459796E-02, .347208E-02, .262121E-02, .197713E-02,
     +  .148879E-02, .111737E-02, .834205E-03, .617361E-03,
     +  .453178E-03, .326992E-03, .231499E-03, .160003E-03 /
        DATA (UPDI(I),I=6085,6136) /
     +  .107372E-03, .695329E-04, .431585E-04, .255744E-04,
     +  .143906E-04, .777946E-05, .397142E-05, .184210E-05,
     +  .748866E-06, .244930E-06, .509349E-07, .228563E-08,
     +  .000000E+00, .167671E+07, .126268E+07, .933820E+06,
     +  .690127E+06, .509694E+06, .376139E+06, .277389E+06,
     +  .204398E+06, .150506E+06, .110730E+06, .814067E+05,
     +  .597968E+05, .438903E+05, .321866E+05, .235858E+05,
     +  .172678E+05, .126326E+05, .923334E+04, .674376E+04,
     +  .492116E+04, .358866E+04, .261480E+04, .190402E+04,
     +  .138543E+04, .100756E+04, .732272E+03, .532171E+03,
     +  .384835E+03, .279557E+03, .203066E+03, .147543E+03,
     +  .107235E+03, .779826E+02, .568055E+02, .413929E+02,
     +  .302015E+02, .220719E+02, .161567E+02, .118492E+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .870416E+01, .640786E+01, .472404E+01, .348766E+01,
     +  .257792E+01, .190766E+01, .141275E+01, .104877E+01,
     +  .778082E+00, .579714E+00, .432426E+00, .324260E+00,
     +  .244364E+00, .185167E+00, .141020E+00, .107823E+00,
     +  .826209E-01, .633411E-01, .485090E-01, .370741E-01,
     +  .282567E-01, .214773E-01, .162820E-01, .123119E-01,
     +  .930520E-02, .701135E-02, .527829E-02, .397202E-02,
     +  .298809E-02, .224693E-02, .168766E-02, .126490E-02,
     +  .944454E-03, .701126E-03, .515662E-03, .375975E-03,
     +  .269353E-03, .189286E-03, .129864E-03, .865336E-04,
     +  .556916E-04, .344063E-04, .203470E-04, .114628E-04,
     +  .620459E-05, .316477E-05, .146769E-05, .595121E-06,
     +  .192984E-06, .399102E-07, .213712E-08, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .215862E+07, .161890E+07, .119141E+07, .876159E+06,
     +  .643863E+06, .472759E+06, .346865E+06, .254275E+06,
     +  .186255E+06, .136308E+06, .996743E+05, .728185E+05,
     +  .531543E+05, .387633E+05, .282446E+05, .205602E+05,
     +  .149537E+05, .108654E+05, .788817E+04, .572123E+04,
     +  .414626E+04, .300207E+04, .217203E+04, .157016E+04,
     +  .113434E+04, .818835E+03, .590993E+03, .424347E+03,
     +  .306072E+03, .220724E+03, .159196E+03, .114844E+03,
     +  .828842E+02, .599150E+02, .433202E+02, .313605E+02,
     +  .227380E+02, .165125E+02, .120139E+02, .875523E+01,
     +  .639464E+01, .467754E+01, .342685E+01, .251403E+01,
     +  .184691E+01, .135826E+01, .100171E+01, .738556E+00,
     +  .547081E+00, .405853E+00, .302740E+00, .226964E+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .171066E+00, .129552E+00, .984687E-01, .749894E-01,
     +  .571303E-01, .434806E-01, .330299E-01, .250293E-01,
     +  .189207E-01, .142709E-01, .107397E-01, .808069E-02,
     +  .606286E-02, .454569E-02, .340704E-02, .255269E-02,
     +  .191142E-02, .142919E-02, .106594E-02, .791656E-03,
     +  .584300E-03, .427053E-03, .309285E-03, .220023E-03,
     +  .153512E-03, .104575E-03, .692162E-04, .442875E-04,
     +  .272421E-04, .160781E-04, .906143E-05, .490415E-05,
     +  .249563E-05, .115404E-05, .464951E-06, .148849E-06,
     +  .304391E-07, .183581E-08, .000000E+00, .273631E+07,
     +  .204397E+07, .149710E+07, .109570E+07, .801299E+06,
     +  .585481E+06, .427444E+06, .311778E+06, .227219E+06,
     +  .165435E+06, .120346E+06, .874584E+05, .635009E+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .460590E+05, .333769E+05, .241615E+05, .174741E+05,
     +  .126242E+05, .911198E+04, .656997E+04, .473289E+04,
     +  .340601E+04, .244907E+04, .175931E+04, .126288E+04,
     +  .905683E+03, .649355E+03, .463077E+03, .331727E+03,
     +  .237567E+03, .170135E+03, .121859E+03, .873073E+02,
     +  .626490E+02, .449589E+02, .323017E+02, .232422E+02,
     +  .167497E+02, .120930E+02, .874522E+01, .633853E+01,
     +  .460140E+01, .334593E+01, .243677E+01, .177750E+01,
     +  .129833E+01, .951340E+00, .697124E+00, .513422E+00,
     +  .378795E+00, .281062E+00, .209604E+00, .157127E+00,
     +  .118322E+00, .893994E-01, .676651E-01, .512300E-01,
     +  .387500E-01, .292600E-01, .220456E-01, .165748E-01,
     +  .124378E-01, .931503E-02, .697690E-02, .521188E-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .389119E-02, .290432E-02, .216682E-02, .161533E-02,
     +  .120217E-02, .892118E-03, .658975E-03, .483552E-03,
     +  .351220E-03, .252692E-03, .178538E-03, .123708E-03,
     +  .837028E-04, .550519E-04, .350332E-04, .214624E-04,
     +  .126412E-04, .712164E-05, .384879E-05, .195115E-05,
     +  .897529E-06, .358191E-06, .112862E-06, .227450E-07,
     +  .149704E-08, .000000E+00, .649443E+05, .536092E+05,
     +  .439975E+05, .361093E+05, .296354E+05, .243224E+05,
     +  .199620E+05, .163834E+05, .134465E+05, .110362E+05,
     +  .905809E+04, .743467E+04, .610234E+04, .500891E+04,
     +  .411154E+04, .337508E+04, .277067E+04, .227464E+04,
     +  .186756E+04, .153348E+04, .125930E+04, .103428E+04,
     +  .849620E+03, .698070E+03, .573697E+03, .471626E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .387859E+03, .318230E+03, .261989E+03, .215827E+03,
     +  .177935E+03, .146830E+03, .121295E+03, .100387E+03,
     +  .831719E+02, .690376E+02, .574278E+02, .478856E+02,
     +  .400360E+02, .335682E+02, .282386E+02, .238311E+02,
     +  .201791E+02, .171445E+02, .146148E+02, .124989E+02,
     +  .107286E+02, .922683E+01, .796340E+01, .688306E+01,
     +  .596482E+01, .517824E+01, .450198E+01, .391852E+01,
     +  .341349E+01, .297507E+01, .259349E+01, .226066E+01,
     +  .196984E+01, .171537E+01, .149253E+01, .129732E+01,
     +  .112636E+01, .977428E+00, .846559E+00, .732640E+00,
     +  .633870E+00, .548683E+00, .475701E+00, .413684E+00,
     +  .361487E+00, .318024E+00, .282212E+00, .252972E+00,
     +  .229449E+00, .210185E+00, .194225E+00, .180429E+00 /
        DATA (UPDI(I),I=6449,6500) /
     +  .167693E+00, .154997E+00, .141472E+00, .126507E+00,
     +  .109672E+00, .911848E-01, .715115E-01, .516726E-01,
     +  .331184E-01, .175550E-01, .658465E-02, .106303E-02,
     +  .000000E+00, .545413E+06, .434347E+06, .342565E+06,
     +  .270067E+06, .212944E+06, .167833E+06, .132298E+06,
     +  .104241E+06, .821469E+05, .647069E+05, .509767E+05,
     +  .401418E+05, .316143E+05, .248868E+05, .195938E+05,
     +  .154193E+05, .121360E+05, .954736E+04, .751219E+04,
     +  .590809E+04, .464741E+04, .365412E+04, .287383E+04,
     +  .225932E+04, .177675E+04, .139688E+04, .109867E+04,
     +  .861194E+03, .677808E+03, .533540E+03, .420393E+03,
     +  .331405E+03, .261634E+03, .206905E+03, .163877E+03,
     +  .130043E+03, .103501E+03, .826046E+02, .661790E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .532055E+02, .429786E+02, .348614E+02, .284174E+02,
     +  .232698E+02, .191497E+02, .158295E+02, .131557E+02,
     +  .109659E+02, .918785E+01, .771696E+01, .650740E+01,
     +  .550279E+01, .466518E+01, .396317E+01, .337274E+01,
     +  .287411E+01, .245177E+01, .209296E+01, .178744E+01,
     +  .152685E+01, .130428E+01, .111413E+01, .951508E+00,
     +  .813204E+00, .694471E+00, .593469E+00, .507758E+00,
     +  .435327E+00, .374360E+00, .323313E+00, .280758E+00,
     +  .245445E+00, .216185E+00, .191860E+00, .171657E+00,
     +  .154345E+00, .139209E+00, .125480E+00, .112501E+00,
     +  .997634E-01, .869152E-01, .738423E-01, .605088E-01,
     +  .473139E-01, .346713E-01, .232112E-01, .136153E-01,
     +  .647804E-02, .214507E-02, .344051E-03, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .122559E+07, .965954E+06, .752956E+06, .586600E+06,
     +  .456999E+06, .355828E+06, .277052E+06, .215588E+06,
     +  .167755E+06, .130455E+06, .101444E+06, .788349E+05,
     +  .612611E+05, .475733E+05, .369414E+05, .286659E+05,
     +  .222426E+05, .172465E+05, .133716E+05, .103600E+05,
     +  .802603E+04, .621348E+04, .481010E+04, .372123E+04,
     +  .287889E+04, .222587E+04, .172118E+04, .132569E+04,
     +  .102516E+04, .792617E+03, .613225E+03, .474538E+03,
     +  .367633E+03, .285245E+03, .221596E+03, .172449E+03,
     +  .134581E+03, .105312E+03, .827232E+02, .652116E+02,
     +  .516588E+02, .411009E+02, .328713E+02, .264177E+02,
     +  .213448E+02, .173299E+02, .141532E+02, .115968E+02,
     +  .955630E+01, .789695E+01, .655485E+01, .545841E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .455878E+01, .381677E+01, .320236E+01, .269151E+01,
     +  .226537E+01, .190880E+01, .160971E+01, .135841E+01,
     +  .114691E+01, .968868E+00, .818739E+00, .692859E+00,
     +  .586259E+00, .496768E+00, .421745E+00, .359040E+00,
     +  .306742E+00, .263252E+00, .227126E+00, .197140E+00,
     +  .172170E+00, .151195E+00, .133522E+00, .118132E+00,
     +  .104493E+00, .920619E-01, .804094E-01, .692467E-01,
     +  .584061E-01, .479007E-01, .377619E-01, .283096E-01,
     +  .198014E-01, .125817E-01, .694855E-02, .308199E-02,
     +  .950386E-03, .151801E-03, .000000E+00, .228672E+07,
     +  .178758E+07, .138047E+07, .106539E+07, .822117E+06,
     +  .633971E+06, .488809E+06, .376623E+06, .290134E+06,
     +  .223344E+06, .171895E+06, .132197E+06, .101644E+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .780908E+05, .599802E+05, .460317E+05, .353174E+05,
     +  .270738E+05, .207485E+05, .158870E+05, .121609E+05,
     +  .930051E+04, .711097E+04, .543223E+04, .414881E+04,
     +  .316593E+04, .241565E+04, .183515E+04, .139961E+04,
     +  .106703E+04, .813772E+03, .620638E+03, .473744E+03,
     +  .362116E+03, .277059E+03, .212321E+03, .163140E+03,
     +  .125682E+03, .971853E+02, .754194E+02, .588159E+02,
     +  .460728E+02, .362822E+02, .287173E+02, .228556E+02,
     +  .182833E+02, .147163E+02, .118863E+02, .965874E+01,
     +  .787233E+01, .644694E+01, .529825E+01, .436819E+01,
     +  .361129E+01, .299268E+01, .248507E+01, .206705E+01,
     +  .172179E+01, .143585E+01, .119865E+01, .100152E+01,
     +  .837637E+00, .701103E+00, .587983E+00, .493279E+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .414633E+00, .349355E+00, .295271E+00, .250483E+00,
     +  .213429E+00, .182728E+00, .157241E+00, .135952E+00,
     +  .117965E+00, .102709E+00, .893509E-01, .774989E-01,
     +  .667644E-01, .568610E-01, .476161E-01, .389433E-01,
     +  .308834E-01, .234619E-01, .168890E-01, .112891E-01,
     +  .681273E-02, .354275E-02, .146494E-02, .420922E-03,
     +  .669273E-04, .000000E+00, .381820E+07, .296431E+07,
     +  .227122E+07, .173893E+07, .133106E+07, .101810E+07,
     +  .778512E+06, .594839E+06, .454360E+06, .346773E+06,
     +  .264571E+06, .201682E+06, .153684E+06, .117003E+06,
     +  .890408E+05, .676972E+05, .514470E+05, .390592E+05,
     +  .296404E+05, .224699E+05, .170257E+05, .128873E+05,
     +  .975006E+04, .736904E+04, .556691E+04, .420111E+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .316944E+04, .237987E+04, .179388E+04, .135141E+04,
     +  .101820E+04, .767035E+03, .578172E+03, .436365E+03,
     +  .329574E+03, .249286E+03, .189025E+03, .143700E+03,
     +  .109638E+03, .839490E+02, .645938E+02, .499267E+02,
     +  .387961E+02, .303044E+02, .238049E+02, .187980E+02,
     +  .149393E+02, .119152E+02, .956331E+01, .769996E+01,
     +  .623064E+01, .506061E+01, .412425E+01, .337113E+01,
     +  .276267E+01, .226915E+01, .186734E+01, .153927E+01,
     +  .127062E+01, .105027E+01, .869166E+00, .720252E+00,
     +  .597501E+00, .496853E+00, .413421E+00, .344777E+00,
     +  .288280E+00, .241815E+00, .203567E+00, .172060E+00,
     +  .146024E+00, .124428E+00, .106375E+00, .911015E-01,
     +  .781365E-01, .668053E-01, .568142E-01, .478771E-01 /
        DATA (UPDI(I),I=6813,6864) /
     +  .397908E-01, .324394E-01, .257639E-01, .197909E-01,
     +  .145174E-01, .100566E-01, .644015E-02, .370246E-02,
     +  .182055E-02, .706843E-03, .191515E-03, .303248E-04,
     +  .000000E+00, .591932E+07, .456781E+07, .347547E+07,
     +  .264230E+07, .200814E+07, .152495E+07, .115757E+07,
     +  .877948E+06, .665585E+06, .504140E+06, .381674E+06,
     +  .288686E+06, .218240E+06, .164822E+06, .124409E+06,
     +  .938071E+05, .706902E+05, .532121E+05, .400299E+05,
     +  .300792E+05, .225870E+05, .169413E+05, .126982E+05,
     +  .950685E+04, .711285E+04, .531522E+04, .397001E+04,
     +  .295038E+04, .220094E+04, .164068E+04, .122292E+04,
     +  .911262E+03, .679281E+03, .506947E+03, .378518E+03,
     +  .283014E+03, .212096E+03, .159348E+03, .120136E+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .908969E+02, .691077E+02, .527821E+02, .405286E+02,
     +  .312854E+02, .242881E+02, .189576E+02, .148940E+02,
     +  .117442E+02, .932094E+01, .742187E+01, .594028E+01,
     +  .477313E+01, .384887E+01, .311337E+01, .252534E+01,
     +  .205339E+01, .167311E+01, .136584E+01, .111680E+01,
     +  .914611E+00, .750104E+00, .616169E+00, .506818E+00,
     +  .417988E+00, .344998E+00, .285441E+00, .236790E+00,
     +  .197041E+00, .164501E+00, .137813E+00, .115830E+00,
     +  .976369E-01, .824580E-01, .696424E-01, .588052E-01,
     +  .493960E-01, .411882E-01, .339615E-01, .275597E-01,
     +  .218913E-01, .169015E-01, .125913E-01, .893086E-02,
     +  .596305E-02, .366535E-02, .201213E-02, .938749E-03,
     +  .344189E-03, .886820E-04, .139875E-04, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .908223E+07, .696472E+07, .526078E+07, .397042E+07,
     +  .299510E+07, .225742E+07, .170053E+07, .127985E+07,
     +  .962687E+06, .723426E+06, .543292E+06, .407597E+06,
     +  .305588E+06, .228863E+06, .171277E+06, .128036E+06,
     +  .956367E+05, .713512E+05, .531889E+05, .396003E+05,
     +  .294579E+05, .218849E+05, .162446E+05, .120423E+05,
     +  .891925E+04, .659688E+04, .487598E+04, .358477E+04,
     +  .264529E+04, .195031E+04, .143743E+04, .105896E+04,
     +  .780234E+03, .575483E+03, .424562E+03, .313615E+03,
     +  .232154E+03, .172271E+03, .128265E+03, .958368E+02,
     +  .719506E+02, .542660E+02, .411461E+02, .313667E+02,
     +  .240491E+02, .185400E+02, .143886E+02, .112080E+02,
     +  .878916E+01, .691539E+01, .547014E+01, .434460E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .346333E+01, .276999E+01, .222186E+01, .178687E+01,
     +  .144026E+01, .116330E+01, .941296E+00, .763022E+00,
     +  .619522E+00, .503916E+00, .410485E+00, .335332E+00,
     +  .274158E+00, .224680E+00, .184588E+00, .152069E+00,
     +  .125620E+00, .104048E+00, .863687E-01, .718065E-01,
     +  .597205E-01, .495810E-01, .410815E-01, .337909E-01,
     +  .275344E-01, .221409E-01, .174857E-01, .134882E-01,
     +  .100896E-01, .726544E-02, .496604E-02, .318521E-02,
     +  .187318E-02, .979194E-03, .432832E-03, .150065E-03,
     +  .369409E-04, .580401E-05, .000000E+00, .133738E+08,
     +  .101952E+08, .764791E+07, .573198E+07, .429346E+07,
     +  .321300E+07, .240289E+07, .179528E+07, .134039E+07,
     +  .999722E+06, .745078E+06, .554689E+06, .412615E+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .306576E+06, .227589E+06, .168746E+06, .125000E+06,
     +  .924750E+05, .683456E+05, .504436E+05, .371922E+05,
     +  .273832E+05, .201400E+05, .147914E+05, .108516E+05,
     +  .794867E+04, .581752E+04, .423373E+04, .309240E+04,
     +  .225644E+04, .164554E+04, .119934E+04, .874041E+03,
     +  .637585E+03, .465101E+03, .339667E+03, .248550E+03,
     +  .182304E+03, .134148E+03, .990565E+02, .734913E+02,
     +  .547751E+02, .410420E+02, .309199E+02, .234290E+02,
     +  .178517E+02, .136949E+02, .105449E+02, .817556E+01,
     +  .636005E+01, .497482E+01, .390770E+01, .308109E+01,
     +  .243772E+01, .193450E+01, .153939E+01, .122788E+01,
     +  .981571E+00, .786188E+00, .630906E+00, .507177E+00,
     +  .408487E+00, .329494E+00, .266546E+00, .215766E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .175042E+00, .142309E+00, .115958E+00, .946757E-01,
     +  .774349E-01, .633991E-01, .519197E-01, .424694E-01,
     +  .346172E-01, .281150E-01, .226224E-01, .179980E-01,
     +  .141023E-01, .108297E-01, .810539E-02, .586824E-02,
     +  .407918E-02, .268234E-02, .164902E-02, .925059E-03,
     +  .458657E-03, .191105E-03, .622579E-04, .145550E-04,
     +  .227566E-05, .000000E+00, .189970E+08, .144015E+08,
     +  .107330E+08, .799142E+07, .594599E+07, .441975E+07,
     +  .328281E+07, .243580E+07, .180587E+07, .133737E+07,
     +  .989556E+06, .731340E+06, .539998E+06, .398221E+06,
     +  .293373E+06, .215845E+06, .158634E+06, .116425E+06,
     +  .853498E+05, .624768E+05, .456789E+05, .333463E+05,
     +  .243135E+05, .176996E+05, .128687E+05, .934003E+04 /
        DATA (UPDI(I),I=7125,7176) /
     +  .677235E+04, .488139E+04, .353114E+04, .255138E+04,
     +  .184208E+04, .132900E+04, .958536E+03, .691932E+03,
     +  .499378E+03, .360780E+03, .261122E+03, .189421E+03,
     +  .137840E+03, .100649E+03, .738368E+02, .544164E+02,
     +  .403159E+02, .300335E+02, .225038E+02, .169566E+02,
     +  .128655E+02, .979755E+01, .751396E+01, .578235E+01,
     +  .447474E+01, .347780E+01, .271344E+01, .212461E+01,
     +  .166871E+01, .131438E+01, .103782E+01, .821344E+00,
     +  .651318E+00, .517510E+00, .411920E+00, .328494E+00,
     +  .262333E+00, .210085E+00, .168304E+00, .135080E+00,
     +  .108594E+00, .874402E-01, .704905E-01, .568687E-01,
     +  .458724E-01, .369617E-01, .297038E-01, .237480E-01,
     +  .188894E-01, .148579E-01, .115345E-01, .880286E-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .657138E-02, .477097E-02, .334269E-02, .224289E-02,
     +  .141886E-02, .836130E-03, .447548E-03, .210619E-03,
     +  .828614E-04, .254489E-04, .567706E-05, .882966E-06,
     +  .000000E+00, .261557E+08, .197246E+08, .146093E+08,
     +  .108097E+08, .799201E+07, .590263E+07, .435579E+07,
     +  .321077E+07, .236458E+07, .173936E+07, .127820E+07,
     +  .938137E+06, .687822E+06, .503627E+06, .368341E+06,
     +  .269017E+06, .196238E+06, .142935E+06, .103977E+06,
     +  .755179E+05, .547745E+05, .396633E+05, .286813E+05,
     +  .207046E+05, .149251E+05, .107383E+05, .771740E+04,
     +  .551184E+04, .395064E+04, .282791E+04, .202233E+04,
     +  .144499E+04, .103194E+04, .737520E+03, .526886E+03,
     +  .376752E+03, .269849E+03, .193701E+03, .139463E+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .100751E+03, .731225E+02, .533137E+02, .390759E+02,
     +  .287989E+02, .213489E+02, .159158E+02, .119489E+02,
     +  .900399E+01, .683382E+01, .520458E+01, .398644E+01,
     +  .306688E+01, .236875E+01, .183620E+01, .142788E+01,
     +  .111360E+01, .870661E+00, .682311E+00, .535779E+00,
     +  .421540E+00, .332227E+00, .262303E+00, .207347E+00,
     +  .164329E+00, .130228E+00, .103343E+00, .820940E-01,
     +  .652681E-01, .519047E-01, .412641E-01, .327605E-01,
     +  .259465E-01, .204669E-01, .160358E-01, .124824E-01,
     +  .959154E-02, .726191E-02, .539554E-02, .391391E-02,
     +  .275566E-02, .186796E-02, .120962E-02, .736075E-03,
     +  .415792E-03, .212402E-03, .949421E-04, .353269E-04,
     +  .102599E-04, .219287E-05, .339047E-06, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .350409E+08, .262936E+08, .193597E+08, .142393E+08,
     +  .104640E+08, .768122E+07, .563318E+07, .412638E+07,
     +  .301958E+07, .220690E+07, .161120E+07, .117474E+07,
     +  .855512E+06, .622156E+06, .451887E+06, .327725E+06,
     +  .237361E+06, .171640E+06, .123940E+06, .893456E+05,
     +  .643116E+05, .462100E+05, .331525E+05, .237411E+05,
     +  .169744E+05, .121112E+05, .863052E+04, .611025E+04,
     +  .434118E+04, .307980E+04, .218246E+04, .154503E+04,
     +  .109301E+04, .773736E+03, .547399E+03, .387581E+03,
     +  .274845E+03, .195308E+03, .139196E+03, .995346E+02,
     +  .715008E+02, .515973E+02, .374299E+02, .273037E+02,
     +  .200339E+02, .147837E+02, .109872E+02, .819589E+01,
     +  .615867E+01, .464384E+01, .352200E+01, .268315E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .205229E+01, .157555E+01, .121343E+01, .937298E+00,
     +  .725808E+00, .563343E+00, .438100E+00, .341338E+00,
     +  .266365E+00, .208188E+00, .162867E+00, .127700E+00,
     +  .100067E+00, .784728E-01, .615586E-01, .482891E-01,
     +  .378531E-01, .296301E-01, .231339E-01, .179947E-01,
     +  .139215E-01, .106815E-01, .813142E-02, .610020E-02,
     +  .450191E-02, .325491E-02, .229342E-02, .156534E-02,
     +  .102630E-02, .641228E-03, .375272E-03, .203185E-03,
     +  .990773E-04, .420928E-04, .148362E-04, .408533E-05,
     +  .839148E-06, .128804E-06, .000000E+00, .458204E+08,
     +  .342189E+08, .250525E+08, .183212E+08, .133856E+08,
     +  .976836E+07, .712128E+07, .518514E+07, .377123E+07,
     +  .273929E+07, .198737E+07, .143983E+07, .104182E+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .752715E+06, .543095E+06, .391229E+06, .281421E+06,
     +  .202091E+06, .144901E+06, .103709E+06, .741063E+05,
     +  .528540E+05, .376332E+05, .267431E+05, .189713E+05,
     +  .134280E+05, .949142E+04, .666355E+04, .469450E+04,
     +  .330201E+04, .231955E+04, .162755E+04, .114100E+04,
     +  .800342E+03, .560956E+03, .393441E+03, .276339E+03,
     +  .194480E+03, .137259E+03, .971908E+02, .691322E+02,
     +  .493978E+02, .354818E+02, .256286E+02, .186208E+02,
     +  .136069E+02, .100150E+02, .739847E+01, .550644E+01,
     +  .411247E+01, .308957E+01, .233163E+01, .176677E+01,
     +  .134374E+01, .102529E+01, .784606E+00, .601903E+00,
     +  .462786E+00, .356482E+00, .275066E+00, .212534E+00,
     +  .164430E+00, .127282E+00, .987090E-01, .764563E-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .592251E-01, .458559E-01, .354714E-01, .273909E-01,
     +  .210970E-01, .161877E-01, .123584E-01, .937133E-02,
     +  .703705E-02, .523612E-02, .383312E-02, .275606E-02,
     +  .193821E-02, .132599E-02, .877037E-03, .555981E-03,
     +  .335070E-03, .188556E-03, .978474E-04, .455532E-04,
     +  .184068E-04, .615439E-05, .161024E-05, .318469E-06,
     +  .484074E-07, .000000E+00, .586305E+08, .435865E+08,
     +  .317370E+08, .230820E+08, .167699E+08, .121692E+08,
     +  .882082E+07, .638552E+07, .461708E+07, .333381E+07,
     +  .240414E+07, .173118E+07, .124488E+07, .893789E+06,
     +  .640774E+06, .458615E+06, .327728E+06, .233778E+06,
     +  .166484E+06, .118337E+06, .839670E+05, .594607E+05,
     +  .420305E+05, .296477E+05, .208737E+05, .146612E+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .102824E+05, .716081E+04, .500408E+04, .349085E+04,
     +  .243166E+04, .169171E+04, .117570E+04, .817446E+03,
     +  .567823E+03, .394654E+03, .274650E+03, .191504E+03,
     +  .133898E+03, .939208E+02, .661770E+02, .468400E+02,
     +  .333270E+02, .238455E+02, .171627E+02, .124241E+02,
     +  .905983E+01, .663081E+01, .488997E+01, .361868E+01,
     +  .269397E+01, .201476E+01, .151294E+01, .114037E+01,
     +  .862298E+00, .653928E+00, .497098E+00, .378691E+00,
     +  .288978E+00, .220849E+00, .168966E+00, .129394E+00,
     +  .990978E-01, .759995E-01, .581731E-01, .444987E-01,
     +  .339940E-01, .259199E-01, .197084E-01, .149298E-01,
     +  .112531E-01, .842821E-02, .626150E-02, .459969E-02,
     +  .334395E-02, .238782E-02, .167211E-02, .114340E-02 /
        DATA (UPDI(I),I=7541,7592) /
     +  .759263E-03, .486507E-03, .298120E-03, .173262E-03,
     +  .937390E-04, .466233E-04, .207297E-04, .797265E-05,
     +  .253206E-05, .630473E-06, .120110E-06, .179974E-07,
     +  .000000E+00, .735673E+08, .544519E+08, .394402E+08,
     +  .285322E+08, .206182E+08, .148804E+08, .107266E+08,
     +  .772188E+07, .555177E+07, .398580E+07, .285763E+07,
     +  .204564E+07, .146224E+07, .104350E+07, .743510E+06,
     +  .528834E+06, .375514E+06, .266146E+06, .188297E+06,
     +  .132954E+06, .937018E+05, .658993E+05, .462563E+05,
     +  .323967E+05, .226439E+05, .157870E+05, .109889E+05,
     +  .759356E+04, .526520E+04, .364395E+04, .251785E+04,
     +  .173733E+04, .119733E+04, .825452E+03, .568453E+03,
     +  .391652E+03, .270159E+03, .186697E+03, .129366E+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .899243E+02, .627880E+02, .440389E+02, .310502E+02,
     +  .220159E+02, .157033E+02, .112658E+02, .814239E+01,
     +  .590645E+01, .431766E+01, .316717E+01, .233737E+01,
     +  .173295E+01, .129009E+01, .963996E+00, .722615E+00,
     +  .543214E+00, .409291E+00, .309001E+00, .233637E+00,
     +  .176873E+00, .134003E+00, .101580E+00, .769697E-01,
     +  .583713E-01, .441491E-01, .333441E-01, .251284E-01,
     +  .188826E-01, .141346E-01, .105289E-01, .779406E-02,
     +  .572570E-02, .416672E-02, .299384E-02, .212619E-02,
     +  .148073E-02, .100972E-02, .671254E-03, .432592E-03,
     +  .268500E-03, .159027E-03, .891279E-04, .463642E-04,
     +  .221086E-04, .939342E-05, .344192E-05, .103969E-05,
     +  .246585E-06, .451732E-07, .661900E-08, .000000E+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .581325E+04, .695958E+04, .577571E+04, .479467E+04,
     +  .398156E+04, .330749E+04, .274856E+04, .228501E+04,
     +  .190046E+04, .158136E+04, .131650E+04, .109659E+04,
     +  .913940E+03, .762187E+03, .636057E+03, .531183E+03,
     +  .443944E+03, .371345E+03, .310900E+03, .260549E+03,
     +  .218586E+03, .183594E+03, .154400E+03, .130029E+03,
     +  .109673E+03, .926601E+02, .784338E+02, .663767E+02,
     +  .564413E+02, .481191E+02, .411449E+02, .352978E+02,
     +  .303938E+02, .262904E+02, .228373E+02, .199387E+02,
     +  .175039E+02, .154566E+02, .137321E+02, .122754E+02,
     +  .110427E+02, .999284E+01, .909396E+01, .831873E+01,
     +  .764454E+01, .705288E+01, .653055E+01, .606047E+01,
     +  .563890E+01, .525317E+01, .490127E+01, .457685E+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .427562E+01, .399356E+01, .372693E+01, .347251E+01,
     +  .322786E+01, .299152E+01, .276288E+01, .254194E+01,
     +  .232907E+01, .212474E+01, .192945E+01, .174445E+01,
     +  .156813E+01, .140192E+01, .124599E+01, .110041E+01,
     +  .965205E+00, .840343E+00, .725717E+00, .621170E+00,
     +  .526431E+00, .441163E+00, .365778E+00, .298786E+00,
     +  .240325E+00, .189912E+00, .147032E+00, .111136E+00,
     +  .816422E-01, .579813E-01, .393931E-01, .254006E-01,
     +  .152649E-01, .833424E-02, .396038E-02, .151138E-02,
     +  .386658E-03, .372117E-04, .000000E+00, .184557E+05,
     +  .243760E+05, .194149E+05, .154693E+05, .123330E+05,
     +  .983699E+04, .785167E+04, .627046E+04, .501180E+04,
     +  .400844E+04, .320903E+04, .257109E+04, .206227E+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .165573E+04, .133107E+04, .107128E+04, .863508E+03,
     +  .696972E+03, .563550E+03, .456400E+03, .370390E+03,
     +  .301163E+03, .245461E+03, .200513E+03, .164250E+03,
     +  .134916E+03, .111179E+03, .916662E+02, .760751E+02,
     +  .633713E+02, .530243E+02, .445625E+02, .376447E+02,
     +  .319807E+02, .273199E+02, .234785E+02, .203123E+02,
     +  .176885E+02, .155123E+02, .136947E+02, .121751E+02,
     +  .108920E+02, .980402E+01, .887212E+01, .806859E+01,
     +  .736821E+01, .675506E+01, .620737E+01, .572057E+01,
     +  .527862E+01, .487900E+01, .451337E+01, .417677E+01,
     +  .386422E+01, .357178E+01, .329592E+01, .303426E+01,
     +  .278518E+01, .254793E+01, .232217E+01, .210792E+01,
     +  .190529E+01, .171428E+01, .153580E+01, .136790E+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .121166E+01, .106689E+01, .933429E+00, .810992E+00,
     +  .699299E+00, .597996E+00, .506735E+00, .425072E+00,
     +  .352462E+00, .289083E+00, .233481E+00, .185595E+00,
     +  .144866E+00, .110708E+00, .825391E-01, .597452E-01,
     +  .417680E-01, .278903E-01, .176498E-01, .103913E-01,
     +  .554372E-02, .256431E-02, .948343E-03, .235154E-03,
     +  .228841E-04, .000000E+00, .596253E+05, .472647E+05,
     +  .370962E+05, .291198E+05, .228662E+05, .179595E+05,
     +  .141118E+05, .110920E+05, .872315E+04, .686318E+04,
     +  .540354E+04, .425679E+04, .335633E+04, .264835E+04,
     +  .209198E+04, .165410E+04, .130965E+04, .103821E+04,
     +  .824390E+03, .655636E+03, .522497E+03, .417214E+03,
     +  .333973E+03, .267988E+03, .215683E+03, .174119E+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .141076E+03, .114383E+03, .934198E+02, .766255E+02,
     +  .631704E+02, .523418E+02, .436241E+02, .365911E+02,
     +  .308842E+02, .262417E+02, .224617E+02, .193640E+02,
     +  .168210E+02, .147165E+02, .129718E+02, .115097E+02,
     +  .102785E+02, .923065E+01, .833266E+01, .755458E+01,
     +  .687748E+01, .627627E+01, .574516E+01, .526584E+01,
     +  .483502E+01, .444313E+01, .408450E+01, .375358E+01,
     +  .344614E+01, .315846E+01, .288804E+01, .263310E+01,
     +  .239270E+01, .216623E+01, .195343E+01, .175411E+01,
     +  .156795E+01, .139558E+01, .123486E+01, .108660E+01,
     +  .950420E+00, .825941E+00, .712715E+00, .610303E+00,
     +  .518203E+00, .435948E+00, .362993E+00, .298684E+00,
     +  .243054E+00, .194698E+00, .153443E+00, .118698E+00 /
        DATA (UPDI(I),I=7905,7956) /
     +  .898530E-01, .663211E-01, .474893E-01, .328182E-01,
     +  .216371E-01, .135034E-01, .782622E-02, .410150E-02,
     +  .185839E-02, .670663E-03, .162163E-03, .159263E-04,
     +  .000000E+00, .101247E+06, .795545E+05, .618157E+05,
     +  .480307E+05, .373255E+05, .290069E+05, .225474E+05,
     +  .175281E+05, .136307E+05, .106021E+05, .825026E+04,
     +  .642232E+04, .500253E+04, .389864E+04, .304090E+04,
     +  .237364E+04, .185485E+04, .145093E+04, .113661E+04,
     +  .891619E+03, .700749E+03, .551751E+03, .435465E+03,
     +  .344505E+03, .273354E+03, .217576E+03, .173832E+03,
     +  .138976E+03, .111971E+03, .906286E+02, .737559E+02,
     +  .603553E+02, .497035E+02, .412171E+02, .344119E+02,
     +  .289389E+02, .245298E+02, .209526E+02, .180426E+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .156549E+02, .136906E+02, .120561E+02, .106885E+02,
     +  .953171E+01, .854603E+01, .769680E+01, .696182E+01,
     +  .631286E+01, .574272E+01, .523101E+01, .477356E+01,
     +  .435970E+01, .398304E+01, .363753E+01, .331862E+01,
     +  .302238E+01, .274615E+01, .248796E+01, .224663E+01,
     +  .202131E+01, .181144E+01, .161655E+01, .143605E+01,
     +  .127029E+01, .111697E+01, .976680E+00, .848835E+00,
     +  .732902E+00, .628282E+00, .534406E+00, .450654E+00,
     +  .376462E+00, .311206E+00, .254157E+00, .205229E+00,
     +  .163072E+00, .127432E+00, .977014E-01, .732616E-01,
     +  .535326E-01, .379161E-01, .258964E-01, .168527E-01,
     +  .103673E-01, .591072E-02, .303935E-02, .134582E-02,
     +  .472299E-03, .110795E-03, .109978E-04, .000000E+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .157730E+06, .123092E+06, .948985E+05, .731499E+05,
     +  .563865E+05, .434587E+05, .334975E+05, .258177E+05,
     +  .199018E+05, .153418E+05, .118299E+05, .912320E+04,
     +  .703878E+04, .543227E+04, .419504E+04, .324127E+04,
     +  .250657E+04, .193995E+04, .150324E+04, .116621E+04,
     +  .906246E+03, .705394E+03, .550263E+03, .430210E+03,
     +  .337308E+03, .265278E+03, .209416E+03, .165405E+03,
     +  .131691E+03, .105350E+03, .847579E+02, .685878E+02,
     +  .558745E+02, .458559E+02, .379048E+02, .315750E+02,
     +  .265237E+02, .224627E+02, .191865E+02, .165194E+02,
     +  .143408E+02, .125400E+02, .110425E+02, .978299E+01,
     +  .871562E+01, .780095E+01, .701339E+01, .632163E+01,
     +  .571698E+01, .517710E+01, .469689E+01, .426469E+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .387338E+01, .351645E+01, .318901E+01, .288694E+01,
     +  .260734E+01, .234806E+01, .210765E+01, .188501E+01,
     +  .167929E+01, .148979E+01, .131560E+01, .115686E+01,
     +  .101114E+01, .878799E+00, .759097E+00, .651358E+00,
     +  .554857E+00, .468918E+00, .392824E+00, .325938E+00,
     +  .267572E+00, .216948E+00, .173885E+00, .137093E+00,
     +  .106258E+00, .807701E-01, .600163E-01, .434307E-01,
     +  .304402E-01, .205567E-01, .132116E-01, .801577E-02,
     +  .449868E-02, .227164E-02, .984356E-03, .336574E-03,
     +  .768267E-04, .769421E-05, .000000E+00, .165454E+06,
     +  .180127E+06, .137954E+06, .105625E+06, .808644E+05,
     +  .618920E+05, .473687E+05, .362459E+05, .277355E+05,
     +  .212206E+05, .162378E+05, .124248E+05, .950955E+04 /
        DATA (UPDI(I),I=8113,8164) /
     +  .727921E+04, .557437E+04, .427020E+04, .327337E+04,
     +  .251072E+04, .192769E+04, .148146E+04, .114019E+04,
     +  .878802E+03, .678689E+03, .525229E+03, .407562E+03,
     +  .317186E+03, .247763E+03, .193601E+03, .152516E+03,
     +  .120736E+03, .961337E+02, .770070E+02, .621143E+02,
     +  .504922E+02, .413537E+02, .341457E+02, .284427E+02,
     +  .238960E+02, .202559E+02, .173144E+02, .149274E+02,
     +  .129668E+02, .113455E+02, .998951E+01, .884617E+01,
     +  .787138E+01, .703612E+01, .630607E+01, .567101E+01,
     +  .510675E+01, .460724E+01, .415989E+01, .375689E+01,
     +  .339130E+01, .305789E+01, .275229E+01, .247139E+01,
     +  .221281E+01, .197485E+01, .175613E+01, .155554E+01,
     +  .137213E+01, .120475E+01, .105332E+01, .915296E+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .790840E+00, .679065E+00, .579177E+00, .490346E+00,
     +  .411806E+00, .342771E+00, .282540E+00, .230380E+00,
     +  .185482E+00, .147592E+00, .115482E+00, .887991E-01,
     +  .669365E-01, .492983E-01, .353393E-01, .245180E-01,
     +  .163764E-01, .103981E-01, .622476E-02, .344074E-02,
     +  .170725E-02, .724616E-03, .241746E-03, .538213E-04,
     +  .543649E-05, .000000E+00, .348712E+06, .268975E+06,
     +  .204592E+06, .155564E+06, .118258E+06, .898660E+05,
     +  .682774E+05, .518585E+05, .393824E+05, .299000E+05,
     +  .226994E+05, .172300E+05, .130790E+05, .992773E+04,
     +  .753731E+04, .572326E+04, .434772E+04, .330407E+04,
     +  .251281E+04, .191248E+04, .145730E+04, .111182E+04,
     +  .849721E+03, .650624E+03, .499405E+03, .384393E+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .296921E+03, .229375E+03, .178660E+03, .139844E+03,
     +  .110104E+03, .872280E+02, .695986E+02, .559852E+02,
     +  .453870E+02, .371115E+02, .306246E+02, .255007E+02,
     +  .214327E+02, .181724E+02, .155458E+02, .134039E+02,
     +  .116438E+02, .101810E+02, .895458E+01, .791501E+01,
     +  .702909E+01, .625908E+01, .559287E+01, .500423E+01,
     +  .448597E+01, .402447E+01, .361112E+01, .323851E+01,
     +  .290097E+01, .259388E+01, .231381E+01, .205811E+01,
     +  .182474E+01, .161204E+01, .141861E+01, .124319E+01,
     +  .108440E+01, .941894E+00, .813048E+00, .697799E+00,
     +  .595123E+00, .504104E+00, .423814E+00, .353404E+00,
     +  .292026E+00, .238924E+00, .193334E+00, .154427E+00,
     +  .121886E+00, .945617E-01, .720707E-01, .538245E-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .392555E-01, .278498E-01, .191085E-01, .126124E-01,
     +  .790486E-02, .466540E-02, .253819E-02, .123704E-02,
     +  .514352E-03, .167656E-03, .365284E-04, .372694E-05,
     +  .000000E+00, .503360E+06, .386178E+06, .291910E+06,
     +  .220556E+06, .166590E+06, .125771E+06, .949255E+05,
     +  .716144E+05, .540137E+05, .407234E+05, .306970E+05,
     +  .231322E+05, .174298E+05, .131307E+05, .989226E+04,
     +  .745235E+04, .561560E+04, .423242E+04, .319163E+04,
     +  .240811E+04, .181868E+04, .137493E+04, .104102E+04,
     +  .789526E+03, .600136E+03, .457352E+03, .349729E+03,
     +  .267387E+03, .206135E+03, .159696E+03, .124448E+03,
     +  .975968E+02, .770964E+02, .614168E+02, .493211E+02,
     +  .399627E+02, .326899E+02, .269940E+02, .225068E+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .189378E+02, .160821E+02, .137687E+02, .118790E+02,
     +  .103177E+02, .901582E+01, .791824E+01, .698772E+01,
     +  .618321E+01, .549074E+01, .488218E+01, .434920E+01,
     +  .387722E+01, .345689E+01, .308033E+01, .274145E+01,
     +  .243533E+01, .215824E+01, .190725E+01, .167999E+01,
     +  .147454E+01, .128917E+01, .112241E+01, .972644E+00,
     +  .839282E+00, .719649E+00, .613481E+00, .519641E+00,
     +  .437114E+00, .364898E+00, .302080E+00, .247770E+00,
     +  .201176E+00, .161517E+00, .127966E+00, .100156E+00,
     +  .770215E-01, .581631E-01, .430179E-01, .310529E-01,
     +  .217901E-01, .147750E-01, .962842E-02, .595037E-02,
     +  .345763E-02, .184828E-02, .882775E-03, .358478E-03,
     +  .113687E-03, .241259E-04, .248590E-05, .000000E+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .704151E+06, .537538E+06, .403962E+06, .303426E+06,
     +  .227818E+06, .170958E+06, .128239E+06, .961448E+05,
     +  .720564E+05, .539771E+05, .404212E+05, .302570E+05,
     +  .226433E+05, .169400E+05, .126718E+05, .947731E+04,
     +  .708867E+04, .530229E+04, .396747E+04, .296978E+04,
     +  .222466E+04, .166788E+04, .125208E+04, .941337E+03,
     +  .709170E+03, .535540E+03, .405743E+03, .307276E+03,
     +  .234654E+03, .180073E+03, .139001E+03, .107989E+03,
     +  .845172E+02, .667222E+02, .531104E+02, .426682E+02,
     +  .346176E+02, .283622E+02, .234699E+02, .196061E+02,
     +  .165340E+02, .140608E+02, .120517E+02, .104010E+02,
     +  .903157E+01, .788295E+01, .691398E+01, .608045E+01,
     +  .536658E+01, .474246E+01, .419867E+01, .371975E+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .329564E+01, .291801E+01, .258037E+01, .227750E+01,
     +  .200536E+01, .176071E+01, .154091E+01, .134373E+01,
     +  .116722E+01, .100965E+01, .869217E+00, .745126E+00,
     +  .634664E+00, .537393E+00, .452084E+00, .377647E+00,
     +  .313025E+00, .257263E+00, .209446E+00, .168765E+00,
     +  .134434E+00, .105641E+00, .819886E-01, .624947E-01,
     +  .467576E-01, .342463E-01, .244667E-01, .169800E-01,
     +  .113774E-01, .731967E-02, .445996E-02, .255125E-02,
     +  .133979E-02, .627008E-03, .248634E-03, .767169E-04,
     +  .158621E-04, .165165E-05, .000000E+00, .960220E+06,
     +  .729577E+06, .545266E+06, .407285E+06, .304074E+06,
     +  .226880E+06, .169201E+06, .126111E+06, .939507E+05,
     +  .699518E+05, .520612E+05, .387259E+05, .287962E+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .214031E+05, .159042E+05, .118145E+05, .877573E+04,
     +  .651789E+04, .484185E+04, .359754E+04, .267456E+04,
     +  .198969E+04, .148186E+04, .110508E+04, .825656E+03,
     +  .618248E+03, .464394E+03, .348599E+03, .263877E+03,
     +  .200718E+03, .153573E+03, .118269E+03, .917637E+02,
     +  .718331E+02, .567079E+02, .451960E+02, .363869E+02,
     +  .295922E+02, .243141E+02, .201728E+02, .168998E+02,
     +  .142799E+02, .121629E+02, .104325E+02, .900388E+01,
     +  .781146E+01, .681031E+01, .595327E+01, .522280E+01,
     +  .458740E+01, .403660E+01, .355414E+01, .312927E+01,
     +  .275326E+01, .241921E+01, .212164E+01, .185615E+01,
     +  .161925E+01, .140801E+01, .121995E+01, .105287E+01,
     +  .904852E+00, .773915E+00, .659087E+00, .557646E+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .468998E+00, .391849E+00, .325054E+00, .267520E+00,
     +  .218270E+00, .176380E+00, .141036E+00, .111462E+00,
     +  .868726E-01, .668536E-01, .505072E-01, .374383E-01,
     +  .271529E-01, .191983E-01, .131768E-01, .872417E-02,
     +  .554069E-02, .332831E-02, .187414E-02, .966844E-03,
     +  .443341E-03, .171693E-03, .515655E-04, .103995E-04,
     +  .109466E-05, .000000E+00, .128135E+07, .969217E+06,
     +  .720553E+06, .535354E+06, .397536E+06, .294997E+06,
     +  .218786E+06, .162154E+06, .120115E+06, .889168E+05,
     +  .657878E+05, .486449E+05, .359526E+05, .265574E+05,
     +  .196102E+05, .144741E+05, .106811E+05, .788013E+04,
     +  .581393E+04, .428976E+04, .316650E+04, .233854E+04,
     +  .172872E+04, .127939E+04, .948488E+03, .704605E+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .525011E+03, .390852E+03, .293433E+03, .221360E+03,
     +  .167970E+03, .128298E+03, .987403E+02, .766841E+02,
     +  .600698E+02, .475178E+02, .379799E+02, .306733E+02,
     +  .250335E+02, .206354E+02, .171788E+02, .144269E+02,
     +  .122141E+02, .104143E+02, .893520E+01, .770633E+01,
     +  .667930E+01, .580420E+01, .506187E+01, .441935E+01,
     +  .386519E+01, .338238E+01, .295960E+01, .258767E+01,
     +  .225936E+01, .196887E+01, .171152E+01, .148355E+01,
     +  .128176E+01, .110344E+01, .946195E+00, .807921E+00,
     +  .686506E+00, .580818E+00, .488150E+00, .407780E+00,
     +  .338368E+00, .278731E+00, .227766E+00, .184482E+00,
     +  .147965E+00, .117407E+00, .920550E-01, .711572E-01,
     +  .542958E-01, .406549E-01, .298545E-01, .214401E-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .150015E-01, .101821E-01, .666089E-02, .417574E-02,
     +  .247276E-02, .137051E-02, .694518E-03, .312035E-03,
     +  .118032E-03, .345217E-04, .679877E-05, .723329E-06,
     +  .000000E+00, .167774E+07, .126360E+07, .934647E+06,
     +  .690866E+06, .510356E+06, .376731E+06, .277918E+06,
     +  .204871E+06, .150929E+06, .111108E+06, .817445E+05,
     +  .600986E+05, .441599E+05, .324274E+05, .238008E+05,
     +  .174598E+05, .128040E+05, .938634E+04, .688031E+04,
     +  .504301E+04, .369736E+04, .271177E+04, .199051E+04,
     +  .146256E+04, .107634E+04, .793605E+03, .586846E+03,
     +  .433491E+03, .322928E+03, .241722E+03, .181998E+03,
     +  .137944E+03, .105357E+03, .812155E+02, .631576E+02,
     +  .496094E+02, .393821E+02, .315974E+02, .256244E+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .209929E+02, .173718E+02, .145034E+02, .122078E+02,
     +  .103491E+02, .882828E+01, .757035E+01, .652368E+01,
     +  .563588E+01, .488628E+01, .424064E+01, .368658E+01,
     +  .320644E+01, .278834E+01, .242275E+01, .210206E+01,
     +  .182021E+01, .157225E+01, .135415E+01, .116250E+01,
     +  .994369E+00, .847188E+00, .718710E+00, .606718E+00,
     +  .509948E+00, .425729E+00, .353231E+00, .291091E+00,
     +  .238111E+00, .193184E+00, .155330E+00, .123650E+00,
     +  .973584E-01, .757299E-01, .580548E-01, .439210E-01,
     +  .325925E-01, .237098E-01, .168592E-01, .116730E-01,
     +  .783447E-02, .506360E-02, .313321E-02, .182891E-02,
     +  .997658E-03, .496599E-03, .218604E-03, .807789E-04,
     +  .230188E-04, .443188E-05, .476488E-06, .000000E+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .215974E+07, .161990E+07, .119231E+07, .876963E+06,
     +  .644582E+06, .473401E+06, .347439E+06, .254788E+06,
     +  .186713E+06, .136717E+06, .100040E+06, .731449E+05,
     +  .534457E+05, .390234E+05, .284767E+05, .207673E+05,
     +  .151384E+05, .110301E+05, .803502E+04, .585211E+04,
     +  .426289E+04, .310597E+04, .226457E+04, .165256E+04,
     +  .120770E+04, .884141E+03, .649099E+03, .475947E+03,
     +  .351963E+03, .261527E+03, .195469E+03, .147080E+03,
     +  .111531E+03, .853750E+02, .659389E+02, .514517E+02,
     +  .405831E+02, .323598E+02, .260853E+02, .212458E+02,
     +  .174807E+02, .145121E+02, .121467E+02, .102398E+02,
     +  .868615E+01, .740646E+01, .634626E+01, .545097E+01,
     +  .469851E+01, .405354E+01, .350283E+01, .302814E+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .261711E+01, .225984E+01, .194843E+01, .167654E+01,
     +  .143898E+01, .123151E+01, .105047E+01, .892803E+00,
     +  .755769E+00, .637012E+00, .534240E+00, .446082E+00,
     +  .369921E+00, .304847E+00, .249489E+00, .202649E+00,
     +  .163237E+00, .130289E+00, .102937E+00, .804227E-01,
     +  .620580E-01, .471793E-01, .353878E-01, .260243E-01,
     +  .187534E-01, .132026E-01, .904513E-02, .600264E-02,
     +  .383280E-02, .234069E-02, .134670E-02, .722963E-03,
     +  .353459E-03, .152449E-03, .550392E-04, .152882E-04,
     +  .288064E-05, .312915E-06, .000000E+00, .273753E+07,
     +  .204506E+07, .149808E+07, .109657E+07, .802078E+06,
     +  .586177E+06, .428066E+06, .312333E+06, .227715E+06,
     +  .165878E+06, .120741E+06, .878110E+05, .638154E+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .463395E+05, .336270E+05, .243844E+05, .176727E+05,
     +  .128012E+05, .926957E+04, .671027E+04, .485775E+04,
     +  .351709E+04, .254786E+04, .184714E+04, .134094E+04,
     +  .975043E+03, .710945E+03, .517651E+03, .380150E+03,
     +  .280513E+03, .208209E+03, .155596E+03, .117193E+03,
     +  .891189E+02, .683883E+02, .530309E+02, .415764E+02,
     +  .329584E+02, .264168E+02, .213964E+02, .175083E+02,
     +  .144562E+02, .120344E+02, .100900E+02, .851208E+01,
     +  .721776E+01, .614994E+01, .525213E+01, .450099E+01,
     +  .386025E+01, .331591E+01, .284920E+01, .244736E+01,
     +  .210017E+01, .179944E+01, .153861E+01, .131225E+01,
     +  .111593E+01, .945825E+00, .798724E+00, .671787E+00,
     +  .562566E+00, .468720E+00, .388800E+00, .320260E+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .262129E+00, .213048E+00, .171832E+00, .137419E+00,
     +  .108876E+00, .853704E-01, .661806E-01, .506595E-01,
     +  .381926E-01, .284010E-01, .206976E-01, .147738E-01,
     +  .102972E-01, .698005E-02, .457994E-02, .288888E-02,
     +  .174111E-02, .987284E-03, .521574E-03, .250449E-03,
     +  .105838E-03, .373396E-04, .101150E-04, .186708E-05,
     +  .204874E-06, .000000E+00, .583956E+04, .686188E+04,
     +  .568856E+04, .471694E+04, .391223E+04, .324566E+04,
     +  .269344E+04, .223586E+04, .185665E+04, .154231E+04,
     +  .128169E+04, .106556E+04, .886278E+03, .737528E+03,
     +  .614073E+03, .511578E+03, .426458E+03, .355743E+03,
     +  .296972E+03, .248108E+03, .207464E+03, .173643E+03,
     +  .145485E+03, .122031E+03, .102485E+03, .861872E+02 /
        DATA (UPDI(I),I=8945,8996) /
     +  .725900E+02, .610931E+02, .516411E+02, .437414E+02,
     +  .371354E+02, .316081E+02, .269807E+02, .231151E+02,
     +  .198666E+02, .171429E+02, .148572E+02, .129366E+02,
     +  .113199E+02, .995528E+01, .880147E+01, .782026E+01,
     +  .698184E+01, .626087E+01, .563625E+01, .509056E+01,
     +  .461105E+01, .418128E+01, .379683E+01, .344510E+01,
     +  .312346E+01, .282593E+01, .254942E+01, .229215E+01,
     +  .205344E+01, .183310E+01, .163098E+01, .144658E+01,
     +  .127904E+01, .112718E+01, .989757E+00, .865531E+00,
     +  .753392E+00, .652798E+00, .561850E+00, .480438E+00,
     +  .407876E+00, .343537E+00, .286828E+00, .237188E+00,
     +  .194069E+00, .156939E+00, .125255E+00, .984874E-01,
     +  .763484E-01, .580169E-01, .431854E-01, .313921E-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .222009E-01, .152030E-01, .100197E-01, .631007E-02,
     +  .374400E-02, .207059E-02, .104163E-02, .460526E-03,
     +  .168904E-03, .461163E-04, .735034E-05, .314238E-06,
     +  .000000E+00, .184852E+05, .242640E+05, .193149E+05,
     +  .153801E+05, .122534E+05, .976596E+04, .778828E+04,
     +  .621391E+04, .496134E+04, .396342E+04, .316885E+04,
     +  .253523E+04, .203027E+04, .162716E+04, .130555E+04,
     +  .104849E+04, .843147E+03, .678769E+03, .547266E+03,
     +  .441824E+03, .357329E+03, .289447E+03, .234939E+03,
     +  .191050E+03, .155723E+03, .127216E+03, .104211E+03,
     +  .853523E+02, .703279E+02, .581229E+02, .482131E+02,
     +  .401348E+02, .335517E+02, .281794E+02, .237730E+02,
     +  .201533E+02, .171797E+02, .147240E+02, .126944E+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .110059E+02, .960005E+01, .841889E+01, .742275E+01,
     +  .657499E+01, .584904E+01, .522100E+01, .467529E+01,
     +  .419118E+01, .376340E+01, .337672E+01, .302814E+01,
     +  .271041E+01, .241994E+01, .215404E+01, .191129E+01,
     +  .169050E+01, .149067E+01, .131055E+01, .114869E+01,
     +  .100351E+01, .873477E+00, .757162E+00, .653223E+00,
     +  .560987E+00, .478476E+00, .405429E+00, .341036E+00,
     +  .284580E+00, .235377E+00, .192795E+00, .156223E+00,
     +  .125095E+00, .988464E-01, .769222E-01, .590063E-01,
     +  .443493E-01, .326348E-01, .234390E-01, .163642E-01,
     +  .110528E-01, .717348E-02, .444200E-02, .258351E-02,
     +  .139829E-02, .689598E-03, .298323E-03, .106716E-03,
     +  .283711E-04, .442352E-05, .193623E-06, .000000E+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .594873E+05, .471414E+05, .369861E+05, .290215E+05,
     +  .227784E+05, .178812E+05, .140419E+05, .110295E+05,
     +  .866740E+04, .681341E+04, .535909E+04, .421710E+04,
     +  .332087E+04, .261667E+04, .206367E+04, .162879E+04,
     +  .128700E+04, .101794E+04, .806240E+03, .639369E+03,
     +  .507903E+03, .404108E+03, .322186E+03, .257375E+03,
     +  .206108E+03, .165464E+03, .133236E+03, .107274E+03,
     +  .869449E+02, .707117E+02, .577502E+02, .473572E+02,
     +  .390217E+02, .323244E+02, .269124E+02, .225295E+02,
     +  .189773E+02, .160808E+02, .137152E+02, .117689E+02,
     +  .101653E+02, .883088E+01, .771557E+01, .677440E+01,
     +  .597504E+01, .528893E+01, .469747E+01, .417697E+01,
     +  .372092E+01, .331233E+01, .294754E+01, .261843E+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .232077E+01, .205124E+01, .180774E+01, .158844E+01,
     +  .139172E+01, .121586E+01, .105904E+01, .919410E+00,
     +  .795244E+00, .685001E+00, .587196E+00, .501059E+00,
     +  .424582E+00, .357404E+00, .298644E+00, .247536E+00,
     +  .203347E+00, .165413E+00, .133094E+00, .105813E+00,
     +  .830031E-01, .641074E-01, .487991E-01, .363845E-01,
     +  .265505E-01, .189029E-01, .130753E-01, .874480E-02,
     +  .561486E-02, .343682E-02, .197316E-02, .105284E-02,
     +  .510320E-03, .216324E-03, .758965E-04, .197515E-04,
     +  .302378E-05, .134981E-06, .000000E+00, .101096E+06,
     +  .794196E+05, .616952E+05, .479231E+05, .372294E+05,
     +  .289211E+05, .224707E+05, .174597E+05, .135696E+05,
     +  .105475E+05, .820147E+04, .637872E+04, .496356E+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .386380E+04, .300974E+04, .234576E+04, .182989E+04,
     +  .142858E+04, .111657E+04, .873642E+03, .684607E+03,
     +  .537241E+03, .422405E+03, .332735E+03, .262728E+03,
     +  .207964E+03, .165122E+03, .131075E+03, .104775E+03,
     +  .840581E+02, .677375E+02, .548262E+02, .446057E+02,
     +  .365002E+02, .300317E+02, .248572E+02, .207117E+02,
     +  .173693E+02, .146681E+02, .124679E+02, .106719E+02,
     +  .919052E+01, .796257E+01, .693453E+01, .606796E+01,
     +  .532966E+01, .469784E+01, .414596E+01, .366616E+01,
     +  .323979E+01, .286241E+01, .252506E+01, .222283E+01,
     +  .195178E+01, .170917E+01, .149258E+01, .129985E+01,
     +  .112883E+01, .977393E+00, .843485E+00, .725207E+00,
     +  .620916E+00, .529015E+00, .448650E+00, .377804E+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .316024E+00, .262382E+00, .216076E+00, .176338E+00,
     +  .142487E+00, .113868E+00, .898992E-01, .700210E-01,
     +  .536847E-01, .405595E-01, .300055E-01, .217180E-01,
     +  .153316E-01, .105107E-01, .696380E-02, .442656E-02,
     +  .268093E-02, .152184E-02, .802590E-03, .384003E-03,
     +  .160534E-03, .551910E-04, .140542E-04, .208582E-05,
     +  .934030E-07, .000000E+00, .157566E+06, .122945E+06,
     +  .947673E+05, .730327E+05, .562819E+05, .433653E+05,
     +  .334140E+05, .257431E+05, .198352E+05, .152823E+05,
     +  .117766E+05, .907559E+04, .699621E+04, .539418E+04,
     +  .416095E+04, .321076E+04, .247923E+04, .191545E+04,
     +  .148126E+04, .114648E+04, .888519E+03, .689451E+03,
     +  .535905E+03, .417263E+03, .325615E+03, .254698E+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .199827E+03, .156707E+03, .123772E+03, .981232E+02,
     +  .781443E+02, .625193E+02, .502884E+02, .406977E+02,
     +  .331266E+02, .271354E+02, .223849E+02, .185931E+02,
     +  .155575E+02, .131077E+02, .111249E+02, .950285E+01,
     +  .816848E+01, .705967E+01, .613156E+01, .534635E+01,
     +  .467898E+01, .410014E+01, .360052E+01, .315993E+01,
     +  .277307E+01, .243016E+01, .212559E+01, .185482E+01,
     +  .161447E+01, .140161E+01, .121360E+01, .104792E+01,
     +  .902172E+00, .774126E+00, .661752E+00, .563311E+00,
     +  .477126E+00, .402262E+00, .336711E+00, .279945E+00,
     +  .231001E+00, .189049E+00, .153306E+00, .123079E+00,
     +  .977117E-01, .766264E-01, .592740E-01, .451223E-01,
     +  .338428E-01, .248467E-01, .178420E-01, .124915E-01 /
        DATA (UPDI(I),I=9361,9412) /
     +  .848931E-02, .557310E-02, .350795E-02, .210268E-02,
     +  .118049E-02, .615442E-03, .290749E-03, .119979E-03,
     +  .407481E-04, .103106E-04, .155370E-05, .654757E-07,
     +  .000000E+00, .165494E+06, .179968E+06, .137812E+06,
     +  .105498E+06, .807508E+05, .617906E+05, .472781E+05,
     +  .361649E+05, .276631E+05, .211558E+05, .161800E+05,
     +  .123730E+05, .946323E+04, .723775E+04, .553726E+04,
     +  .423695E+04, .324357E+04, .248400E+04, .190371E+04,
     +  .145993E+04, .112083E+04, .861385E+03, .662998E+03,
     +  .511077E+03, .394779E+03, .305618E+03, .237280E+03,
     +  .184096E+03, .143867E+03, .112848E+03, .889235E+02,
     +  .704003E+02, .560434E+02, .448981E+02, .361848E+02,
     +  .293570E+02, .239931E+02, .197510E+02, .163844E+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .136903E+02, .115270E+02, .977083E+01, .833640E+01,
     +  .715280E+01, .616863E+01, .534150E+01, .464305E+01,
     +  .404129E+01, .352543E+01, .307378E+01, .268016E+01,
     +  .233401E+01, .202900E+01, .176002E+01, .152310E+01,
     +  .131482E+01, .113211E+01, .972166E+00, .832338E+00,
     +  .710250E+00, .603765E+00, .511065E+00, .430411E+00,
     +  .360802E+00, .300249E+00, .248159E+00, .203549E+00,
     +  .165573E+00, .133442E+00, .106459E+00, .839754E-01,
     +  .654227E-01, .502680E-01, .380005E-01, .282983E-01,
     +  .206214E-01, .146931E-01, .102034E-01, .687517E-02,
     +  .447279E-02, .278832E-02, .165436E-02, .918753E-03,
     +  .473549E-03, .220927E-03, .899902E-04, .301834E-04,
     +  .757369E-05, .114929E-05, .463502E-07, .000000E+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .348517E+06, .268800E+06, .204436E+06, .155424E+06,
     +  .118133E+06, .897546E+05, .681778E+05, .517695E+05,
     +  .393028E+05, .298289E+05, .226357E+05, .171730E+05,
     +  .130280E+05, .988208E+04, .749642E+04, .568662E+04,
     +  .431486E+04, .327459E+04, .248635E+04, .188871E+04,
     +  .143592E+04, .109259E+04, .832389E+03, .634991E+03,
     +  .485284E+03, .371618E+03, .285349E+03, .218889E+03,
     +  .169128E+03, .131162E+03, .102179E+03, .799805E+02,
     +  .629538E+02, .498783E+02, .397615E+02, .319177E+02,
     +  .258173E+02, .210416E+02, .172871E+02, .143109E+02,
     +  .119418E+02, .100351E+02, .848999E+01, .722521E+01,
     +  .618132E+01, .531059E+01, .458071E+01, .395663E+01,
     +  .342573E+01, .296471E+01, .256626E+01, .221893E+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .191558E+01, .165042E+01, .141885E+01, .121694E+01,
     +  .104116E+01, .888415E+00, .755824E+00, .640868E+00,
     +  .541307E+00, .455252E+00, .380913E+00, .317220E+00,
     +  .262226E+00, .215275E+00, .175373E+00, .141668E+00,
     +  .113374E+00, .898017E-01, .703180E-01, .543730E-01,
     +  .414579E-01, .310916E-01, .229644E-01, .165917E-01,
     +  .117164E-01, .806005E-02, .537710E-02, .346123E-02,
     +  .213312E-02, .125007E-02, .684871E-03, .347712E-03,
     +  .159385E-03, .635813E-04, .207781E-04, .503387E-05,
     +  .725985E-06, .318289E-07, .000000E+00, .503147E+06,
     +  .385987E+06, .291739E+06, .220403E+06, .166453E+06,
     +  .125649E+06, .948163E+05, .715168E+05, .539263E+05,
     +  .406452E+05, .306271E+05, .230697E+05, .173738E+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .130805E+05, .984731E+04, .741206E+04, .557946E+04,
     +  .419999E+04, .316252E+04, .238195E+04, .179515E+04,
     +  .135376E+04, .102195E+04, .772327E+03, .584607E+03,
     +  .443311E+03, .337018E+03, .255880E+03, .195686E+03,
     +  .150194E+03, .115790E+03, .896943E+02, .698687E+02,
     +  .547926E+02, .432382E+02, .343665E+02, .275303E+02,
     +  .222283E+02, .180965E+02, .148499E+02, .122864E+02,
     +  .102398E+02, .859374E+01, .725635E+01, .616030E+01,
     +  .525258E+01, .449699E+01, .385561E+01, .331400E+01,
     +  .284731E+01, .244717E+01, .210126E+01, .180166E+01,
     +  .154197E+01, .131701E+01, .112237E+01, .954175E+00,
     +  .809058E+00, .683961E+00, .576251E+00, .483613E+00,
     +  .404104E+00, .335903E+00, .277893E+00, .228174E+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .186045E+00, .150515E+00, .120734E+00, .959301E-01,
     +  .754302E-01, .586236E-01, .449836E-01, .340295E-01,
     +  .253126E-01, .185394E-01, .132772E-01, .929008E-02,
     +  .632961E-02, .418002E-02, .266190E-02, .162180E-02,
     +  .938944E-03, .507799E-03, .254283E-03, .114819E-03,
     +  .450868E-04, .145079E-04, .347206E-05, .502014E-06,
     +  .212758E-07, .000000E+00, .703917E+06, .537328E+06,
     +  .403775E+06, .303258E+06, .227668E+06, .170824E+06,
     +  .128119E+06, .960378E+05, .719607E+05, .538915E+05,
     +  .403446E+05, .301884E+05, .225819E+05, .168850E+05,
     +  .126225E+05, .943311E+04, .704903E+04, .526671E+04,
     +  .393552E+04, .294107E+04, .219885E+04, .164466E+04,
     +  .123117E+04, .922486E+03, .692159E+03, .520169E+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .391841E+03, .294706E+03, .223255E+03, .169723E+03,
     +  .129589E+03, .994182E+02, .766982E+02, .595766E+02,
     +  .465701E+02, .366726E+02, .291116E+02, .232982E+02,
     +  .188049E+02, .153030E+02, .125589E+02, .103847E+02,
     +  .864833E+01, .724750E+01, .610718E+01, .516919E+01,
     +  .439365E+01, .373990E+01, .319174E+01, .272294E+01,
     +  .232405E+01, .198196E+01, .168802E+01, .143526E+01,
     +  .121799E+01, .103141E+01, .871332E+00, .734175E+00,
     +  .616746E+00, .516326E+00, .430550E+00, .357442E+00,
     +  .295172E+00, .242585E+00, .197844E+00, .160216E+00,
     +  .128721E+00, .102526E+00, .808784E-01, .631290E-01,
     +  .486952E-01, .370777E-01, .278273E-01, .205293E-01,
     +  .149091E-01, .105830E-01, .733660E-02, .495030E-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .323585E-02, .203844E-02, .122771E-02, .702168E-03,
     +  .374856E-03, .185146E-03, .823697E-04, .318540E-04,
     +  .101034E-04, .239401E-05, .348623E-06, .152696E-07,
     +  .000000E+00, .959965E+06, .729349E+06, .545061E+06,
     +  .407102E+06, .303911E+06, .226733E+06, .169071E+06,
     +  .125994E+06, .938461E+05, .698582E+05, .519774E+05,
     +  .386509E+05, .287290E+05, .213429E+05, .158503E+05,
     +  .117661E+05, .873233E+04, .647895E+04, .480689E+04,
     +  .356614E+04, .264633E+04, .196430E+04, .145900E+04,
     +  .108449E+04, .807087E+03, .601485E+03, .449250E+03,
     +  .334924E+03, .251496E+03, .189497E+03, .143390E+03,
     +  .109017E+03, .833466E+02, .641638E+02, .497116E+02,
     +  .388057E+02, .305418E+02, .242393E+02, .194055E+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .156669E+02, .127584E+02, .104703E+02, .865516E+01,
     +  .720058E+01, .602410E+01, .506265E+01, .427286E+01,
     +  .361154E+01, .306082E+01, .259322E+01, .219828E+01,
     +  .186216E+01, .157555E+01, .133098E+01, .112231E+01,
     +  .944402E+00, .792832E+00, .663847E+00, .554156E+00,
     +  .460986E+00, .381945E+00, .315042E+00, .258453E+00,
     +  .211005E+00, .170930E+00, .137475E+00, .109684E+00,
     +  .867457E-01, .679373E-01, .526377E-01, .402966E-01,
     +  .304455E-01, .226681E-01, .165851E-01, .119423E-01,
     +  .840167E-02, .577035E-02, .385559E-02, .249448E-02,
     +  .155439E-02, .925423E-03, .522856E-03, .275538E-03,
     +  .134237E-03, .588517E-04, .224211E-04, .701345E-05,
     +  .164608E-05, .241101E-06, .114595E-07, .000000E+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .128107E+07, .968968E+06, .720329E+06, .535154E+06,
     +  .397358E+06, .294838E+06, .218643E+06, .162026E+06,
     +  .120001E+06, .888145E+05, .656962E+05, .485629E+05,
     +  .358791E+05, .264916E+05, .195512E+05, .144213E+05,
     +  .106337E+05, .783760E+04, .577576E+04, .425548E+04,
     +  .313569E+04, .231084E+04, .170381E+04, .125697E+04,
     +  .928285E+03, .686387E+03, .508574E+03, .376032E+03,
     +  .280038E+03, .209244E+03, .157000E+03, .118356E+03,
     +  .897203E+02, .684908E+02, .526210E+02, .407394E+02,
     +  .318046E+02, .250423E+02, .198937E+02, .159400E+02,
     +  .128852E+02, .104979E+02, .861627E+01, .711795E+01,
     +  .591354E+01, .493537E+01, .413689E+01, .347260E+01,
     +  .292307E+01, .245973E+01, .207118E+01, .174293E+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .146510E+01, .122976E+01, .103041E+01, .861640E+00,
     +  .718835E+00, .598123E+00, .496150E+00, .410114E+00,
     +  .337620E+00, .276679E+00, .225491E+00, .182875E+00,
     +  .147143E+00, .117532E+00, .931203E-01, .731241E-01,
     +  .568552E-01, .437256E-01, .332205E-01, .249042E-01,
     +  .183941E-01, .133463E-01, .952808E-02, .664324E-02,
     +  .452006E-02, .299065E-02, .191498E-02, .118033E-02,
     +  .694637E-03, .387708E-03, .201698E-03, .969324E-04,
     +  .418872E-04, .157266E-04, .485410E-05, .112881E-05,
     +  .166029E-06, .849662E-08, .000000E+00, .167743E+07,
     +  .126333E+07, .934403E+06, .690649E+06, .510161E+06,
     +  .376556E+06, .277762E+06, .204731E+06, .150804E+06,
     +  .110997E+06, .816445E+05, .600091E+05, .440797E+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .323556E+05, .237365E+05, .174022E+05, .127523E+05,
     +  .933999E+04, .683872E+04, .500567E+04, .366384E+04,
     +  .268165E+04, .196343E+04, .143821E+04, .105443E+04,
     +  .773870E+03, .569067E+03, .417487E+03, .308491E+03,
     +  .228690E+03, .170226E+03, .127304E+03, .957315E+02,
     +  .725002E+02, .552618E+02, .424513E+02, .328874E+02,
     +  .257009E+02, .202669E+02, .161224E+02, .129406E+02,
     +  .104699E+02, .853435E+01, .700238E+01, .577821E+01,
     +  .478992E+01, .398807E+01, .332514E+01, .278029E+01,
     +  .232400E+01, .194400E+01, .162527E+01, .135742E+01,
     +  .113216E+01, .942669E+00, .783352E+00, .649448E+00,
     +  .537008E+00, .442650E+00, .363568E+00, .297382E+00,
     +  .242124E+00, .196031E+00, .157927E+00, .126210E+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .100119E+00, .787700E-01, .614153E-01, .474049E-01,
     +  .361870E-01, .272841E-01, .202941E-01, .148688E-01,
     +  .106983E-01, .757212E-02, .523205E-02, .352652E-02,
     +  .231038E-02, .146414E-02, .892633E-03, .519281E-03,
     +  .286331E-03, .147059E-03, .697246E-04, .297052E-04,
     +  .109953E-04, .335043E-05, .772173E-06, .113890E-06,
     +  .623156E-08, .000000E+00, .215941E+07, .161961E+07,
     +  .119204E+07, .876725E+06, .644369E+06, .473211E+06,
     +  .347269E+06, .254636E+06, .186577E+06, .136596E+06,
     +  .999310E+05, .730474E+05, .533584E+05, .389452E+05,
     +  .284066E+05, .207045E+05, .150821E+05, .109797E+05,
     +  .798980E+04, .581155E+04, .422649E+04, .307330E+04,
     +  .223523E+04, .162619E+04, .118400E+04, .862830E+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .629931E+03, .458724E+03, .336458E+03, .247562E+03,
     +  .182885E+03, .135738E+03, .101301E+03, .761421E+02,
     +  .576040E+02, .439244E+02, .337816E+02, .262116E+02,
     +  .205250E+02, .162156E+02, .129274E+02, .103894E+02,
     +  .841257E+01, .685699E+01, .562100E+01, .462893E+01,
     +  .382874E+01, .317121E+01, .263420E+01, .218742E+01,
     +  .181788E+01, .151005E+01, .125317E+01, .103863E+01,
     +  .859390E+00, .709703E+00, .584724E+00, .480465E+00,
     +  .393546E+00, .321181E+00, .261024E+00, .211141E+00,
     +  .169819E+00, .135900E+00, .107870E+00, .849807E-01,
     +  .663913E-01, .513944E-01, .393811E-01, .298380E-01,
     +  .223254E-01, .164755E-01, .119737E-01, .854311E-02,
     +  .599456E-02, .410465E-02, .274062E-02, .177783E-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .111501E-02, .672390E-03, .386667E-03, .210642E-03,
     +  .106815E-03, .499706E-04, .209948E-04, .766443E-05,
     +  .230673E-05, .526975E-06, .778478E-07, .452637E-08,
     +  .000000E+00, .273717E+07, .204474E+07, .149779E+07,
     +  .109631E+07, .801847E+06, .585970E+06, .427881E+06,
     +  .312168E+06, .227567E+06, .165746E+06, .120622E+06,
     +  .877049E+05, .637204E+05, .462544E+05, .335508E+05,
     +  .243162E+05, .176116E+05, .127465E+05, .922051E+04,
     +  .666629E+04, .481831E+04, .348172E+04, .251614E+04,
     +  .181867E+04, .131539E+04, .952099E+03, .690343E+03,
     +  .499176E+03, .363553E+03, .265599E+03, .194806E+03,
     +  .143548E+03, .106361E+03, .793755E+02, .596245E+02,
     +  .451470E+02, .344824E+02, .265741E+02, .206700E+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .162228E+02, .128491E+02, .102600E+02, .825453E+01,
     +  .668509E+01, .544493E+01, .445504E+01, .366120E+01,
     +  .301274E+01, .248640E+01, .205132E+01, .169383E+01,
     +  .139805E+01, .115290E+01, .949547E+00, .780792E+00,
     +  .640788E+00, .524658E+00, .428411E+00, .348695E+00,
     +  .282764E+00, .228324E+00, .183488E+00, .146602E+00,
     +  .116538E+00, .918718E-01, .718775E-01, .557599E-01,
     +  .428555E-01, .325983E-01, .245142E-01, .182015E-01,
     +  .133266E-01, .960681E-02, .679669E-02, .472789E-02,
     +  .320805E-02, .212178E-02, .136282E-02, .845901E-03,
     +  .504561E-03, .286835E-03, .154388E-03, .773047E-04,
     +  .356900E-04, .147916E-04, .532775E-05, .158443E-05,
     +  .358830E-06, .530368E-07, .325954E-08, .000000E+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
