# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.delimited_text_reader import DelimitedTextReader


class TemporalDelimitedTextReader(DelimitedTextReader):
    r"""
    TemporalDelimitedTextReader - reads a delimited ascii or unicode
    text files and and output a temporal Table.
    
    Superclass: DelimitedTextReader
    
    This reader requires that field_delimiter_characters is set before the
    pipeline is executed, otherwise it will produce an empty output.
    
    A column can be selected as time step indicator using the
    set_time_column_name or set_time_column_id functions. If so, for a given
    time step 's' only the lines where the time step indicator column
    have the value 's' are present. To control if the time step indicator
    column should be present in the output, a remove_time_step_column option
    is available. If no time step indicator column is given by the user,
    the whole file it outputted.
    
    This reader assume the time step column is numeric. A warning is set
    otherwise. The detect_numeric_columns field is set to on, do not change
    this field unless you really know what you are doing.
    
    @see DelimitedTextReader
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTemporalDelimitedTextReader, obj, update, **traits)
    
    remove_time_step_column = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _remove_time_step_column_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRemoveTimeStepColumn,
                        self.remove_time_step_column)

    time_column_id = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _time_column_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTimeColumnId,
                        self.time_column_id)

    time_column_name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _time_column_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTimeColumnName,
                        self.time_column_name)

    _updateable_traits_ = \
    (('add_tab_field_delimiter', 'GetAddTabFieldDelimiter'),
    ('detect_numeric_columns', 'GetDetectNumericColumns'),
    ('force_double', 'GetForceDouble'), ('generate_pedigree_ids',
    'GetGeneratePedigreeIds'), ('merge_consecutive_delimiters',
    'GetMergeConsecutiveDelimiters'), ('output_pedigree_ids',
    'GetOutputPedigreeIds'), ('read_from_input_string',
    'GetReadFromInputString'),
    ('trim_whitespace_prior_to_numeric_conversion',
    'GetTrimWhitespacePriorToNumericConversion'), ('use_string_delimiter',
    'GetUseStringDelimiter'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('remove_time_step_column', 'GetRemoveTimeStepColumn'),
    ('time_column_id', 'GetTimeColumnId'), ('time_column_name',
    'GetTimeColumnName'), ('default_double_value',
    'GetDefaultDoubleValue'), ('default_integer_value',
    'GetDefaultIntegerValue'), ('field_delimiter_characters',
    'GetFieldDelimiterCharacters'), ('file_name', 'GetFileName'),
    ('have_headers', 'GetHaveHeaders'), ('input_string',
    'GetInputString'), ('max_records', 'GetMaxRecords'),
    ('pedigree_id_array_name', 'GetPedigreeIdArrayName'),
    ('replacement_character', 'GetReplacementCharacter'),
    ('string_delimiter', 'GetStringDelimiter'), ('utf8_field_delimiters',
    'GetUTF8FieldDelimiters'), ('utf8_record_delimiters',
    'GetUTF8RecordDelimiters'), ('utf8_string_delimiters',
    'GetUTF8StringDelimiters'), ('unicode_character_set',
    'GetUnicodeCharacterSet'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'add_tab_field_delimiter', 'debug',
    'detect_numeric_columns', 'force_double', 'generate_pedigree_ids',
    'global_warning_display', 'merge_consecutive_delimiters',
    'output_pedigree_ids', 'read_from_input_string', 'release_data_flag',
    'trim_whitespace_prior_to_numeric_conversion', 'use_string_delimiter',
    'default_double_value', 'default_integer_value',
    'field_delimiter_characters', 'file_name', 'have_headers',
    'input_string', 'max_records', 'object_name',
    'pedigree_id_array_name', 'progress_text', 'remove_time_step_column',
    'replacement_character', 'string_delimiter', 'time_column_id',
    'time_column_name', 'unicode_character_set', 'utf8_field_delimiters',
    'utf8_record_delimiters', 'utf8_string_delimiters'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TemporalDelimitedTextReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TemporalDelimitedTextReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['add_tab_field_delimiter', 'detect_numeric_columns',
            'force_double', 'generate_pedigree_ids',
            'merge_consecutive_delimiters', 'output_pedigree_ids',
            'read_from_input_string',
            'trim_whitespace_prior_to_numeric_conversion',
            'use_string_delimiter'], [], ['default_double_value',
            'default_integer_value', 'field_delimiter_characters', 'file_name',
            'have_headers', 'input_string', 'max_records', 'object_name',
            'pedigree_id_array_name', 'remove_time_step_column',
            'replacement_character', 'string_delimiter', 'time_column_id',
            'time_column_name', 'unicode_character_set', 'utf8_field_delimiters',
            'utf8_record_delimiters', 'utf8_string_delimiters']),
            title='Edit TemporalDelimitedTextReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TemporalDelimitedTextReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

