# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class StreamTracer(PolyDataAlgorithm):
    r"""
    StreamTracer - Streamline generator
    
    Superclass: PolyDataAlgorithm
    
    StreamTracer is a filter that integrates a vector field to
    generate streamlines. The integration is performed using a specified
    integrator, by default Runge-Kutta2.
    
    StreamTracer produces polylines as the output, with each cell
    (i.e., polyline) representing a streamline. The attribute values
    associated with each streamline are stored in the cell data, whereas
    those associated with streamline-points are stored in the point data.
    
    StreamTracer supports forward (the default), backward, and
    combined (i.e., BOTH) integration. The length of a streamline is
    governed by specifying a maximum value either in physical arc length
    or in (local) cell length. Otherwise, the integration terminates upon
    exiting the flow field domain, or if the particle speed is reduced to
    a value less than a specified terminal speed, or when a maximum
    number of steps is completed. The specific reason for the termination
    is stored in a cell array named reason_for_termination.
    
    Note that normalized vectors are adopted in streamline integration,
    which achieves high numerical accuracy/smoothness of flow lines that
    is particularly guaranteed for Runge-Kutta45 with adaptive step size
    and error control). In support of this feature, the underlying step
    size is ALWAYS in arc length unit (LENGTH_UNIT) while the 'real' time
    interval (virtual for steady flows) that a particle actually takes to
    trave in a single step is obtained by dividing the arc length by the
    LOCAL speed. The overall elapsed time (i.e., the life span) of the
    particle is the sum of those individual step-wise time intervals.
    
    The quality of streamline integration can be controlled by setting
    the initial integration step (initial_integration_step), particularly
    for Runge-Kutta2 and Runge-Kutta4 (with a fixed step size), and in
    the case of Runge-Kutta45 (with an adaptive step size and error
    control) the minimum integration step, the maximum integration step,
    and the maximum error. These steps are in either LENGTH_UNIT or
    CELL_LENGTH_UNIT while the error is in physical arc length. For the
    former two integrators, there is a trade-off between integration
    speed and streamline quality.
    
    The integration time, vorticity, rotation and angular velocity are
    stored in point data arrays named "integration_time", "Vorticity",
    "Rotation" and "angular_velocity", respectively (vorticity, rotation
    and angular velocity are computed only when compute_vorticity is on).
    All point data attributes in the source dataset are interpolated on
    the new streamline points.
    
    StreamTracer supports integration through any type of dataset.
    Thus if the dataset contains 2D cells like polygons or triangles, the
    integration is constrained to lie on the surface defined by 2D cells.
    
    The starting point, or the so-called 'seed', of a streamline may be
    set in two different ways. Starting from global x-y-z "position"
    allows you to start a single trace at a specified x-y-z coordinate.
    If you specify a source object, traces will be generated from each
    point in the source that is inside the dataset. Note that if the
    integration direction is BOTH, then potentially 2N streamlines will
    be generated given N seed points.
    
    ote This class has been threaded using SMPTools. Each separate
    streamline (corresponding to the initial seeds) is processed in a
    separate thread. Consequently, if threading is enabled and many
    streamlines are generated, significant performance improvement is
    possible.
    
    ote Field data is shallow copied to the output. When the input is a
    composite data set, field data associated with the root block is
    shallow- copied to the output PolyData.
    
    @sa
    RibbonFilter RuledSurfaceFilter InitialValueProblemSolver
    RungeKutta2 RungeKutta4 RungeKutta45 ParticleTracerBase
    ParticleTracer ParticlePathFilter StreaklineFilter
    AbstractInterpolatedVelocityField
    CompositeInterpolatedVelocityField AMRInterpolatedVelocityField
    SMPTools PStreamTracer
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkStreamTracer, obj, update, **traits)
    
    force_serial_execution = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _force_serial_execution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetForceSerialExecution,
                        self.force_serial_execution_)

    surface_streamlines = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _surface_streamlines_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSurfaceStreamlines,
                        self.surface_streamlines_)

    use_local_seed_source = tvtk_base.true_bool_trait(desc=\
        r"""
        If true the filter considers that the whole seed source is
        available on all ranks. Else the filter will aggregate all seed
        sources from all ranks and merge their points.
        
        This property only makes sense when the filter is parallelized
        and is a no-op for its sequential version. However, this member
        function needs to be defined in this class to maintain a uniform
        interface between StreamTracer and its parallel override
        class, PStreamTracer. Default is true.
        """
    )

    def _use_local_seed_source_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseLocalSeedSource,
                        self.use_local_seed_source_)

    integration_direction = tvtk_base.RevPrefixMap({'forward': 0, 'backward': 1, 'both': 2}, default_value='forward', desc=\
        r"""
        Specify whether the streamline is integrated in the upstream or
        downstream direction, or in both directions. (If integrated in
        both directions, two separate streamlines are generated, both of
        which which start at the seed point with one traveling in the
        forward direction, and one in the backward direction.)
        """
    )

    def _integration_direction_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIntegrationDirection,
                        self.integration_direction_)

    integrator_type = tvtk_base.RevPrefixMap({'runge_kutta2': 0, 'runge_kutta4': 1, 'runge_kutta45': 2}, default_value='runge_kutta2', desc=\
        r"""
        
        """
    )

    def _integrator_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIntegratorType,
                        self.integrator_type_)

    compute_vorticity = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        Turn on/off vorticity computation at streamline points (necessary
        for generating proper stream-ribbons using the RibbonFilter).
        """
    )

    def _compute_vorticity_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeVorticity,
                        self.compute_vorticity)

    initial_integration_step = traits.Float(0.5, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the Initial step size used for line integration,
        expressed in: LENGTH_UNIT      = 1 CELL_LENGTH_UNIT = 2 (either
        the starting size for an adaptive integrator, e.g., RK45, or the
        constant / fixed size for non-adaptive ones, i.e., RK2 and RK4)
        """
    )

    def _initial_integration_step_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInitialIntegrationStep,
                        self.initial_integration_step)

    integration_step_unit = traits.Int(2, enter_set=True, auto_set=False, desc=\
        r"""
        Specify a uniform integration step unit for
        minimum_integration_step, initial_integration_step, and
        maximum_integration_step. NOTE: The valid unit is now limited to
        only LENGTH_UNIT (1) and CELL_LENGTH_UNIT (2), EXCLUDING the
        previously-supported TIME_UNIT.
        """
    )

    def _integration_step_unit_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIntegrationStepUnit,
                        self.integration_step_unit)

    def _get_integrator(self):
        return wrap_vtk(self._vtk_obj.GetIntegrator())
    def _set_integrator(self, arg):
        old_val = self._get_integrator()
        self._wrap_call(self._vtk_obj.SetIntegrator,
                        deref_vtk(arg))
        self.trait_property_changed('integrator', old_val, arg)
    integrator = traits.Property(_get_integrator, _set_integrator, desc=\
        r"""
        
        """
    )

    maximum_error = traits.Float(1e-06, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the maximum error tolerated throughout streamline
        integration.
        """
    )

    def _maximum_error_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumError,
                        self.maximum_error)

    maximum_integration_step = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the Maximum step size used for line integration,
        expressed in: LENGTH_UNIT      = 1 CELL_LENGTH_UNIT = 2 (Only
        valid for an adaptive integrator, e.g., RK45)
        """
    )

    def _maximum_integration_step_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumIntegrationStep,
                        self.maximum_integration_step)

    maximum_number_of_steps = traits.Int(2000, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the maximum number of steps for integrating a streamline.
        Note that the number of steps generated is always one greater
        than maximum_number_of_steps. So if maximum_number_of_steps==0, then
        only one step will be generated. This is useful for advection
        situations when the stream tracer is to be propagated just one
        step at a time (e.g., see StreamSurface which depends on this
        behavior).
        """
    )

    def _maximum_number_of_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumNumberOfSteps,
                        self.maximum_number_of_steps)

    maximum_propagation = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the maximum length of a streamline expressed in
        LENGTH_UNIT.
        """
    )

    def _maximum_propagation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumPropagation,
                        self.maximum_propagation)

    minimum_integration_step = traits.Float(0.01, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the Minimum step size used for line integration,
        expressed in: LENGTH_UNIT      = 1 CELL_LENGTH_UNIT = 2 (Only
        valid for an adaptive integrator, e.g., RK45)
        """
    )

    def _minimum_integration_step_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMinimumIntegrationStep,
                        self.minimum_integration_step)

    rotation_scale = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        This can be used to scale the rate with which the streamribbons
        twist. The default is 1.
        """
    )

    def _rotation_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRotationScale,
                        self.rotation_scale)

    start_position = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Specify the starting point (seed) of a streamline in the global
        coordinate system. Search must be performed to find the initial
        cell from which to start integration.
        """
    )

    def _start_position_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStartPosition,
                        self.start_position)

    terminal_speed = traits.Float(1e-12, enter_set=True, auto_set=False, desc=\
        r"""
        Specify the terminal speed value, below which streamline
        integration is terminated.
        """
    )

    def _terminal_speed_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTerminalSpeed,
                        self.terminal_speed)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_source(self):
        return wrap_vtk(self._vtk_obj.GetSource())
    source = traits.Property(_get_source, desc=\
        r"""
        
        """
    )

    def calculate_vorticity(self, *args):
        """
        calculate_vorticity(self, cell:GenericCell, pcoords:[float,
            float, float], cellVectors:DoubleArray, vorticity:[float,
            float, float]) -> None
        C++: void calculate_vorticity(GenericCell *cell,
            double pcoords[3], DoubleArray *cellVectors,
            double vorticity[3])"""
        my_args = deref_array(args, [('vtkGenericCell', ['float', 'float', 'float'], 'vtkDoubleArray', ['float', 'float', 'float'])])
        ret = self._wrap_call(self._vtk_obj.CalculateVorticity, *my_args)
        return ret

    def convert_intervals(self, *args):
        """
        convert_intervals(self, step:float, minStep:float, maxStep:float,
            direction:int, cellLength:float) -> None
        C++: void convert_intervals(double &step, double &minStep,
            double &maxStep, int direction, double cellLength)
        The following methods should not be called by the user. They
        serve as integration bridges between this StreamTracer class
        and classes defined and implemented in anonymous namespace.
        
        Helper method to convert between length scales. Made public so
        internal threaded classes in anonymous namespace can invoke the
        method.
        """
        ret = self._wrap_call(self._vtk_obj.ConvertIntervals, *args)
        return ret

    def generate_normals(self, *args):
        """
        generate_normals(self, output:PolyData, firstNormal:[float,
            ...], vecName:str) -> None
        C++: void generate_normals(PolyData *output,
            double *firstNormal, const char *vecName)
        Helper methods to generate normals on streamlines. Made public so
        internal threaded classes in anonymous namespace can invoke the
        methods.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GenerateNormals, *my_args)
        return ret

    def set_interpolator_prototype(self, *args):
        """
        set_interpolator_prototype(self,
            ivf:AbstractInterpolatedVelocityField) -> None
        C++: void set_interpolator_prototype(
            AbstractInterpolatedVelocityField *ivf)
        The object used to interpolate the velocity field during
        integration is of the same class as this prototype. The
        performance of streamline generations can be significantly
        affected by the choice of the interpolator, particularly its use
        of the locator to use.
        
        For non AMR datasets, initialize a
        CompositeInterpolatedVelocityField and set the
        find_cell_strategy_type.
        """
        ret = self._wrap_call(self._vtk_obj.SetInterpolatorPrototype, *args)
        return ret

    def set_interpolator_type(self, *args):
        """
        set_interpolator_type(self, interpType:int) -> None
        C++: void set_interpolator_type(int interpType)
        Set the type of the velocity field interpolator to determine
        whether INTERPOLATOR_WITH_DATASET_POINT_LOCATOR or
        INTERPOLATOR_WITH_CELL_LOCATOR is employed for locating cells
        during streamline integration. The latter (adopting
        AbstractCellLocator sub-classes such as CellLocator and
        ModifiedBSPTree) is more robust than the former (through
        DataSet / PointSet::FindCell() coupled with
        PointLocator). However the former can be much faster and
        produce adequate results.
        """
        ret = self._wrap_call(self._vtk_obj.SetInterpolatorType, *args)
        return ret

    def set_interpolator_type_to_cell_locator(self):
        """
        set_interpolator_type_to_cell_locator(self) -> None
        C++: void set_interpolator_type_to_cell_locator()
        Set the velocity field interpolator type to one that uses a cell
        locator to perform spatial searching. Using a cell locator should
        always return the correct results, but it can be much slower that
        point locator-based searches.
        """
        ret = self._vtk_obj.SetInterpolatorTypeToCellLocator()
        return ret
        

    def set_interpolator_type_to_data_set_point_locator(self):
        """
        set_interpolator_type_to_data_set_point_locator(self) -> None
        C++: void set_interpolator_type_to_data_set_point_locator()
        Set the velocity field interpolator type to one that uses a point
        locator to perform local spatial searching. Typically a point
        locator is faster than searches with a cell locator, but it may
        not always find the correct cells enclosing a point. This is
        particularly true with meshes that are disjoint at seams, or abut
        meshes in an incompatible manner. By default (and if a
        interpolation_prototype is not set), a point locator is used.
        """
        ret = self._vtk_obj.SetInterpolatorTypeToDataSetPointLocator()
        return ret
        

    def set_source_connection(self, *args):
        """
        set_source_connection(self, algOutput:AlgorithmOutput) -> None
        C++: void set_source_connection(AlgorithmOutput *algOutput)
        Specify the source object used to generate starting points
        (seeds). This method connects to the pipeline: the Source will be
        updated and the results used as streamline seeds.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceConnection, *my_args)
        return ret

    def set_source_data(self, *args):
        """
        set_source_data(self, source:DataSet) -> None
        C++: void set_source_data(DataSet *source)
        Specify the source object used to generate starting points
        (seeds). Note that this method does not connect the pipeline. The
        algorithm will work on the input data as it is without updating
        the producer of the data. See set_source_connection for connecting
        the pipeline.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSourceData, *my_args)
        return ret

    _updateable_traits_ = \
    (('force_serial_execution', 'GetForceSerialExecution'),
    ('surface_streamlines', 'GetSurfaceStreamlines'),
    ('use_local_seed_source', 'GetUseLocalSeedSource'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('integration_direction',
    'GetIntegrationDirection'), ('integrator_type', 'GetIntegratorType'),
    ('compute_vorticity', 'GetComputeVorticity'),
    ('initial_integration_step', 'GetInitialIntegrationStep'),
    ('integration_step_unit', 'GetIntegrationStepUnit'), ('maximum_error',
    'GetMaximumError'), ('maximum_integration_step',
    'GetMaximumIntegrationStep'), ('maximum_number_of_steps',
    'GetMaximumNumberOfSteps'), ('maximum_propagation',
    'GetMaximumPropagation'), ('minimum_integration_step',
    'GetMinimumIntegrationStep'), ('rotation_scale', 'GetRotationScale'),
    ('start_position', 'GetStartPosition'), ('terminal_speed',
    'GetTerminalSpeed'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'force_serial_execution',
    'global_warning_display', 'release_data_flag', 'surface_streamlines',
    'use_local_seed_source', 'integration_direction', 'integrator_type',
    'compute_vorticity', 'initial_integration_step',
    'integration_step_unit', 'maximum_error', 'maximum_integration_step',
    'maximum_number_of_steps', 'maximum_propagation',
    'minimum_integration_step', 'object_name', 'progress_text',
    'rotation_scale', 'start_position', 'terminal_speed'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(StreamTracer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit StreamTracer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['force_serial_execution', 'surface_streamlines',
            'use_local_seed_source'], ['integration_direction',
            'integrator_type'], ['compute_vorticity', 'initial_integration_step',
            'integration_step_unit', 'maximum_error', 'maximum_integration_step',
            'maximum_number_of_steps', 'maximum_propagation',
            'minimum_integration_step', 'object_name', 'rotation_scale',
            'start_position', 'terminal_speed']),
            title='Edit StreamTracer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit StreamTracer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

