# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class MeshQuality(DataSetAlgorithm):
    r"""
    MeshQuality - Calculate functions of quality of the elements of a
    mesh
    
    Superclass: DataSetAlgorithm
    
    MeshQuality computes one or more functions of (geometric) quality
    for each 2-D and 3-D cell (triangle, quadrilateral, tetrahedron,
    pyramid, wedge, or hexahedron) of a mesh. These functions of quality
    are then averaged over the entire mesh. The minimum, average,
    maximum, and unbiased variance of quality for each type of cell is
    stored in the output mesh's field_data. The field_data arrays are named
    "Mesh Triangle Quality," "Mesh Quadrilateral Quality," "Mesh Tetrahedron
    Quality," "Mesh Pyramid Quality," "Mesh Wedge Quality," and "Mesh Hexahedron
    Quality." Each array has a single tuple with 5 components. The first
    4 components are the quality statistics mentioned above; the final
    value is the number of cells of the given type. This final component
    makes aggregation of statistics for distributed mesh data possible.
    
    By default, the per-cell quality is added to the mesh's cell data, in
    an array named "Quality." Cell types not supported by this filter
    will have an entry of 0. Use save_cell_quality_off() to store only the
    final statistics.
    
    This version of the filter written by Philippe Pebay and David
    Thompson overtakes an older version written by Leila Baghdadi, Hanif
    Ladak, and David Steinman at the Imaging Research Labs, Robarts
    Research Institute. That version only supported tetrahedral radius
    ratio. See the compatibility_mode_on() member for information on how to
    make this filter behave like the previous implementation. For more
    information on the triangle quality functions of this class, cf.
    Pebay & Baker 2003, Analysis of triangle quality measures, Math Comp
    72:244. For more information on the quadrangle quality functions of
    this class, cf. Pebay 2004, Planar Quadrangle Quality Measures, Eng
    Comp 20:2.
    
    @warning
    While more general than before, this class does not address many cell
    types, including triangle strips and fans in 2D (among others). Most
    quadrilateral quality functions are intended for planar
    quadrilaterals only. The minimal angle is not, strictly speaking, a
    quality function, but it is provided because of its usage by many
    authors.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMeshQuality, obj, update, **traits)
    
    compatibility_mode = tvtk_base.false_bool_trait(desc=\
        r"""
        compatibility_mode governs whether, when both a quality function
        and cell volume are to be stored as cell data, the two values are
        stored in a single array. When compatibility mode is off (the
        default), two separate arrays are used -- one labeled "Quality"
        and the other labeled "Volume". When compatibility mode is on,
        both values are stored in a single array, with volume as the
        first component and quality as the second component.
        
        * Enabling compatibility_mode changes the default tetrahedral
        * quality function to RADIUS_RATIO and turns volume
        * computation on. (This matches the default behavior of the
        * initial implementation of MeshQuality.) You may change
        * quality function and volume computation without leaving
        * compatibility mode.
        
        * Disabling compatibility mode does not affect the current
        * volume computation or tetrahedral quality function settings.
        
        * The final caveat to compatibility_mode is that regardless of
        * its setting, the resulting array will be of type DoubleArray
        * rather than the original FloatArray.
        * This is a safety function to keep the authors from
        * diving off of the Combinatorial Coding Cliff into
        * Certain Insanity.
        """
    )

    def _compatibility_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCompatibilityMode,
                        self.compatibility_mode_)

    linear_approximation = tvtk_base.false_bool_trait(desc=\
        r"""
        If set to true, then this filter will output 2 quality arrays
        instead of one. The second array is names "Quality (Linear
        Approx)" and features measure for all non-linear cells in
        addition to the linear ones, but treated like if they were
        linear.
        
        ote In the array "Quality", any non-linear cell quality is set to
        NaN.
        """
    )

    def _linear_approximation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLinearApproximation,
                        self.linear_approximation_)

    ratio = tvtk_base.true_bool_trait(desc=\
        r"""
        These methods are deprecated. Use Get/set_save_cell_quality()
        instead.
        
        Formerly, set_ratio could be used to disable computation of the
        tetrahedral radius ratio so that volume alone could be computed.
        Now, cell quality is always computed, but you may decide not to
        store the result for each cell. This allows average cell quality
        of a mesh to be calculated without requiring per-cell storage.
        """
    )

    def _ratio_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRatio,
                        self.ratio_)

    save_cell_quality = tvtk_base.true_bool_trait(desc=\
        r"""
        This variable controls whether or not cell quality is stored as
        cell data in the resulting mesh or discarded (leaving only the
        aggregate quality average of the entire mesh, recorded in the
        field_data).
        """
    )

    def _save_cell_quality_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSaveCellQuality,
                        self.save_cell_quality_)

    volume = tvtk_base.false_bool_trait(desc=\
        r"""
        These methods are deprecated. The functionality of computing cell
        volume is being removed until it can be computed for any 3D cell.
        (The previous implementation only worked for tetrahedra.)
        
        * For now, turning on the volume computation will put this
        * filter into "compatibility mode," where tetrahedral cell
        * volume is stored in first component of each output tuple and
        * the radius ratio is stored in the second component. You may
        * also use compatibility_mode_on()/Off() to enter this mode.
        * In this mode, cells other than tetrahedra will have report
        * a volume of 0.0 (if volume computation is enabled).
        
        * By default, volume computation is disabled and compatibility
        * mode is off, since it does not make a lot of sense for
        * meshes with non-tetrahedral cells.
        """
    )

    def _volume_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVolume,
                        self.volume_)

    hex_quality_measure = tvtk_base.RevPrefixMap({'max_aspect_frobenius': 5, 'condition': 9, 'diagonal': 21, 'dimension': 22, 'distortion': 15, 'edge_ratio': 0, 'equiangle_skew': 29, 'jacobian': 25, 'max_edge_ratio': 16, 'med_aspect_frobenius': 4, 'nodal_jacobian_ratio': 34, 'oddy': 23, 'relative_size_squared': 12, 'scaled_jacobian': 10, 'shape': 13, 'shape_and_size': 14, 'shear': 11, 'shear_and_size': 24, 'skew': 17, 'stretch': 20, 'taper': 18, 'volume': 19}, default_value='max_aspect_frobenius', desc=\
        r"""
        Set/Get the particular estimator used to measure the quality of
        hexahedra. The default is MAX_ASPECT_FROBENIUS and valid values
        also include EDGE_RATIO, MAX_ASPECT_FROBENIUS, MAX_EDGE_RATIO,
        SKEW, TAPER, VOLUME, STRETCH, DIAGONAL, DIMENSION, ODDY,
        CONDITION, JACOBIAN, SCALED_JACOBIAN, SHEAR, SHAPE,
        RELATIVE_SIZE_SQUARED, SHAPE_AND_SIZE, SHEAR_AND_SIZE,
        DISTORTION, EQUIANGLE_SKEW, and NODAL_JACOBIAN_RATIO.
        """
    )

    def _hex_quality_measure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHexQualityMeasure,
                        self.hex_quality_measure_)

    pyramid_quality_measure = tvtk_base.RevPrefixMap({'shape': 13, 'equiangle_skew': 29, 'jacobian': 25, 'scaled_jacobian': 10, 'volume': 19}, default_value='shape', desc=\
        r"""
        Set/Get the particular estimator used to measure the quality of
        pyramids. The default is SHAPE and valid values also include
        EQUIANGLE_SKEW, JACOBIAN, SCALED_JACOBIAN, and VOLUME.
        """
    )

    def _pyramid_quality_measure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPyramidQualityMeasure,
                        self.pyramid_quality_measure_)

    quad_quality_measure = tvtk_base.RevPrefixMap({'edge_ratio': 0, 'area': 28, 'aspect_ratio': 1, 'condition': 9, 'distortion': 15, 'equiangle_skew': 29, 'jacobian': 25, 'max_angle': 8, 'max_aspect_frobenius': 5, 'max_edge_ratio': 16, 'med_aspect_frobenius': 4, 'min_angle': 6, 'oddy': 23, 'radius_ratio': 2, 'relative_size_squared': 12, 'scaled_jacobian': 10, 'shape': 13, 'shape_and_size': 14, 'shear': 11, 'shear_and_size': 24, 'skew': 17, 'stretch': 20, 'taper': 18, 'warpage': 26}, default_value='edge_ratio', desc=\
        r"""
        Set/Get the particular estimator used to measure the quality of
        quadrilaterals. The default is EDGE_RATIO and valid values also
        include RADIUS_RATIO, ASPECT_RATIO, MAX_EDGE_RATIO SKEW, TAPER,
        WARPAGE, AREA, STRETCH, MIN_ANGLE, MAX_ANGLE, ODDY, CONDITION,
        JACOBIAN, SCALED_JACOBIAN, SHEAR, SHAPE, RELATIVE_SIZE_SQUARED,
        SHAPE_AND_SIZE, SHEAR_AND_SIZE, DISTORTION, and EQUIANGLE_SKEW.
        
        Scope: Except for EDGE_RATIO, these estimators are intended for
        planar quadrilaterals only; use at your own risk if you really
        want to assess non-planar quadrilateral quality with those.
        """
    )

    def _quad_quality_measure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetQuadQualityMeasure,
                        self.quad_quality_measure_)

    tet_quality_measure = tvtk_base.RevPrefixMap({'aspect_ratio': 1, 'aspect_frobenius': 3, 'aspect_gamma': 27, 'collapse_ratio': 7, 'condition': 9, 'distortion': 15, 'edge_ratio': 0, 'equiangle_skew': 29, 'equivolume_skew': 30, 'jacobian': 25, 'mean_ratio': 33, 'min_angle': 6, 'normalized_inradius': 35, 'radius_ratio': 2, 'relative_size_squared': 12, 'scaled_jacobian': 10, 'shape': 13, 'shape_and_size': 14, 'squish_index': 36, 'volume': 19}, default_value='aspect_ratio', desc=\
        r"""
        Set/Get the particular estimator used to measure the quality of
        tetrahedra. The default is RADIUS_RATIO and valid values also
        include ASPECT_RATIO, ASPECT_FROBENIUS, EDGE_RATIO,
        COLLAPSE_RATIO, ASPECT_GAMMA, VOLUME, CONDITION, JACOBIAN,
        SCALED_JACOBIAN, SHAPE, RELATIVE_SIZE_SQUARED, SHAPE_AND_SIZE,
        DISTORTION, EQUIANGLE_SKEW, EQUIVOLUME_SKEW, MEAN_RATIO,
        NORMALIZED_INRADIUS, and SQUISH_INDEX.
        """
    )

    def _tet_quality_measure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTetQualityMeasure,
                        self.tet_quality_measure_)

    triangle_quality_measure = tvtk_base.RevPrefixMap({'aspect_ratio': 1, 'area': 28, 'aspect_frobenius': 3, 'condition': 9, 'distortion': 15, 'edge_ratio': 0, 'equiangle_skew': 29, 'max_angle': 8, 'min_angle': 6, 'normalized_inradius': 35, 'radius_ratio': 2, 'relative_size_squared': 12, 'scaled_jacobian': 10, 'shape': 13, 'shape_and_size': 14}, default_value='aspect_ratio', desc=\
        r"""
        Set/Get the particular estimator used to function the quality of
        triangles. The default is RADIUS_RATIO and valid values also
        include ASPECT_RATIO, ASPECT_FROBENIUS, and EDGE_RATIO,
        MIN_ANGLE, MAX_ANGLE, CONDITION, SCALED_JACOBIAN,
        RELATIVE_SIZE_SQUARED, SHAPE, SHAPE_AND_SIZE, DISTORTION,
        EQUIANGLE_SKEW, and NORMALIZED_INRADIUS.
        """
    )

    def _triangle_quality_measure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTriangleQualityMeasure,
                        self.triangle_quality_measure_)

    wedge_quality_measure = tvtk_base.RevPrefixMap({'edge_ratio': 0, 'condition': 9, 'distortion': 15, 'equiangle_skew': 29, 'jacobian': 25, 'max_aspect_frobenius': 5, 'max_stretch': 31, 'mean_aspect_frobenius': 32, 'scaled_jacobian': 10, 'shape': 13, 'volume': 19}, default_value='edge_ratio', desc=\
        r"""
        Set/Get the particular estimator used to measure the quality of
        wedges. The default is EDGE_RATIO and valid values also include
        CONDITION, DISTORTION, EQUIANGLE_SKEW, JACOBIAN,
        MAX_ASPECT_FROBENIUS, MAX_STRETCH, MEAN_ASPECT_FROBENIUS,
        SCALED_JACOBIAN, SHAPE, and VOLUME.
        """
    )

    def _wedge_quality_measure_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWedgeQualityMeasure,
                        self.wedge_quality_measure_)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def hex_condition(self, *args):
        """
        hex_condition(cell:Cell) -> float
        C++: static double hex_condition(Cell *cell)
        Calculate the condition of a hexahedron. The condition of a
        hexahedron is equivalent to hex_max_aspect_frobenius.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexCondition, *my_args)
        return ret

    def hex_diagonal(self, *args):
        """
        hex_diagonal(cell:Cell) -> float
        C++: static double hex_diagonal(Cell *cell)
        Calculate the diagonal of a hexahedron. The diagonal of a
        hexahedron Minimum diagonal length / maximum diagonal length.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexDiagonal, *my_args)
        return ret

    def hex_dimension(self, *args):
        """
        hex_dimension(cell:Cell) -> float
        C++: static double hex_dimension(Cell *cell)
        Calculate the dimension of a hexahedron. The dimension of a
        hexahedron is the Pronto-specific characteristic length for
        stable time step calculation, where characteristic length =
        Volume / 2 grad Volume.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexDimension, *my_args)
        return ret

    def hex_distortion(self, *args):
        """
        hex_distortion(cell:Cell) -> float
        C++: static double hex_distortion(Cell *cell)
        Calculate the distortion of a hexahedron. The distortion of a
        hexahedron is {min(|J|)/actual volume} * parent volume, parent
        volume = 8 for a hexahedron.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexDistortion, *my_args)
        return ret

    def hex_edge_ratio(self, *args):
        """
        hex_edge_ratio(cell:Cell) -> float
        C++: static double hex_edge_ratio(Cell *cell)
        Calculate the edge ratio of a hexahedron. The edge ratio of a
        hexahedron $H $ is:$\\frac{|H|_\\infty}{|H|_0} $, where $|H|_\\infty $
        and $|H|_0 $ respectively denote the greatest and the smallest
        edge lengths of $H $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexEdgeRatio, *my_args)
        return ret

    def hex_equiangle_skew(self, *args):
        """
        hex_equiangle_skew(cell:Cell) -> float
        C++: static double hex_equiangle_skew(Cell *cell)
        Calculate the equiangle skew of a hexahedron.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexEquiangleSkew, *my_args)
        return ret

    def hex_jacobian(self, *args):
        """
        hex_jacobian(cell:Cell) -> float
        C++: static double hex_jacobian(Cell *cell)
        Calculate the Jacobian of a hexahedron. The jacobian of a
        hexahedron is the minimum point-wise of local map at 8 corners &
        center of the hexahedron.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexJacobian, *my_args)
        return ret

    def hex_max_aspect_frobenius(self, *args):
        """
        hex_max_aspect_frobenius(cell:Cell) -> float
        C++: static double hex_max_aspect_frobenius(Cell *cell)
        Calculate the maximal Frobenius aspect of the 8 corner tetrahedra
        of a hexahedron, when the reference tetrahedral elements are
        right isosceles at the hexahedron vertices.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexMaxAspectFrobenius, *my_args)
        return ret

    def hex_max_edge_ratio(self, *args):
        """
        hex_max_edge_ratio(cell:Cell) -> float
        C++: static double hex_max_edge_ratio(Cell *cell)
        Calculate the maximum edge ratio of a hexahedron at its center.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexMaxEdgeRatio, *my_args)
        return ret

    def hex_med_aspect_frobenius(self, *args):
        """
        hex_med_aspect_frobenius(cell:Cell) -> float
        C++: static double hex_med_aspect_frobenius(Cell *cell)
        Calculate the average Frobenius aspect of the 8 corner tetrahedra
        of a hexahedron, when the reference tetrahedral elements are
        right isosceles at the hexahedron vertices.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexMedAspectFrobenius, *my_args)
        return ret

    def hex_nodal_jacobian_ratio(self, *args):
        """
        hex_nodal_jacobian_ratio(cell:Cell) -> float
        C++: static double hex_nodal_jacobian_ratio(Cell *cell)
        Calculate the nodal Jacobian ratio of a hexahedron. The nodal
        Jacobian ratio of a hexahedron is min(Jacobian) / max(Jacobian)
        over all nodes.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexNodalJacobianRatio, *my_args)
        return ret

    def hex_oddy(self, *args):
        """
        hex_oddy(cell:Cell) -> float
        C++: static double hex_oddy(Cell *cell)
        Calculate the oddy of a hexahedron. The oddy of a hexahedron is
        the general distortion measure based on left Cauchy-Green Tensor.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexOddy, *my_args)
        return ret

    def hex_relative_size_squared(self, *args):
        """
        hex_relative_size_squared(cell:Cell) -> float
        C++: static double hex_relative_size_squared(Cell *cell)
        Calculate the relative size squared of a hexahedron. The relative
        size squared of a hexahedron is Min(J, 1 / J), where J is
        determinant of weighted Jacobian matrix.
        
        Note: hex_relative_size_squared will return 0.0 if the mesh_quality
        filter has NOT been executed, because it relies on the average
        hex size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexRelativeSizeSquared, *my_args)
        return ret

    def hex_scaled_jacobian(self, *args):
        """
        hex_scaled_jacobian(cell:Cell) -> float
        C++: static double hex_scaled_jacobian(Cell *cell)
        Calculate the scaled Jacobian of a hexahedron. The scaled
        jacobian of a hexahedron is the minimum Jacobian divided by the
        lengths of 3 edge vectors.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexScaledJacobian, *my_args)
        return ret

    def hex_shape(self, *args):
        """
        hex_shape(cell:Cell) -> float
        C++: static double hex_shape(Cell *cell)
        Calculate the shape of a hexahedron. The shape of a hexahedron is
        3 / Mean Ratio of weighted Jacobian matrix.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexShape, *my_args)
        return ret

    def hex_shape_and_size(self, *args):
        """
        hex_shape_and_size(cell:Cell) -> float
        C++: static double hex_shape_and_size(Cell *cell)
        Calculate the shape and size of a hexahedron. The shape and size
        of a hexahedron is product of shape and average size.
        
        Note: hex_shape_and_size will return 0.0 if the mesh_quality filter
        has NOT been executed, because it relies on the average hex size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexShapeAndSize, *my_args)
        return ret

    def hex_shear(self, *args):
        """
        hex_shear(cell:Cell) -> float
        C++: static double hex_shear(Cell *cell)
        Calculate the shear of a hexahedron. The shear of a hexahedron is
        3 / Mean Ratio of Jacobian Skew matrix.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexShear, *my_args)
        return ret

    def hex_shear_and_size(self, *args):
        """
        hex_shear_and_size(cell:Cell) -> float
        C++: static double hex_shear_and_size(Cell *cell)
        Calculate the shear and size of a hexahedron. The shear and size
        of a hexahedron is product of shear and average size.
        
        Note: hex_shear_and_size will return 0.0 if the mesh_quality filter
        has NOT been executed, because it relies on the average hex size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexShearAndSize, *my_args)
        return ret

    def hex_skew(self, *args):
        """
        hex_skew(cell:Cell) -> float
        C++: static double hex_skew(Cell *cell)
        Calculate the skew of a hexahedron. The skew of a hexahedron is
        the maximum |cos A|, where A is the angle between edges at the
        hexahedron center.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexSkew, *my_args)
        return ret

    def hex_stretch(self, *args):
        """
        hex_stretch(cell:Cell) -> float
        C++: static double hex_stretch(Cell *cell)
        Calculate the stretch of a hexahedron. The stretch of a
        hexahedron is Sqrt(3) * minimum edge length / maximum diagonal
        length.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexStretch, *my_args)
        return ret

    def hex_taper(self, *args):
        """
        hex_taper(cell:Cell) -> float
        C++: static double hex_taper(Cell *cell)
        Calculate the taper of a hexahedron. The taper of a hexahedron is
        the ratio of lengths derived from opposite edges.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexTaper, *my_args)
        return ret

    def hex_volume(self, *args):
        """
        hex_volume(cell:Cell) -> float
        C++: static double hex_volume(Cell *cell)
        Calculate the volume of a hexahedron. The volume of a hexahedron
        is the Jacobian at the hexahedron center.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.HexVolume, *my_args)
        return ret

    def pyramid_equiangle_skew(self, *args):
        """
        pyramid_equiangle_skew(cell:Cell) -> float
        C++: static double pyramid_equiangle_skew(Cell *cell)
        Calculate the equiangle skew of a pyramid.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PyramidEquiangleSkew, *my_args)
        return ret

    def pyramid_jacobian(self, *args):
        """
        pyramid_jacobian(cell:Cell) -> float
        C++: static double pyramid_jacobian(Cell *cell)
        Calculate the Jacobian of a pyramid. The jacobian of a
        tetrahedron is the minimum point-wise volume at any corner.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PyramidJacobian, *my_args)
        return ret

    def pyramid_scaled_jacobian(self, *args):
        """
        pyramid_scaled_jacobian(cell:Cell) -> float
        C++: static double pyramid_scaled_jacobian(Cell *cell)
        Calculate the Jacobian of a pyramid. The jacobian of a
        tetrahedron is the minimum point-wise volume at any corner.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PyramidScaledJacobian, *my_args)
        return ret

    def pyramid_shape(self, *args):
        """
        pyramid_shape(cell:Cell) -> float
        C++: static double pyramid_shape(Cell *cell)
        Calculate the shape of a pyramid. The shape of a pyramid is 4
        divided by the minimum mean ratio of the Jacobian matrix at each
        element corner.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PyramidShape, *my_args)
        return ret

    def pyramid_volume(self, *args):
        """
        pyramid_volume(cell:Cell) -> float
        C++: static double pyramid_volume(Cell *cell)
        Calculate the volume of a pyramid.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PyramidVolume, *my_args)
        return ret

    def quad_area(self, *args):
        """
        quad_area(cell:Cell) -> float
        C++: static double quad_area(Cell *cell)
        Calculate the area of a quadrilateral. The area of a
        quadrilateral is the Jacobian at quad center.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadArea, *my_args)
        return ret

    def quad_aspect_ratio(self, *args):
        """
        quad_aspect_ratio(cell:Cell) -> float
        C++: static double quad_aspect_ratio(Cell *cell)
        Calculate the aspect ratio of a planar quadrilateral. The aspect
        ratio of a planar quadrilateral $q $
        is:$\\frac{|q|_1|q|_\\infty}{4{\\cal A}} $, where $|q|_1 $,
        $|q|_\\infty $ and ${\\cal A} $ respectively denote the perimeter,
        the greatest edge length and the area of $q $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadAspectRatio, *my_args)
        return ret

    def quad_condition(self, *args):
        """
        quad_condition(cell:Cell) -> float
        C++: static double quad_condition(Cell *cell)
        Calculate the condition number of a quadrilateral. The condition
        number of a quadrilateral is the (maximum) condition number of
        the Jacobian matrix at the 4 corners.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadCondition, *my_args)
        return ret

    def quad_distortion(self, *args):
        """
        quad_distortion(cell:Cell) -> float
        C++: static double quad_distortion(Cell *cell)
        Calculate the distortion of a quadrilateral. The distortion of a
        quadrilateral is {min(|J|)/actual area} * parent area, parent
        area = 4 for quad.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadDistortion, *my_args)
        return ret

    def quad_edge_ratio(self, *args):
        """
        quad_edge_ratio(cell:Cell) -> float
        C++: static double quad_edge_ratio(Cell *cell)
        Calculate the edge ratio of a quadrilateral. The edge ratio of a
        quadrilateral $q $ is:$\\frac{|q|_\\infty}{|q|_0} $, where
        $|q|_\\infty $ and $|q|_0 $ respectively denote the greatest and
        the smallest edge lengths of $q $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadEdgeRatio, *my_args)
        return ret

    def quad_equiangle_skew(self, *args):
        """
        quad_equiangle_skew(cell:Cell) -> float
        C++: static double quad_equiangle_skew(Cell *cell)
        Calculate the equiangle skew of a quadrilateral.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadEquiangleSkew, *my_args)
        return ret

    def quad_jacobian(self, *args):
        """
        quad_jacobian(cell:Cell) -> float
        C++: static double quad_jacobian(Cell *cell)
        Calculate the Jacobian of a quadrilateral. The Jacobian of a
        quadrilateral is the minimum point-wise volume of local map at 4
        corners & center of quad.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadJacobian, *my_args)
        return ret

    def quad_max_angle(self, *args):
        """
        quad_max_angle(cell:Cell) -> float
        C++: static double quad_max_angle(Cell *cell)
        Calculate the maximum (nonoriented) angle of a quadrilateral,
        expressed in degrees.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadMaxAngle, *my_args)
        return ret

    def quad_max_aspect_frobenius(self, *args):
        """
        quad_max_aspect_frobenius(cell:Cell) -> float
        C++: static double quad_max_aspect_frobenius(Cell *cell)
        Calculate the maximal Frobenius aspect of the 4 corner triangles
        of a planar quadrilateral, when the reference triangle elements
        are right isosceles at the quadrangle vertices. The Frobenius
        aspect of a triangle $t $, when the reference element is right
        isosceles at vertex $V $, is:$\\frac{f^2+g^2}{4{\\cal A}} $, where
        $f^2+g^2 $ and $\\cal A $ respectively denote the sum of the
        squared lengths of the edges attached to $V $ and the area of $t
        $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadMaxAspectFrobenius, *my_args)
        return ret

    def quad_max_edge_ratio(self, *args):
        """
        quad_max_edge_ratio(cell:Cell) -> float
        C++: static double quad_max_edge_ratio(Cell *cell)
        Calculate the maximum edge length ratio of a quadrilateral at
        quad center.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadMaxEdgeRatio, *my_args)
        return ret

    def quad_med_aspect_frobenius(self, *args):
        """
        quad_med_aspect_frobenius(cell:Cell) -> float
        C++: static double quad_med_aspect_frobenius(Cell *cell)
        Calculate the average Frobenius aspect of the 4 corner triangles
        of a planar quadrilateral, when the reference triangle elements
        are right isosceles at the quadrangle vertices. The Frobenius
        aspect of a triangle $t $, when the reference element is right
        isosceles at vertex $V $, is:$\\frac{f^2+g^2}{4{\\cal A}} $, where
        $f^2+g^2 $ and $\\cal A $ respectively denote the sum of the
        squared lengths of the edges attached to $V $ and the area of $t
        $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadMedAspectFrobenius, *my_args)
        return ret

    def quad_min_angle(self, *args):
        """
        quad_min_angle(cell:Cell) -> float
        C++: static double quad_min_angle(Cell *cell)
        Calculate the minimal (nonoriented) angle of a quadrilateral,
        expressed in degrees.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadMinAngle, *my_args)
        return ret

    def quad_oddy(self, *args):
        """
        quad_oddy(cell:Cell) -> float
        C++: static double quad_oddy(Cell *cell)
        Calculate the oddy of a quadrilateral. The oddy of a
        quadrilateral is the general distortion measure based on left
        Cauchy-Green Tensor.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadOddy, *my_args)
        return ret

    def quad_radius_ratio(self, *args):
        """
        quad_radius_ratio(cell:Cell) -> float
        C++: static double quad_radius_ratio(Cell *cell)
        Calculate the radius ratio of a planar quadrilateral. The name is
        only used by analogy with the triangle radius ratio, because in
        general a quadrilateral does not have a circumcircle nor an
        incircle. The radius ratio of a planar quadrilateral $q $
        is:$\\frac{|q|_2h_{\\max}}{\\min_i{\\cal A}_i} $, where $|q|_2 $,
        $h_{\\max} $ and $\\min{\\cal A}_i $ respectively denote the sum of
        the squared edge lengths, the greatest amongst diagonal and edge
        lengths and the smallest area of the 4 triangles extractable from
        $q $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadRadiusRatio, *my_args)
        return ret

    def quad_relative_size_squared(self, *args):
        """
        quad_relative_size_squared(cell:Cell) -> float
        C++: static double quad_relative_size_squared(Cell *cell)
        Calculate the relative size squared of a quadrilateral. The
        relative size squared of a quadrilateral is the Min(J, 1 / J),
        where J is the determinant of weighted Jacobian matrix.
        
        Note: quad_relative_size_squared will return 0.0 if the mesh_quality
        filter has NOT been executed, because it relies on the average
        quad size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadRelativeSizeSquared, *my_args)
        return ret

    def quad_scaled_jacobian(self, *args):
        """
        quad_scaled_jacobian(cell:Cell) -> float
        C++: static double quad_scaled_jacobian(Cell *cell)
        Calculate the scaled Jacobian of a quadrilateral. The scaled
        Jacobian of a quadrilateral is the minimum Jacobian divided by
        the lengths of the 2 edge vectors.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadScaledJacobian, *my_args)
        return ret

    def quad_shape(self, *args):
        """
        quad_shape(cell:Cell) -> float
        C++: static double quad_shape(Cell *cell)
        Calculate the shear of a quadrilateral. The shear of a
        quadrilateral is 2 / Condition number of weighted Jacobian
        matrix.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadShape, *my_args)
        return ret

    def quad_shape_and_size(self, *args):
        """
        quad_shape_and_size(cell:Cell) -> float
        C++: static double quad_shape_and_size(Cell *cell)
        Calculate the shape and size of a quadrilateral. The shape and
        size of a quadrilateral is product of shape and average size.
        
        Note: quad_shape_and_size will return 0.0 if the mesh_quality filter
        has NOT been executed, because it relies on the average triangle
        size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadShapeAndSize, *my_args)
        return ret

    def quad_shear(self, *args):
        """
        quad_shear(cell:Cell) -> float
        C++: static double quad_shear(Cell *cell)
        Calculate the shear of a quadrilateral. The shear of a
        quadrilateral is 2 / Condition number of Jacobian Skew matrix.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadShear, *my_args)
        return ret

    def quad_shear_and_size(self, *args):
        """
        quad_shear_and_size(cell:Cell) -> float
        C++: static double quad_shear_and_size(Cell *cell)
        Calculate the shear and size of a quadrilateral. The shear and
        size of a quadrilateral is product of shear and average size.
        
        Note: quad_shear_and_size will return 0.0 if the mesh_quality filter
        has NOT been executed, because it relies on the average triangle
        size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadShearAndSize, *my_args)
        return ret

    def quad_skew(self, *args):
        """
        quad_skew(cell:Cell) -> float
        C++: static double quad_skew(Cell *cell)
        Calculate the skew of a quadrilateral. The skew of a
        quadrilateral is the maximum |cos A|, where A is the angle
        between edges at the quad center.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadSkew, *my_args)
        return ret

    def quad_stretch(self, *args):
        """
        quad_stretch(cell:Cell) -> float
        C++: static double quad_stretch(Cell *cell)
        Calculate the stretch of a quadrilateral. The stretch of a
        quadrilateral is Sqrt(2) * minimum edge length / maximum diagonal
        length.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadStretch, *my_args)
        return ret

    def quad_taper(self, *args):
        """
        quad_taper(cell:Cell) -> float
        C++: static double quad_taper(Cell *cell)
        Calculate the taper of a quadrilateral. The taper of a
        quadrilateral is the ratio of lengths derived from opposite
        edges.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadTaper, *my_args)
        return ret

    def quad_warpage(self, *args):
        """
        quad_warpage(cell:Cell) -> float
        C++: static double quad_warpage(Cell *cell)
        Calculate the warpage of a quadrilateral. The warpage of a
        quadrilateral is the cosine of Minimum Dihedral Angle formed by
        Planes Intersecting in Diagonals.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.QuadWarpage, *my_args)
        return ret

    def tet_aspect_frobenius(self, *args):
        """
        tet_aspect_frobenius(cell:Cell) -> float
        C++: static double tet_aspect_frobenius(Cell *cell)
        Calculate the Frobenius condition number of the transformation
        matrix from a regular tetrahedron to a tetrahedron. The Frobenius
        aspect of a tetrahedron $K $, when the reference element is
        regular, is:$\\frac{\\frac{3}{2}(l_{11}+l_{22}+l_{33}) -
        (l_{12}+l_{13}+l_{23})} {3(\\sqrt{2}\\det{T})^\\frac{2}{3}} $, where
        $T $ and $l_{ij} $ respectively denote the edge matrix of $K $
        and the entries of $L=T^t\\,T $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetAspectFrobenius, *my_args)
        return ret

    def tet_aspect_gamma(self, *args):
        """
        tet_aspect_gamma(cell:Cell) -> float
        C++: static double tet_aspect_gamma(Cell *cell)
        Calculate the aspect gamma of a tetrahedron. The aspect gamma of
        a tetrahedron is: Srms**3 / (8.479670*V) where Srms =
        sqrt(Sum(Si**2)/6), Si = edge length.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetAspectGamma, *my_args)
        return ret

    def tet_aspect_ratio(self, *args):
        """
        tet_aspect_ratio(cell:Cell) -> float
        C++: static double tet_aspect_ratio(Cell *cell)
        Calculate the aspect ratio of a tetrahedron. The aspect ratio of
        a tetrahedron $K $ is:$\\frac{|K|_\\infty}{2\\sqrt{6}r} $, where
        $|K|_\\infty $ and $r $ respectively denote the greatest edge
        length and the inradius of $K $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetAspectRatio, *my_args)
        return ret

    def tet_collapse_ratio(self, *args):
        """
        tet_collapse_ratio(cell:Cell) -> float
        C++: static double tet_collapse_ratio(Cell *cell)
        Calculate the collapse ratio of a tetrahedron. The collapse ratio
        is a dimensionless number defined as the smallest ratio of the
        height of a vertex above its opposing triangle to the longest
        edge of that opposing triangle across all vertices of the
        tetrahedron.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetCollapseRatio, *my_args)
        return ret

    def tet_condition(self, *args):
        """
        tet_condition(cell:Cell) -> float
        C++: static double tet_condition(Cell *cell)
        Calculate the condition number of a tetrahedron. The condition
        number of a tetrahedron is Condition number of the Jacobian
        matrix at any corner.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetCondition, *my_args)
        return ret

    def tet_distortion(self, *args):
        """
        tet_distortion(cell:Cell) -> float
        C++: static double tet_distortion(Cell *cell)
        Calculate the distortion of a tetrahedron. The distortion of a
        quadrilateral is {min(|J|)/actual volume} * parent volume, parent
        volume = 1 / 6 for a tetrahedron.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetDistortion, *my_args)
        return ret

    def tet_edge_ratio(self, *args):
        """
        tet_edge_ratio(cell:Cell) -> float
        C++: static double tet_edge_ratio(Cell *cell)
        Calculate the edge ratio of a tetrahedron. The edge ratio of a
        tetrahedron $K $ is:$\\frac{|K|_\\infty}{|K|_0} $, where
        $|K|_\\infty $ and $|K|_0 $ respectively denote the greatest and
        the smallest edge lengths of $K $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetEdgeRatio, *my_args)
        return ret

    def tet_equiangle_skew(self, *args):
        """
        tet_equiangle_skew(cell:Cell) -> float
        C++: static double tet_equiangle_skew(Cell *cell)
        Calculate the equiangle skew of a tetrahedron.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetEquiangleSkew, *my_args)
        return ret

    def tet_equivolume_skew(self, *args):
        """
        tet_equivolume_skew(cell:Cell) -> float
        C++: static double tet_equivolume_skew(Cell *cell)
        Calculate the equivolume skew of a tetrahedron.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetEquivolumeSkew, *my_args)
        return ret

    def tet_jacobian(self, *args):
        """
        tet_jacobian(cell:Cell) -> float
        C++: static double tet_jacobian(Cell *cell)
        Calculate the Jacobian of a tetrahedron. The jacobian of a
        tetrahedron is the minimum point-wise volume at any corner.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetJacobian, *my_args)
        return ret

    def tet_mean_ratio(self, *args):
        """
        tet_mean_ratio(cell:Cell) -> float
        C++: static double tet_mean_ratio(Cell *cell)
        Calculate the mean ratio of a tetrahedron. The mean ratio of a
        tetrahedron is the ratio of tetrahedron volume over the volume of
        an equilateral tetrahedron with the same RMS edge length.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetMeanRatio, *my_args)
        return ret

    def tet_min_angle(self, *args):
        """
        tet_min_angle(cell:Cell) -> float
        C++: static double tet_min_angle(Cell *cell)
        Calculate the minimal (nonoriented) dihedral angle of a
        tetrahedron, expressed in degrees.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetMinAngle, *my_args)
        return ret

    def tet_normalized_inradius(self, *args):
        """
        tet_normalized_inradius(cell:Cell) -> float
        C++: static double tet_normalized_inradius(Cell *cell)
        Calculate the normalized in-radius of a tetrahedron. The minimum
        normalized in-radius of a tetrahedron is the ratio of the minimum
        sub-tetrahedron inner radius to the outer tetrahedron radius.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetNormalizedInradius, *my_args)
        return ret

    def tet_radius_ratio(self, *args):
        """
        tet_radius_ratio(cell:Cell) -> float
        C++: static double tet_radius_ratio(Cell *cell)
        Calculate the radius ratio of a tetrahedron. The radius ratio of
        a tetrahedron $K $ is:$\\frac{R}{3r} $, where $R $ and $r $
        respectively denote the circumradius and the inradius of $K $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetRadiusRatio, *my_args)
        return ret

    def tet_relative_size_squared(self, *args):
        """
        tet_relative_size_squared(cell:Cell) -> float
        C++: static double tet_relative_size_squared(Cell *cell)
        Calculate the relative size squared of a tetrahedron. The
        relative size squared of a tetrahedron is Min(J, 1 / J), where J
        is determinant of weighted Jacobian matrix.
        
        Note: tet_relative_size_squared will return 0.0 if the mesh_quality
        filter has NOT been executed, because it relies on the average
        tet size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetRelativeSizeSquared, *my_args)
        return ret

    def tet_scaled_jacobian(self, *args):
        """
        tet_scaled_jacobian(cell:Cell) -> float
        C++: static double tet_scaled_jacobian(Cell *cell)
        Calculate the scaled Jacobian of a tetrahedron. The scaled
        jacobian of a tetrahedron is the minimum Jacobian divided by the
        lengths of 3 edge vectors.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetScaledJacobian, *my_args)
        return ret

    def tet_shape(self, *args):
        """
        tet_shape(cell:Cell) -> float
        C++: static double tet_shape(Cell *cell)
        Calculate the shape of a tetrahedron. The shape of a tetrahedron
        is 3 / Mean Ratio of weighted Jacobian matrix.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetShape, *my_args)
        return ret

    def tet_shape_and_size(self, *args):
        """
        tet_shape_and_size(cell:Cell) -> float
        C++: static double tet_shape_and_size(Cell *cell)
        Calculate the shape and size of a tetrahedron. The shape and size
        of a tetrahedron is product of shape and average size.
        
        Note: tet_shape_and_size will return 0.0 if the mesh_quality filter
        has NOT been executed, because it relies on the average tet size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetShapeAndSize, *my_args)
        return ret

    def tet_squish_index(self, *args):
        """
        tet_squish_index(cell:Cell) -> float
        C++: static double tet_squish_index(Cell *cell)
        Calculate the squish index of a tetrahedron.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetSquishIndex, *my_args)
        return ret

    def tet_volume(self, *args):
        """
        tet_volume(cell:Cell) -> float
        C++: static double tet_volume(Cell *cell)
        Calculate the volume of a tetrahedron. The volume of a
        tetrahedron is (1/6) * Jacobian at corner node.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TetVolume, *my_args)
        return ret

    def triangle_area(self, *args):
        """
        triangle_area(cell:Cell) -> float
        C++: static double triangle_area(Cell *cell)
        Calculate the area of a triangle.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleArea, *my_args)
        return ret

    def triangle_aspect_frobenius(self, *args):
        """
        triangle_aspect_frobenius(cell:Cell) -> float
        C++: static double triangle_aspect_frobenius(Cell *cell)
        Calculate the Frobenius condition number of the transformation
        matrix from an equilateral triangle to a triangle. The Frobenius
        aspect of a triangle $t $, when the reference element is
        equilateral, is:$\\frac{|t|^2_2}{2\\sqrt{3}{\\cal A}} $, where
        $|t|^2_2 $ and $\\cal A $ respectively denote the sum of the
        squared edge lengths and the area of $t $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleAspectFrobenius, *my_args)
        return ret

    def triangle_aspect_ratio(self, *args):
        """
        triangle_aspect_ratio(cell:Cell) -> float
        C++: static double triangle_aspect_ratio(Cell *cell)
        Calculate the aspect ratio of a triangle. The aspect ratio of a
        triangle $t $ is:$\\frac{|t|_\\infty}{2\\sqrt{3}r} $, where
        $|t|_\\infty $ and $r $ respectively denote the greatest edge
        length and the inradius of $t $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleAspectRatio, *my_args)
        return ret

    def triangle_condition(self, *args):
        """
        triangle_condition(cell:Cell) -> float
        C++: static double triangle_condition(Cell *cell)
        Calculate the condition number of a triangle.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleCondition, *my_args)
        return ret

    def triangle_distortion(self, *args):
        """
        triangle_distortion(cell:Cell) -> float
        C++: static double triangle_distortion(Cell *cell)
        Calculate the distortion of a triangle.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleDistortion, *my_args)
        return ret

    def triangle_edge_ratio(self, *args):
        """
        triangle_edge_ratio(cell:Cell) -> float
        C++: static double triangle_edge_ratio(Cell *cell)
        Calculate the edge ratio of a triangle. The edge ratio of a
        triangle $t $ is:$\\frac{|t|_\\infty}{|t|_0} $, where $|t|_\\infty $
        and $|t|_0 $ respectively denote the greatest and the smallest
        edge lengths of $t $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleEdgeRatio, *my_args)
        return ret

    def triangle_equiangle_skew(self, *args):
        """
        triangle_equiangle_skew(cell:Cell) -> float
        C++: static double triangle_equiangle_skew(Cell *cell)
        Calculate the equiangle skew of a triangle.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleEquiangleSkew, *my_args)
        return ret

    def triangle_max_angle(self, *args):
        """
        triangle_max_angle(cell:Cell) -> float
        C++: static double triangle_max_angle(Cell *cell)
        Calculate the maximal (nonoriented) angle of a triangle,
        expressed in degrees.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleMaxAngle, *my_args)
        return ret

    def triangle_min_angle(self, *args):
        """
        triangle_min_angle(cell:Cell) -> float
        C++: static double triangle_min_angle(Cell *cell)
        Calculate the minimal (nonoriented) angle of a triangle,
        expressed in degrees.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleMinAngle, *my_args)
        return ret

    def triangle_normalized_inradius(self, *args):
        """
        triangle_normalized_inradius(cell:Cell) -> float
        C++: static double triangle_normalized_inradius(Cell *cell)
        Calculate the normalized in-radius of a triangle. The minimum
        normalized in-radius of a triangle is the ratio of the minimum
        sub-triangle inner radius to the outer triangle radius.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleNormalizedInradius, *my_args)
        return ret

    def triangle_radius_ratio(self, *args):
        """
        triangle_radius_ratio(cell:Cell) -> float
        C++: static double triangle_radius_ratio(Cell *cell)
        Calculate the radius ratio of a triangle. The radius ratio of a
        triangle $t $ is:$\\frac{R}{2r} $, where $R $ and $r $
        respectively denote the circumradius and the inradius of $t $.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleRadiusRatio, *my_args)
        return ret

    def triangle_relative_size_squared(self, *args):
        """
        triangle_relative_size_squared(cell:Cell) -> float
        C++: static double triangle_relative_size_squared(Cell *cell)
        Calculate the square of the relative size of a triangle.
        
        Note: triangle_relative_size_squared will return 0.0 if the
        mesh_quality filter has NOT been executed, because it relies on
        the average triangle size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleRelativeSizeSquared, *my_args)
        return ret

    def triangle_scaled_jacobian(self, *args):
        """
        triangle_scaled_jacobian(cell:Cell) -> float
        C++: static double triangle_scaled_jacobian(Cell *cell)
        Calculate the scaled Jacobian of a triangle.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleScaledJacobian, *my_args)
        return ret

    def triangle_shape(self, *args):
        """
        triangle_shape(cell:Cell) -> float
        C++: static double triangle_shape(Cell *cell)
        Calculate the shape of a triangle.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleShape, *my_args)
        return ret

    def triangle_shape_and_size(self, *args):
        """
        triangle_shape_and_size(cell:Cell) -> float
        C++: static double triangle_shape_and_size(Cell *cell)
        Calculate the product of shape and relative size of a triangle.
        
        Note: triangle_shape_and_size will return 0.0 if the mesh_quality
        filter has NOT been executed, because it relies on the average
        triangle size.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleShapeAndSize, *my_args)
        return ret

    def wedge_condition(self, *args):
        """
        wedge_condition(cell:Cell) -> float
        C++: static double wedge_condition(Cell *cell)
        Calculate the condition number of a wedge. The condition number
        of a wedge is equivalent to the max aspect Frobenius.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeCondition, *my_args)
        return ret

    def wedge_distortion(self, *args):
        """
        wedge_distortion(cell:Cell) -> float
        C++: static double wedge_distortion(Cell *cell)
        Calculate the distortion of a wedge. The distortion of a wedge is
        {min(|J|) / actual volume } * parent volume.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeDistortion, *my_args)
        return ret

    def wedge_edge_ratio(self, *args):
        """
        wedge_edge_ratio(cell:Cell) -> float
        C++: static double wedge_edge_ratio(Cell *cell)
        Calculate the edge ratio of a wedge. The edge ratio of a wedge is
        Hmax / Hmin, where Hmax and Hmin are respectively the maximum and
        the minimum edge lengths.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeEdgeRatio, *my_args)
        return ret

    def wedge_equiangle_skew(self, *args):
        """
        wedge_equiangle_skew(cell:Cell) -> float
        C++: static double wedge_equiangle_skew(Cell *cell)
        Calculate the equiangle skew of a wedge.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeEquiangleSkew, *my_args)
        return ret

    def wedge_jacobian(self, *args):
        """
        wedge_jacobian(cell:Cell) -> float
        C++: static double wedge_jacobian(Cell *cell)
        Calculate the Jacobian of a wedge. The jacobian of a wedge is the
        min{((L_2 X L_0) * L_3)_k}.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeJacobian, *my_args)
        return ret

    def wedge_max_aspect_frobenius(self, *args):
        """
        wedge_max_aspect_frobenius(cell:Cell) -> float
        C++: static double wedge_max_aspect_frobenius(Cell *cell)
        Calculate the max aspect Frobenius of a wedge. The max aspect
        Frobenius of a wedge is max(F_0123, F_1204, F_2015, F_3540,
        F_4351, F_5432).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeMaxAspectFrobenius, *my_args)
        return ret

    def wedge_max_stretch(self, *args):
        """
        wedge_max_stretch(cell:Cell) -> float
        C++: static double wedge_max_stretch(Cell *cell)
        Calculate the max stretch of a wedge. The maximum stretch of a
        wedge is maximum stretch (S) of the three quadrilateral faces: q
        = max[S_1043, S_1254, S_2035]
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeMaxStretch, *my_args)
        return ret

    def wedge_mean_aspect_frobenius(self, *args):
        """
        wedge_mean_aspect_frobenius(cell:Cell) -> float
        C++: static double wedge_mean_aspect_frobenius(Cell *cell)
        Calculate the mean aspect Frobenius of a wedge. The mean aspect
        Frobenius of a wedge is: 1/6 * (F_0123 + F_1204 + F+2015 + F_3540
        + F_4351 + F_5432).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeMeanAspectFrobenius, *my_args)
        return ret

    def wedge_scaled_jacobian(self, *args):
        """
        wedge_scaled_jacobian(cell:Cell) -> float
        C++: static double wedge_scaled_jacobian(Cell *cell)
        Calculate the scaled Jacobian a wedge. The jacobian of a wedge is
        the minimum point-wise volume at any corner divided by the
        corresponding edge lengths and normalized to the unit wedge: q =
        min(  2 / sqrt(3) * ((L_2 X L_0) * L_3)_k / sqrt(mag(L_2) *
        mag(L_0) * mag(L_3))), where ((L_2 X L_0) * L_3)_k is the
        determinant of the Jacobian of the tetrahedron defined at the kth
        corner node, and L_2, L_0 and L_3 are the egdes defined according
        to the standard for tetrahedral elements.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeScaledJacobian, *my_args)
        return ret

    def wedge_shape(self, *args):
        """
        wedge_shape(cell:Cell) -> float
        C++: static double wedge_shape(Cell *cell)
        Calculate the shape of a wedge. The shape of a wedge is 3 divided
        by the minimum mean ratio of the Jacobian matrix at each element
        corner.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeShape, *my_args)
        return ret

    def wedge_volume(self, *args):
        """
        wedge_volume(cell:Cell) -> float
        C++: static double wedge_volume(Cell *cell)
        Calculate the volume of a wedge.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WedgeVolume, *my_args)
        return ret

    _updateable_traits_ = \
    (('compatibility_mode', 'GetCompatibilityMode'),
    ('linear_approximation', 'GetLinearApproximation'), ('ratio',
    'GetRatio'), ('save_cell_quality', 'GetSaveCellQuality'), ('volume',
    'GetVolume'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('hex_quality_measure', 'GetHexQualityMeasure'),
    ('pyramid_quality_measure', 'GetPyramidQualityMeasure'),
    ('quad_quality_measure', 'GetQuadQualityMeasure'),
    ('tet_quality_measure', 'GetTetQualityMeasure'),
    ('triangle_quality_measure', 'GetTriangleQualityMeasure'),
    ('wedge_quality_measure', 'GetWedgeQualityMeasure'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compatibility_mode', 'debug',
    'global_warning_display', 'linear_approximation', 'ratio',
    'release_data_flag', 'save_cell_quality', 'volume',
    'hex_quality_measure', 'pyramid_quality_measure',
    'quad_quality_measure', 'tet_quality_measure',
    'triangle_quality_measure', 'wedge_quality_measure', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(MeshQuality, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit MeshQuality properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compatibility_mode', 'linear_approximation', 'ratio',
            'save_cell_quality', 'volume'], ['hex_quality_measure',
            'pyramid_quality_measure', 'quad_quality_measure',
            'tet_quality_measure', 'triangle_quality_measure',
            'wedge_quality_measure'], ['object_name']),
            title='Edit MeshQuality properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit MeshQuality properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

