//
// starter.h
//
//
//  Created by Pierre Peterlongo on 22/10/2012
//


#include "../minia/Bloom.h"
#include "../minia/Kmer.h"
#include "../minia/Set.h"
#include "../minia/Bank.h"
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include "GraphOutput.h"
#include "Extension_Bank.h"
#include "commons.h"
#include "Fragment.h"

extern "C" {
    //#include "read_coherence_mapsembler/simplehash.h"
#include "read_coherence_mapsembler/hash.h"
#include "read_coherence_mapsembler/read_coherence.h"
}

#ifndef _STARTER_H
#define _STARTER_H

/**
 * A starter is a fragment extensible with mapsembler
 * Thus it contains all substarters, and a set of id of right and left kmers
 */
class Starter{
public:
    
    long starting_id_in_the_boolean_vector; // used to know if the current tested read (during mapping) was already tested on this fragment at a given position
    
    /**
     * The fragment of the starter:
     */
    Fragment * fragment;
    /**
     * number of substarters (cf mapsembler publications)
     */
    int nb_substarters;      // number of sub starters for this starter
    /**
     * sequences of all substarters
     */
    char ** substarters_sequences; // sequences of all the sub-starters
    /**
     * As substarters may contain same left or right kmers used for extension, we store in Extension_Bank non redundant kmers. This array stores the ids of right kmers extensions
     */
    int * right_kmers; //  distinct ids of each right kmers (each substarter is extended from a right starter, but some right kmers may be the same, so only one extension is performed)
    
    /**
     * As substarters may contain same left or right kmers used for extension, we store in Extension_Bank non redundant kmers. This array stores the ids of left kmers extensions
     */
    int * left_kmers; // distinct ids of each left kmers whose reverse complements are gonna be extended (each substarter is extended from a left starter, but some left kmers may be the same, so only one extension is performed)
    
    /**
     * Create a new Fragment
     */
    Starter(char *starter_sequence);
    
    /**
     * Create a new Fragment
     */
    Starter(Fragment* fragment);
    /**
     * delete substarters and right_kmers and left_kmers
     */
    ~Starter();
    /**
     * reads the starter together with the indexed kmers for detecting the substarters.
     */
    int generate_substarters(Extension_Bank *bank, const int max_substitutions, const int min_coverage, const int substitutions_allowed, const int size_kmers);
    
    /**
     * stores the starter as its substarter. Used when no mapping is requiered (option -E).
     */
    void generate_substarter_no_mapping(Extension_Bank *bank, const int size_kmers);
    /**
     * output results - fasta fashion
     */
    void starter_output_sequence(Extension_Bank *bank, int index, string output_res, bool erase);
    /**
     * output results - graph fashion
     */
    id_els starter_output_graph(Extension_Bank *bank, GraphOutput graph, id_els first_id_els);
};

#endif // _STARTER_H
