package tests::DataTypesTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::DataTypes qw/ format_numeric_type check_duration check_type /;

sub test_format_numeric_type {
    my $self = $_[0];

    $self->{'cfg'}{'lr_scale_numbers'} = 0;
    $self->assert_str_equals( 'NaN', format_numeric_type( undef ));

    $self->{'cfg'}{'lr_scale_numbers'} = 0;
    $self->assert_str_equals( 2000, format_numeric_type( 2000));
    $self->{'cfg'}{'lr_scale_numbers'} = 1;
    $self->assert_str_equals( '2k', format_numeric_type( 2000));

    $self->{'cfg'}{'lr_scale_seconds'} = 0;
    $self->assert_str_equals( 120, format_numeric_type( 120, 'duration' ));
    $self->{'cfg'}{'lr_scale_seconds'} = 1;
    $self->assert_str_equals( '2m', format_numeric_type( 120, 'duration' ));

    $self->{'cfg'}{'lr_scale_bytes'} = 0;
    $self->assert_str_equals( 2048, format_numeric_type( 2048, 'bytes' ));
    $self->{'cfg'}{'lr_scale_bytes'} = 1;
    $self->assert_str_equals( '2k', format_numeric_type( 2048, 'bytes' ));
}

sub test_check_duration {
    my $self = $_[0];

    my @vtests = ( '1d', '2days', '1M', '1y', '4d', '5w', '12y',
                   '0', '60', '8s', '60sec', '38secs', '38seconds',
                   '8m', '60min', '38mins', '38minutes',
                   '8h', ' 60 hour', '38 hours',
                   '8w', '60 week ', '38weeks',
                   '8M', '60Month ', '38Months',
                   '8y', '60year', '38years',
                 );
    foreach my $vd ( @vtests ) {
        my $rc = check_duration( $vd );
        $self->assert( $rc, "check duration returned false for '$vd'" );
    }

    my @ivtests = ( undef, ''. 'wawa', '1d2m', );
    foreach my $iv ( @ivtests ) {
        my $rc = check_duration( $iv );
        $iv = '<undef>' unless defined $iv;
        $self->assert( ! $rc, "check duration returned true for '$iv'" );
    }
}

sub test_check_type {
    my $self = $_[0];

    foreach my $type ( qw/id bool int number string timestamp time date
                          duration ip port hostname url email
                          bytes filename type field superservice chart / )
    {
        $self->assert( check_type( $type ), "check_type($type)" );
    }
    $self->assert( ! check_type( undef ), 'check_type(undef)' );
    $self->assert( ! check_type( 'string1' ), 'check_type("string1")' );
}

1;
