# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gtk

from lernid.lernidconfig import get_data_path

class PasswordDialog(gtk.Dialog, gtk.Buildable):
    __gtype_name__ = "PasswordDialog"

    @staticmethod
    def new():
        builder = gtk.Builder()
        builder.add_from_file(get_data_path('ui', 'PasswordDialog.ui'))    
        return builder.get_object("password_dialog")

    def do_parser_finished(self, builder):
        """do_parser_finished is automatically called after
        the UI definition has been parsed.
        """
        entry = builder.get_object('password_entry')
        ok = builder.get_object('ok_button')
        def update(widget):
            ok.set_sensitive(bool(entry.get_text()))
        entry.connect('changed', update)

        self.entry = entry

    def run(self):
        password = None
        if gtk.Dialog.run(self) == gtk.RESPONSE_OK:
            password = self.entry.get_text()
        self.entry.set_text('')
        self.hide()
        return password


if __name__ == "__main__":
    dialog = PasswordDialog.new()
    print dialog.run()
