<?php
/**
 *
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: init.php 741 2009-07-05 21:43:39Z lordlamer $
 */

// base path
$base_path = realpath(dirname(__FILE__).'/../') . '/';

// load required files
require_once($base_path."include/version.php");
require_once($base_path."include/class-session.php");
require_once($base_path."include/class-runtime.php");
require_once($base_path."include/class-tree.php");
require_once($base_path."include/function.php");
require_once($base_path."include/class-knowledgeroot.php");
require_once($base_path."include/class-knowledgeroot-header.php");
require_once($base_path."include/class-knowledgeroot-content.php");
require_once($base_path."include/class-knowledgeroot-themes.php");
require_once($base_path."include/class-language.php");
require_once($base_path."system/phpmailer/class.phpmailer.php");
require_once($base_path."include/class-email-notification.php");
require_once($base_path."include/class-knowledgeroot-extension.php");
require_once($base_path."include/class-extension-base.php");
require_once($base_path."include/class-default-menu.php");
require_once($base_path."include/class-error.php");
require_once($base_path."include/class-knowledgeroot-auth.php");
require_once($base_path."include/class-hooks.php");
require_once($base_path."include/class-rte.php");
require_once($base_path."include/class-db-result.php");
require_once($base_path."include/class-db-core.php");
require_once($base_path."include/class-highlight.php");


// this is the variable where all classes are in
$CLASS = array();

// define global variables
$CLASS['vars'] = $CONFIG;

// init error
$CLASS['error'] = new knowledgeroot_error();
$CLASS['error']->start($CLASS);

// define runtimer
$CLASS['runtime'] = new runtime();

// set base paths
$CLASS['vars']['base_path'] = $base_path;

// load databaseclass
if($CLASS['vars']['db']['type'] == "mysql") {
	require_once($base_path."include/class-mysql.php");
}

if($CLASS['vars']['db']['type'] == "mysqli") {
	require_once($base_path."include/class-mysqli.php");
}

if($CLASS['vars']['db']['type'] == "pgsql") {
	require_once($base_path."include/class-pgsql.php");
}

if($CLASS['vars']['db']['type'] == "mdb2") {
	require_once($base_path."include/class-mdb2.php");
}

if($CLASS['vars']['db']['type'] == "sqlite") {
        require_once($base_path."include/class-sqlite.php");
}

if($CLASS['vars']['db']['type'] == "oracle") {
        require_once($base_path."include/class-oracle.php");
}

if(isset($KNOWLEDGEROOTDB) && $KNOWLEDGEROOTDB != "PGSQL" && $KNOWLEDGEROOTDB != "MYSQL" && $KNOWLEDGEROOTDB != "MDB2" && $KNOWLEDGEROOTDB != "SQLITE" && $KNOWLEDGEROOTDB != "OCI") {
	echo "WRONG DBTYPE SELECTED!\n";
	exit();
}

// init hooks
$CLASS['hooks'] = new hooks();
$CLASS['hooks']->start($CLASS);

// init error
$CLASS['auth'] = new knowledgeroot_auth();
$CLASS['auth']->start($CLASS);

// init databaseclass
$CLASS['db'] = new db();
$CLASS['db']->start($CLASS);

// connect to database
$CLASS['db']->connect($CLASS['vars']['db']['host'],$CLASS['vars']['db']['user'],$CLASS['vars']['db']['pass'],$CLASS['vars']['db']['database'],$CLASS['vars']['db']['schema'],$CLASS['vars']['db']['encoding']);

// init knowledgerootclass
$CLASS['knowledgeroot'] = new knowledgeroot();
$CLASS['knowledgeroot']->start($CLASS);

// addslashes on GET/POST/COOKIE/REQUEST/SERVER
$CLASS['knowledgeroot']->addSlashesOnArray($_GET);
$CLASS['knowledgeroot']->addSlashesOnArray($_POST);
$CLASS['knowledgeroot']->addSlashesOnArray($_COOKIE);
$CLASS['knowledgeroot']->addSlashesOnArray($_REQUEST);
$CLASS['knowledgeroot']->addSlashesOnArray($_SERVER);

// load config from db
$CLASS['vars'] = $CLASS['knowledgeroot']->replace_array($CLASS['vars'], $CLASS['knowledgeroot']->getConfigArr());

// init session
$CLASS['session'] = new session();
$CLASS['session']->start($CLASS);
$CLASS['session']->startSession(md5($CLASS['vars']['baseurl']));
if(!$CLASS['session']->checkSession()) {
	die("SESSION WAS WRONG!");
}

// PHP-Gettext start
define('LOCALE_DIR', $base_path.'system/language');
require_once ($base_path."system/php-gettext/gettext.inc.php");

if ($CLASS['vars']['knowledgeroot']['charset'] != '') {
	$encoding = $CLASS['vars']['knowledgeroot']['charset'];
} else {
	$encoding = 'utf-8';
}

if ($CLASS['vars']['knowledgeroot']['language'] != '') {
	define('DEFAULT_LOCALE', $CLASS['vars']['knowledgeroot']['language']);
} else {
	define('DEFAULT_LOCALE', 'en');
}

$locale = (isset($_SESSION['language']))? $_SESSION['language'] : DEFAULT_LOCALE;

// gettext setup
putenv('LANG='.$locale);
T_setlocale(LC_ALL, $locale);

// Set the text domain as 'knowledgeroot'
$domain = 'knowledgeroot';
T_bindtextdomain($domain, LOCALE_DIR);

// bind_textdomain_codeset is supported only in PHP 4.2.0+
if (function_exists('T_bind_textdomain_codeset'))
	T_bind_textdomain_codeset($domain, $encoding);

T_textdomain($domain);
// PHP-Gettext end


// init language
$CLASS['language'] = new language();
$CLASS['language']->start($CLASS,$CLASS['vars']['knowledgeroot']['language']);

// init themes
$CLASS['themes'] = new knowledgeroot_themes();
$CLASS['themes']->start($CLASS);

// init email notification class
$CLASS['notification'] = new knowledgeroot_notification($CLASS);

// check for safari and konqueror
// this is a short fix beacause the ajaxtree does not work in opera and konqueror
if($CLASS['vars']['menu']['ajax'] == "yes") {
	if(isset($_SERVER['HTTP_USER_AGENT']) && (preg_match("/.*[Kk]onqueror.*/",$_SERVER['HTTP_USER_AGENT']) || preg_match("/.*[Ss]afari.*/",$_SERVER['HTTP_USER_AGENT']))) {
		$CLASS['vars']['menu']['ajax'] = "no";
	}
}

// load rte editor class
$CLASS['rte'] = new rte($CLASS);

// load string-highlight class
$CLASS['highlight'] = new highlight();

// load extensions
$CLASS['kr_extension'] = new knowledgeroot_extension();
$CLASS['kr_extension']->start($CLASS);

// init tree
$CLASS['tree'] = new categoryTree();
$CLASS['tree']->start($CLASS);

// init tree_path
$CLASS['path'] = new pathTree();
$CLASS['path']->start($CLASS);

// init header
$CLASS['kr_header'] = new knowledgeroot_header();
$CLASS['kr_header']->start($CLASS);

// init content
$CLASS['kr_content'] = new knowledgeroot_content();
$CLASS['kr_content']->start($CLASS);

// start all extensions
$CLASS['kr_extension']->start_extensions();

// check header variables
$CLASS['kr_header']->check_vars();

// check if site is a download
$CLASS['kr_header']->check_download();

// load default menu
$CLASS['default_menu'] = new default_menu();
$CLASS['default_menu']->start($CLASS);

// add javascript to htmlheader
if(!isset($CONFIG['include_prefix'])) {
	$CONFIG['include_prefix'] = "";
}

$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/prototype.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/scriptaculous.js");
//$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/effects.js");
//$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/dragdrop.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/showhide.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/ajax-tree.js");
$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/messagebox.js");

// check if contextmenus are enabled
if($CLASS['vars']['menu']['context'] == 1) {
	// load js for contextmenus
	$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/knowledgeroot-menu.js");
}

// add js for dragbox if dragdrop is enabled
if($CLASS['vars']['menu']['dragdrop'] == "1") {
	$CLASS['kr_header']->addjssrc($CONFIG['include_prefix']."system/javascript/dragbox.js");
}

// add loadingmessage for messagebox
$CLASS['kr_header']->addjs("var msgboxloading = '".T_('loading...')."';");

// add theme
$CLASS['kr_header']->addcsssrc($CLASS['themes']->load_theme());

// add favicon pointer
$CLASS['kr_header']->addheader("<link rel=\"shortcut icon\" href=\"".$CONFIG['include_prefix']."favicon.ico\" type=\"image/x-icon\" />");

// add generator
if(isset($version))
	$CLASS['kr_header']->addheader("<meta name=\"generator\" content=\"Knowledgeroot - ".$version."\" />");

// add hook
$CLASS['hooks']->setHook("init","init","end");
?>
