#include <iostream>

#include "regex_glue.h"
#include "Heap.h"
#include "VM.h"
#include "stdfuns.h"
#include "KayaAPI.h"
#include <cstring>

void* re_compile(void* vm, wchar_t* pattern, kint len, kint flagcode)
{
    VMState* vmptr = (VMState*)vm;
    const char* error;
    int erroffset;
    // set by ./configure
#ifndef NOUTF8
    int regexflags = PCRE_UTF8;
#else
    int regexflags = 0;
    if (checkUTF8(pattern)) {
      vmptr->kaya_internalError(1);
    }
#endif
    if (flagcode & 1) { regexflags = regexflags | PCRE_CASELESS; }
    if (flagcode & 2) { regexflags = regexflags | PCRE_EXTENDED; }
    if (flagcode & 4) { regexflags = regexflags | PCRE_MULTILINE; }
    if (flagcode & 8) { regexflags = regexflags | PCRE_UNGREEDY; }
    
    CNPSTRING(patt,pattern,len);
    char* cpatt = patt;
    pcre* re =  pcre_compile(patt,regexflags,&error, &erroffset, NULL);
    if (re == NULL) {
      vmptr->kaya_internalError(0);
    }
    CompiledRegex* reobj = new CompiledRegex(re);
    return (void*)reobj;
}

kint re_quickmatch(void* vm, void* pc, wchar_t* wstr, kint inlen)
{
    VMState* vmptr = (VMState*)vm;
    CNPSTRING(stra,wstr,inlen);
    char* str = stra;

#ifdef NOUTF8
    if (topSet(str)) {
      vmptr->kaya_internalError(1);
    }
#endif

    int ovector[255];

    pcre* re = ((CompiledRegex*)pc)->regex;
    int rc = pcre_exec(re, NULL, str, strlen(str), 0, 0, ovector, 255);

    return (rc>=0);
}

void* re_match(void* vm, void* pc, wchar_t* wstr, kint inlen)
{
    VMState* vmptr = (VMState*)vm;
    CNPSTRING(stra,wstr,inlen);
    char* str = stra;

#ifdef NOUTF8
    if (topSet(str)) {
      vmptr->kaya_internalError(1);
    }
#endif

    int ovector[255];
    Match* m = new Match();

    pcre* re = ((CompiledRegex*)pc)->regex;
    int rc = pcre_exec(re, NULL, str, strlen(str), 0, 0, ovector, 255);
    int len = strlen(str);

//    cout << rc << endl;
    //cout << str << endl;
    if (rc>=0) {
	m->matched = true;
	m->matches = new Array();

	char beforetmp[ovector[0]+1];
	strncpy(beforetmp,str,ovector[0]);
	beforetmp[ovector[0]] = '\0';
	m->before = KSTRING(beforetmp);

	/*	m->before = (wchar_t*)GC_MALLOC_ATOMIC((ovector[0]+1)*sizeof(wchar_t));
	wcsncpy(m->before, strtowc(str),ovector[0]);
	m->before[ovector[0]]='\0';
	cout << ovector[0] << endl; */

	int afterlen = len-ovector[1];
	char aftertmp[afterlen+1];
	strncpy(aftertmp,str+ovector[1],afterlen);
	aftertmp[afterlen] = '\0';
	m->after = KSTRING(aftertmp);

	/*	m->after = (wchar_t*)GC_MALLOC_ATOMIC((afterlen+1)*sizeof(wchar_t));
	wcsncpy(m->after, strtowc(str+ovector[1]),afterlen);
	m->after[afterlen]='\0'; */

	for(int i=0;i<rc;i++) {
//	    cout << ovector[i*2] << "-" << ovector[i*2+1] << endl;
	    const char* sub;
	    pcre_get_substring(str, ovector, rc, i, &sub);
	    //	    char* val = (char*)GC_MALLOC_ATOMIC((strlen(sub)+1)*sizeof(char));
	    //	    strcpy(val,sub);
	    // this now uses the API!
	    KVSTRING(vmptr,sub);
	    m->matches->push_back(KayaString2(vmptr));
	    //new Value(new String(strtowc(sub)),KVT_STRING));
	}
    }
    else
    {
	m->matched = false;
	m->matches = new Array();
    }
    return (void*)m;
}

Array* getmatches(void* mo)
{
    return ((Match*)mo)->matches;
}

bool matched(void* mo)
{
    return ((Match*)mo)->matched;
}

wchar_t* getBefore(void* mo)
{
    return ((Match*)mo)->before;    
}

wchar_t* getAfter(void* mo)
{
    return ((Match*)mo)->after;    
}
