/*************************************************************************
* Copyright (C) 2002 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#ifndef IFMA_ECPRECOMP4_P256_H
#define IFMA_ECPRECOMP4_P256_H

#include <internal/ecnist/ifma_ecpoint_p256.h>

#if (_MBX>=_MBX_K1)

#define MUL_BASEPOINT_WIN_SIZE (4)

#define BP_WIN_SIZE  MUL_BASEPOINT_WIN_SIZE
#define BP_N_SLOTS  NUMBER_OF_DIGITS(P256_BITSIZE+1,BP_WIN_SIZE)
#define BP_N_ENTRY (1<<(BP_WIN_SIZE-1))

__ALIGN64 static SINGLE_P256_POINT_AFFINE ifma_ec_nistp256_bp_precomp[][BP_N_ENTRY] = {
{/* digit=0 [{1,2,3,..,}]*([2^0]*G)  */
   {{0x00030d418a9143c1,0x000c4fedb60179e7,0x00062251075ba95f,0x0005c669fb732b77,0x00008905f76b5375}, {0x0005357ce95560a8,0x00043a19e45cddf2,0x00021f3258b4ab8e,0x000d8552e88688dd,0x0000571ff18a5885}},
   {{0x00046d410ddd64df,0x0000b433827d8500,0x0001490d9aa6ae3c,0x000a3a832205038d,0x00006bb32e52dcf3}, {0x00048d361bee1a57,0x000b7b236ff82f36,0x000042dbe152cd7c,0x000a3aa9a8fb0e92,0x00008c577517a5b8}},
   {{0x0003f904eebc1272,0x0009e87d81fbffac,0x000cbbc98b027f84,0x00047e46ad77dd87,0x00006936a3fd6ff7}, {0x0005c1fc983a7ebd,0x000c3861fe1ab04c,0x0002ee98e583e47a,0x000c06a88208311a,0x00005f06a2ab587c}},
   {{0x000b50d46918dcc5,0x000d7623c17374b0,0x000100af24650a6e,0x00076abcdaacace8,0x000077362f591b01}, {0x000f24ce4cbaba68,0x00017ad6f4472d96,0x000ddd22e1762847,0x000862eb6c36dee5,0x00004b14c39cc5ab}},
   {{0x0008aaec45c61f5c,0x0009d4b9537dbe1b,0x00076c20c90ec649,0x0003c7d41cb5aad0,0x0000907960649052}, {0x0009b4ae7ba4f107,0x000f75eb882beb30,0x0007a1f6873c568e,0x000915c540a9877e,0x00003a076bb9dd1e}},
   {{0x00047373e77664a1,0x000f246cee3e4039,0x00017a3ad55ae744,0x000673c50a961a5b,0x00003074b5964213}, {0x0006220d377e44ba,0x00030dff14b593d3,0x000639f11299c2b5,0x00075f5424d44cef,0x00004c9916dea07f}},
   {{0x000354ea0173b4f1,0x0003c23c00f70746,0x00023bb082bd2021,0x000e03e43eaab50c,0x00003ba5119d3123}, {0x000d0303f5b9d4de,0x00017da67bdd2847,0x000c941956742f2f,0x0008670f933bdc77,0x0000aedd9164e240}},
   {{0x0004cd19499a78fb,0x0004bf9b345527f1,0x0002cfc6b462ab5c,0x00030cdf90f02af0,0x0000763891f62652}, {0x000a3a9532d49775,0x000d7f9eba15f59d,0x00060bbf021e3327,0x000f75c23c7b84be,0x00006ec12f2c706d}},
},
{/* digit=1 [{1,2,3,..,}]*([2^4]*G)  */
   {{0x0000b650bc6fb805,0x0004effe2e6b808b,0x00083f5495882e07,0x00072385ef2f7c2c,0x00004d63c80e103b}, {0x0001bd652a23f9b6,0x0008eb0b6587f2f1,0x000580e9e3670c31,0x00021ff5c4623bb1,0x00004edf7b261efe}},
   {{0x000fccfc5e3a3d83,0x000c1079dfbfd8c5,0x000ad0197befd904,0x0002a48c6d6a58fe,0x0000922707799553}, {0x0003e6ddbef42f56,0x0003e80a990809e2,0x0009a2e407e449b6,0x0002a41b969c1aad,0x0000231d792f591c}},
   {{0x000413077adc612c,0x0008fbd803a06b34,0x0008805bda749652,0x0003ac5a1baaa76d,0x0000840390307034}, {0x0009f66175adff18,0x000b37d8c5b739f5,0x0009d75e30b26d7f,0x000cc22875f5ce52,0x00005efc7e9c1325}},
   {{0x00096f305968b809,0x0002789f73b9db6d,0x000c61e01380a091,0x0008c6eda70b83c2,0x00005fb8394e69b3}, {0x000651280edfe2f2,0x00096faeaf829a3c,0x000424bf88f726bb,0x0009706010a4a078,0x000096720442e844}},
   {{0x000dc0752b3e584c,0x0007f5f86a2c492b,0x0007de57335ff9aa,0x0003296074213db2,0x00000bfffc512638}, {0x000c22a1d49c6052,0x00059320ebfb2429,0x00020f4281b037d7,0x00066032b6a17392,0x0000995919cc4cd2}},
   {{0x0008d2333e12b701,0x000b09dd329b802b,0x000bc354d6d490a4,0x000a0d04f356cc6a,0x00001eddf7fe0a0d}, {0x0008328d87fd1d83,0x000ccd0258131e20,0x00029bca2fd2f4f8,0x000b70d3b48cc47c,0x0000f2a78b3541a2}},
   {{0x00005760a99cbca7,0x000594a428f26a95,0x00032ba0c94e258f,0x000166d5ab5a4d78,0x00001704d00f938c}, {0x000ab0ef88b8b706,0x000e600eb207db97,0x000367d8056feb92,0x000a41870352687d,0x00005000c2527973}},
   {{0x000cb817a2ad62aa,0x00090c62ff5463c5,0x000ad9db57ef2b6b,0x0006169749bba4b3,0x0000d311f2ce6d5a}, {0x0008087c2ff3b6df,0x0002467834ffb77a,0x000d6b138b46feaf,0x00018808aa266d75,0x0000a38d321dc008}},
},
{/* digit=2 [{1,2,3,..,}]*([2^8]*G)  */
   {{0x0008ffa696946fc7,0x000849cba56d486d,0x000f35a1550fbc6d,0x00062c0e3d423e90,0x0000c3da19630dd9}, {0x000fdb03cfd5d8b3,0x0002589dfca5e673,0x0002305aa0704b7c,0x000e53c6ce581ff5,0x000099d49ebc14d5}},
   {{0x0008110399492969,0x000aa61db1b544e3,0x0006eaff55b63827,0x00028fae5323ed20,0x000042370d3521f4}, {0x000af2ee0d985a17,0x000b0239846df2ca,0x0006312f8192cc64,0x0001080c0b8f47ae,0x0000dc61f9206620}},
   {{0x000a53eed4c37174,0x000efd0ed2a335d6,0x000543aa59f8240c,0x0004b44c0d4d05e5,0x00005d5bbfc1d33b}, {0x000cc73137fd28e3,0x000f973b3ffdfa04,0x000f51ef2862ac6e,0x0005a2103ff9f531,0x00004d5e0fcec73f}},
   {{0x00081e144cc3adda,0x0005e7be82cf4f70,0x000dd6472d5ffa1d,0x000862e9890b6c0e,0x0000da26e1aded17}, {0x000271563483caaf,0x00083f6077fd276f,0x000466e3ce6924cd,0x000d1e15a7fe980a,0x00001c794b1a1902}},
   {{0x000385c08369a907,0x000aa90eb4f833b2,0x0008eac802990c59,0x000014119a6145c6,0x0000a786d629ec4a}, {0x000adbe20ac3a8dd,0x00008aba2d3033fa,0x000a4f56531a2178,0x000fba509d2742db,0x0000b2ce9e425aa0}},
   {{0x0006bf38bd7aff18,0x000a9d81b146b315,0x00028a9151b5ee4c,0x00099dfba1ac41d6,0x0000f3a8f9d7d896}, {0x000b9c9a0748be7d,0x0004d92e621f7329,0x00010a8371d391c9,0x000435151e6b214d,0x0000255f53b1947b}},
   {{0x00058d474a861082,0x000fce4c5d900c4a,0x0006d4c80f8048a8,0x000e60c3c7c924e8,0x00008c889de256a1}, {0x000662eb214a040f,0x000747e1034757e2,0x000ac748ae8c48e9,0x0006f19774286280,0x00001c24023086b0}},
   {{0x00024b9eb7926b83,0x00039dbe55093d2b,0x000dd640bbff88cb,0x000d45a0f399afe4,0x0000c5fe1305f76e}, {0x00062f43764fb3df,0x00074151b62d6f35,0x0009ce5f37b5af31,0x00090ee5bd0bc7d7,0x0000daf6b21dc668}},
},
{/* digit=3 [{1,2,3,..,}]*([2^12]*G)  */
   {{0x000b0e5ab4b35a24,0x0001b5eeaacf6772,0x0005b95801d8b600,0x0001da328f7ce479,0x0000a20ed2a81fb8}, {0x0005cd44fec01e63,0x000c77ff50ad9f68,0x0002d97fd3ed7ddc,0x0004f9160fd2640c,0x0000a2414271b82f}},
   {{0x0009862d5d721d5b,0x0002abd3a1828000,0x000a2cda40c3357a,0x00008477f3a83b7a,0x000058ae74fa6f83}, {0x0001a812e6dad6be,0x0001143d6c5b2a91,0x00096c4d8de28605,0x00024d6bdccc41f9,0x00007312ec0eae1e}},
   {{0x00068feaae6ee702,0x00053602b0c96faf,0x00094052a78f4cc1,0x000d805e3321a86e,0x0000fb3a0d6934d5}, {0x0008f3bb25a43ba1,0x000109ee2951f3b9,0x000b0612a30bf803,0x0001d06ffee43321,0x00002f775e43eb82}},
   {{0x00012e76e6485b37,0x000b071c52f8f8d1,0x0004a2f6d4d3e24d,0x000550d8e3ee4168,0x0000161957d91d95}, {0x0001283cdb12a6c3,0x0001fe50e1641963,0x00066cc73bf3fa88,0x000c38c6254b6331,0x0000aefa7aedee8c}},
   {{0x000008037a929a9e,0x000d39fec6bd46f7,0x000ab8b6265601a8,0x0000ce737f5edc12,0x0000497cd963e599}, {0x000387f9aa5b2f93,0x000f37b78fe82fcd,0x0005d5e30e5faa3f,0x0007ebebcf538d29,0x0000a573239d813a}},
   {{0x000286bd17c24093,0x000333264d9be9f5,0x000f6880f2c4e479,0x000e42e77042b117,0x00009b7e2c87ce1e}, {0x000e722d096f4a9c,0x000afed5e697cec8,0x0002319116861aec,0x00037a02d153f06c,0x0000c2f42b8e8905}},
   {{0x000cb51d0a917b49,0x0002b899f93133e2,0x000a2f6b6c2cfa3f,0x0002b722c94f4be9,0x0000707b1820ca16}, {0x000a172d5f8b10d2,0x00052fd4542ab602,0x000996992fd30783,0x0005e1cef226dddd,0x000021fa98a0b0a1}},
   {{0x000fe623b36f9fd2,0x0003dde19fc079b0,0x0008482ef26543b2,0x000824f36e64a095,0x00003f63771bb095}, {0x000d596b6a1142e5,0x0005e35aac0b14cf,0x000081dd55ea6aac,0x00012a36a0e8bdf3,0x0000fb89d79503dc}},
},
{/* digit=4 [{1,2,3,..,}]*([2^16]*G)  */
   {{0x00065fce3779ee34,0x000d7d495d9e0f01,0x000284e7ae00e7f9,0x000218dfa4efa220,0x0000564bade87ac6}, {0x000312ac4708e8e4,0x000b671e9adf90e6,0x000684b9f4f5725f,0x000415a95f55ae3d,0x00007f7ccb15e94b}},
   {{0x000890361a341c13,0x000fdcfd61423617,0x00033316c3604dc5,0x000921d22295eb85,0x0000dbde4ac74af2}, {0x000fc5d1c7eef696,0x0005714f4fa1898a,0x0003c21ca5889680,0x00030aa500216020,0x0000f0d1f30a0ef7}},
   {{0x0008b1dbe7a2af37,0x0008dfb74a72bd9b,0x000879697ec51caa,0x0007d549937a4b63,0x0000c9a9d215c268}, {0x000e44f6ef5f0145,0x0002990c69001773,0x00042161e8abcf41,0x000f29e87bd02281,0x000003937564cb6f}},
   {{0x000770977f7195ad,0x0006ddeb838ffabf,0x0004f012d8ec8616,0x000b3f1a1285a8bb,0x000068835046a3ea}, {0x00024f8309004c28,0x000593ffe95eee5d,0x000223ea4a96e4b7,0x000a528cdffe12bd,0x0000f5c2ee636739}},
   {{0x000333959145a65f,0x00080a4063373d61,0x0008a52a0cd9bc36,0x00058f92d11be32d,0x00006877b2887a1c}, {0x000819bf5cbdb258,0x00085e090249837a,0x000990e5f2a4fd1d,0x00011ae22a7de774,0x000040fa5a0f9455}},
   {{0x00090b36b0cf82eb,0x00057615b5e7e58e,0x0009c145a6438d24,0x0001ca57b1f8fc66,0x00000d8b2dae6f1e}, {0x000dadbd9184c4d2,0x0005d93d997654d5,0x000147d473dbb18d,0x000608ea3e0f56d1,0x0000afa8c8dc0a48}},
   {{0x0008c07e3533d77b,0x00097e341c9926e0,0x0002dc4edd7222e6,0x000cf7ed60ec3d8d,0x0000dfe0d902c476}, {0x0009ab61d056605f,0x000596a8551f1fe5,0x000fb8d8ca9ea9df,0x000b0f9489941e47,0x0000eb874ec3a7f1}},
   {{0x0006aa9bd7638026,0x000005303da1ed40,0x000e62ec4c21486a,0x00033e01ae291ec7,0x000022a04933f993}, {0x0000c9dbb7a8ee0d,0x000b9c01aedb7fd8,0x000be74ecdc2ed3b,0x00071e65c35a1208,0x0000540cb1b169f6}},
},
{/* digit=5 [{1,2,3,..,}]*([2^20]*G)  */
   {{0x000746a584c5e205,0x000169dc7035a7a8,0x000548c9b267e4ea,0x0002f3093a15cfb9,0x0000e6e21359bd01}, {0x000cc6a8c8f936e6,0x000455c241dcdf31,0x0005efb868af84d0,0x0002cb03990a6f34,0x0000fef4e6219b96}},
   {{0x0008f09257226088,0x000a931cf5c6f636,0x000b4f7ac131260d,0x000828c0eb353bfa,0x00005c78880b7eee}, {0x00081ffc3bdf24eb,0x000b45c3c5a84c15,0x0004e6f405bff75c,0x0000c985e8c83fa1,0x000081d1c0fb295e}},
   {{0x000e23d442a8ad11,0x000cf6b9c164f2ef,0x0000aa5e5c3816a7,0x000e6599df2d8bdc,0x000091ae46f220a8}, {0x0007f8700611c5bf,0x00070f1099488366,0x00069595283171ed,0x000a1243a2ecf8ca,0x0000a4a73efe48d1}},
   {{0x0007cc8f43a730f8,0x000bb3ab590efcde,0x00003240be89b6f3,0x0005db4823f529ad,0x00002b79aff18bea}, {0x0002856962fe5de3,0x000b30c591f3568f,0x00028a8580c590ad,0x000f4befc74a144a,0x0000b662498e3203}},
   {{0x0004ed082dd1b6ad,0x000797b703af48fc,0x0005d6aaa5783a13,0x000d425463cb9a00,0x000031ec55d406ec}, {0x000d33f8e9a76414,0x000cc98d9e7a9f8e,0x000887493625453e,0x00056663beade4ec,0x000042b80509a795}},
   {{0x000cf0d6c39765a2,0x000d8c3cca0b91e3,0x000953b50a2db3ac,0x000f1a088f2f08cb,0x0000414582cef43c}, {0x0008bbc60eee9a8a,0x0001d29aa0428dec,0x00032f5d554c79f0,0x00015f381cd5ec65,0x0000672303b6f82e}},
   {{0x000582d3bfab839b,0x00037f8adade46df,0x0007a1bc392474e0,0x00097886a7766a14,0x00006940f54bdc0f}, {0x0008ef2f2759f255,0x00095719f4c64473,0x00050c3459dd9578,0x0000d4d859b7f407,0x0000e788bf302218}},
   {{0x000afa8719c05631,0x000cac5fc79f376a,0x000750cd3cd8ad2d,0x00008e203fdb9fcb,0x00004ff052f5418b}, {0x00084cf3e2d65208,0x0007944ed509f750,0x000f25b987ebdf0f,0x000837743bf0f2d3,0x00006ad71d02354d}},
},
{/* digit=6 [{1,2,3,..,}]*([2^24]*G)  */
   {{0x000c8c4868af75df,0x000e55c8c7ead9d0,0x00081ecb0d7325cf,0x0004ecbb471996cc,0x0000f5d55f451182}, {0x00045411977a0ee8,0x0004f22038c6be31,0x0004bb4955085c4c,0x000081ad5335bff9,0x000094ad8a748e2a}},
   {{0x00034b22c11bb373,0x000dbd4c74a35402,0x000c5f25d2d0366d,0x000142c9a968daee,0x0000660106897b63}, {0x0006d2c68d7b6d44,0x0008cc84294207cd,0x00068b1eea8f74f0,0x000ee4a275140477,0x0000b5f7e8a3e62a}},
   {{0x00059b21994ef202,0x0009438ae318d1e0,0x0006990102a653b6,0x00084a50d5eb582f,0x000079739f729f5f}, {0x000663c8b799336a,0x000c803c37eb5da4,0x000dbfb2dfdfdf14,0x000f9a92d8a9dca1,0x0000b40cff117d48}},
   {{0x0009f0b879fbbed4,0x00069a9d1869f236,0x000766f450ff0ae8,0x0000fc1251d75956,0x0000984d8c06be8d}, {0x00095a6d21008f03,0x00000a1a1c497ecc,0x0006c50f329bd54a,0x0002517b9828c5d2,0x00002c0087c81d0d}},
   {{0x00090abfbaf50a55,0x000b184e0750f617,0x00076b005df55e76,0x000dc79c516da7f1,0x000075553bbca2dd}, {0x0007ca3553afa736,0x000bed55c25137c8,0x0003e5d35315f3ff,0x000f288846442aaf,0x00001b91149c495f}},
   {{0x000eb6662b5f3af3,0x0000dabb373447fe,0x000f35cb1cefab56,0x000eb9149de60e19,0x00009f8db14457f0}, {0x000cc5b3c61bfd60,0x000d41216703ffae,0x0004e1cc2a5a4d41,0x0009537f8fabed22,0x0000d5a8186871ad}},
   {{0x0003a4956f908239,0x000fe41d777b4bdf,0x0008bf760ba0f507,0x000b01791d71c3f3,0x0000633d5102b625}, {0x000b743b8c9de617,0x0003ede7472003ec,0x000ce1cb2b475125,0x0002ef2f9defc974,0x000074a4f6a70bd3}},
   {{0x0008ea601799a527,0x0001486d2952190d,0x000ff2a7ca20cec4,0x000d36c062ffb27f,0x000041b32e5e9f19}, {0x00081814eb57d471,0x000406aef06bf80d,0x000ecb5887a2d0ed,0x000f5af9735fb01c,0x0000641caaad6061}},
},
{/* digit=7 [{1,2,3,..,}]*([2^28]*G)  */
   {{0x000824f20151427a,0x0005f24302067f99,0x000112357206828b,0x0004ec0a9097d7e1,0x0000cf9a2f2a9e41}, {0x000c9da279153564,0x0006c01efee3dbda,0x000b288e27e0734b,0x00009c14fab5bbd2,0x0000c630fc5362dd}},
   {{0x000107a1ac2703b2,0x00084bc857b58537,0x000daccd1b49258d,0x00052937df14debc,0x00004ab68d7e4ae8}, {0x000b5d4734e59d08,0x00084495cc807ed8,0x0001db9b35f8740c,0x0005be04aedd5a29,0x00000b360f8cfb99}},
   {{0x0005f5d5fa067d1d,0x000ec668960cae91,0x0008edaac4134b57,0x000435ed3656d6a4,0x0000ac1e3e5cc1d7}, {0x000f869d81fbb26c,0x000bf26c33d4674f,0x0004203e8449ed3e,0x000f49c5138705d9,0x0000cde538c7eeb6}},
   {{0x000c68da61a76fa3,0x000d9a1554dc55d5,0x0003b279c598b441,0x000efca39923b977,0x00003331d3c66bf9}, {0x000848e298de399d,0x0006d1a27f562d4c,0x000b8ab70cfdb8e7,0x0009b9c4c855ea57,0x0000cdb9daf3f787}},
   {{0x000f8c2019f2a596,0x00036b4fbc747bdf,0x0009173ddb3ce5bb,0x0004398a907f688a,0x0000cd3d0d3f5a75}, {0x000c4d6efed021c1,0x00005a77339a92ec,0x00088c64a09a9f9b,0x00015877ca6b1571,0x00000c2996854899}},
   {{0x000a229ed6e82ef1,0x000355ebaf4e5859,0x000ad67ae16f338e,0x000bb3fcd313875e,0x0000c73d22864ef0}, {0x000513174a5c8c7d,0x000faf69ad6a4cb5,0x00066f87e01cd296,0x000320d04d00dde9,0x000096fe447db7b0}},
   {{0x000c06e88fbd3813,0x00042c35a493342a,0x000f1bbcd02cd4a8,0x000d4cb8fa89de54,0x000041d63675575e}, {0x00057fbd238202b9,0x000a1984ead9ebe3,0x000436ea0600b4d1,0x00051b335c9f4452,0x00006fe0a3a33707}},
   {{0x00007367f636a38c,0x00064e76d5cb4c4f,0x000b68b8b9f943fb,0x000a1ef03510baa8,0x0000246780b5ed07}, {0x00014156d549fc2b,0x0000b07781ca3c05,0x000d95413c2953f3,0x0002e2e55e2c69d8,0x0000300fadd2bd28}},
},
{/* digit=8 [{1,2,3,..,}]*([2^32]*G)  */
   {{0x00086024147519ad,0x000b56b372f02028,0x00085ebc8d0981ea,0x0008e8d9d4a7caa7,0x0000953c50eabdf5}, {0x00061ccfd590f8f8,0x000ac4e6c9179d63,0x000eb64cf72e9626,0x0008f2ffd9611022,0x000063ebb7f1eb28}},
   {{0x0007cf5678a31b0f,0x000d4998b620877b,0x0000fb396d50301a,0x0002a5834257c5c0,0x00009fb18a0f4e67}, {0x000d8ebe8758851b,0x0005ad99ba44ff8b,0x000fd93b71e64e4c,0x000b8b9b8eaedf7d,0x0000a2f2a98b4e76}},
   {{0x00007e0e90fb21e5,0x00006ba7fca1a18f,0x000cd67b500fd2b8,0x0007f6d0387f2795,0x0000b89a4e823970}, {0x000ad3f894407ce5,0x00041c2261328f83,0x00006c13ba0025b9,0x000025779563c7f9,0x0000f548f319e7bb}},
   {{0x000d3a7c35d87949,0x00077356bae50ee6,0x0003322fd042e655,0x0009670f59698d64,0x0000379ae15e0a61}, {0x000ae62fcc9981ea,0x0000cd2934c664b9,0x0004e65ebaed3d63,0x0004278454b3025e,0x0000b09f64899950}},
   {{0x000d3d331b85f091,0x000a988ae64ac1b3,0x000ec50fd0f45354,0x00034f98b626d32f,0x0000bdcfbd4f8288}, {0x0002866cd5225391,0x0002710f7ab3e45a,0x00005f293fa9d473,0x000597c8c1d6b4c9,0x00000ac80474461b}},
   {{0x00015366d91cd2c0,0x000adaa3f0e4e2c8,0x00041e08340a2bee,0x000347fb167a5924,0x000004675e9e9240}, {0x000aaff840e446e0,0x000fea308f727848,0x0009bfad99f9f258,0x000af650f1289963,0x0000939ae63205c0}},
   {{0x00075146fc627e20,0x000591573a51bbb1,0x0008243d5a0569bc,0x000692a7016d9e35,0x0000dac0c56ac1d6}, {0x00033b5da590d5fc,0x00031e8174919938,0x000bf75d0a806780,0x000cfaa5b4f2124d,0x0000c9602338cf80}},
   {{0x0003a1222248acc7,0x000ec264e366b208,0x000fdee281f6ec0e,0x000bb4e659b7045a,0x0000a823a4156430}, {0x0002a04e1900a791,0x000ab9ee65762459,0x0005ea54acde09d4,0x0005a742b6463f4b,0x0000efe9ed3e3ca6}},
},
{/* digit=9 [{1,2,3,..,}]*([2^36]*G)  */
   {{0x0006dbe305406dd9,0x000f4d5d1957e27a,0x0007d4d8f8eb7dc7,0x000de4654a687638,0x0000c47940a57762}, {0x0005b5d99b307781,0x00065e793682be4d,0x000c740e325380c5,0x0004ae502d37f3da,0x000040deabe2566e}},
   {{0x0006126c49a861ec,0x0005214f0d06eaee,0x0009bfc17024f3b6,0x00038091a3f1e8c6,0x00003c3a8ea67686}, {0x000752cb103d4c8d,0x0002c218b36b3400,0x00051504a02bc461,0x000bf9f67f75eb76,0x00006848b57a02ae}},
   {{0x00081db1782269b6,0x0008c597e5509583,0x000385153ae34bf7,0x0000485b5c60645f,0x0000f0e96b043088}, {0x000021577884456e,0x000b89310ea7bf6a,0x000fad2deb3b5688,0x000d4c37c9429504,0x0000020f0e5f7896}},
   {{0x000428dbbe5a1a9a,0x000e9126bd67cca4,0x0001058268187fd5,0x00019f6036973a48,0x000039b666458bd6}, {0x000deef2d65a8087,0x000f24636b196d42,0x0005d564c4969044,0x0000778611ee47dd,0x0000b2f3a4a42873}},
   {{0x000d8dd0f82b2148,0x00097103cbc603b0,0x000d79e19460c34f,0x0007f8732e5c0318,0x0000b8888bb28411}, {0x00037dcc07226779,0x00088c1c0f278f3c,0x000f7a0c610d21be,0x0000e0447c8468e0,0x0000bf022143decc}},
   {{0x0004160b7fe7b6e0,0x000a400a3fb29755,0x00028ca1e7d16189,0x0008ccd73e9beae3,0x0000dd04b97e793d}, {0x0003c9b506db8cc0,0x000ecf38814ca9c8,0x0004b45e65cd47aa,0x000a8426fc430db6,0x000079b5499d818e}},
   {{0x000d21ae0ac29416,0x000462d3193703b5,0x000c992d0279b025,0x0001f2d307c052ca,0x0000aa7cb934fa8b}, {0x00025800d37c7a50,0x0007342d54225a18,0x000d2ef9213380c3,0x0003c692ac2d66d5,0x000035a70c9030c6}},
   {{0x000b78571ba18615,0x000c80c8f93d5109,0x00033bb9348b22d5,0x000d0898fa84a786,0x00003fba6baaaebb}, {0x0007df3e5eea7d82,0x000648ca71587ff2,0x0006f1a05521c879,0x000ee499d5133bce,0x0000d50cd541d0eb}},
},
{/* digit=10 [{1,2,3,..,}]*([2^40]*G)  */
   {{0x0006d65533ef2177,0x000453ca2e87889f,0x0002b41677158c7e,0x00057f8b670dfbdc,0x00005910a01f44c2}, {0x000bf07cf88577d2,0x0000c45e2acef336,0x000a23d852224525,0x000f580ed92e8d7c,0x00009f8be4c4b812}},
   {{0x000b2452133ffd9d,0x0000b30f1a20fbb9,0x000a1f52a39a8b2f,0x000df7784bc97dd5,0x00006aebf57740ed}, {0x0007acb76ccdac60,0x000c1586ff273225,0x000de7dd1af4d36e,0x000c168eaa8863f8,0x0000045d5cf88647}},
   {{0x000414351facc618,0x000d668a25bcc51e,0x000f872edbaf2647,0x0006590f5271a00f,0x0000f32ef99bd2d9}, {0x000488c7593cbd4c,0x000c42b82fabca12,0x000eb3f16ed266c5,0x000fe24a2f78ad14,0x000034049490d47a}},
   {{0x000d574c005979da,0x0001ca40e350a6f3,0x000e2ecf9c2072b4,0x00044e5ca5c1568d,0x00008c8bf5c45153}, {0x000e555114df14a7,0x000d8dc5ec6b97ae,0x000a85418d4374a4,0x000f78054cc28f2c,0x00001cb9e2843c41}},
   {{0x0006702094704963,0x000dbbd2381509c1,0x000dd4398a489a5e,0x00069694dde4648e,0x0000ca7b94ab0111}, {0x0005d682ad636a41,0x0004f8dc5f1e3c38,0x000a219436702702,0x00069dfc1965deaf,0x00008666e16710be}},
   {{0x000fd350369c8e10,0x0002b9dc843b6792,0x00002e2ab9271aa6,0x0003838711a4b14d,0x00002b2a3e27ee1a}, {0x000e35f0e2b379be,0x000bf652ab25b226,0x0005601063d3de39,0x000876cca6d4c93b,0x0000ced0cf5a95bd}},
   {{0x000b4ca2a604b3b7,0x0003ca61676245be,0x0008b806e56f6518,0x000480852f5a7097,0x0000aa3978781dc4}, {0x000ac2a0e01fabc4,0x0004e37d99f9e13f,0x000211ffe7c6ee8a,0x0003eae51384ee05,0x0000ff6976d5bc9d}},
   {{0x000507903605c397,0x000e3142c96c8910,0x000923684f0843d9,0x0008938374493416,0x000032caa306a0a2}, {0x000c27061160170e,0x000b637fbaa3b2e8,0x000eda3acc32788c,0x000e0659cd818ea6,0x00002e9423a7e2b2}},
},
{/* digit=11 [{1,2,3,..,}]*([2^44]*G)  */
   {{0x00075455922ac1c3,0x000c752b3f638df2,0x000de57c4a7b3ef5,0x00008b5e77b21471,0x00001682c10b34c0}, {0x00024f04bd55d319,0x000587b61c71c768,0x000a5089db6d1c08,0x000d3ea1db0903c2,0x0000c092172a84e5}},
   {{0x0005035ea6c39976,0x000a62610bef5ace,0x00080dd3954259aa,0x000a398f18bb3f3c,0x0000910b95bbfc3f}, {0x000f51043e09aee6,0x000f47675665fce2,0x00072db61ced56c9,0x000e68b0e265acd8,0x0000982812f0e9fc}},
   {{0x000b690768fccfce,0x000cd835b362ca2e,0x000fdfccef402d37,0x00098f2efac0d0e2,0x0000fc9cdf09638d}, {0x0002b72d1669a8bc,0x000b9774ccbd2af1,0x00034870e33c536b,0x000ac970b21909fb,0x000038fa2f83df25}},
   {{0x0003d931341ed7a4,0x000c67b59d49b8fa,0x000b8c4a44223272,0x0002e3fdcb194783,0x0000e413c022d130}, {0x0009127e17e44ceb,0x000483b3adfb6d99,0x000aa96caee86bf7,0x00047d46902fe625,0x000073540e595aae}},
   {{0x0005e75b2c69dbcc,0x000843c3da6c7bfc,0x0009102713aa77a2,0x000c551e0df03cca,0x0000bd5ca4b3806d}, {0x00058076db476cb9,0x0001cf37a31ee1ca,0x0001af416fde15d6,0x000db5649af520f4,0x00006c5c5b20d342}},
   {{0x000ef6c872b4a606,0x0003e613521bcc50,0x0003e15d1ab2a34a,0x000511d9c5c19098,0x00001dde5dfb9905}, {0x000f6219f2275f33,0x0006151d894be417,0x000b0bdaa0750c8b,0x0009bd45b04ab978,0x0000bfd9fd475858}},
   {{0x000e02adb22b94b8,0x000921eaa45bc792,0x0001e1c63993d8ae,0x00088a0aad6cd3cd,0x00009529ca845ce6}, {0x000e3aae572a2530,0x000802a21efb2cce,0x000430358e02b643,0x000504a7091b6ec9,0x00006d1b1fa9d7db}},
   {{0x000bfabaf95894c5,0x0006d76b2241aafc,0x000dda48b7b9bdc0,0x0004df9af983625b,0x0000977faf2f3fcb}, {0x00042ef052c4b5b7,0x0000967591f0bed0,0x000f24ec79fe87f7,0x000f1b589c73ca22,0x0000d37fa9f564a9}},
},
{/* digit=12 [{1,2,3,..,}]*([2^48]*G)  */
   {{0x00064880a750c0f3,0x00031e548e83cc7a,0x000110f0539bacfe,0x0005880d418c760c,0x0000e4daa4ce1f11}, {0x000e7b55ffc69ff6,0x000c320531272733,0x00022df9446f147b,0x000b7c285b2434d7,0x0000a444f6646fc6}},
   {{0x000465ac3f16ea83,0x000d82f1d11c7a1a,0x00068a172115a461,0x0006981767dd956c,0x0000392f2ec013a4}, {0x0009ccde526cdc7f,0x000b32292b81c7a9,0x000d391988e537fd,0x00052c86d8cf69a6,0x0000fc5ff4414468}},
   {{0x00016f4bdaedfbdc,0x000fc6746ced6d0b,0x0004b3e1723fd325,0x0004c7cbfb1d2fff,0x00007f2ec2dc19c1}, {0x00032f245104b0d2,0x000b8dea2b7e3e08,0x000fbfb0f5f00daf,0x000cda09e5cf6699,0x000064f972381827}},
   {{0x0004f7ea90567e6d,0x0006e6ae5cb797b1,0x00010903d513257b,0x000723b5454a3c9f,0x00008d2c9ae39bc3}, {0x00093246b29cb44f,0x000c87c8cbac38da,0x000918e42b540a21,0x00014dabbfe43501,0x0000ffa707b46c36}},
   {{0x000a2f3e30bc27ff,0x0009c08365116eb1,0x00065ab0ee5f0c05,0x000bbc5d741bbf49,0x0000eec41cb73464}, {0x000705f99d0b09f8,0x0006742da5fa1aca,0x00052b931c5d6cc5,0x0008d7c9964eddcc,0x0000ae596164884d}},
   {{0x000e3f1d4e353b7b,0x00043f46b0a00ce4,0x0004b73fd062d8a1,0x000ffcb408d5ab57,0x0000c41d1ca83273}, {0x000e1e76be77800a,0x0007256550313538,0x0009b331a71fe8b3,0x000f727cd916216b,0x0000d825d0c5b388}},
   {{0x000b57b39f8868a8,0x0003f5cc69aff634,0x000d5496ee27f4fd,0x00007f247e58cbd0,0x0000a2679405323e}, {0x0009b72fa30f349b,0x00090696d134c61a,0x00080a6d194c9d9c,0x000994c92beca858,0x0000dcc46465f039}},
   {{0x000e05b1cb76219d,0x0000a1567e7e56c2,0x000c4c9100ec0bf9,0x0004d917076f8661,0x000067b085c8abc0}, {0x00004595e93a96a9,0x000a6bdc249a9fb9,0x000dd0bb77526c1e,0x0006947d44d367ec,0x000053999182dc0d}},
},
{/* digit=13 [{1,2,3,..,}]*([2^52]*G)  */
   {{0x0009167ceca9754a,0x0005ab7939a083f4,0x0003fd0bf426d2cf,0x0004e18555e35572,0x000096e6d0764f14}, {0x000a8dd87880e616,0x00058508e4d54768,0x000b65e151554381,0x000f9fa9d7e772b1,0x00003439dd70c302}},
   {{0x0003145983c38b5e,0x000b837abc8b859d,0x000ff7be6b14f176,0x000a594793fb9dca,0x0000be5a56015a66}, {0x0001dcd9f87dc596,0x00039bdbf5607cec,0x000eb32577c595cd,0x0005fcfb543b2226,0x0000908064724c93}},
   {{0x000688eadd70482e,0x00099b4a4e8a6aac,0x0008a6eef708de92,0x000c4295b6dd7375,0x0000a4bf353525b3}, {0x0001f2c87912868c,0x00052f09297a1004,0x000f3860ab1b1be9,0x000f4a59ae23c5a9,0x00004f0f83a115dc}},
   {{0x00052381d531696e,0x000fa8cdde69b934,0x00086afc757201bf,0x000ea7fde922519a,0x000030438969d35c}, {0x000c1e18555970de,0x00084535935e7608,0x0002ea38b8267dfa,0x0008b4f4c60a5732,0x00000bf7978604ef}},
   {{0x000049f16a66e918,0x00007a1b0e0dd730,0x0004c28eae97f282,0x000c61c131e00330,0x000020ab732d26ba}, {0x0009ef9287144234,0x000a6db10cb2b2ac,0x00086a4cc54ecfff,0x000d494781476ef8,0x0000b2c87b61b2f8}},
   {{0x0001d4286d2e0f86,0x0001ae8a9fd56ada,0x0008c1b49e592012,0x000afea2c936af70,0x00000f30fee8b4bf}, {0x000ad06858e6a61a,0x00069fd374d06637,0x00088defbce4c776,0x000b6599d54b2d71,0x00008c9d251956a6}},
   {{0x000c0965f5206989,0x000db4f7b8d90e6e,0x0005a68b9640631f,0x000f4e02fd34fca3,0x0000c5a4b66dd40c}, {0x00054bf80b6783d1,0x000e2a320a109494,0x0000a39b280e701f,0x0007db7d1a564a1a,0x0000436d53d42058}},
   {{0x000ea68c094dbb56,0x000e7968d4106233,0x000b3002db77d062,0x000d57de719bbc58,0x00008e7dd3d9dc49}, {0x0005740013a5e585,0x0006ec9e3c1b8d82,0x00099b6ab2131174,0x0008f1bcb0a2a77c,0x0000c48a3b412f88}},
},
{/* digit=14 [{1,2,3,..,}]*([2^56]*G)  */
   {{0x0003e91991724f36,0x000bd9cbd686c791,0x000d4fc1e5eda799,0x000d547db595c763,0x0000b63b80c0c4fe}, {0x000fc697e5fb5166,0x000a70f1c9646ea0,0x000a92ca5737708b,0x00067a3628745f11,0x00001f37958fa869}},
   {{0x0009b2caa6650728,0x00046fd324ef9af3,0x00027bd3178322fa,0x000aafbd153394c3,0x00001d5f271b129d}, {0x0000c42f48027f5b,0x000bd536e717c72e,0x000369d0faa40cdb,0x0004e6445a657a2d,0x000003bbfc59a7f7}},
   {{0x000c4180d738ded3,0x0000b0de572946a8,0x000a816756f1a5bb,0x0003d4c10230b98b,0x00002c6f30c412b3}, {0x000129dd8fffb620,0x0007b459bf057559,0x0003b67766a281b4,0x00073a77c1bd3afa,0x0000709b38078299}},
   {{0x000b232a3326505c,0x00022e1d41bf8c26,0x000e32afa38d6927,0x000a864459453eff,0x0000e8143ae3cb3e}, {0x000c1fa7e6ab6665,0x000fd2286264932e,0x00036f8ed6cd2d22,0x0005baf59a46fe67,0x00000bf0d00eeca8}},
   {{0x0005852877a21ec5,0x0006bf537a940b82,0x000a9a6a2300414a,0x000bffef1cba4021,0x00000824eeec6943}, {0x000fcecf83cba5d5,0x000843b4f3c0a0db,0x000f24dd7f953814,0x0009dd1174416248,0x0000322d64e34fb0}},
   {{0x00073843d9325f3b,0x00004371cb845744,0x0001e36c5a9bef2d,0x000f71c7d2188ba6,0x0000bd6a7d87602d}, {0x000a9028f61bc0b8,0x000ceed0b6a1ba3a,0x0006e8298f49085e,0x00001d0bc625d6ae,0x000032b0b1e22e9c}},
   {{0x000c447f1f0ced18,0x00031492dd2ba337,0x000a08efa800cc79,0x00041dcb93151dbe,0x000020cf3f95e0a7}, {0x00082dc1c0f7d133,0x000054dde6caff19,0x000f96ee3ef92196,0x0000c6ead7d97245,0x000019c8dbe59dea}},
   {{0x00038717b82b99b6,0x000ce70eb624d3ea,0x00095d46675922d4,0x0003462f66ec543b,0x00006e673cd1ee1e}, {0x00067c4b5f2b89a4,0x0005e90e5cd36afe,0x0000a2ada3de9c1e,0x00023b4c278bb631,0x000020fa3844bdb3}},
},
{/* digit=15 [{1,2,3,..,}]*([2^60]*G)  */
   {{0x00096796424c49b9,0x0007d7c241c9646f,0x000f68b49f888dfe,0x000f20512d4b9324,0x0000a6b62d93571d}, {0x000b26d179483cb7,0x00022511fae281b4,0x0003aa51f666f963,0x000d166281b3e4d5,0x0000f96a765ef3db}},
   {{0x000d37c051af62b9,0x000a7bf944968553,0x000d59aa1e9a998e,0x00081350844f9fb0,0x000083fd55976afb}, {0x000c0ca65d698049,0x000ddea5ff2d9670,0x000d8623b732b22d,0x00078247640ba95f,0x0000f61916436351}},
   {{0x000b4e0bdefdd4f1,0x0005e366e401f167,0x0003bbec06995846,0x000c214aa368aba7,0x000021487098b240}, {0x000323318969006d,0x000e11fe53d1378c,0x0000c4361cb4d73c,0x00012a8f50a80e13,0x000067f59524ef52}},
   {{0x00081088cad38c0b,0x000fbbd68ae2332f,0x0008e27a3471b7e8,0x000b0ca6ac3fb20d,0x000054660dbc36b4}, {0x0001e11a6fd8de44,0x000a637799ef123a,0x0006ac17c44dbffe,0x000cef0540b977ce,0x000095173a8ef60a}},
   {{0x00037434573eab0b,0x000b21ac6031eb44,0x000dd9afd11570df,0x00023147d9b45b44,0x00008066addd2067}, {0x0002ad8f8a3f0b44,0x0009a0ace2a215f9,0x000b38b809e0e489,0x0000527dcd0aadfa,0x00006506ae957020}},
   {{0x00069f78fca399da,0x00016207bb63429a,0x00088f582fe9e27d,0x000f6e4c655ed687,0x0000426d7494db75}, {0x0005c02ca81c66da,0x00070531d4251869,0x000ff48ba84fb8d2,0x0002469a3a8956de,0x0000f1d0d57166d2}},
   {{0x0009565352c4b5c2,0x0001390bc3e25a05,0x0006f9f5f4926153,0x000a9b609f7521f6,0x0000baef6bfe70a4}, {0x000fa6509ed3561b,0x0002e84b230ce7e6,0x0004cdc691137023,0x0004157151659bd0,0x0000db83c64a007d}},
   {{0x000284d391c2a82a,0x0002758308e89ebb,0x000f1edcabcdd486,0x0006c7606f16ec83,0x000013e2c38095dc}, {0x00056f04a057a87a,0x000006b48f982ab7,0x000651c44a876550,0x000e01a252face68,0x000052b540c81765}},
},
{/* digit=16 [{1,2,3,..,}]*([2^64]*G)  */
   {{0x0002fc516a0d2bb2,0x000bfa6234994f92,0x000c62c8b0d5cc16,0x00067f7241cf3a57,0x0000f5e69621d1b6}, {0x000c70bf5a01797f,0x000c709561925c15,0x0001fdb523d20b44,0x000f7a14911b3707,0x0000648f9177d6f0}},
   {{0x000c8b8fac61d9a1,0x0002d3c6fe8a027c,0x000bff5037d25e06,0x0002f7d08805bfe5,0x00003271e6c7ff63}, {0x000a6c0232f76a55,0x000d201ef42655dc,0x0000a51788957c32,0x0001739e728bcba1,0x0000ea60412062c5}},
   {{0x000914bb5def9961,0x0003133dd1e74090,0x0003d5e761cb69c8,0x000012b1e9c1d39b,0x0000f3338ee0ccf6}, {0x0005d0d2f5378a8d,0x00065f00cd21b1e9,0x0005fe290acf4c2c,0x0008ad9e984240eb,0x000066c038df4808}},
   {{0x000462bb4d8bc50a,0x0006091957709ad5,0x000412a68181c0b1,0x00048c4bd4fe1c78,0x0000e0341bd60dff}, {0x00045cf7003e8666,0x000a2a24a41bb6bc,0x0004c24c2f11a6de,0x000b67f407151ad0,0x00002c9d27e3a5b7}},
   {{0x0002b30614c09004,0x00017d00c24bd499,0x000c4bfa1da98d12,0x0004bc3f534dc87e,0x0000a5ff67477dc3}, {0x00096b81d7ea1d7e,0x0002a0a6d20868c1,0x000cbbd6e38cf289,0x0005b61d56cd09e3,0x0000c72e27f2205a}},
   {{0x0005719a8afd30bb,0x0007da826dce3286,0x000a8fbe08679832,0x000ad32f04e891c4,0x0000b6b6e1c9bf56}, {0x0005b11471f1ff0f,0x0008ce15baf00a69,0x00096c43ed76c338,0x000157118edb95be,0x00002beaaf580794}},
   {{0x0007932b88756ddc,0x0002317e3e61e8b9,0x000e1c4a4ed4e865,0x000c0e02dd14993e,0x00000aaee18197f8}, {0x000edb96c168af3a,0x000f139ae87515c4,0x000adb4366563c7b,0x000ac00dfadb6f20,0x0000d55e8ca3a042}},
   {{0x000b12e523b8bf60,0x000b8f910c1b0a50,0x0001675888009eb5,0x000abdf535af824a,0x0000f835f9cfb2a2}, {0x00029312afceb620,0x000a169d383ff59b,0x000ac02b0c797df2,0x0000caeb3f5fb066,0x000029d4c6fdaa2d}},
},
{/* digit=17 [{1,2,3,..,}]*([2^68]*G)  */
   {{0x0002010f5b343bcf,0x000a02f142fe58af,0x0005f4bdf0f2e400,0x000aa84483bfdea8,0x00000b1d093f3bfe}, {0x0001b95c70816030,0x00093dba10972ea0,0x00038f3a6e943e4c,0x00063647be92adb4,0x00000bb7742e5bf6}},
   {{0x000481b7bfe71786,0x000e05405868b674,0x0008c867d4e1deba,0x0000e9a61b2821c4,0x00009c15b35b13b3}, {0x0001666368710884,0x000cd220b1ff3b4a,0x0003d9f4de5e29f5,0x0006750b82bb3523,0x0000e07633358cdc}},
   {{0x000c39731815e696,0x00067cdd28023a63,0x000b4f6af6df9cbd,0x000977ec47ed4a15,0x00002009d82cac0f}, {0x00080d28b898fc75,0x0009dc17c91f664d,0x000ae660972f1eed,0x0008954e84d3bc7a,0x00008c7c19578376}},
   {{0x000f5c7a3e6fced0,0x0005f45fbdeb0d53,0x000339a70e8cbbdd,0x000b81f85c01df13,0x0000ff71880142ce}, {0x0008774bd70437a2,0x00019a0bda6a4c4e,0x0008bd26e5fb3289,0x000521fcdbebd2f1,0x0000f9526f123a9d}},
   {{0x000c905a8271d7e9,0x0004c8e5810ba752,0x000925aeb4735dfa,0x000853518a44ee5d,0x0000708697fa3c8a}, {0x000d540bfcc9a0be,0x000c0574d4038377,0x00060a8a67b27e01,0x0008be5d3d180ccf,0x000048ef153d1c29}},
   {{0x0002e8c0aeaa3c09,0x000e1be85b0a313a,0x000a97d3a89f46d9,0x000cba42889ebd2d,0x0000484026aa03f8}, {0x0009f8a87d83b5f4,0x000671ef02955215,0x000c01acfdb2220d,0x000fe37da0746e03,0x0000f97b2a754419}},
   {{0x0007ac2c880e5cac,0x000dcd11c450ccbf,0x00077a6bf8299dbe,0x000792fb27d11b0f,0x0000601630c1edce}, {0x000b9fb79e7f8ea9,0x000764367288db73,0x00035571be448bba,0x0001a265b6416fb0,0x000081b8f5e34889}},
   {{0x000305192c4d6840,0x00057612efcd40ce,0x0009cae208b04d72,0x00056cb9dcda366f,0x0000edc4d24f0588}, {0x000e6bf854279005,0x00058c09dfea64f2,0x0009bf26c3de8129,0x0005a9841b448737,0x00000b62c6dbdf13}},
},
{/* digit=18 [{1,2,3,..,}]*([2^72]*G)  */
   {{0x000fb5ed005832ae,0x000ab1042e4f0db2,0x00070f8ca5f5efd3,0x0009cbac4ffdc6ed,0x00004645d0c952da}, {0x000f58bc9001d1f8,0x000bce1172059596,0x00098a08452c8f0b,0x0009de7d4aa0d2e3,0x000015bfe3a904f4}},
   {{0x0003acce548b37b2,0x000264d4054954eb,0x000341b4fb38e754,0x0007fa6c3daa517b,0x0000f6928ec890bf}, {0x000b32386ce6c413,0x0004e0adadcd0496,0x000b5faf901be1c5,0x000985904e67e74b,0x0000cbaf679115c9}},
   {{0x000226ad7ab9a2d8,0x000cfdfae958524d,0x00051d8c29c00090,0x00062c8ba5f53987,0x0000afcbcddbab82}, {0x0002729e99d043b6,0x000b4ebc943a5739,0x000862935ef51263,0x00017b3feace9320,0x000039efc04106c8}},
   {{0x000be7d341d81dcf,0x000842148379e839,0x000026eadcddb688,0x000c5dea6211a1f7,0x00003b25760e4d1c}, {0x000c8f6a7a73ae65,0x000e11d5b48340cf,0x000a50ebc83879a5,0x0008fa75acb1ed41,0x00009a60cc88c07d}},
   {{0x0008d4ac3b819900,0x00029e0cc8fedec9,0x000b427b91cb8372,0x00066cfe0b0491d2,0x0000f2386ace983a}, {0x0004d1eb32912137,0x000de9a62ae4930c,0x0003e89e3a2f82b2,0x000c7f07233853f9,0x0000f8063ac81777}},
   {{0x000c97c593710000,0x00007f759c18604a,0x000db6b65e1c48c7,0x0004953f62ecc5a5,0x0000a78b17338a21}, {0x000819dbcc8ad945,0x0006889c34006be1,0x000b4840a70dc04f,0x0001bff62557b4a6,0x000044c6adeb0bd2}},
   {{0x00007cf02ff6072b,0x0008dad98cdc36e6,0x000f56609a47d2ca,0x000da00f471d1ef5,0x0000cf86624a264a}, {0x0000687aa9e5cb6d,0x000147401c6cb70c,0x000a61435c98124f,0x000ea5b189635fd4,0x000028fb8b079d98}},
   {{0x00030b665c7322db,0x000103c1b3fb4395,0x00072f685cf12cc0,0x00091d170b018601,0x0000915ee22cb583}, {0x000f03ba317db248,0x000897b8ffc49afd,0x000d3d05087dec65,0x0000e6ff46597be4,0x00000a1c1ed80650}},
},
{/* digit=19 [{1,2,3,..,}]*([2^76]*G)  */
   {{0x000a7b397acf4ec2,0x00003ea8b6403e22,0x0009692850426c40,0x0006703e3295a64e,0x00002aabc59c6a45}, {0x000714c5f5942bc4,0x000dba3182edb929,0x0004152ba9a6168b,0x000367e216a66510,0x00006908d03f6926}},
   {{0x000d8745a1251fb6,0x0008672725c7a9f5,0x000ffe89e967747a,0x00035db95c33e531,0x000009d211049649}, {0x0006ca82fe122271,0x0005f426469dcafd,0x00093183caf9b5b9,0x000fef1e9ee04c56,0x0000084a333d8146}},
   {{0x000b88210395755c,0x00039ec1df80ce06,0x000f55e96117ce63,0x000d1e3efae513ef,0x0000f36cba7bd7fe}, {0x000eca9a40ebf884,0x000f73d37e127340,0x000bbf9ffe6ec1bc,0x00005e8a51b64e86,0x0000e0dbb58cb40e}},
   {{0x0009933aed1d1f71,0x0003405630909664,0x0002e39cf566eaff,0x000124245057f0ad,0x000048ff65b2f832}, {0x00089d4cf94cf0dc,0x0003920c58b3042e,0x00061aa0d319bec8,0x0007ac6a26762653,0x000086fa3034fbc8}},
   {{0x0007b9c7ea2ee345,0x000bb9cc3a71359d,0x0001ea37a3fd0d94,0x000c876b53c31c3a,0x000033425fb1f818}, {0x00099c3810156e0e,0x000350c164487cd1,0x0006425420ea020e,0x0005ea0557ba094a,0x0000657e7e87465f}},
   {{0x000d2ab5c8b06d5c,0x00023e4eac46fc83,0x0006f7779b1a785a,0x000504f99315bc84,0x0000f31d817af9ea}, {0x000fe6a15d7dc85d,0x0003e4016b332391,0x0001cb4c72f132b0,0x0005a059547fe318,0x0000b66d8a735015}},
   {{0x0000e8b593d070f7,0x0005e255625d59cd,0x0007a03994375751,0x000eeae51fdda75b,0x0000bb6e6b09dec1}, {0x000b662334c0922f,0x000e1cf41b79729b,0x000f324023df631d,0x000c8711abf3c578,0x0000cb4666d8cd33}},
   {{0x000d7e1adc1696fc,0x00024acd72d06b66,0x0001b743598ebe59,0x0005eba5f24550cc,0x0000e23139474b9a}, {0x00022d4db067df91,0x0005baff9b00234a,0x00000c9c198dda09,0x0006950bbc75a061,0x0000560a9c8a39cf}},
},
{/* digit=20 [{1,2,3,..,}]*([2^80]*G)  */
   {{0x0000f1cf1c367cab,0x000b190fbc7de405,0x000a110329bc85a9,0x0003a8f373c4a2e1,0x000064232b85d039}, {0x0007eb0167dad297,0x000124b78ab2f557,0x00029348b1604f30,0x0003419baa94afe8,0x00007fbd8ddb1654}},
   {{0x0004802fcf0a7fd8,0x0008d488b01e31f1,0x00052b49842fd078,0x000200f1d78d6d99,0x0000eb572d987ac5}, {0x000a44c4d194a88b,0x00090a017e66e0a2,0x00088aefcd2b63fd,0x000a10c8efc6c8f8,0x000076f6bdafa881}},
   {{0x000932c68af43eec,0x000db03d00bda2f7,0x000b061f55502468,0x0005ad25dc978f2f,0x00009a1904ae8c81}, {0x000538d470c56a4f,0x000e293d8cedd3af,0x000108ef3159abc5,0x0001773a37245f20,0x0000a17081f123f7}},
   {{0x000a9b2b4b4b67c8,0x0000680206041fe2,0x0008058d8c1d10df,0x000fbb1d64abfcbc,0x0000943b9b2f12a0}, {0x000d9143b3def048,0x0001cce775ff90ee,0x000bc904085ab3aa,0x000dfae05fd4ca7b,0x0000b34a56562c75}},
   {{0x000acf88e2f7d902,0x000757be32cd5c18,0x000eb5ee9fdbf33d,0x000114ea085cd7d2,0x0000d702cfbd3201}, {0x000ebdb85c88ce89,0x000b8e01d617b6e0,0x0007333ac23a3ce3,0x000b6aa041618e56,0x0000dd0fd8fa57ed}},
   {{0x000610798fa7aaac,0x00043073aa4eb2b2,0x000d6b19b41209ee,0x000caf31570359f2,0x0000be6868dbc577}, {0x0004bdc32c04dd3e,0x000defeee397186c,0x00086c0cfa6c35fa,0x000fe1d4a1b312f0,0x00000a5ccc7b9461}},
   {{0x000f3a36fa6110cc,0x00013b93561f516f,0x00057522b74fb1eb,0x000dc5ac0c904784,0x0000fd321052bb8b}, {0x00084a2cc80ad571,0x000576a9b6372d68,0x000f4e8cd7c27fc3,0x0002f02461baedad,0x0000d56251a71724}},
   {{0x00011a9431dd80e8,0x0009f3306cd9b840,0x000b3b730eb7c7cc,0x0003d2a0fadd29d1,0x00003858b5c7e37b}, {0x000d193b6251d5c7,0x0002a352d952bf4c,0x000fbc0511cca1fd,0x000636566157a490,0x0000990a638f9b98}},
},
{/* digit=21 [{1,2,3,..,}]*([2^84]*G)  */
   {{0x000692a87dec0e16,0x000d97b39d00e5aa,0x000cfa0b5010ded8,0x000a281b1b80c854,0x00006beb87700f8e}, {0x000f5313476cd0e8,0x0005308d394950d7,0x000479fc6a63d0e6,0x0007419a09eea953,0x00002ae98927499e}},
   {{0x000b9105ca7d8669,0x0001aadb3b34ab58,0x000eac0bc582967e,0x000af4f9ae4447cc,0x000019c667d0bf56}, {0x00017b160f5dcd7b,0x000f2dcaadbc9aec,0x0003467f5ec697b9,0x00032e5b98f34146,0x0000187f1f859671}},
   {{0x0007a1d214aeb181,0x000c641432f790fe,0x00091a0c41506af3,0x000bc3ab5565f9e5,0x00000d41a77c44f1}, {0x00065e4a84bde96b,0x0008420a6a1ca09d,0x0007f9ce742f060d,0x00039eb52a3bfdf2,0x00006bdb65ceb3d7}},
   {{0x000dcb6ec7fae9f1,0x0004dfb66e5aeb5d,0x000445d52995f271,0x000620cee95d8e69,0x0000b6c2d4619e27}, {0x0001c318129d7161,0x0000f958c1aa3262,0x000f4af63b03909f,0x000df67c468ef91a,0x000062c42a00ba5c}},
   {{0x0002343753b9371c,0x00099f1f9cd72f68,0x00045db9629cab45,0x000998971623abb2,0x0000507db09ffd79}, {0x000f652af036c326,0x0007a5018e5c4e2e,0x0008be35086f0cc7,0x000327610a73d4ab,0x0000519b397de826}},
   {{0x0005eef9c053df72,0x00079300ea6fe8cb,0x00049cffb8de25b3,0x0009bbbb03fa92c8,0x000042e43a808416}, {0x00051f4dd6f958ec,0x000f34445a8de4fa,0x0000d89496925a77,0x00039026e72a50e9,0x000066648e3eb1f6}},
   {{0x0001957173e460c5,0x0004e0704590b2ab,0x0001c71621bbbce7,0x00065d70a90dbddb,0x000005e399e65cdd}, {0x0004dcb57797ab7b,0x0009ba2ca8e86843,0x0003336c160ad35b,0x0000149bfdb1e0de,0x0000bef99ec88b39}},
   {{0x00096f31711ebec8,0x000f4e98fdc46c3b,0x000b4411f2da40f1,0x000bb6399774d357,0x00007c8bdf495b65}, {0x00089e3c2eef12d5,0x000aec7471f3da3a,0x00012c594de95bb9,0x00056b100f225bd8,0x00004907c5d7b75a}},
},
{/* digit=22 [{1,2,3,..,}]*([2^88]*G)  */
   {{0x0001db6f79588c00,0x0009b55768cca80d,0x00054438afa52fc6,0x000a4f0b4df1ae7f,0x0000cadd1a7f9b46}, {0x000a6b31803dd6fc,0x000495eaae35b40e,0x0002e4e16488e4fa,0x000c97df047d5538,0x00009b5b7e0ef6e0}},
   {{0x00038b67c4a658ad,0x000870e72182c127,0x00098e44fb3c4763,0x00085e6b77be4687,0x0000c047df2e7a7f}, {0x000d4c55e59d92d3,0x0005b8e64d8d2439,0x000ca9b16cedca47,0x000dfe7724cd0d87,0x00005e4fd59d5540}},
   {{0x0000e0683a7337bd,0x00042fecf2494b7d,0x000a2b71f1e3416d,0x00026c54840eff66,0x00000d9a50b837cc}, {0x00081506fe28ef7e,0x000543324c7fe219,0x0009b52633cc5ef1,0x000474420f345576,0x00002ade2f2810bf}},
   {{0x000344f3a29467a3,0x0009951eba6d9894,0x000e5c2f2de81e94,0x0007b3aaea066ba5,0x0000fc8a61438c8c}, {0x000f88f06d0de9fa,0x00049b75ce0a7adf,0x000bc87d5bbc11cf,0x000de1ffbb7accfb,0x00001458e271badf}},
   {{0x000c8c7dacddb7dc,0x0003be1edcad03b6,0x00008063392ed500,0x0001cde0e46c2f54,0x0000d37663e06dec}, {0x00084c5f365b7cc3,0x000ab79bb95d3969,0x000b1d3c1294e3a2,0x0000f56aa17d7727,0x0000ffd3cfb14944}},
   {{0x00093e3abb830d13,0x00022c2c5270041c,0x0004b259d2ad2353,0x0008577efd1be2ee,0x0000ef267774eadd}, {0x000f7039b0d7d86e,0x000c9b7e6f202af8,0x000c8e29580f5af2,0x0009f5d5fa1d3cce,0x000073f3903d68f0}},
   {{0x0009d11399f9cf33,0x000dee3c43942667,0x00098daf178e7a48,0x000ea2d8722dea0d,0x00007e7ed58b0030}, {0x0001ad43c8aae72e,0x0004cc729695f373,0x000c283527878be9,0x000b608a643affbb,0x0000f8b801c58759}},
   {{0x0003668e039c2560,0x000b7c17fd5d1cb4,0x000aa062b5f26fb8,0x000f04eee426af79,0x000072002d0d78fb}, {0x000a237e84fb7e3e,0x00002c82133d4c9c,0x0007e4181b401d8a,0x000151caa525926d,0x0000943083453dbb}},
},
{/* digit=23 [{1,2,3,..,}]*([2^92]*G)  */
   {{0x000da31be24319a2,0x000bc095a8e7f92d,0x00078218503f7d28,0x000dbc852fe84098,0x000076ddafe49c24}, {0x00054961d7a64eb7,0x00090f1dbe4280cd,0x00038d2d5e436088,0x000035bf81a87784,0x0000e4d52a8f5169}},
   {{0x000fd9d615faa8f2,0x0000768554ed7b15,0x000a448828fa1eb4,0x000f325bb4447e7a,0x0000bb2d0d1229ff}, {0x0002a646caa6d2f2,0x000e02e7351b075e,0x000506c628eb879d,0x0004dc9cd5624e9a,0x000018eaef0c87e2}},
   {{0x00047d83d30a2c5c,0x000e378a81dc1fe6,0x0001a4a9b0857f77,0x0003f451d5a33413,0x00000a94af9e9d39}, {0x0005c0bdaa6ec1a9,0x0002f8d2d7edbc3a,0x000614797ba9fe49,0x0005332b4335b4bb,0x000091c4d6902f83}},
   {{0x00068cee978a1d35,0x00032ab92d0477b8,0x000a5b862e3a68b3,0x00041d0102979487,0x0000f0606c38a61d}, {0x000be276f9326f11,0x0004b6fe3c2e2814,0x000df73512f521c1,0x000e4407464d7dac,0x00000f5f9d3877f7}},
   {{0x0004ce43d34a2e3f,0x000dc43b5d611fd8,0x0009186c7ee3759c,0x000259995bc78c61,0x000019c380abbb97}, {0x00021aade744b1f6,0x000000f8056bc0be,0x0003efe11a7d222b,0x00025314be6157b2,0x0000fab2b4f6cd68}},
   {{0x0003878a4d32282f,0x000c58020ae7b6e3,0x000a9b750e36e029,0x000818f05847fb37,0x0000876812da29e3}, {0x000138ed23a17f08,0x000070b3950e84ad,0x000d67ae06d7b448,0x000af65fa8aef42f,0x0000d3eea24d2333}},
   {{0x000a522b99a72cb0,0x0007876180162101,0x000f3653e06de6e6,0x00054a5ff8c7cde6,0x0000a821ab5c7a67}, {0x000a52b7cb0b5a2b,0x000c190487907e3f,0x000ce053aa7fb121,0x0009af6a72502006,0x0000490a31fb4e92}},
   {{0x0001244c5f95cd80,0x0000f4ab95f4b06b,0x000e5836dda8c8af,0x000ffc1bae59c2b9,0x00007d51e7e3acff}, {0x0005e6ac2ccbcda6,0x000f2528c3e001e1,0x0009fead43bc1923,0x000710e3324577a4,0x00001a1b8848aa7a}},
},
{/* digit=24 [{1,2,3,..,}]*([2^96]*G)  */
   {{0x000ee31b0e63d348,0x000229e54fab4fe7,0x000e7b5a4f460057,0x00083140493334d5,0x0000589fb9286d54}, {0x000f5cc6583553ae,0x000a025649e5aa70,0x0000446520879094,0x000c4eec90450710,0x0000bb0696de2541}},
   {{0x0001a3ea2dee7a63,0x000c434b2284758c,0x000aba6addcde2f3,0x0000a77ba445d24e,0x00005aaf668a6cee}, {0x00004a9e5aa049a6,0x000d31103e847e0b,0x000afecc3e74083a,0x000f7a5eb183ce40,0x0000b89dea04a043}},
   {{0x0000e0399375235e,0x0006d9917970b99f,0x0004ec0677614c84,0x0005201ec93ce952,0x000040e7bf97b122}, {0x0000631ee4c47744,0x0009fb04914cb567,0x0009dd2266f03847,0x0001f8896e9429dc,0x00003489b6ccc57c}},
   {{0x0009d23fe67ba665,0x000043cf2f340e29,0x000fcf9139145076,0x000ddaa45b5ea997,0x0000be00843dbd7d}, {0x0003e05d53ff04d3,0x00032de91ef7358c,0x0009ec1a0bf7ccdc,0x0009977d684dbfb6,0x000067e7cf2b01fd}},
   {{0x000d227cc2338fb4,0x000950e2615346ff,0x0001a007689ff6fa,0x0003af7e57077933,0x00003d241c546e1f}, {0x000b97dde9b62a31,0x000490ae30eafdcd,0x000bddf7d6a06e98,0x0003c4b9bf16804f,0x000070471a2e3616}},
   {{0x000a8ae3113655ef,0x000a67b83180ff5b,0x000e0eabefa2c6e2,0x000a962c48271977,0x00009f3c556237fe}, {0x0007022a42581cb1,0x000208f710e3340f,0x0002e5aa8e1de0bc,0x000940de640adef6,0x00006b2389159428}},
   {{0x00019e455950cc3a,0x000bb6b66bb83616,0x000ac6d84c71d665,0x0007e34a034b34af,0x0000987f83385e4c}, {0x00027727a79a6a7a,0x0007426d6c23a074,0x000167e1056e5d01,0x00084dde50b97638,0x0000a6c81f0888aa}},
   {{0x000f3b7b0dc85957,0x00082f1d9f2e0ca1,0x000dd82a727de460,0x000447aaf3bf39ba,0x00009356a79d5862}, {0x0002345f5f9a0529,0x0008839a42f9c060,0x0004d40fc1a8b0f8,0x000368253eee4284,0x00003b0bfe5de5b6}},
},
{/* digit=25 [{1,2,3,..,}]*([2^100]*G)  */
   {{0x0003a5dc8de610b8,0x000ae7e223ce0f89,0x000ad6dc5e8c515f,0x00028ef774bfa64e,0x00009d20f96125c7}, {0x0000966098583ce0,0x000493f2a7d77a1e,0x000304d4aa2eedb9,0x00082d1b2820974c,0x0000842e3dac0772}},
   {{0x0000e9d74cd06ff8,0x000f2ca3eeaca101,0x00063aa2b9c17c7d,0x0004fef4c86cd380,0x0000595c4b3f3461}, {0x00000ca990f62ccd,0x0002fa0c3be5a3de,0x0008ce9f5d9bed21,0x000443a886078adf,0x0000db27ce42cd44}},
   {{0x00097befc15aa1ee,0x0007d54b07455a30,0x0009a5f1240d1254,0x000ee57bad470651,0x0000d03f7188439d}, {0x000bb6c4a02c4997,0x000d5ffe71d20794,0x0003adcaff725083,0x00030fbcad75190f,0x0000f68ea1cb3729}},
   {{0x000581d26ee83821,0x0005259d638e9c7c,0x00028ae3dcf17dcc,0x000047de8273abb7,0x0000d1129270821f}, {0x000847750491a746,0x00019de0dfb91149,0x000a435ab687fa76,0x000e3ecc2580227e,0x0000b8bdb94f1ce7}},
   {{0x0006d8af7f91d0f2,0x0001882a57289c80,0x000d767543b61b0f,0x0004c62640032d94,0x000073eb5de67d83}, {0x000abf77b4e4d538,0x000f5e4017772988,0x0005071b3b7ce66b,0x000a981fba6b3271,0x00002413c252d3a1}},
   {{0x0007b7e3cc8ac855,0x00078d02753b7553,0x00037df2f8d725f5,0x00031dad05ff64b7,0x00005fe871346d25}, {0x00004a96ab6b01c8,0x0008fcd9372457ce,0x00086699b69a02a8,0x000231cf82ac35cf,0x0000242d3ae1cb4b}},
   {{0x00035269be47be0e,0x0007eb28fea169c4,0x0006c67e5323b7dd,0x000e461a5538ba3a,0x0000f921d70fd378}, {0x00061fc3c4b880ea,0x000df8940a67f929,0x000f0ff393f6f914,0x000f9c0990eb0afe,0x00006c2921090eef}},
   {{0x00003a553fb2b560,0x00074e057f78b23a,0x000e490d96ce141e,0x000e75796525c389,0x0000bc95725a31a7}, {0x00067911220fd06a,0x000ba08b0bd61ec5,0x000ebeba9716e3a3,0x00066f91cd6bf7e8,0x00007326ca75ee6b}},
},
{/* digit=26 [{1,2,3,..,}]*([2^104]*G)  */
   {{0x000c982cf7d62d27,0x000cb3ba815020d3,0x000763f9e1f36e29,0x000006d8ae0bf092,0x0000a527e6b8d3a7}, {0x0009097581a85e38,0x000f5c158be5b4a8,0x0007d726e1f1a520,0x000862798db37d16,0x0000802786e9113e}},
   {{0x000149e36f09ab05,0x0009fa10bb5befb2,0x000e2099803f163c,0x000bab8029704506,0x00006f0af006b5a3}, {0x000cfec70880e0de,0x000ede3d913f7af4,0x000ceb4bd7332a66,0x000f5452e6c84a7e,0x0000dc4a79b7c228}},
   {{0x00094d1f4c6b6ec2,0x0006f8b3cd9bf6e8,0x000117fbf526b082,0x000bf553f952a812,0x0000be864b031945}, {0x0008ea542099b646,0x0009a7548ce286f1,0x0005c1c9c2770b28,0x0006c337390f2829,0x000072e6a442b520}},
   {{0x0007dd0c55c44969,0x000695bbabd2c37c,0x000d7f363a6a9635,0x0001decb7e63f2ad,0x0000dce3782be73f}, {0x000a16ab2b91f71a,0x0002bba0163ce1e5,0x000e515ade448982,0x000ecf52759c32f6,0x00005e2f1f92615e}},
   {{0x000e2c847c643671,0x000f35af4ec0cacc,0x00034042c6a496b9,0x0002ea1a0836f360,0x00004a1f3901b6c6}, {0x00093633ef1f5404,0x000a32a76d93e7fa,0x000eae451d323b30,0x000f87bfeec8b50f,0x0000eafc172fd04e}},
   {{0x0009be7abded5516,0x000868b744107451,0x00010d9a903d358b,0x0002b6ed00b10b0e,0x0000392b0b188da5}, {0x000a2980b75c904f,0x000db8f7f96c6744,0x0002cf932c305b0a,0x0006c9142e421d18,0x00006fc5d518e463}},
   {{0x0005a51b3e59b897,0x0004d133a1c9e443,0x0000bee591361395,0x0001e417f4697344,0x000014710f870c40}, {0x0004bced6c446c96,0x00060c4d5368c0cf,0x00068fc37e0aa7fd,0x0000577e5d811afc,0x00001febd7317c2a}},
   {{0x00047c9d64cc78c4,0x000b5b6cb27b7958,0x0008022ab6c50621,0x000a1cc7099bf8df,0x00008f862ec004ed}, {0x00032ede1603c166,0x000efc9a9450d127,0x00029b4fc19a80e0,0x00051582257f54b4,0x00006d3b2c6a5460}},
},
{/* digit=27 [{1,2,3,..,}]*([2^108]*G)  */
   {{0x000b7bc453cadd69,0x00072c0bc1f88de2,0x000abd3af203900a,0x000ffb2cd86e47a6,0x000011cac131502e}, {0x0000242ec965469f,0x000139e0017e2d55,0x0009798850e9f769,0x0001ee733f078f65,0x0000b87d44a3cf75}},
   {{0x000e2a2d551ee106,0x0008127e09a66066,0x00001148d87a8f1d,0x0003fda0d08bab2c,0x0000da8e4f1a24f3}, {0x00017f0cf9a4e718,0x000fbbf5cb19466d,0x00062ecc0ff50200,0x000ac45ccf97d8d0,0x00000c0d9b001d80}},
   {{0x00045ff1d7aadabe,0x000ff5f6a67c1a04,0x000cfb26f65d3825,0x0001d58e62fb0891,0x0000f1e0fa63c7d9}, {0x000c7ba33db72cdc,0x00093a7c74b247e7,0x0000a503c017cbc0,0x000a417c931590f5,0x0000ac54f61216ba}},
   {{0x0007ceb1bf4581ca,0x00060ca7b1669885,0x0009722ace635e18,0x000006878ddd2265,0x00000903c4cbdb68}, {0x000458948f214029,0x0004296abda2366e,0x00040319031b49c1,0x0003fda29c4b09e0,0x00007197ca4629f4}},
   {{0x000dd5d4b07e2b19,0x000afd9ea2217173,0x00005ab14d144c4c,0x0008f158b04ea411,0x00002dda5438e80d}, {0x0002fa8cf03dce66,0x0004ba22cffce998,0x000ad88c48b5ea96,0x00095c97f4ea7f3f,0x00002db773eca5ba}},
   {{0x0003fb4820357c72,0x000e4f1458ad18bd,0x000b44aa1992039a,0x0002817a1df3c525,0x0000d7803580d3d5}, {0x0007e4dc77ad4d4a,0x000859df4fc458cf,0x00071205ed49a799,0x0004a9a465a8b51d,0x00000ee0ea704925}},
   {{0x000e6e89c92b2350,0x000e6b3993a14baa,0x0003dd031a73bbd0,0x00081cd06d60ec69,0x00003cab91b71568}, {0x000862f1db3574b2,0x000544bb061ad615,0x000181e06485b018,0x00075707434988a0,0x0000cd61ad4e1c0c}},
   {{0x000de1cf3480d4af,0x0006cc8acf1a03e2,0x000295a9cf0d8edc,0x00097d023e330368,0x0000add5f69b546a}, {0x00097ad96f8acb1a,0x0004c71bdae28955,0x000dd43f4bddd49d,0x00041976fcd52821,0x00005a4541306191}},
},
{/* digit=28 [{1,2,3,..,}]*([2^112]*G)  */
   {{0x000b6bfc360e25a8,0x0004875a1a788ce9,0x0001732f4e642519,0x00057a1dc756a848,0x00003c0440fd432b}, {0x000b3f1d720281f6,0x000e7135e051c670,0x000052be72205910,0x000a397ed14b0edb,0x000097b3d282568e}},
   {{0x0009b9afb3ff9ed0,0x000b17f6515c2e59,0x0004da44928c2e0a,0x0004521cbee4fd47,0x000071279a44f364}, {0x000ff6601fbe8556,0x0007ffda51c497ab,0x000597c0b3ee394e,0x00034ab90385f667,0x0000e9fccc7027ee}},
   {{0x000de9314092ebb4,0x000d028e240c0b89,0x000d2f064f17256b,0x000b148f89a7f393,0x0000f57841f21ed3}, {0x0004405e708d8553,0x0001d3f1c3d04ee1,0x000d7eed5856aae7,0x00027098e5424fbd,0x0000333e4efa3ab4}},
   {{0x0007adedda492f81,0x000a682972053bc7,0x000931b4cc11a3ae,0x0004bb4e89a3e734,0x00007512e2eaf569}, {0x00049f3177bf8b6c,0x000948c7ff3e5dc3,0x00011145d232ea4b,0x0009c2dc4f9d16f5,0x0000cf109a3f3b37}},
   {{0x0007a88a1f258972,0x000f81b5d4d8e75e,0x000f3ed5c7ac6961,0x000dfbc3e1077308,0x000008a54ec2a892}, {0x0006e1978660710a,0x0006837df2c8be82,0x000704da50cf70a9,0x0003fca18a7340ed,0x00003eeb9a9a8ca3}},
   {{0x0006233169bca968,0x0003ada6aafb49d9,0x000c2fa9404d286d,0x000fb3409606eca0,0x0000869d0d5a3ff0}, {0x00037e5d0150d651,0x0003140c14c9a999,0x0008e2d49a92e250,0x000e2b556bf94510,0x000052a733ab2f59}},
   {{0x0003d588434a920a,0x0002c22103c5b432,0x0008dbf9ac0af8e9,0x000df1c67518ef93,0x0000184307423a9c}, {0x00094aa5447ab801,0x0005b75a3d61350a,0x000411a9ee5e5a32,0x0000c564ba507f68,0x00000581fc1694f7}},
   {{0x000857080eb24a90,0x000d488e0cfd60e2,0x00059cdb87bedfb4,0x0000a9721ebbd7c2,0x0000b0da855bc639}, {0x00004dbde314c709,0x000bdc32e8462b4d,0x00062fc9ecdbf1fb,0x000ab6a3833eabb1,0x0000939b48c40dd3}},
},
{/* digit=29 [{1,2,3,..,}]*([2^116]*G)  */
   {{0x0002c1f711b0eb9e,0x0007980ab9549689,0x0000792dbb905f2c,0x000125cce26309a2,0x0000c8ac9b3e684e}, {0x000d8b6b40a24474,0x00015fe3fb24486a,0x0008e3b3f60121fc,0x0003941626fccf1a,0x0000e568622aad1f}},
   {{0x00046c64a8a3d626,0x000fc47743d25a4b,0x000f7e4338469c4c,0x000848cbb3a13d88,0x00002b23a1061be5}, {0x00096b4a63d1a4c4,0x000a3d183f3ee835,0x000afb01c454e7fe,0x000638243fce6117,0x0000e65e5e65c4c3}},
   {{0x00077176add85450,0x000672c49b66e5db,0x000421d771b71cb6,0x000fead856073968,0x00003840fe883e3a}, {0x000dad51ec699775,0x0008e07f6726b391,0x000ca160cae243fb,0x0005f4788ac87be8,0x0000174cced9ce35}},
   {{0x0007eb6cbc613e57,0x0004d97ea61cc1e1,0x0007eded533131d5,0x00011abf69d39eaf,0x00003c2f4354e6af}, {0x0002493a4a375fa7,0x000c4833c5c24ca5,0x0006e71cf5f06787,0x000666114e091f3e,0x00006451f57fb746}},
   {{0x000ab8495fe1347f,0x00087f24503c5ee6,0x00086dd6bab0f6c3,0x000ef4907e3ffb44,0x000000b6c757002f}, {0x000f9a6a78629992,0x000c9ed89e2648bf,0x0008419eb85e5a06,0x000f1666d311af3d,0x00004f3ad7854733}},
   {{0x00003fc6c68d6876,0x000cbff052c75e3e,0x000d16e7a3e732c3,0x00074692d0efa66e,0x00003d92b27165bb}, {0x00082badd44867cb,0x000e48c081b8ffcd,0x0006c8785a71b4a9,0x0002cfbc1676a773,0x0000e2c06174d893}},
   {{0x0006d282bcffbc46,0x0006a6eadb7a5337,0x00035ae69708817a,0x000fde0ff50e05cd,0x00003b5fb75d4bc7}, {0x000e953e7fe08c4a,0x00045583ca1871c9,0x000e81c5cb4d8bfd,0x0001383e8d788245,0x00005f5e93d80474}},
   {{0x000bdef694db7e04,0x000779fcddc680f9,0x000b8dce1edca878,0x000ba111981c3403,0x0000274dcf1b0e10}, {0x00043b86def6d1a2,0x0000cbdb1866f727,0x0000c6f58d25b167,0x0007f5a4491e8c05,0x0000be2b2aba7fbd}},
},
{/* digit=30 [{1,2,3,..,}]*([2^120]*G)  */
   {{0x0005c9dd111f8ec7,0x000d47c4e7603e0e,0x000392a51bcc33f8,0x00092d002f9a91bd,0x0000da4a7963132e}, {0x0000ae30bb1151be,0x000722e322511a0b,0x0004e9e7854febac,0x0000b80a3a508269,0x000058ffec2c4fe4}},
   {{0x000349d29c4120ba,0x000f20d0d915fbb8,0x00010ba519f94391,0x00091124074fa754,0x000066adbf6b50a5}, {0x000543c34bfca38e,0x000fd9e1ccfcc164,0x00020219ce0f2755,0x000979b9da0f53e8,0x00008234499a6b49}},
   {{0x000c513516e19e45,0x000775c4d5937b23,0x000e71ef656e2e84,0x0004c54f727d735c,0x0000b6304a7479a4}, {0x000a7363ab7e433f,0x00000e742f836638,0x0007fc19f1adea47,0x000697f054b8545b,0x0000935381baa1d0}},
   {{0x0004f9d918e49366,0x000652513982b550,0x0004d9cb965035ef,0x000508a553a0c26f,0x0000cb10d571ea85}, {0x00057b7a242da112,0x000d472b726848d9,0x00002a96b16a4d3d,0x00063b1d7e637c85,0x00007c7032b930d4}},
   {{0x0006b7d5846426f7,0x0008b47d441d5536,0x0006fbf48e7d09e8,0x000d7ce10b404d73,0x0000fa003d15784b}, {0x000614f17fd95965,0x0000e5cb98db25f7,0x00083a76a49e0e0a,0x0000f7dc65957b2e,0x0000d40da8e1ddbe}},
   {{0x0008bb4a595939dd,0x00085874021737f6,0x000ad76120355647,0x00095ebe740e7c84,0x000089bc84460446}, {0x000da5d85a9184d6,0x000b3fc0b074f7f3,0x0008a888e562563b,0x000e7ba6d2e6aaf8,0x000012d8643761fb}},
   {{0x000bba354530bb24,0x00078b0869ea9fb3,0x000431163bde3ef7,0x000a3549bc90460b,0x0000d03d7d324819}, {0x0004f9e43b6a782b,0x0006ec88a68633ae,0x000ffedd9216db30,0x00083fe1dd88e000,0x0000280da9fc2bd4}},
   {{0x00086913e538cd75,0x000c3e08ad53458f,0x0005d15ffa7001f6,0x0005dd02b8c6e6bf,0x000048234a451121}, {0x0009d2d3d5b40458,0x0005ca904190ff5a,0x000607f8bb0ffeeb,0x000729d5a3aca448,0x0000cbd665cb0a06}},
},
{/* digit=31 [{1,2,3,..,}]*([2^124]*G)  */
   {{0x000a8f833f6746cb,0x00054ea990cac7f3,0x000ddb0a921e46f6,0x000554e15fd5c5ca,0x0000d41f01728614}, {0x0004434426ffb589,0x000584dbc204346f,0x000969b7f8055943,0x00039a63dd20fe5a,0x0000d59e9577899a}},
   {{0x0000ba9b733aa5fc,0x000b305af2353c2f,0x000ac82a5dece47c,0x00018a38e3f715a2,0x000097ba641e203f}, {0x000550409c110608,0x0004c6af512dc3af,0x000f2814656ea2c0,0x0004947ac28daff3,0x00007fab43b159ef}},
   {{0x000115c775d6ece0,0x000be8c0e78def4f,0x0005cfc8169d2e3b,0x00088bb0264ef114,0x0000a41e9fa1b697}, {0x00033be909a1f0b1,0x0001fae76b300d92,0x00032bb69150a845,0x00084ada33753706,0x00005f7b3cfba255}},
   {{0x0001641d4c5105f3,0x000e3d7fbd650989,0x000e6bdb01ae80f8,0x0008606d67225fbe,0x0000b433b59afc4d}, {0x0006db693e856387,0x000273e9862f44e6,0x0005c32ecf7b5925,0x000f506b78515766,0x000002fefd81e362}},
   {{0x000a9141339609ae,0x000d5e37eabd6eb4,0x0008c8d9c2b627de,0x0001e40a4083d172,0x000070814d5318f2}, {0x0005b5717398d14c,0x0004c003f6c94cb0,0x0008292759d37d25,0x000e4eb0577af760,0x0000b4a9a9b867d7}},
   {{0x0006a5c97290293f,0x000be388acbffe75,0x000916bdabf04a19,0x000bec0bbbb9cf5e,0x0000489527481f93}, {0x0007ec32a5923d75,0x000bade0c370dee0,0x00019d8fcc7bc949,0x00093f6d51217504,0x00004f5d4768fdcc}},
   {{0x00005f7d13fb27da,0x0002cc7195c0c20f,0x000fc56c5c05b30d,0x00082b0335cf1832,0x0000e65bcd402b3a}, {0x000aab8630d99eaf,0x0005f62cec6ccbf6,0x000eed2f1164be81,0x000d0c7d41819d2f,0x0000cdc5907fb91b}},
   {{0x000475d0fefb0c3a,0x000aa6d7c35d3754,0x0003798a4d48fb56,0x0008e60070b63336,0x0000e89f3d32fdb9}, {0x00089c86363d14cb,0x0000b7abd27d970b,0x000d5a0218981752,0x000aedebf7d47444,0x00003083bb07ac72}},
},
{/* digit=32 [{1,2,3,..,}]*([2^128]*G)  */
   {{0x000c244bfe209256,0x00032fdce86762a8,0x00038706391c19ac,0x0004f5fa96a5d5dd,0x00001d587d481d32}, {0x00073a2a37173eaf,0x000763778b65e876,0x000bab43e2384800,0x000fbd20f8441e05,0x0000a11fe133621e}},
   {{0x00049feb8a24a205,0x0001a52ca53f23f9,0x000fb485317ebfed,0x00005d4b691bbebc,0x0000617ff6bb278a}, {0x00034c5e3c99ebdb,0x000d6784156a241b,0x0005d67dffc64242,0x0000109206482f69,0x0000967ce0f9e27c}},
   {{0x00034a3b23358342,0x000a70ef6860c0f7,0x000e2bb0d9526205,0x0003faab8be71704,0x0000418871e22f38}, {0x00076814082c1576,0x000fc9c20073d717,0x00087e728cc914ac,0x0005fd9186c1ebe5,0x0000fdb3c22c1bcd}},
   {{0x0000f0441c23fa36,0x000061989a2eb448,0x000a29ca7b4712eb,0x00028bdccbba0f93,0x0000e205c1536194}, {0x0007957b36416860,0x000d45ac8b4e90db,0x0004e03500432691,0x00051707a759acf6,0x0000514d89c9c972}},
   {{0x0004c1c2cf9d7c1c,0x000a2e95e5abcc7c,0x000ae170c1320886,0x000661fb7b9056be,0x00008a5b2519bc0d}, {0x0001432c11d23031,0x00020f03769f4ed8,0x0005398287da6691,0x000d022ac7a5fd84,0x00004dada944bccd}},
   {{0x000f7aaf0dcbc49e,0x000890bbb45b7bb4,0x0002ca2e57de551f,0x0006eeefd0f3e49f,0x0000ce58709ff5c7}, {0x0000edd167d79ae1,0x0002ea7d7ec13292,0x00030af91039df8a,0x000b59e46206c0bb,0x0000ff5e2f532676}},
   {{0x0000651cbae2f701,0x000583aaa8eb51b9,0x0001df499efc4bc0,0x0007a57ecd8689dd,0x0000aee99a832f36}, {0x00085b9ae8274c57,0x00050d30b39c95d4,0x000c1ef816c14d44,0x0002ed4afea90bbc,0x0000c5f317b1459a}},
   {{0x0002c6bc4fe3c395,0x00031c7bebdfe3b2,0x000693459ba4a815,0x000b11a23ab6b725,0x00003bc377064922}, {0x000c8ab5afc60db8,0x0004a0b9f2a34645,0x0000fc507aa02235,0x0002e6d2a2954cce,0x0000c2731bbfce1c}},
},
{/* digit=33 [{1,2,3,..,}]*([2^132]*G)  */
   {{0x00091c2e48fb8898,0x0002fb8a9d066a70,0x00082a0e226882c1,0x00052d224986631b,0x000044ed736b5181}, {0x000476fd86e27c75,0x0009b4afefdc282f,0x00019e34da04edac,0x00078b3b256ebc61,0x00006a413e95787d}},
   {{0x000061d5a74be506,0x00047ea16ff582ee,0x000bfc8a2e41781c,0x000e2d80b0c81e99,0x000024f4d696b547}, {0x000545dbdcc9ae4f,0x0005509b1e8e3a83,0x000c935392573dbb,0x000797582960c4a6,0x000001059ae4ae18}},
   {{0x0001e274d559d96d,0x0002e8db6c013815,0x0009921af4f18c0d,0x00002879a3aa836f,0x0000beab27c5c046}, {0x0009eaa7040bf3b5,0x0004c614b091242b,0x0004baf5d39c479e,0x000944e38ede2b0e,0x0000bb192b840a53}},
   {{0x0009f973112795f7,0x0007284e6ee1715c,0x000b66bcde824443,0x000bede5cb4858ec,0x0000c1367361baff}, {0x00015955dbec38e2,0x000c188ad1535466,0x000e0952f51c0782,0x000fa87ba4c53ac6,0x00007e6782a3b21d}},
   {{0x000c251ec5d7f652,0x0006703940877d89,0x000691ab30c8f561,0x000b21409e1cfcf0,0x0000a0300c009b20}, {0x0002fadb114faf4d,0x0008821bf5d1bf53,0x000fc36de328fc0b,0x000f5fed51f93c3b,0x0000989050f4a4e5}},
   {{0x000903d4ed2dbc25,0x00082c3b2d83682f,0x0007e93350eba59c,0x0006d73e9dc84d9c,0x0000f9b21b05eb22}, {0x000d394af267bae5,0x00056e2e15aee33b,0x0008ec500aa86cc2,0x000657ff0bf67d6a,0x0000846aa4549630}},
   {{0x000ba38e7e0c2780,0x000e588b2e6f6786,0x0005fee3a09bf87c,0x000394723b702246,0x00008b8411464682}, {0x0002ce029e646294,0x000f8ca78e430eb5,0x00054a991adb60e8,0x000fe4e0dd7062b6,0x0000281d429069a6}},
   {{0x0009740e2c2bf152,0x000589e99704feb0,0x000fbc565627a220,0x000de8cc8d73d0c2,0x000023eed8fe20c8}, {0x0002583a8363b49a,0x000929c2b0a61ee3,0x000dbc85c1a0b6cb,0x0001aba9f7c3d290,0x00008dfbb97bef4c}},
},
{/* digit=34 [{1,2,3,..,}]*([2^136]*G)  */
   {{0x000236e846e364f6,0x000c7ea50ca0c16c,0x00026b86d7f33527,0x00070c6481077509,0x0000c2a36096598e}, {0x0005e52f024e9245,0x00044db4afcaa675,0x000831790e0fa07a,0x0000d5c5c3ce7d66,0x0000b4ef350f6cbb}},
   {{0x0004c050f15dde91,0x0007fd5f2b820521,0x000e82b62a47a76a,0x0005eeab254d3062,0x00001a05fe04ec95}, {0x000f46e9d529b36f,0x00009f9e3df67eaf,0x00031769855ab130,0x0007acd463e37199,0x0000d251439bcda4}},
   {{0x0007598a9d82abfd,0x000b16c170f5e2a3,0x00066b0875f188cc,0x000ad9b168220050,0x0000a22c21397155}, {0x0005d3afbddb4799,0x0003dd715b99151e,0x00097cb2e4b606b8,0x000b65ba73b54bf9,0x0000a1bfe43cecd8}},
   {{0x00022f3dbfb894e2,0x0006ae274b18e131,0x00058aadfbe9b79f,0x00035165a49de5ca,0x0000495775831487}, {0x000ef61bb9390993,0x0009f6d13694111d,0x000fc253b1d6a974,0x00015e1474b4ced3,0x0000a1485e67c5db}},
   {{0x000dab61430c9ab7,0x0002b238e9975afd,0x0008042ae0bdd41d,0x0004cb8094743041,0x00001f9addb3dddc}, {0x000c016c52dd907b,0x000c79e2047f7090,0x0001011a6d9bdf44,0x000c7836f1fe801b,0x000063accbd89acd}},
   {{0x000acab4baef62e3,0x0002785b91e87817,0x000e576109f5a220,0x000e036666ebe66c,0x00002ad31f4273bf}, {0x00030a425bcf4d6c,0x0002915056e66283,0x000332156ea95059,0x0002d699811c89e1,0x000089cf1ff4c11b}},
   {{0x000337ac0b7eff35,0x000e75e48b3c0ad7,0x000f13a5f8552225,0x000cbe96f78b0c73,0x0000e70062ed2349}, {0x0005048e7073969a,0x0009233cb3d26b8d,0x000caa20f392d2a2,0x0007074e4f727c4e,0x0000068c99ecccde}},
   {{0x00086ec1ed66f181,0x000bc61fce43ebde,0x000bed74d225d906,0x000ab74cab07d6e8,0x00006e4617f37855}, {0x000aaddb2fbc3dd3,0x000f5aeddf5b6568,0x000cf2fadedb5484,0x000699578f20e86d,0x0000516497c915f5}},
},
{/* digit=35 [{1,2,3,..,}]*([2^140]*G)  */
   {{0x0003fecfa181e695,0x0000e0d69a98ef0a,0x000eab95d9ea02f8,0x00002162e9cf8e66,0x000020f2beb74720}, {0x000540a1df843618,0x0000f1fa6d5d621c,0x000f5f6ff1203772,0x000ef2ee3c7b510f,0x000017a069c2bb2b}},
   {{0x0002fb6b294cda6a,0x000519039f348357,0x0005cbb216ce9bf7,0x0000d980e012f009,0x00000aecc1c7063f}, {0x0001c3af02909e50,0x000f48ce9cdc57c2,0x000e336f8c7d59ec,0x0005f42732b8448a,0x000056e37233f4f8}},
   {{0x000b53189e800ca4,0x0006d45208fd8a10,0x00014ba3750fe0c1,0x000acc5e43c0d3b7,0x000027d200e74189}, {0x000e24fe616e2c00,0x0008ee1854c105de,0x000342a739c25f4c,0x0009524d3222a58f,0x0000807804fa027c}},
   {{0x000653a4f0d56f34,0x00078a28b805c222,0x00073434b961e404,0x000a18ec03f8b04a,0x0000c966787eb712}, {0x0006c42864fee422,0x000a3b0ece5ccc19,0x00031c159c1be93d,0x000655887d9f22c1,0x0000bb6d593fce45}},
   {{0x0009ec9b809b7ceb,0x000b32c72c2c22c4,0x000a0bf368a41486,0x000c68d13b9420fe,0x00003d36eea566da}, {0x000c08a328cc987f,0x000b4a3264616fdd,0x00010dbba0a3bcd2,0x0004c38103c49dd8,0x00009d81a293b78a}},
   {{0x00065ade4d559419,0x000da03840873de8,0x000f18b9bdedafa5,0x000267df414abb4e,0x0000ee9ea438aee5}, {0x000aa1637a55a4a5,0x0003b15f93b9260f,0x0009c3598eb19a51,0x00078e01d7ebd29e,0x000023fc56d69321}},
   {{0x000070cb98fe684f,0x0009224a1458501d,0x000bc6b3fd60fbe9,0x0007cab45761c892,0x00005384859ee6f2}, {0x00071f7b59e763bd,0x00088b5a8e5e4b02,0x000a482923d4606a,0x0004454eda5d9b05,0x0000a7731d1b6fec}},
   {{0x000369390d458714,0x000fc6166d8da3e3,0x000a90403e976403,0x00063775c3368289,0x0000bd17983b2f1d}, {0x000679ed5d2c53a7,0x00088dcf3b87a616,0x0006a694e5ec4bcd,0x0007e53e6d7613b6,0x0000460fc7753fc2}},
},
{/* digit=36 [{1,2,3,..,}]*([2^144]*G)  */
   {{0x0001fe1c63c4962c,0x0008d81fdb258053,0x0004c2b6b50541e8,0x000fca1c1291a1fd,0x00000693a1866df4}, {0x000604e0117f203b,0x00025a99b8d0b2c4,0x000212c44245f196,0x0002a7fedc20aac6,0x00001ed4e57020f5}},
   {{0x0000fb6700a1acd0,0x0003fd999681b556,0x000b4e1bae823fd7,0x0000a3da915d1f6c,0x0000d0301186ebe0}, {0x000b0c989fca8cdb,0x000b49da0e0b744f,0x00031d76f970d01d,0x0009695ad8c56479,0x000015737c0a659b}},
   {{0x0007a9c6bdf22da8,0x000f10dc82df18f3,0x000703651efbc432,0x0001a5452cef8e5d,0x00002887ba159988}, {0x0009ddab920ec1de,0x00030c3e8d3b7cec,0x000a88747d0d7e8c,0x000534645bc3954c,0x0000deaa2e17fd53}},
   {{0x000384ece53c2d04,0x000d1e4606daa12b,0x000ec12b0779d897,0x0001ad653e47b073,0x000062dbbba9756f}, {0x00009f2cafe37b68,0x000f6cce2e1769fe,0x000f607fd273d1eb,0x000c250ac1d5383c,0x0000035f7ff92e10}},
   {{0x000cc0f296c9005d,0x0009ab0aebdbb7d4,0x0000ec8d44b9094f,0x00010111bf10f1c0,0x0000807b1c5a667c}, {0x0002cdfbe7133835,0x000e31142ba1a941,0x0000a6bdc435e063,0x000ab9484c15ecaf,0x000092c2460e2a3d}},
   {{0x0002d5a2093c22a9,0x000145703aedca44,0x0003287b6ebd0bd3,0x0008b9a08f2afd65,0x0000bb88bac9d1bc}, {0x000853875c1e3b2d,0x000ffa11447cfbaf,0x0005c4c8dbd2ac94,0x000207586d816cea,0x0000c3aa800f8dc3}},
   {{0x000690016e23e9d2,0x000b87cc41e19365,0x000d6245ccb220c6,0x000a6a936b20c369,0x0000d63c348d62e9}, {0x0003e19cdc0bcb5a,0x000eef601b98a347,0x000e346e470f18b3,0x000a63ead7a2c7cd,0x0000e9f6ec45d3aa}},
   {{0x00034c77e6c55202,0x000fbcb9ea58854d,0x00086666dc27df9e,0x000a85205f2369d6,0x00009d1febf2417a}, {0x000819e93470afed,0x000912a27f9e9846,0x0001e65043e6a966,0x00080954d008a2e3,0x0000ba7ced06cb76}},
},
{/* digit=37 [{1,2,3,..,}]*([2^148]*G)  */
   {{0x000f541338d6e434,0x00030541d5ccecaf,0x000bc88ca56f7dd7,0x0002c375d426de96,0x00008d94f6bded3a}, {0x000a3bb2ef8279cf,0x000a1b1867f26354,0x000225151d575465,0x0000d7ff99b0ff95,0x00003e19d89e9450}},
   {{0x000f6ce51efb3108,0x0004158df5be0d0d,0x000158e59cb5b2eb,0x00033656459e2936,0x00002aae2b99466e}, {0x0008a39411aa636f,0x0004e4c0a933fb65,0x000f026b77152ecc,0x00011f010c758a49,0x00004837f98bb093}},
   {{0x000f364b71698f58,0x00021f7b605e7807,0x0003b2cbb6ba418d,0x00086f7d20b00fa0,0x000083eca385a543}, {0x000e43ff3437f24a,0x0002048bb33cff0b,0x0009df765e910b43,0x0006f6a963a12832,0x0000c1dd5575e2fe}},
   {{0x000523a626332d5d,0x00028561bb44994f,0x000845ea27bc3883,0x000089305ed4b03d,0x000039d3ee292a1f}, {0x000fdd3e7676b0dc,0x000f3b7060176561,0x00064f9a8620e35f,0x0001f676ce424ff2,0x00004c341a09a268}},
   {{0x000861cf405ff065,0x000cf86e828b1c30,0x0006933fcebac86b,0x0009479791a97163,0x00000e7c2becaeee}, {0x000a095fa90d7679,0x000b5670ab7bc3d4,0x0007b056dae60eb7,0x0002a987633a6439,0x00003a21f33a0501}},
   {{0x0001f22369b87ada,0x000892fca556857c,0x000b064663c00e5d,0x000af17ad74cab90,0x00007112386f50fa}, {0x000e1986d9bd5f51,0x000849c3463f7435,0x0007bd4b22dcc7e3,0x000f31cc7df748ca,0x00003cd4c08adec2}},
   {{0x000e46022caf46b4,0x000f5a96fe4f5936,0x0008f474e6a45dd8,0x000f15b7925434b9,0x000014104124053e}, {0x0008d1241de97bff,0x0000cd80bef471cf,0x000db0037b8547b6,0x000dfec47d3970c4,0x00001bcd329eef20}},
   {{0x00031769bb816483,0x0005353120d000f8,0x000cabc62d69eb48,0x000cb1a17d75f44c,0x00004a07f82e749f}, {0x000f787bbfb55541,0x000052e283f82c3a,0x0009213a0b06ed4d,0x0007b44722889fa1,0x000062b085eecf3c}},
},
{/* digit=38 [{1,2,3,..,}]*([2^152]*G)  */
   {{0x0000d2f7189e71f4,0x00081ecf91e73267,0x000757a21c643874,0x000ce4d5758e57db,0x000027d09f8690a9}, {0x000308f38384a7a9,0x000420732b99846a,0x000845819aac3acb,0x000e030e94100917,0x00005cba11237ce5}},
   {{0x000851aaaca5e9b7,0x0000e6713b9797b7,0x0000a61f6518aa52,0x000b68c357e8c715,0x0000842e7e35c2c2}, {0x000af656868a5489,0x00025068fc818dff,0x000917733d963bd8,0x000327d4da5c8b65,0x000027091000b247}},
   {{0x0001e48a105fc8eb,0x0009789ba48c37a0,0x0001c2180769d754,0x000387108c6fe1d5,0x0000032dd3467bd1}, {0x00026db020b0aa69,0x000f7664c73c9538,0x0000cf95d05137e7,0x00028a366302c466,0x00009004e1242cef}},
   {{0x000c9a7d298c241d,0x000986807cfd214b,0x00064eadbe3b697b,0x0009c51f1c780245,0x0000de8cdd084814}, {0x000f0a75a4d2604d,0x000e9c1538af946b,0x0005b1fcc27154d7,0x000f81c5cc9230de,0x000088519ea36864}},
   {{0x000e4f796ea6ca1f,0x00092f7928711013,0x000658d45567cdc2,0x000e97bdb728705c,0x00007c1ff4bbe600}, {0x00086574b6cad39a,0x00041a20b428a1ba,0x000e6fdfb3d58d63,0x00060d20011cdea2,0x0000832367b1b189}},
   {{0x0008c9f0e4938f75,0x00098c83719e4761,0x0001a64cc58d47d6,0x000f66874c1a23f4,0x0000d28e06905829}, {0x0007529210466f66,0x000f66a64ef8d8d3,0x000ce6a7a2af1152,0x0002d6f5d4485c19,0x0000d0bd2f65648e}},
   {{0x000032af416448df,0x000ffc76d9711ecc,0x0000b6eae4a7e8c0,0x000593954f9805b9,0x0000d0b15333bed0}, {0x0001848d98b5ca3e,0x000c1039b3ef89f7,0x0007bda2ed01fe5f,0x000e406481332e62,0x000067cecd885073}},
   {{0x000dd1a7cb1282c7,0x00064e46973ab828,0x00008d6b2a08d762,0x0003f2fbaf8d40e7,0x00002571fa1bdaeb}, {0x000732ff22dfd98c,0x00064087108d85b1,0x00088207a87ab01a,0x000754eaaafea859,0x0000cc832f929f00}},
},
{/* digit=39 [{1,2,3,..,}]*([2^156]*G)  */
   {{0x0001185ca8d9d1ae,0x000cf987ded2488f,0x000c46124adf2c77,0x0005f37f3039f060,0x00005d70b7651e09}, {0x00086506260e70ff,0x00070750d10582d5,0x000bac36439d75ea,0x0003289cf3d0b175,0x00003a7564e11d01}},
   {{0x000a43e3fcd3efca,0x000418088e9ab24a,0x0003d46eadd26c03,0x000a6f05ef4dc9bd,0x00002f99d592a4c6}, {0x000d3552f1da46cd,0x000d4afacdd1ddab,0x000d4057872c3f8c,0x000b94090c4eee92,0x000028bb4209a623}},
   {{0x00092d2e7417ce17,0x0001270ee7f52427,0x00067a41eff42bc7,0x000a57aff4dc6d5c,0x00007709b7b90882}, {0x000731dbe217f2cb,0x000cabb721773554,0x0001dd0592af2a8c,0x000476a8eee76959,0x0000b2930c9fbba6}},
   {{0x000dddaf176f2c08,0x0004625726581e6a,0x000342ffb01ca460,0x0008d58a404ded85,0x0000cf60f96c4183}, {0x000691cc9071c4aa,0x0003944428039bbc,0x0009c0d81fd58874,0x000f7ef7101c8580,0x00007fb754d2c456}},
   {{0x000a1d5af71013f7,0x00049bedc9466af7,0x0007370a0e68216e,0x0001cc84cba30bd2,0x0000981afbff7042}, {0x0006a679449f0e1f,0x000d1a47edae0249,0x000feca2286cfc4b,0x0008fa4073c936b1,0x00005694612f3f8f}},
   {{0x000d6715bde48f8d,0x00025189bc7dbcad,0x00009ee8ac970387,0x000ff78d45299ec7,0x00001287ee3545aa}, {0x0008874db1dbf1fd,0x000ac90c88d67d1f,0x000368313ea46588,0x0003ad90ba649a84,0x00005fdcbcf30d54}},
   {{0x000e9959890272db,0x00098e713a10cf3d,0x0008227b875f3432,0x000dc7ae13479fe2,0x00008561eaaaefac}, {0x00097a08332aafd7,0x000503809b62a6a2,0x00063036f9b0d8bb,0x000da862fa1cfd0c,0x0000a16eb562d64b}},
   {{0x0008e8a2ac13e274,0x000f0eb1a9f5f7e4,0x0001f0a624494f6d,0x0008f0adbf84eb98,0x00009badc3293643}, {0x000a541004f7571b,0x00002f1c94ee50be,0x00027bc31bac67d1,0x000e27753d73a1b7,0x00003d01cf2e0686}},
},
{/* digit=40 [{1,2,3,..,}]*([2^160]*G)  */
   {{0x000e50f6d3549cf8,0x000f7acd665ed433,0x00011fcb46f33696,0x00085fe95bfdacce,0x000010ee2532f7c9}, {0x0000fe17159bb2cd,0x000da58b357b6545,0x0009fea72f7dfbeb,0x0007445b057e74d6,0x0000485717b62731}},
   {{0x00042e8ee36860ce,0x000c6113c22d896c,0x000104213daf04df,0x0004e93adbb7b744,0x00005fd5fa1ffd39}, {0x0005d941a4e0551e,0x000d38d101516823,0x0009845236772cfb,0x000a97476071e309,0x00004e879df3a56b}},
   {{0x0000aa9b898fd522,0x00079e9af1a76c8d,0x0004f03f82fb38a5,0x000c6fc1f2b9a93b,0x0000b1aad44e3f0c}, {0x000332e7cf2c0846,0x000ea367d26d58b5,0x0006e4a8d1c57d96,0x000b69c297eabdfa,0x00005a947eeaa0e2}},
   {{0x000afb0285b94916,0x0007be4c705eaaaf,0x000d9caab01a0be8,0x00033f9f1d4f5d2a,0x0000e349a4b237a2}, {0x00012464a1c6a163,0x0005f9383260cf1c,0x0006d5471d99e6b6,0x00089bba3d43665f,0x00006974d052f8cc}},
   {{0x000b616fdd5b8549,0x0007c728719ff535,0x000921cad592549c,0x000ef85231468606,0x00008c8ce34c11b1}, {0x00037e7e9090b363,0x0008dbf7bbb728b9,0x000d8797467fc3ab,0x0003fde2337097a9,0x0000e5adca22970e}},
   {{0x00049a1cfe89d80f,0x000cea9c8371c26c,0x000d066d2b42c026,0x0003edda6c013ada,0x0000b8f722946a4f}, {0x00079ecd850935b3,0x000ca631e1b308b5,0x00019853434c1a74,0x000f259b5fe596ac,0x00009ff21f711f24}},
   {{0x00068a7b3f85ff0f,0x000c2a888044cdcc,0x000dbe894acd21cd,0x0000d3c6719b2e05,0x0000ae1d3d97b826}, {0x000dece8a1c5d92d,0x00040c52077eedfe,0x000dd13edbca01a9,0x000aacf085549c16,0x0000c5c3baf195eb}},
   {{0x0009e148f9290579,0x000630c853df27f2,0x000e9c5ce7a64ae0,0x0002a4956cd18358,0x0000d9cce836ed09}, {0x00059796e93b7c7b,0x000181bb9e27cc6e,0x0009e29a0e1e4709,0x000644070b3083aa,0x0000f181a75e785e}},
},
{/* digit=41 [{1,2,3,..,}]*([2^164]*G)  */
   {{0x000a13f1402b9d0c,0x00026c7bc863d3b3,0x0008c3e6e573441c,0x00057d8b301ec457,0x000026fc9c4cadaf}, {0x0001bfd7493cea35,0x000ecaf8145696e7,0x0008c608fd05d4b3,0x0002768aca2a8a6a,0x00003ef07f65725b}},
   {{0x000c9d646ac49d20,0x000b83137aa9a6b5,0x000225a3842c77c0,0x00090724d000fc68,0x0000f63cfc82fe1e}, {0x000b01bc6441f959,0x00095c8e448f22d1,0x0007fb1ba7d38f71,0x0008df0b33fa5f78,0x00004dcfda1a9015}},
   {{0x000ed45526f09fd2,0x000c6128240a057f,0x0002bfd8de8a4f10,0x000a317332efc4ff,0x000014e77a0dd35a}, {0x0006d7314faa40ec,0x000b41e5f1863289,0x000a1813e767867e,0x00079509adf8f117,0x0000b6cda7914741}},
   {{0x000de10296c36eff,0x000192c4da77211c,0x0007836da7ee8967,0x00060ac617d270a5,0x00000cd9c328cb75}, {0x000cbf7e455fe908,0x000afe7334f301fd,0x0007de4ec3fb53cb,0x000fcff81e2ea44e,0x0000adab3ad8b384}},
   {{0x000d47d53b618c0e,0x000b8a2279231c6b,0x00092d964c424f46,0x000bf19303ffdedd,0x0000971287951b5a}, {0x000a632f815561dd,0x000503c055d18f48,0x00025684f85f48ff,0x000cc2522a142775,0x00000d841a137360}},
   {{0x0008a2b599ff0f94,0x00074104fc6b0177,0x000694ff368a923d,0x000f121bfa44dfda,0x0000f7199dc37667}, {0x0008ff6e46f2a79c,0x000d29f8131dc06d,0x000b4ce7c08b5dea,0x000c3d42519a59ab,0x00004f710bd742ae}},
   {{0x000a90f0e0b040d2,0x000225ff897fb228,0x000fa6122baf02d8,0x0005570aac79e600,0x00004828817ae36f}, {0x0001d31113ec3567,0x000da5eff1f8b952,0x000d417159e48861,0x0001b7baa1d412e0,0x00001f86203c3f13}},
   {{0x000368b4ed80940f,0x00058a6fcedd3014,0x00097579f67e6d05,0x0007f58c208c49ca,0x0000e3d7a8292359}, {0x00032027e096ae27,0x0006b4b393665e20,0x000dcdffcb1f3e1e,0x000e82b6da26f32f,0x00009422f1dd097b}},
},
{/* digit=42 [{1,2,3,..,}]*([2^168]*G)  */
   {{0x0002cfb9db3b3818,0x000e54df0a4b263a,0x00004e61f9c3a2de,0x000324f28d06e97d,0x0000b1adfbcc2449}, {0x000d9397e053a1bd,0x000696daf7076ec1,0x0000ac7abee2be5c,0x000173b0ba1e1481,0x0000d2ae779c530f}},
   {{0x000d97a205b9d8b0,0x0004056756d40435,0x000f8210e6eb8f06,0x0009ead5e88a8bb6,0x000070ef12dec9fd}, {0x00095053bcc876ae,0x0007c7404ce34d84,0x000a1db5e12a7533,0x0005acf22b49e1b8,0x0000c1f2051f4bfa}},
   {{0x000eb79b6828f364,0x0007c1bd5b9eadba,0x000844b0c9d7a025,0x000fc9ada01e0d1e,0x0000b625175c87ed}, {0x0009fdd9669b6210,0x0006f6f87b981410,0x0000df6bc88a2ca5,0x0003f9fe2eb78817,0x0000cea06f4ffa47}},
   {{0x00081b5c4e83d33c,0x00089efd488b43ed,0x000eb4d0fd9f3587,0x000393564a620f9d,0x00006927bdc6c6a7}, {0x0008df79f9e0f036,0x000e9cd7e1a945c2,0x000a348f12868661,0x0008e01cf4e8d0ff,0x0000bd4c28499853}},
   {{0x000a091289a8619a,0x000fc671b1732618,0x00090c632ef796e5,0x0008fac64e46e590,0x000038062d4be66f}, {0x0004a200573274eb,0x0003f92713946c74,0x000dc0e20d07b67e,0x0005a6891223b26b,0x0000e2d93f29b0a0}},
   {{0x0002e533f36d1411,0x00043dfca442f23e,0x0007c023ae84bb3d,0x000c3ba804a48d6b,0x0000e16a8fa86431}, {0x00052adddd472e03,0x0006dd1ee1271b54,0x000a275997d405ee,0x000b3520fc6f1dff,0x000051ac53cef391}},
   {{0x00014b84444896b8,0x000f794027fb7efa,0x00084487d64974d2,0x00089b6fdcd0e8de,0x0000c45b260ab489}, {0x000bbc2d84634875,0x0006efbc476ca8fc,0x000f443c0d1b2b3f,0x00039bd1d005b7c8,0x000018f2e6790c01}},
   {{0x0006e8c06d75fc1f,0x00064249a89f5603,0x00045e7dd2dcf7bb,0x0002a691dd1d3de2,0x0000578dc4cdbd6e}, {0x0008903df2ce7a06,0x00083c39afac4c02,0x0006404abaee3628,0x0008187c847c3114,0x0000304c0d904e97}},
},
{/* digit=43 [{1,2,3,..,}]*([2^172]*G)  */
   {{0x0008b33070d3aab6,0x000b3a2cd5e5e4ac,0x000fc91732643672,0x00013ef2eff79b1c,0x000065ca49bf0a7c}, {0x000da59b3efb9983,0x000cd52f13415a8d,0x000f9a5308a5b922,0x0004d77e9ebbab3c,0x00005986e7c256da}},
   {{0x000cf4fda79e5acb,0x0009d630215f534a,0x00085756e68b83b3,0x000cb1ac748b2ed0,0x0000031725995d37}, {0x000841ac5ccc2c46,0x000add9d50696735,0x0001754bd7d7dc96,0x000dd54147e410fd,0x00005296e953399d}},
   {{0x000b3edf0290a8fd,0x0005fb47c387831a,0x0004efb4fcae8196,0x00010ddad7dece18,0x0000cfc53b417491}, {0x000f23c4cb632f9e,0x0005d91f80676698,0x00084180ac42a1ad,0x00026ed116a81d62,0x0000bedf5f9c9013}},
   {{0x000c4cdb30cfb3a6,0x00010c9db4c8d7e0,0x000c8d9df6d09b8c,0x00066ce0ba1a4207,0x0000fd495f77c52c}, {0x000169f275264daf,0x0005f57d8362fb0e,0x000ad722280c2b74,0x000c7afdd987f749,0x0000dc229b03398e}},
   {{0x000fe5a59b0ff628,0x0002c094d0d454a6,0x000437f1d25ec81a,0x0004dc7cfd834e33,0x0000e98378c26760}, {0x0007dd6f48485983,0x000f32fda36a5313,0x00074df4687f2c5b,0x00005640dc1c27ef,0x0000ebf428f3a86a}},
   {{0x000ac7ad0d350a3a,0x0008705a1f2f6713,0x00025404684f6ebf,0x0006f677a1495816,0x0000fa5e9a54ef40}, {0x000af7c1cdd69b63,0x00002ee86474f97b,0x00027f62a64081a3,0x00052cbb9f7f0912,0x0000e47f1dc64856}},
   {{0x0005e7fb7f01d83d,0x000a75ccf5cb6f97,0x00070930f5f1f860,0x00087852702eba8b,0x00008186df7fb5cc}, {0x0005da01720468f0,0x000100464c808c06,0x00077e1ca4247726,0x00042fd8c4bbbec2,0x00004aaea1766ba6}},
   {{0x000ed8452666a58c,0x000026a9c3c2b0d1,0x0009064084bcb6e0,0x0003ff7c57411c26,0x0000fc20755d3556}, {0x0001c505294dba30,0x00068b7dd31ea08b,0x0001eca74a30ba28,0x0002b9d70ba90e99,0x000094e142ce762c}},
},
{/* digit=44 [{1,2,3,..,}]*([2^176]*G)  */
   {{0x000783e979f39254,0x000a6f4c89a7b81d,0x0001bf7fa1efd130,0x000a9e125c2144fd,0x0000b2969045b265}, {0x0009634b9db65b69,0x000173599d8aed8e,0x0003563f335c82e3,0x0008ab4aa7a54f40,0x0000df088ad922c3}},
   {{0x0004f124237b64b8,0x000963ecfd078d08,0x000845dd8688ebe9,0x000324d7b8a70cf6,0x000008fc59cdda4a}, {0x0002b2ba3585862b,0x00053df29386a903,0x0001ec29bb66825d,0x000dc805a5a8db43,0x0000b143a98ea1e8}},
   {{0x000ba24f111661eb,0x00040105eb049e93,0x00024b578edced48,0x000068e6dc9ba1f4,0x0000f8f66b8983e9}, {0x0004df4d7ed8216f,0x00069e2cbecf872d,0x000e73754bf07f37,0x0007075281d89998,0x0000ec85fbc7aab8}},
   {{0x000bf22765fa7d04,0x000fdd6a537013b5,0x00080db9859805be,0x000ce327a5e29d42,0x0000f53916fb76b1}, {0x000f61f33ddf6269,0x000e1085d103714f,0x000809ee34206238,0x000b1c8c50d4b7e5,0x000099f450e15f8e}},
   {{0x000be731a3a93bc2,0x0005821adc1a82ee,0x000030efd42bbf46,0x0007bba10b6fa4ef,0x000047aa4c7a7b09}, {0x000c632f60c77da5,0x000a7223523e8b8d,0x0004579cf6ffbc26,0x0000f654f6ff1134,0x0000825653ce8025}},
   {{0x00067ba4a493b31c,0x0001dbf7f0264bf3,0x00095914b54f20a5,0x0006abf696e06297,0x0000ddab96e4bf23}, {0x000c70aed25ea138,0x000b01cbbbe74ff2,0x0008544c5fa1d09e,0x00031708fc8c8746,0x000047a670de96b3}},
   {{0x000c595d314e7bc2,0x000b267899ededa6,0x0001ed5d32ee7464,0x000612fcef423c0a,0x000017e76ea89cc7}, {0x000ce1fe7cda917f,0x000a9a893f1627cc,0x000c74f6b12d8016,0x000e60ccd6de849f,0x0000a5817e3e3144}},
   {{0x0004cc5ac751e7b7,0x00028d4211bdb79d,0x000de4fc693f9647,0x0000641c72d3d2c8,0x0000b69cbf64f44f}, {0x0000ca2f4bf94e19,0x0008612894e23da9,0x00017d60b1a5325f,0x000b5c7a437f6c79,0x0000be7048726c9c}},
},
{/* digit=45 [{1,2,3,..,}]*([2^180]*G)  */
   {{0x0009976e1337c262,0x000db73d68e5949c,0x000b768d96faadeb,0x0000697e158614f1,0x00002dfa557bcc4f}, {0x000da17be93c6d61,0x00019504f5b9ccd6,0x000694da124866c6,0x0008c61121353c8d,0x0000c6ca5801140b}},
   {{0x0004a7dd4b79bb87,0x000ae2c878c8f160,0x00047b8e8aee806f,0x000053c4144f118d,0x00002edf52c049f9}, {0x000a84e2127015a3,0x00006cb7cef3ebfc,0x0006deec89051d0c,0x000d7456e8fe5829,0x00003b2818871010}},
   {{0x00060ed9aed9f40e,0x0000732a8c99bd56,0x000c371ea70ca6ad,0x00009ce4978bfb95,0x00005464d0e50031}, {0x0002fdfd9e535ef8,0x000718c9185b1af3,0x000b42488abf57ea,0x0006fa6d7a741712,0x0000e0296a869728}},
   {{0x0009383171b445fe,0x0002a131ad4c0107,0x0003987e89bcf21e,0x000c8eacdfe205c9,0x000063f4153a92e8}, {0x00062a930add43df,0x0002d980f05a7294,0x00006e96862ebb14,0x0006b05f3954e53b,0x0000e1d75ae142cf}},
   {{0x000416e1f017d5eb,0x0005c674e99b8b57,0x000f488a03753339,0x00095dbe6d94c0e8,0x000093a787b8c16f}, {0x00051a2dcc99ccc0,0x00039aa47c1dc3ac,0x000dfd8d5c134b41,0x0001edf28fcdafaf,0x0000d57bd8e10b83}},
   {{0x000fbccf0bcfc46a,0x000e15cffee69276,0x0005d915b3a822ac,0x00076b928ed2fec7,0x0000145c11463594}, {0x00081538be17bcdc,0x0002ea6c3d8ff61a,0x00016c82f01e867c,0x0009af9634e15d65,0x00001437bd32948b}},
   {{0x000d2006c19d4c7d,0x000711b1e976d2fc,0x000f237e8a0f3c43,0x000bb120545ff694,0x0000d10ec4090bf8}, {0x000696cac7cd3e1f,0x000b6f24bfe64f89,0x000af7706ed3714e,0x000c31463eb1d85f,0x0000cbd604eb027c}},
   {{0x000c6c7af8685c8b,0x000d7f8f01aa5f95,0x00074692ad4c1c8c,0x000068144bbe3225,0x0000800347984a4a}, {0x000c6e52eca3cdb7,0x000b7c04d3997c8f,0x0002bc5cfea1db16,0x0003d2405bc82e8f,0x000063d518064479}},
},
{/* digit=46 [{1,2,3,..,}]*([2^184]*G)  */
   {{0x000963f4c8303203,0x0000603203e3f3b7,0x000327afb842c7aa,0x0009b67f22ca0ae7,0x00008e13092c6760}, {0x000fb62757558f1a,0x000157eca8c173b8,0x0003316273cc3e83,0x00023444174474f6,0x000077989cb63c40}},
   {{0x00017f4b0166f7a3,0x00079eec74e6ae83,0x000874bfdfbd3e3f,0x0003a3cdb516ace0,0x0000d846019f681f}, {0x000ee5c7c1620b02,0x000d0b63c5010b12,0x00068c51eba68b4d,0x000b5b8c03cd3266,0x0000a6279f76e0bc}},
   {{0x000b8b0b796d2197,0x000ec4741dd9b32c,0x000edf6f5c3e95f4,0x000b8e1721212568,0x0000a03aee512b9c}, {0x000c376f53a89aa8,0x0001148a28dc0cd3,0x0002ab04f0d8af9b,0x00002d4f86a3f490,0x0000aacb62aff420}},
   {{0x000139f8f5fcda83,0x00048dee5bfdfd8e,0x0003f9f77f3e558c,0x000969a76cbaf4e3,0x0000a4c97a4a1771}, {0x000e84bf6dce6a73,0x0005e3e6c2d1da27,0x00059a6e9ff373d9,0x00062cc115193cd7,0x0000f9b702593d22}},
   {{0x000ae6c252bd4796,0x0009b2b5848f9cb0,0x000c9766305e0f88,0x00025c18f6d2b2a5,0x0000f6e149c21622}, {0x000235cde601a897,0x00088373be1fe602,0x000471827d17bbe9,0x0001165af49a5ba8,0x0000e1a0a8588aaa}},
   {{0x0006fea87baa6279,0x0001672aa6801253,0x0001e5dc958c1fec,0x0001b8dc29b63760,0x0000e3c3c1d6e9e0}, {0x000127b2bcfe0b0f,0x00013a12f50defc8,0x00079b3973510710,0x000f207ccd6cb148,0x0000792f805e8a82}},
   {{0x000572235e6fc06c,0x000e4b3e13d58b1e,0x0008a73723477728,0x000289550c294daa,0x00000291d43fbfa5}, {0x000bc67cec5a196b,0x0003ac2e8a7cc6c8,0x0006e1c51deeb31e,0x0001560a93e244fb,0x00009f8b71bde28e}},
   {{0x00084911a335cc88,0x0009ea5913e48c31,0x000b32919563459b,0x0005ac9b920d61c7,0x000005ab8b720242}, {0x00012da8d006086c,0x0009fcf5c0fd2ac5,0x0002138d76ca4846,0x000442efea51d8ac,0x0000b647545f44cd}},
},
{/* digit=47 [{1,2,3,..,}]*([2^188]*G)  */
   {{0x00053e453544774f,0x000b4adba2bc5110,0x000e371f5834d0ec,0x0003bb5215d7f7ba,0x0000cfd57c05c866}, {0x000383dd6901b1d3,0x000485587dc3ded2,0x000625f623b49fbb,0x000762cd44a08d07,0x0000ee4d65bcde9b}},
   {{0x000137d0d63d1fae,0x000122a9d89f64e5,0x000436309658fc05,0x000a606889487450,0x00009ae30f9b598d}, {0x00010d1818baf918,0x00060b6a0c202ed7,0x0001a6b44e27e9e0,0x0007db9e28dcfb1c,0x000083acb6556ac5}},
   {{0x0002e774e6daae2d,0x0002ce0a19bced7f,0x000ae677e7b3ae0e,0x00011f03293f8a91,0x0000363b0cc15c86}, {0x0001ccf309ae93b1,0x00072920cae1be1d,0x0008edf01a3f80be,0x000c909aacba7449,0x0000e6d2a4ac2f5a}},
   {{0x000728dc2c6ff707,0x000f55dc22358735,0x000e277f979d6122,0x000cc6b3f5d00319,0x0000ee84e264ded8}, {0x000afb063cd880a6,0x0005d574af6091a8,0x000de7f423f3ea7c,0x000151acfcdc8402,0x00002d07930131aa}},
   {{0x000f5aabeccefb5d,0x00086621d7c740fd,0x000b576c1cf56ede,0x000026e632a9ce52,0x00003403ae96a6f6}, {0x000050de8785a64c,0x0006d682652e660a,0x000bcbe0210f3d64,0x00015cb8b25edf4f,0x00009710fdf74f93}},
   {{0x0004e438a5807cef,0x0002f4109a7e8e1b,0x000d59ddaad28389,0x000092d30cc9cbaf,0x000065f36c72d8d8}, {0x000469ea60d32b2d,0x000a6e8191c8df31,0x0005bdeb5ee93df4,0x000a27cc1017c535,0x000026231865616a}},
   {{0x000ade73245980e9,0x0006f1067200d655,0x000136be1a6f5965,0x00087954fc23bedb,0x0000f246cdd3f13d}, {0x0003117f961ac0ef,0x0004fbdb9e1ac2b9,0x000693bd1c8a741b,0x00001d92ede2466c,0x0000cde6b502dd17}},
   {{0x00083f9dec31a21e,0x00028ad9d573b02c,0x0007be365988c8b2,0x00034d73e983aea5,0x0000968734e446f8}, {0x000ea8f5da6309bd,0x0003f1f1ce169137,0x00044092110f3a62,0x0001b4a82a9ea2ca,0x0000f94739f2b46f}},
},
{/* digit=48 [{1,2,3,..,}]*([2^192]*G)  */
   {{0x000410ef4f8b16a8,0x000e447b266a56f8,0x0009c87c197241af,0x000b1a8a406b8e6d,0x000003f3e034d42a}, {0x00009a804dbec69c,0x00067bbad05f7f03,0x0008e197fa83b85f,0x000dc106097273ad,0x0000097440f1067a}},
   {{0x0007fa0b311898c7,0x00045d0eac653f74,0x00014d0bce2a272e,0x000ee2dbba5851f9,0x0000a1a966134a43}, {0x00067cea1c8cde9a,0x0008d271abe3e5a3,0x0001615cd9d958ba,0x0000b053ff7eb63d,0x00002280dcf95ae2}},
   {{0x00044a43794f8dcb,0x0009983c5c362663,0x0009d10a0dcca923,0x000df27d6b6bbf3f,0x0000320c5cb31d9b}, {0x00028ff47b50a951,0x0001bef03371620e,0x000100153933e3b0,0x0008d6e081bf8599,0x000083be9a0d3a8c}},
   {{0x00085c341dca5663,0x000aa8622aa3b6c1,0x0001b6dfb7de7fed,0x00028869e84d9290,0x00000a02b0eac4ad}, {0x0001daa2fd3cf36d,0x00070f89e59fc7c8,0x000496733d131954,0x00012ae2be8184cd,0x00005f449ec63d34}},
   {{0x0000fabe085116b3,0x0005572853102547,0x000bfd52f04a4337,0x000c741e39187ee2,0x00006166b44ad9eb}, {0x000433cfd4b322cf,0x0006ca79ab5192ad,0x000db15eb726aa81,0x000e63096eacd8c1,0x0000af71e91f476b}},
   {{0x0009bdac97e65165,0x00007230f49ed74e,0x00074ea498877936,0x0005a256ec1de31e,0x000081dcee58fb64}, {0x00023918f483f148,0x000c5137d13bbaef,0x000743a426d2dddf,0x000e66d4cde50ed2,0x00009a34fc664d97}},
   {{0x000d2e949dee1686,0x0002de2af23972cf,0x00094066a1ae0522,0x000412a09e75be1d,0x0000cca31c798abf}, {0x000d61d9bc499082,0x000cd5e2bc1eb50b,0x0006f83ac4a9b4a8,0x000b28cb6cc5f794,0x00007da93fd0bffa}},
   {{0x000ec644cd8f64c3,0x000ff79d7b51c492,0x000c7525658a2d78,0x000016dced1fc51f,0x0000e658aedbf433}, {0x000942e05da59eb6,0x0002addc37220b61,0x0002e7f87ba3d60a,0x000b6e1c311cd174,0x0000473ffef56b01}},
},
{/* digit=49 [{1,2,3,..,}]*([2^196]*G)  */
   {{0x000604f692ac542f,0x0000327b91d38303,0x000aaf9bdf079ffe,0x0004fa29f63e6315,0x000099ee566e1f34}, {0x000661fd62191997,0x0006648ce41c8a1d,0x00074d9048c883bc,0x000b1aa065118f3c,0x000013889ee7faf8}},
   {{0x0003f8f81a1b3bed,0x0004fe2764a0972b,0x000c4f5f74f3ce14,0x00085b12d0f1cc28,0x0000eee0c0e97f39}, {0x000adc0d39e25c35,0x00007467a0807df4,0x000cf5a584061982,0x0005fff40ebc9361,0x000027729a6922ad}},
   {{0x0000937b1b76ba6f,0x00045d2026dcca6c,0x000d9ae0a1a2eab8,0x000025c1715e1519,0x00001ad919aaac4a}, {0x000dfb807ea7b0ef,0x000e4ed9eb8935b3,0x0006d08abedf5496,0x0007309932e5ff2d,0x0000314874f15bd2}},
   {{0x0006a753f73f449b,0x0007dd44fc79efb2,0x000c0dc4d1d1c94f,0x0000cf99f0fbc53b,0x0000747ea0be698a}, {0x000c3fe228d291e6,0x0004e3c129d65218,0x000acc51635b804b,0x0006689ac859b8d1,0x0000c10697df5d6e}},
   {{0x000438f0876fd4e6,0x000723d2f383c38e,0x0000934cb45f0c30,0x0006edc03cc2ecb1,0x0000a8f24398c9d4}, {0x000431b65ccde7b6,0x0007c7e76a6ff16b,0x0003484d741e2cd1,0x00044a59c8cf8f4e,0x00004426efde3152}},
   {{0x0008e44fc94dea3f,0x000eead6a0b01c0a,0x000113cef34c8cdb,0x000ff9a19c384004,0x0000d32fba505490}, {0x00090f6795dcfb75,0x000333588baf58d1,0x0001fc1c0fef01b0,0x000ac94e6d1d63ca,0x00003173f9740a41}},
   {{0x000402aba16f73bc,0x0003ccf9b9fc2b1d,0x0006ef7bf2fb3101,0x0007446d51e60e44,0x0000731021c791e1}, {0x00047244fee99d47,0x00068ac5c1ea9d3b,0x000ea9af74bca48b,0x00083a00f5f514bb,0x000051f55a6074c2}},
   {{0x000251acb452fdbb,0x0004a0f306506e30,0x0003548d931ee696,0x000f5b00b3e50893,0x00008949a50a4b0e}, {0x00083263c88f3bd1,0x0000cb1d9989208b,0x000d4df03ab147c3,0x0000c5dd6515fd44,0x00007a12f75f72eb}},
},
{/* digit=50 [{1,2,3,..,}]*([2^200]*G)  */
   {{0x0004f7881fdad909,0x00057d2cf6ab2591,0x000054de5cf638f5,0x000350290bc03fcc,0x000032811a7a8b06}, {0x000b3309bbd11ff0,0x000fb40449742f00,0x00051d26676108a6,0x0000c1801bb9e0a8,0x0000dd099bebf899}},
   {{0x000dd8a58d6cd461,0x00057e6634d214c6,0x0001bc3289cb633b,0x0007e5b1305047f8,0x00002ede0e236a17}, {0x000ca62065a6f4f9,0x000cd7be487b332c,0x00047ed1cc3a47ec,0x000b13e41eb1870f,0x00009e66e5977598}},
   {{0x000a6777b0ac93d1,0x000d68f5e0d7ebd6,0x000f5492ba6e37b0,0x000f3a1516c09676,0x0000e4bf888aac05}, {0x0002ce04df0ba2b4,0x000d1062341bcdb4,0x000acac20935d5cf,0x00000e4a30333382,0x000029438c49198b}},
   {{0x00038be67e573e06,0x0008e084c44bfb28,0x000c1c2c505891db,0x00044b3131137396,0x0000aebfa4039584}, {0x000dce9e56e55c19,0x00029caa46d0ac9c,0x0001fe8eb7148ced,0x000f4c9e10c7efb6,0x0000fd835db8f97c}},
   {{0x0006f56c17706169,0x000d79da9a2d6c62,0x000730e455351909,0x000a79558e6825a3,0x0000d8c8bc093ef0}, {0x00078b6056becfd1,0x00039090b36d543f,0x0004432f933f1325,0x00050272ad499779,0x0000386493c5721f}},
   {{0x000eefa5abea82a6,0x000933fe62d43794,0x0001ef6068dc611b,0x000e6909f1af3728,0x0000af546c899839}, {0x00078c7c977ec238,0x000c3d5c05766255,0x000d1a4c0a8de294,0x0004d462ddaf0f7c,0x0000243fc70cf95f}},
   {{0x000f400b008733a5,0x000d012e1f57e566,0x000509cd0cba0697,0x000d8c4537c2b240,0x0000f989c69a7353}, {0x000c9724c3c2b2fb,0x00084f031fa87dbe,0x000d5d11f90e02fa,0x000dfc44d15c53cf,0x00003404faef8314}},
   {{0x000a109081e9387c,0x0006cc935828a36d,0x00040b015fb9780d,0x0006fa15940332e5,0x00009d7b51ca0f46}, {0x000cd41d6d9f6711,0x0008a1a2ac17faad,0x000201e5fba6c1e2,0x00062af66a7833ed,0x00009d9971a090f4}},
},
{/* digit=51 [{1,2,3,..,}]*([2^204]*G)  */
   {{0x000f462060b5f619,0x0003ebd057c2f431,0x000e1bf65a56f46b,0x0001fea48dca6c47,0x0000a38783ed1bcf}, {0x00033a9da710718f,0x00063e0aeaf67a5d,0x00029d1875a77998,0x000732da87314d2d,0x0000a0edc3fb687d}},
   {{0x0004849cb198ac73,0x000cdf2646651c89,0x000200678a884a93,0x0004e5fda964ef9b,0x0000c351b8730983}, {0x000ef9fe2c4b44b8,0x0006b326790cafb2,0x00002264a580f6c4,0x0004e2384805210b,0x0000ba6f9e2c2a19}},
   {{0x0006ab65eb03c0ee,0x000392bc3fde499b,0x0003a80d2f19b795,0x00019ec86b5b9c6e,0x000043775094d428}, {0x0003650bb3ee8a3e,0x000bd132075fc166,0x000d834f675eb14f,0x000ffcc8ccc9067a,0x0000a6a2475c6e92}},
   {{0x00034abd3c095f18,0x000e64b76d7139d9,0x0003e698404b261b,0x000b109d2e6970e7,0x000079fb23bde5fc}, {0x0006c72dfd754907,0x0004f1bcf1c11150,0x0005e70073a97d08,0x0002a6d3201d82bf,0x0000f0ac52fe9823}},
   {{0x00020ee4b049136e,0x0001556a4613cb4d,0x000e081288b63bf1,0x000b153221aef670,0x000062d8c522acb6}, {0x0004a67379e7896c,0x00020afd7fa571f6,0x00041ba6ab25237a,0x000e7e3077bd9838,0x00004ac0244fcd16}},
   {{0x00001fb319d76820,0x00090a982feeb251,0x00061b344b029312,0x0001fa51c1c9b902,0x0000e008c5bbfd37}, {0x000dd1c0278ca331,0x0006d5aa53b1d866,0x00013a2cf666f76a,0x000836d5cfb77960,0x0000d3a1aadb3521}},
   {{0x00004ff50f75f9cd,0x0002ae752b223c56,0x0009a11181d8eddf,0x000d7a3ef074dd3c,0x00000ffc1739cb86}, {0x000ece3037d90f29,0x0005d055856cabd1,0x0004c6dafe3f307d,0x00099fb22f93287e,0x000002aac66c3487}},
   {{0x000131a567193ec5,0x000a95f6e70b76b4,0x0001eebddaf3c305,0x0008314587bd3903,0x0000709def8c1bbe}, {0x00099830eb2b6692,0x000b675b70295705,0x00064ac164d80ce1,0x0003ab638a7da803,0x0000f431d23de1c8}},
},
{/* digit=52 [{1,2,3,..,}]*([2^208]*G)  */
   {{0x000bc15adf7cccff,0x0005efa1e1b075d9,0x0009bc17e81a3e5d,0x000d429c39e44424,0x000037dccb37ea7f}, {0x0004873907fba12d,0x00097a372904da65,0x00083a6c535daa6d,0x0005be3564cfc662,0x000009fa4f71a939}},
   {{0x0007080eb6b242d6,0x0002db71e246832d,0x00031139dd30bd02,0x000e531027991bbe,0x00008797e91a62e4}, {0x000e20a6b4e185ab,0x000d92d9b707423f,0x000f7811b82f2c67,0x00095c75c817684c,0x0000d53005eb45bb}},
   {{0x000a29e5cfe5c487,0x000e115ee096c51a,0x00049a68a82c020a,0x0003550848ad8275,0x0000933d489d0471}, {0x0008d2e67c51e574,0x000a99944afc0499,0x000fadac60f64020,0x00092c3a299fe1a7,0x00000c73ff49aefe}},
   {{0x00049be9d8e68fd9,0x00028b044320e5f6,0x000c33398db0f053,0x000fae66fde9b3e0,0x00002f4209bf6c8c}, {0x000afcc1a739d4b6,0x000f428ab8dee9d1,0x000c6f1d009aea75,0x000aa4b4375fb5ea,0x0000420b560d08f7}},
   {{0x000ffc75488771a4,0x00013f2f2191bf44,0x000f86a42cb76e3f,0x000d9a0197bde394,0x00005c25bb9b0641}, {0x0009e31f88ce6dce,0x000c6bb7ac7dd8a2,0x000670cc7be2becf,0x00043233094214b5,0x000090a8fd640af8}},
   {{0x000fd5696f37750f,0x0006a1507ff22d1a,0x0006543ed25dda55,0x0009103b95fd4c00,0x00003c778da923c3}, {0x000f4463b04938d5,0x00062eef947b84cc,0x000e325b53d9dded,0x00055d6ed83735da,0x0000ba0f75d49214}},
   {{0x0009b8b4ebd3f02d,0x000cb6b770ea0ecf,0x000a213cea47acd9,0x0008cec3b84a6a2d,0x0000760871c23e7c}, {0x00058e536e530d74,0x0004d912ad517a5f,0x000a0252a7abc52a,0x0007423ad43db02e,0x000098b00ed0176b}},
   {{0x000499c6254dc41f,0x00038a837e7e9eae,0x0000524a77e29392,0x0005f184aec08c09,0x000082b921a7d6f5}, {0x000962e1402cec5e,0x00071a2f30e7493c,0x000b879cb9f17ca1,0x00045edcd783e8e9,0x0000a3d8c153a6f1}},
},
{/* digit=53 [{1,2,3,..,}]*([2^212]*G)  */
   {{0x00046e60ebcf7262,0x00014231470e103c,0x0007c21094482b83,0x0006ef4f6dfaca48,0x0000e0ace9782e66}, {0x000a9d31f8d1f420,0x0001574944d23246,0x0007f334b1b1e83f,0x000d8113dfa63aa5,0x0000cf8daed9f025}},
   {{0x0001f0d1e935abb5,0x0003c54de37a85de,0x0009cebb5defd10b,0x0004be68d9e39236,0x00004d5ef9bc6132}, {0x00041ba74f17e266,0x000818c1dde44d63,0x000d918fdc0a0e3c,0x000a1346d7758187,0x0000687601562ca3}},
   {{0x000180c207674f17,0x0006c3ae8fdbbc19,0x000aeb71e112e09a,0x0001c7296675546a,0x00009432af25101b}, {0x000558fde2ddec64,0x000f1357753fd5eb,0x000e1158a81392d1,0x00099167a76b973a,0x000016fbbff8a899}},
   {{0x00032c7904fc3fa4,0x000587e3636aee73,0x00091d9aa14a23f4,0x000540838659c3f0,0x0000a995e5df12d8}, {0x0003becf3a5598a7,0x000741eaa99520a5,0x00004e03c56534b1,0x0002682ed3dca4bf,0x000016c563b48d56}},
   {{0x0006e892f3b26e7d,0x00000a8752476d95,0x00082dda3f470986,0x0002ef6ad1517924,0x000064110e3d17d8}, {0x0008d2cfad414e41,0x00081ed02b241492,0x000821bf12b155f5,0x0005da381a141bcb,0x00002e3c7705f81f}},
   {{0x00044ea308780f21,0x00012845f5e4dd59,0x00024d7a3dc8de76,0x00011e5beaba7d76,0x0000e709afd404df}, {0x0004376021704560,0x000ac8f94b649536,0x00080ca68bf204b3,0x0005744e53af7c56,0x0000526074ae0c67}},
   {{0x000a63e7882f14f1,0x0004f7c6cadce29f,0x00082bed0c9f6dc3,0x00052c36f22d6fb8,0x0000a45755be118e}, {0x0007c277c4608cf7,0x0001e68012c29f2c,0x000729b0e7ccbdf3,0x000dbf8cb0aedd61,0x0000ca2ca9f67d75}},
   {{0x000dea7e0f222c2d,0x000ba2e651425043,0x00016cd30309d42a,0x000eebc4fe9ddd92,0x00006539c7ddf87f}, {0x000a57c432ac7d72,0x0000127fda1003c5,0x0000698de72692cf,0x0003b1cc28c85f28,0x0000331fb469ec28}},
},
{/* digit=54 [{1,2,3,..,}]*([2^216]*G)  */
   {{0x0008eeae457a4773,0x000bbe6ddc05a015,0x000c41671d19857d,0x000d588326522418,0x0000ffdfc7e6c2c0}, {0x000525426ee7cda3,0x0009af02c3a83a3a,0x0003bbfc8341b086,0x0006917023bf4272,0x0000d15002a44452}},
   {{0x000324c85edfa308,0x000407d4f3da5ef7,0x000b50c862597655,0x00096bb52f5bc0dc,0x0000f6927b0c832a}, {0x000e1ba55f2f94c5,0x0008e44b45fad08e,0x000aa455d6a996f9,0x0001f79133cb8da8,0x0000d0721ecc58dc}},
   {{0x000e7e9262a35393,0x000d3670d59ef3ca,0x000c5e1b978a49d1,0x000c1c07de0f63c1,0x0000072c30c99cb7}, {0x0008a5277c850e61,0x000f0f6a3de61d27,0x0002ca7ad84f15f8,0x0004b836a8bb4559,0x0000912e3eef4d42}},
   {{0x000a92079e5fb67e,0x000a90aa725e6ba7,0x000f5d837e1331fe,0x000e207080ccf57d,0x00004cae01e5ff72}, {0x0003ee60412a77db,0x000c2f449025d924,0x000ef5a3106ff7ca,0x0007a80e75f7cd23,0x0000c957822bddef}},
   {{0x0008086365e668b9,0x000a1abda5fbdc98,0x0005f1fbeada8dcd,0x000fc32c146b4c25,0x0000cfcde2a5f34c}, {0x000453e7e85d1e48,0x0009792358b5acbb,0x0000823ff9ca0967,0x00011d95fc2d9624,0x0000d65adf78c11d}},
   {{0x000230cb0ce1c552,0x0004ebbfb6078cf7,0x00016363b5b534d0,0x000e82ce1ef1130e,0x00007e0aa7ad4999}, {0x000ac2d79362c410,0x000091bb6cb0ce1d,0x00023df2467920c9,0x000f281e648d6322,0x0000f7d9eefe32e8}},
   {{0x00057f10296f4fd3,0x0003ba51b4367755,0x0009508051dca76a,0x0007f1c3e98f60fb,0x00001ff32eab31cf}, {0x0007bf18d2c714bf,0x00083e9d2aca643e,0x000dc2d2364b5c33,0x000b9ab9fd9ccc6a,0x0000c2397edbc721}},
   {{0x000f39afa8338349,0x0002163285626943,0x00070fc102295172,0x000e6cf1d63dd541,0x0000f5fa5903ecc2}, {0x0008725e77d9a3b0,0x000a6384ebe0b66c,0x00045e24a11235ce,0x0003b106a8c11858,0x0000137b286ebd09}},
},
{/* digit=55 [{1,2,3,..,}]*([2^220]*G)  */
   {{0x0007d6ac42bd6d29,0x00082b1f96aedb56,0x00043b28e6df8646,0x00023f7efe5b1a48,0x000061bbb05f379b}, {0x000f5f070a6a26b8,0x000cb28e6e39b6ca,0x0005fc8d370686c0,0x000dc900da06cf89,0x000004d88113363f}},
   {{0x0009ce74462007dd,0x00047cb5f5b763b9,0x0005edde7b8ab48a,0x000fd9cec673d2f5,0x00001567f755cfae}, {0x0001b6b0887bcec5,0x000e9178f3c24638,0x0006266cb694497c,0x0004130e6525e31e,0x0000931de26b97d6}},
   {{0x0009da11f17a34c7,0x0008b35a145614e4,0x00050363b5420ab3,0x000b6e476372412f,0x0000b15d62433fab}, {0x00040b1e274e49c4,0x000456b1860aa0ef,0x000afe5a45cf5074,0x000e9a96583fbf66,0x00004240511347e3}},
   {{0x00055021a93507a4,0x00074d3c06cf142b,0x000ec3f40b4cd118,0x0003c29f70e76a91,0x000084e81ad8e755}, {0x00087b5272e9d6ec,0x000506ff514a830f,0x000192a8eea1c93e,0x000359a7cc2adcc4,0x000077e27e302f45}},
   {{0x0008b1e48ac28403,0x0004bcba9477b535,0x000946b431831129,0x000819aa58f990a6,0x0000098baf9cab41}, {0x000c1584198da522,0x000bf46bfd1b66c4,0x00036a908ab4fc17,0x0008380f0a4c3cbf,0x0000ae9e34b78cf7}},
   {{0x00040ec0ccced589,0x000b7da44f9845eb,0x0001812c625cd4b9,0x000650b3e0645887,0x00009f80d55a6cef}, {0x00040c9ce6dc1532,0x0007b86655215713,0x00007014d138d511,0x000b918cdb45bc4e,0x0000f34bb38a4b60}},
   {{0x00099e84a34f239b,0x000c090402d54174,0x0003aa83215fdb83,0x000db1075f46bf43,0x000061e15b013215}, {0x00059d4a127f89a5,0x000bb7e816daaabe,0x00018b6925d541e0,0x0000265aba0659a6,0x0000532773367266}},
   {{0x0009cf2d0c051995,0x0002aae784548cda,0x00072a182502fbc2,0x00037270bda9dff5,0x0000f9b71b8b158b}, {0x0003a592b82dd077,0x00052523032ee0f3,0x000505a327630273,0x00009f0fe1a721c4,0x0000b6e3e8367964}},
},
{/* digit=56 [{1,2,3,..,}]*([2^224]*G)  */
   {{0x0007bc035d0b34a2,0x000b6327c0a7e341,0x0000362d1440b386,0x0009436fb7262dac,0x0000c41114d00cdf}, {0x000cef1ad95a0b12,0x000847d543622ba5,0x000e486c9c09b37a,0x00029706d6cdd201,0x00000477abf62ff9}},
   {{0x000dcb3292a92874,0x000637b092c7a004,0x0006c0605ddc15cf,0x0007afc83a846480,0x0000a68df707db99}, {0x0004e4505bf7dd0a,0x0008eccf7f8c9c13,0x000b5f8afa4e63d3,0x0001cc06e6517f41,0x0000a8b93434d7bc}},
   {{0x00035b51e706ad97,0x000453a9ebdf126f,0x000608d90b99cebb,0x000858375389afbf,0x00006113c5036c89}, {0x0008eb097e2b5aa3,0x000c33b9130480de,0x000cc066c7e1022c,0x0009000bdab6056c,0x00003cbb144e2edf}},
   {{0x00064717af715d2e,0x0003f0134a96c417,0x0001ec956e2f7f59,0x0003034c1873efa4,0x00004e7b4f757821}, {0x000ff9788d5374a6,0x000320823d5be5c8,0x000ee8fe22b915e6,0x0006518a6bc755b2,0x0000657624d47112}},
   {{0x000f101dace5aca9,0x000181a6a267157a,0x0009c8609c4fdbcf,0x000a654addf340c4,0x00007e49f5379604}, {0x000e790937e2ad5c,0x0007726e17f19be8,0x000bbc0dc846e250,0x0006d57f38007a0b,0x0000f036040711e1}},
   {{0x00000e07442f1d58,0x0000e6e0e3abd6f8,0x000c64047475607d,0x00083d02807f16b7,0x0000858e1e427498}, {0x000120b8231ee10a,0x000ac38a1ece5859,0x000aa73a41b80e7e,0x0003ac2b72525ac6,0x00007cdea3e24442}},
   {{0x000c007f8ae7c38d,0x000b6d7401925ed0,0x000e36db36db07a5,0x000045ee5e9c2a5f,0x00005b9d57b46e95}, {0x00032e78eba20f2f,0x000e81b9a35254ac,0x00098a658ef11ca8,0x000666405e373eff,0x0000fe5a101723eb}},
   {{0x0007b11e51732d26,0x0007c538fc0e5747,0x00039eec5dfd6eb2,0x000c56fc43b0cc3b,0x0000af127792b36c}, {0x000852d06c425aef,0x000b6c221b9b70b0,0x000826d9c6df92f8,0x0009c27c8d4f9ece,0x000059aba7ca4935}},
},
{/* digit=57 [{1,2,3,..,}]*([2^228]*G)  */
   {{0x0002c2e421d3aa42,0x000cc84fa840c37e,0x00054e41cf926407,0x000643f8abc03d14,0x00006605ecd5f7af}, {0x00041a6d6a5eabf5,0x0003d16b668e2423,0x0000101021edb84f,0x000d8c8836edb804,0x0000b337ce7e45e1}},
   {{0x0006b86d23ddc820,0x000c7e0143f04c07,0x0007af2c503fd344,0x000a4fa95362ff31,0x0000add3db7e18b7}, {0x0003e3f8260e01bc,0x000494a1cc919c67,0x000f2e433fbeb49e,0x0001ead1351bf292,0x0000755e7ed45114}},
   {{0x000e368da9f3804c,0x000de164349c349a,0x00062baa5470f07f,0x000df3152f4cc985,0x000074a9e86eb290}, {0x000aa3543471a24c,0x000df8194511d3a1,0x000dcd44d239446b,0x00082cfec2dd0081,0x0000a3d7f10842ac}},
   {{0x000db47f23206d55,0x000fcd2601522bf5,0x0008ff89a2f6d341,0x000457c7b876533f,0x0000157c30c878fa}, {0x000c5c52d4fb936f,0x000bf6518cdc7517,0x000847a64ef22f7a,0x000a88eeb483e6bf,0x0000508455982e0f}},
   {{0x000c2a69b583160e,0x0003d4e59194b418,0x00083e3ffbe74fcd,0x00029b1178eeaa3c,0x0000051f896c296f}, {0x000523806ceb84af,0x000df111fe6bd023,0x0000455455ace48c,0x00014550e43a491c,0x00003fa86decd522}},
   {{0x00016fa908ec5b55,0x000d501ab12d9596,0x00082ae8a882d661,0x000f5e749f608243,0x0000cdf92ebad133}, {0x000cc425ef6c9c1e,0x0001864d84ee98ce,0x00025b8c4b52d668,0x000e87be285ed86f,0x0000b80cdc828deb}},
   {{0x00094c1ec222ba0e,0x000e723e5d482d97,0x000e4846bc3dff42,0x0001736a7cd5700f,0x0000fc5b114df135}, {0x000b25bc6b05e85d,0x0008954cd0772630,0x000d8b89d0a6d302,0x000c26e4f1f54f32,0x0000e3baff2e627f}},
   {{0x00059d8df7304d44,0x000bbf210e8eab96,0x0003fbd60b71bcf1,0x0004de69a2438bd7,0x0000595cd1f9d11b}, {0x000329a4835859dc,0x000cbdbb6e569c0d,0x000928a4e4a0f0d2,0x00015406038e5edf,0x000094296224f5ad}},
},
{/* digit=58 [{1,2,3,..,}]*([2^232]*G)  */
   {{0x0003462f23f2d925,0x000d10b940789121,0x0006cde206cab71b,0x0004bc1bdd0a6317,0x00004c9b20d3e4d5}, {0x000d8aa9f2ac02f8,0x0006a06eedb03cd2,0x00008643403f8e61,0x000db947f68e1693,0x000031469c612dd3}},
   {{0x000a1583ae9c1bde,0x0008037ce2407aa7,0x000ab38b4e0af6d9,0x0008ca054342d928,0x00008b75007ea1c9}, {0x00086afe02358f2b,0x00063a921228efce,0x0001c67fc31b8b85,0x000d58552a19120a,0x00004069ea593aea}},
   {{0x00090cde36d07576,0x000179a293824a90,0x000b48ddff722d7b,0x000f439b7fb04c04,0x000028ad2a84be16}, {0x000bfb520226040e,0x00007104b6c4cd3f,0x00003c1886c34ecb,0x000aaf50c0754ec9,0x0000c336b090d23c}},
   {{0x000439e558df0194,0x000a6c712b279f51,0x000185a24230da4b,0x000f50118919e355,0x0000dcefcddc4b78}, {0x0000fb2a47d4c5ab,0x000f030e009ea7d9,0x000eed27355ac9ab,0x000faf4d2fc35974,0x000072d824d8bea8}},
   {{0x000f923cbb13d1b0,0x00025bfb9bfed213,0x0001144a998799f4,0x0005ee1ae8ddc970,0x0000b8b3bb64c559}, {0x000ef2e3ecebb211,0x000b2671f9a70ea9,0x0006f1d1f17cb6c4,0x00027637ef464f72,0x000071b94847943a}},
   {{0x0008552de7e5c194,0x000981c0256c779b,0x000d4743dfab2860,0x00093b24f58eeeab,0x0000e8ef838bb6cc}, {0x0000d264cb1bf3d1,0x000963dedf61ee65,0x000b70ced4c1f9d0,0x000e1e9ef7c9d7bf,0x0000ec0507e2641d}},
   {{0x0001109a607419d5,0x00026b6bca80c994,0x000c431f3faa71e6,0x000479e4158c1307,0x000094abebce92bc}, {0x000a691eb78399f1,0x00052f42cba46dfe,0x0007c04f048aafb3,0x00091addcd65af07,0x0000a29a366f8844}},
   {{0x000b2b5ef7d92893,0x0007e97f015a549d,0x0000493b62480d4a,0x00033131d5590bc4,0x0000a55b52e9f780}, {0x0008115309eadb09,0x000a02e5c62540eb,0x0006a3d5adea7de5,0x000d60d4d631f0cc,0x0000d5e9d7d23e8d}},
},
{/* digit=59 [{1,2,3,..,}]*([2^236]*G)  */
   {{0x00060411e84e0e5b,0x0002fea34c931968,0x00073a732a5db84d,0x0007c049d5bb1970,0x00008d2fe571bcfd}, {0x0005f36f3eb82fab,0x000c4dff8b584577,0x00074c1108cb20cc,0x0008996659b65f83,0x00008b4a422e30c7}},
   {{0x000cda3af2ebc2fd,0x000cfb4efe24c4f4,0x000cd10b1a0af843,0x000e0383b857c19c,0x0000dc9d1ec614d3}, {0x000c8bb62771deb1,0x000a81c5aa817bde,0x0002391ae829277a,0x0004ca6af18dd683,0x0000740f316d71a8}},
   {{0x0000910cab91f1eb,0x00039d1cd2162d50,0x000d02252bedd9e4,0x00017a2634b74fed,0x0000d60f8e1c2586}, {0x000537b9e05614a8,0x000667af5fc5d8c7,0x0002bd926fd26c76,0x000fc78660b58158,0x000070192452cf07}},
   {{0x000e99aeeaf8c495,0x000d1e24d7288928,0x0002b156cee7aa73,0x000a1cfc5007c2e7,0x0000fcf57c63d408}, {0x0009e39b6057604e,0x0000e2868bbf9f71,0x000103e2d7d343c0,0x000ea14cca254b7e,0x00006eb38aad131b}},
   {{0x000e3520a981b0d0,0x0003bd1a41a40ba4,0x0009fab9c1c354cb,0x0008d51aabaa3adf,0x0000701a7d153c41}, {0x0007cefdcf2b9218,0x00033cf48061dd1a,0x00025cce66ceef0b,0x000e339083b598de,0x000090a54c8690a5}},
   {{0x00018db4f6d01b11,0x00027f11e8a04057,0x000591a3be73c6bc,0x0005319c11bb8ca0,0x00002d09a5a1acc4}, {0x00074eee7de13f4c,0x0005444fd682cbf1,0x00048af70177e2be,0x000b7ba5f574cb1c,0x0000e5966935961c}},
   {{0x000ed6c048752a14,0x000e601341b4c59e,0x000c6b09241f2702,0x000b232e35903b9d,0x0000291aba85f5b5}, {0x000aa70a653d61da,0x0003af2eb51e8173,0x000b93f8fd1b648d,0x0004fd91b7ce065a,0x000055408ef39e2f}},
   {{0x000624f8be762b49,0x0000758e3413b33e,0x000d805fa2a9ee4d,0x000fd7068e636967,0x0000848949c0db8b}, {0x000d7e5d23a84178,0x000d73e29da55308,0x000ee471f892f3b1,0x000089495c139e3d,0x0000631594e5757e}},
},
{/* digit=60 [{1,2,3,..,}]*([2^240]*G)  */
   {{0x000e2ea1f095615b,0x000664e68c331083,0x0008818be0a28ad7,0x0000ccbbfc02523d,0x0000585113ba3585}, {0x0005f0b30df8aa1c,0x000b8ab7e3ac7d93,0x0002f00cbaddda07,0x000f6bd2c3429955,0x000033ed1dee909d}},
   {{0x0000d483e07113c9,0x0008ed8b63ae2dc4,0x000684c2b6e4a5d3,0x00026bc582a94b79,0x000032b33d4f22da}, {0x000f6510dbbf08dd,0x000894c23a52f534,0x0005bdc9b211d07c,0x0005573eeece0fee,0x0000f178169c7015}},
   {{0x000905a83cdd60ed,0x0004d1170184abe7,0x00023642a50602fb,0x000aff989886cdb0,0x0000568d09176e1f}, {0x00022c70259217fd,0x0008f43141e45b19,0x00095f86e93831cd,0x0008280fca35870c,0x0000ec2057b268ae}},
   {{0x0008925913cc16df,0x000cf1a26f5a568f,0x000f499ae18bc5b6,0x000e83efa413bef5,0x00008835dedb3f0a}, {0x0000bd865a40ab05,0x0008c94b377eb6e6,0x000084a696559643,0x000de06cd8562592,0x0000ce433b99f23e}},
   {{0x000523d42e06189e,0x00006e3aff13860d,0x000b20650bf07794,0x00000c2b616dcac1,0x000066dd6d201313}, {0x000fd67ff99abde3,0x000097aac50dd4a0,0x00046b2d7c990355,0x0002aed22ecf8b7c,0x0000333b1e86abf9}},
   {{0x00065e784d6365d8,0x000f0f759fb8c0da,0x000e81930bcb7443,0x0008aab5c712b17a,0x00000428dffcc6e0}, {0x000afefa4faf8433,0x000dcfa9855ff19d,0x0003ac7ceced8538,0x00071df0ac409cbe,0x000058c1fb6b82da}},
   {{0x000def7be42a5821,0x000055046be6efec,0x000e8dba9d3fc608,0x0001ffb9af13c809,0x0000e6c984774149}, {0x0004925d30c31f70,0x000aac2a21223b57,0x0000859e7b7eb72b,0x000942776a0dacef,0x00006fec31421900}},
   {{0x00094b07e50122b3,0x000b1af07ca53247,0x0003fc97bdd744f8,0x000d9d00a12f08d6,0x00009650f1aa6626}, {0x00047f71fa38477c,0x000914dc124f101b,0x0006eb58a3d815f1,0x0008865569ae95b2,0x00003cde18955fb1}},
},
{/* digit=61 [{1,2,3,..,}]*([2^244]*G)  */
   {{0x0007a952f41deff1,0x000ad63b89b702b3,0x0003ff9510e44a59,0x000af4573257dc14,0x00009c02205e752b}, {0x0003069c4b7d692e,0x00031d1502ac46c2,0x0002208462e6392c,0x000b628057b1a21b,0x000051ff946ec1b5}},
   {{0x000cb51566c5c43e,0x00085597f0466e85,0x00094d94acff9c91,0x00027cb354e90c49,0x00000a3933301479}, {0x000fac10dc1eb2bf,0x00013ff319fa8427,0x00096527488cfd8c,0x000745f2d4e68401,0x0000a2e067e57aaa}},
   {{0x000857c5b0f7bd45,0x0008c08ea1cdb9dc,0x00084c7a96990c2c,0x000a7834730b83b9,0x000052723d33ab18}, {0x000c2e2919ba0f93,0x00091bf408909752,0x000d98212075a3bd,0x0004c841e52a04a6,0x0000fb6607acf18a}},
   {{0x0002a7f3e5f9f11f,0x0009e6cb3b8eb6d9,0x000f800bd9afe153,0x000e185d1a6dd7dd,0x00006c13cc1baf17}, {0x000c58e325fc3ee3,0x0000731dc3b215f6,0x000a3d3e77109540,0x000e2ce68e7c07af,0x0000f8417a1c4c7a}},
   {{0x00075216ce400bb1,0x0007baf07d99f47b,0x000ce62e0f72919f,0x00000e85b86e0600,0x00001872baf9fcfd}, {0x00021eb211f7dc69,0x0005c4ebd6f6049b,0x0002d78dab8900e5,0x000d9fec38cea416,0x0000a586c9e9bfa3}},
   {{0x0004772813b230d7,0x000ea7344427ec23,0x0007fc56a634d0f5,0x000f76a1548ab1d7,0x0000fab17513e06a}, {0x00010a74f7c4f830,0x0004220a67d9b62c,0x0001209a0a7d2edc,0x0009f01c40417092,0x0000b9815a0face5}},
   {{0x00083e151c3ebe53,0x0007a25d7be8ad38,0x0008ea8c9db14d5c,0x0006aaf3e4491155,0x0000a68529f6f45c}, {0x000a1dc149f75b88,0x0000879c7cb2eb18,0x00057a94e9b8946a,0x000859a7ad2a1911,0x00004b14f469106f}},
   {{0x000589b319540c33,0x00097283d6f82842,0x000ae9fcb18490f5,0x000ba072731f84da,0x0000db6d960f3683}, {0x00063bb146110697,0x000e9788bf05c85c,0x0007460d2b19436a,0x000db1205459df34,0x00003f6e095511a7}},
},
{/* digit=62 [{1,2,3,..,}]*([2^248]*G)  */
   {{0x000a3c8ee3c76cb3,0x0003a32a1f6ef306,0x00063e9563cf1162,0x000c26b6d5ab6468,0x0000b8a4cbe8c005}, {0x00029a59ce6bb278,0x000184d4b16fdcd5,0x00023798dc4afaa5,0x000fab30624a2679,0x00005e56df6eb307}},
   {{0x0000fef4e4ca4631,0x00072566cc63b233,0x000780900bcef728,0x00027dc161d2cacf,0x000035dc5396b548}, {0x000052e27bf1bc68,0x000f87dfa06c638f,0x0003321da10a224e,0x000c8f6973586d6d,0x0000b0c5738a6152}},
   {{0x00095959884aaf7a,0x000267b348a68968,0x000147c87b1959be,0x0001f7f6250e573c,0x0000e0efb3b7d0c6}, {0x000745eca8c325e7,0x00067cff3f70ed00,0x0009ad41d3c91169,0x0007ef03acbc6531,0x0000b01a02160b1c}},
   {{0x000ba6b23a5d8961,0x00056fe4364e9910,0x00033c6771fe19e3,0x000fd05e1da8c39a,0x00005b4488b39fd9}, {0x00092541a1f22bff,0x000fbb8163e81f43,0x000e5658e920a8a6,0x00039a4fd1b24907,0x00002c4f79da6ec8}},
   {{0x00043b5224c08dca,0x0003e1b50c912621,0x000a8c84f2bbb09b,0x000ca8216ed709ac,0x00006210d9e52850}, {0x000f67a09cb54d69,0x000fc00919a46d8d,0x00013285791eef6d,0x00028b00f613810f,0x0000acede4888d50}},
   {{0x000a0691416a6a5e,0x000863ef881c84ce,0x000038a5d8f860c7,0x00006661311f8a38,0x000078c2ec1dc612}, {0x0002e815ad735813,0x000029604097494d,0x000612cbab4cc9e0,0x00039ecf558aecf3,0x00005beef7ace36c}},
   {{0x0001446de6736294,0x000e303c2d2145e2,0x000c868c757f7aa1,0x00067660e99b7f98,0x0000e42f66dcb641}, {0x00084dc910778965,0x000f72c9885b6028,0x0009a5187a0d690c,0x0007eeaeb4da333b,0x0000f789598653c8}},
   {{0x000619c76497ee80,0x0006c717370e8b5c,0x000cf68e15d2b0ac,0x00079298204cb64f,0x0000bdec21162bc6}, {0x000ccefa63b10110,0x0007e0de1ac56973,0x0000e0c8bf9e3fa9,0x000cb45efb693e3d,0x000037248e9d2d4f}},
},
{/* digit=63 [{1,2,3,..,}]*([2^252]*G)  */
   {{0x0002dc91ec34f9e7,0x0004c38106038080,0x0000cb4f3d8772d3,0x000128cf06d66c53,0x0000be5ed0e3475c}, {0x0003c1931e82b100,0x0007c9ff6b4ccb9e,0x000a1b45ec63d285,0x000bcab92118c692,0x0000aec44147285b}},
   {{0x0009ae71e29a3efb,0x000f9c93302efc18,0x000aae10ecbe906e,0x0009f820107914ce,0x00007a23f35668e1}, {0x00075c2efd2119d3,0x000eccadc9c8e9d8,0x000a1711303198c6,0x00003835591bf64d,0x0000cf0bbf86d443}},
   {{0x0005bb72b7247593,0x000182d4c63aae48,0x0007d6f2c945353e,0x00010952159d07de,0x000089caef37ec5b}, {0x000bb53db65ef147,0x000e6d99de434a8e,0x000f2405f2dc2cb7,0x0008a3116fa3ed83,0x00003429bba31420}},
   {{0x000d590b01e6e274,0x000da180b2dcb618,0x000aea4a9047e2cc,0x0003a491b299b504,0x000012c9e1edfa40}, {0x0008a36794075521,0x0006e332b8e388d2,0x00068de1949c5013,0x000b972a1b6fcce6,0x000078851bc85122}},
   {{0x0003752fb85fa4ca,0x000d983c8ce9b1e1,0x000f74daed61257c,0x000bbb343da670d2,0x000035aa2405f846}, {0x000235d4421fc835,0x00007363473b5e74,0x0004aa158f6df8ee,0x00022de4d7f52a3c,0x00000d05aabebc6d}},
   {{0x000e735a64785f45,0x000b0f29cd078c56,0x000e35067bc56637,0x00027003b2bb803e,0x00000235a102c919}, {0x000b6d8f2c4aa658,0x00010396023b191a,0x000f805bac347583,0x00080f00400ba5f0,0x0000881065bdec0f}},
   {{0x000e522cc1b5e838,0x0001060b8bfbc370,0x000b256dfde2d4ad,0x0009972d364df067,0x0000f12502f60138}, {0x000a0dc7783920a0,0x000dc0bc866a503f,0x000064ba6e80014a,0x000ba53f89b744d3,0x00003511dcdcba5d}},
   {{0x000d46d95a7b1a29,0x0005ac6341fb197d,0x0004c2ece9c4e7ad,0x000f89b26eca2948,0x0000211e48a6e7f4}, {0x0007f6ec78ef1f42,0x000fe65745861499,0x0003eede82b2c090,0x000017f7286a6e1c,0x00005f92e472f60e}},
},
{/* digit=64 [{1,2,3,..,}]*([2^256]*G)  */
   {{0x00070af3aeac968f,0x0008d4b63266b4e3,0x000ac5664e4f7fee,0x000cbec4acd4c2e3,0x00008910bd3beb38}, {0x000e50cc9c0726e3,0x0009a97b40bf1c3a,0x0005a5a1b1530956,0x0004cd40884b7ffd,0x0000890896b1f831}},
   {{0x0003c9f82e4c6346,0x0003da4464f85ced,0x0001dca258efb831,0x00012b8706381b7a,0x0000cd15a3cba2a4}, {0x000a8fdbfcd8fb51,0x000f5e54cd229347,0x000d8932f31db2ee,0x0001afb4aeb11ef8,0x00001e7c1ed44441}},
   {{0x00084f5903fa2711,0x0002a9da921e9968,0x000b01e54e6da0fd,0x00014e96f2f2695d,0x0000ee3e9bd78762}, {0x000181ce27a94979,0x0003fe215e04a26e,0x0002cabca36d254e,0x000613b2f32a6c25,0x0000948148810b57}},
   {{0x000b43a43228d831,0x00003ad63f99ab41,0x000a5122924ae1c3,0x0002b47e525f1a46,0x00004af860fdd26d}, {0x000ef613f714aa18,0x000d6b78795ed6ba,0x000a9d694f51865a,0x00052753e21fcee6,0x00002ceb1de0a37b}},
   {{0x0005bfd2f9fd51a3,0x0002181b97f74a66,0x00036ce507f2f1fe,0x000ded9ad05d69ad,0x000014fc2a4b44f4}, {0x0003d8cb55fc5c6d,0x0007efb1e23dd559,0x000453ccee3510ce,0x00063129b7be6937,0x00003541b7a39fae}},
   {{0x0006525eca445df4,0x0001ecdfa4c69929,0x000a6d3bcf1af24f,0x000cc7b5b4eb61eb,0x0000560910cd8972}, {0x0001c32093eaa327,0x00090d3c67bb5475,0x0008711100183134,0x000a7dcbd90ce62d,0x00005fc863ac38ba}},
   {{0x0008a4176a9f05d0,0x000b9011d488711b,0x00048a65e06ca4e4,0x000894543bc62ba2,0x000017535ffc9290}, {0x00084ce406851d75,0x000f40e960b4840b,0x00028fd34afa3acd,0x00092c5c3394af71,0x00004eb4d5b7ac0f}},
   {{0x000e87355dbd4b3d,0x00079639bbb1db09,0x0006519621f87992,0x000573e83e47e51c,0x00004ef0fb7943fb}, {0x000b9d8f1bfb12a4,0x00082e5e8b7227d3,0x0007b90146ab877e,0x000b644eebdc9d15,0x0000c2110057aa5c}},
}
};

#endif /* #if (_MBX>=_MBX_K1) */

#endif /* IFMA_ECPRECOMP4_P256_H */
