/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ICALCULATORKIT_H
#define ICALCULATORKIT_H


#include "istring.h"


namespace iCalculatorKit
{
	//
	//  **********************************************************************
	//
	//  Generic interface
	//
	//  **********************************************************************
	//
	class Variable;
	class Handle
	{

	public:

		Handle(const iString &name);
		Handle(Variable *v);

		void Attach(const Variable *v);

		inline Variable* Self() const { return mVar; }
		inline const iString& Name() const { return mName; }

	private:

		iString mName;
		Variable *mVar;
	};


	class Variable
	{

	public:

		virtual ~Variable();

		inline int Dim() const { return mDim; }
		inline int Use() const { return mUse; }
		inline const iString& Name() const { return mName; }

		bool Copy(const Variable &var);
		bool Morph(int dim, int use);

	protected:

		Variable(int dim, int use, const iString &name);
		virtual void CopyBody(const Variable &var) = 0;
		virtual bool MorphBody(int dim, int use) = 0;

	private:

		int mDim, mUse;
		iString mName;
	};


	class Function
	{

	public:

		virtual ~Function();

		inline Variable* Result() const { return mResult; }

		inline int DataLocation() const { return mDataLoc; }
		inline int NumArguments() const { return mNumArgs; }

		//
		//  There properties are set at link-time
		//
		void SetNumArguments(int narg);

		//
		//  This function is called at link-time; it should also set the usage and dimension of the argument
		//
		virtual bool CheckArguments(int *dims, int *uses, iString &err) = 0; 

		//
		//  Main worker called at run-time
		//
		virtual int Evaluate(Variable **args) = 0;

	protected:

		Function(Variable *result, int narg, int loc);

		Variable *mResult;
		int mNumArgs;

	private:

		int mDataLoc;
	};
};

#endif  // ICALCULATORKIT_H
