//**************************************************************************************************
//                                         SimnNgSpice.hpp                                         *
//                                        -----------------                                        *
// Description : A class to contain the values required to define a NG-Spice simulation.           *
// Started     : 2008-05-07                                                                        *
// Last Update : 2015-04-08                                                                        *
// Copyright   : (C) 2008 by MSWaters                                                              *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef SIMNNGSPICE_HPP
#define SIMNNGSPICE_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "base/SimnBase.hpp"
#include "ngspice/commands/CmdNgSpiceOPT.hpp"
#include "ngspice/commands/CmdNgSpiceDC.hpp"
#include "ngspice/commands/CmdNgSpiceAC.hpp"
#include "ngspice/commands/CmdNgSpiceTR.hpp"
#include "ngspice/commands/CmdNgSpicePR.hpp"
#include "netlist/SimnGnuCap.hpp"

class SimnGnuCap;

//**************************************************************************************************

class SimnNgSpice : public SimnBase
{
  public :

    CmdNgSpiceDC   m_oCmdDC;
    CmdNgSpiceAC   m_oCmdAC;
    CmdNgSpiceTR   m_oCmdTR;

    CmdNgSpiceOPT  m_oCmdOPT;
    CmdNgSpicePR   m_oCmdPR;
    CpntNgsIndSrc  m_oCpntIndSrc;

  private :

    // Function to extract information from the circuit description
    virtual  bool  bLoadSimEng ( void );
    virtual  bool  bLoadSimCmds( void );
    virtual  bool  bLoadSigSrc ( void );

  public :

                   SimnNgSpice( void );
                  ~SimnNgSpice( );

    virtual  bool  bClear     ( void );
    virtual  bool  bClrCmds   ( void );
    virtual  bool  bClrTstPts ( void );

    virtual  bool  bValidate  ( void );

    virtual  bool  bLoad      ( void );
    virtual  bool  bSave      ( void );

    virtual  bool  bSetAnaType( eTypeCmd eAnaType ) { return( m_oCmdPR.bSetAnaType( eAnaType ) ); }

    virtual  bool  bAddTstNode( const wxString & rosName );
    virtual  bool  bAddTstCpnt( const wxString & rosName );

    virtual        eTypeCmd           eGetAnaType ( void ) const { return( m_oCmdPR.eGetAnaType());}
    virtual  const wxArrayString & rosaGetTstNodes( void ) const { return( m_oCmdPR.m_osaNodes ); }
    virtual  const wxArrayString & rosaGetTstCpnts( void ) const { return( m_oCmdPR.m_osaCpnts ); }

    SimnNgSpice & operator = ( const SimnGnuCap & roSimn );

    virtual  void  Print( const wxString & rosPrefix=wxT("  ") );
};

//**************************************************************************************************

#endif // SIMNNGSPICE_HPP
