/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

#ifndef _USERIF_H_INCLUDED
#define _USERIF_H_INCLUDED

/* server-api:
 * auf senden schalten:
 *    modus angeben   PSK(preamble,idle) CW(nix,ruhe), TUNE(nix,carrier)
 *    sofort oder bei DCD off angeben
 * senden ausschalten:
 *    mit postamble oder ohne...
 *    nach tx buffer ende
 *    txbuffer leeren, ggf. postamble, dann abschalten
 *    sofort abschalten
 */

#define STEREO 1
#define MONO   0

#define COMM_PTT	0x01
#define COMM_DCD	0x02
#define COMM_DCDLEVEL	0x03
#define COMM_QPSK	0x04
#define COMM_LSB	0x05
#define COMM_AFC	0x06
#define COMM_MODE	0x07
#define COMM_FREQ	0x08
#define COMM_FFTN	0x20
#define COMM_FFTOVERLAP 0x21
#define COMM_SWAP       0x40

#define COMM_TXCH	0xFF
#define COMM_ECHOCH     0x00
#define COMM_FFTCH	0x01
#define COMM_RXCH	0x02

#define PTTOFF		0
#define PTTON		1
#define PTTFORCE	0x10

#define MO_NORMAL	0x01     /* PSK31 RX or TX */
#define MO_CWSEND	0x02     /* only TX channel: send CW */
#define MO_TUNE		0x04     /* only TX channel: send tune carrier */
#define MO_DISABLED	0x80     /* disable channel. only supp. for 2nd RX */

	// spec:
	// COMM_PTT       ON OFF PTT_FORCE
	// COMM_DCD       ON OFF
	// COMM_DCDLEVEL  0..100 (?)
	// COMM_QPSK      ON OFF
	// COMM_LSB       ON OFF
	// COMM_AFC       ON OFF
	// COMM_MODE      MO_DISABLED MO_NORMAL (TXonly:) MO_CWSEND  MO_TUNE
	// COMM_FFTN        128..4096
	// COMM_FFTOVERLAP  0..FFTN, evtl grer
	// channel: -1=TX, sonst RX
	// channel:  TXCH, RXCH, FFTCH
	// value: -1= nix ndern, sonst value; return: aktueller value oder -1


typedef struct {
	int freq;       // IF frequence (RX,TX)
	int qpsk;         // QPSK <-> BPSK (RX,TX)
	int lsb;          // LSB(inverted)  (RX,TX)
	int cw;           // 0=normal PSK mode  1=transmit as CW  2=tuning(TX)
	int dcd;          // DCD active (RX)
	int dcdlevel;     // DCD sensitifity (-1=disable DCD,  (RX)
	                  // 0=only preamble/postamble DCD)
	int strength;     // range: 0..40
	int afc;          // use AFC (RX)
	int mode;         // ??
	int ptt;          // PTT on??? (transmitting?)  (all CH)
	int phdelta;      // last phase change (RX)
	float qty[4];     // quality (current,bpsk,qpsk,qpsk-inverted)
} PSK31info;

int commWaitUpdate(unsigned long timeout);
int commGetData(int channel, char *buffer, int buflen);
int commPutData(const char *buffer, int buflen);
int commControl(int channel, int spec, int value);
int commGetInfo(int channel, void *buffer, int buflen);

// for the non-socket server...
int server_main(char *audio, char *ptt, const char *datadir);

#endif
