-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_result.adb,v $
--  Description     : GUI for the data base client
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/10/07 19:39:43 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;         use Ada.Text_IO;

with Glib;                use Glib;
with Gdk;                 use Gdk;
with Gdk.Color;           use Gdk.Color;
with Gdk.Font;            use Gdk.Font;
with Gdk.Pixmap;          use Gdk.Pixmap;
with Gdk.Bitmap;          use Gdk.Bitmap;
with Gtk;                 use Gtk;
with Gtk.Box;             use Gtk.Box;
with Gtk.Button;          use Gtk.Button;
with Gtk.Check_Button;    use Gtk.Check_Button;
with Gtk.Clist;           use Gtk.Clist;
with Gtk.Enums;           use Gtk.Enums;
with Gtk.Label;           use Gtk.Label;
with Gtk.Option_Menu;     use Gtk.Option_Menu;
with Gtk.Radio_Menu_Item; use Gtk.Radio_Menu_Item;
with Gtk.Scrolled_Window; use Gtk.Scrolled_Window;
with Gtk.Handlers;        use Gtk.Handlers;
with Gtk.Style;           use Gtk.Style;
with Gtk.Widget;          use Gtk.Widget;
with Gtkada.Types;        use Gtkada.Types;
with Interfaces.C.Strings;

with GUI_Logging;         use GUI_Logging;

package body GUI_Result is

   Version : constant String := "$Id: gui_result.adb,v 1.5 2001/10/07 19:39:43 me Exp $";

   package IC  renames Interfaces.C;
   package ICS renames Interfaces.C.Strings;

   package Clist_Cb is new Handlers.Callback (Gtk_Clist_Record);
   package Check_Cb is new Handlers.User_Callback
     (Gtk_Check_Button_Record, Gtk_Clist);

   use type Interfaces.C.size_t;

   Current_Result     : Gtk_Clist;

   ------------------
   -- Click_Column --
   ------------------
   procedure Click_Column (
      List   : access Gtk_Clist_Record'Class;
      Column : Gint ) is
   begin
      if Column = 4 then
         Set_Column_Visibility (List, Column, False);
      elsif Column = Get_Sort_Column (List) then
         if Get_Sort_Type (List) = Ascending then
            Set_Sort_Type (List, Descending);
         else
            Set_Sort_Type (List, Ascending);
         end if;
      else
         Set_Sort_Column (List, Column);
      end if;

      Sort (List);
   end Click_Column;

   -------------------------
   -- CB_Result_Activated --
   -------------------------
   procedure Cb_Result_Activated (
      List : access Gtk_Clist_Record'Class) is
   begin
      Current_Result := Gtk_Clist(List);
   end CB_Result_Activated;

   ---------------------
   -- CB_Close_Result --
   ---------------------
   procedure CB_Close_Result (
      List    : access Gtk_Clist_Record'Class) is
   begin
      Destroy( List );
      Remove_Page( Toplevel, Get_Current_Page( Toplevel ) );
   end CB_Close_Result;

   ----------------
   -- Add_Result --
   ----------------
   procedure Add_Result(
      Q           : in ODBC.Object;
      Name        : in Unbounded_String) is
      -- Add an editor
      Vbox        : Gtk_Box;
      HBox        : Gtk_Box;
      Scrolled    : Gtk_Scrolled_Window;
      Label_Box   : Gtk_Box;
      Label       : Gtk_Label;
      Menu_Box    : Gtk_Box;
      Clist       : Gtk_Clist;
      Titles      : Chars_Ptr_Array (1 .. 512 ) := (others=>ICS.Null_Ptr);
      Cols        : C.Size_t;
      Button      : Gtk_Button;
   begin
      Gtk_New_Vbox (Vbox);
      Set_Border_Width (Vbox, 5);
      Show_All (Vbox);

      Gtk_New (Scrolled);
      Set_Border_Width (Scrolled, 5);
      Set_Policy (Scrolled, Policy_Automatic, Policy_Automatic);
      Pack_Start (Vbox, Scrolled, True, True, 0);

      Cols := C.Size_T(Columns(Q));
      for I in Titles'Range loop
         --if Titles(I) /= ICS.Null_Ptr then
         --   ICS.Free( Titles(I) );
         --end if;
         Titles(I) := ICS.New_String( Field_Name(Q,Integer(I)) );
      end loop;

      Gtk_New (Clist, Gint (Cols), Titles);
      Clist_Cb.Connect (
         Clist, "click_column",
         Clist_Cb.To_Marshaller (Click_Column'Access)
      );

      Add (Scrolled, Clist);
      Show_All( Vbox );

      -- get the query result set
      declare
         Result  : Result_Record := Null_Result_Record;
         Rows    : Natural := 0;
         New_Row : Gint;
         Texts   : Chars_Ptr_Array (0 .. Cols-1):=(others=>ICS.Null_Ptr);
      begin
         if Columns(Q) > 0 then
            Result := Fetch( Q );
            while Result /= Null_Result_Record loop
                 for I in Texts'Range loop
                    Texts(I) := ICS.New_String(To_String( Result,Integer(I)+1 ));
                 end loop;
                 New_Row := Append (Clist, Texts);

                 Rows := Rows + 1;
                 Result := Fetch( Q );
            end loop;
            GUI_Logging.Log("Resultset size:" & Natural'Image(Rows) );

         else
            GUI_Logging.Log("SQL command executed");
            GUI_Logging.Log("Number affected rows:" & Integer'Image(Affected_Rows(Q)));
         end if;

      exception
         when Error : others =>
            GUI_Logging.Error( "Error during execution" );
            raise;
      end;

      Gtk_New_Hbox (Hbox, False, 5);
      Set_Border_Width (Hbox, 5);
      Pack_Start (Vbox, Hbox, Expand => False );
      --------------------------
      -- add the close button --
      --------------------------
      Gtk_New (Button, "Close");
      Pack_Start (Hbox, Button, Expand => False );

      Clist_Cb.Object_Connect
        (Button, "clicked",
         Clist_Cb.To_Marshaller (CB_Close_Result'Access),
         Slot_Object => Clist);
      Show_All( Hbox );

      ------------------------
      -- add the tab labels --
      ------------------------
      Gtk_New_Hbox (Label_Box, False, 0);
      Gtk_New (Label, To_String( Name ) );
      Pack_Start (Label_Box, Label, False, True, 0);
      Show_All (Label_Box);

      Gtk_New_Vbox (Menu_Box, False, 0);
      Gtk_New (Label, To_String( Name ) );
      Pack_Start (Menu_Box, Label, False, True, 0);
      Show_All (Menu_Box);

      Append_Page_Menu (Toplevel, Vbox, Label_Box, Menu_Box);

      Clist_CB.Object_Connect(
         Clist,
         "draw_focus",
         Clist_CB.To_Marshaller (CB_Result_Activated'Access ),
         Slot_Object => Clist
      );

      -- bring result in fron
      Set_Page( Toplevel );

   end Add_Result;

end GUI_Result;

