-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_about.adb,v $
--  Description     : Display the version information                        --
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/05/30 07:19:16 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;              use Ada.Text_IO;

with Glib;                     use Glib;
with Gdk.Color;                use Gdk.Color;
with Gdk.Font;                 use Gdk.Font;
with Gtk.Box;                  use Gtk.Box;
with Gtk.Check_Button;         use Gtk.Check_Button;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Hbutton_Box;          use Gtk.Hbutton_Box;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Label;                use Gtk.Label;
with Gtk.Frame;                use Gtk.Frame;
with Gtk;                      use Gtk;

with GUI_Window;               use GUI_Window;
with GUI_Dialog;               use GUI_Dialog;

package body GUI_About is

   Version : constant String :=
      "$Id: gui_about.adb,v 1.3 2002/05/30 07:19:16 merdmann Exp $";

   --------------
   -- Add_Text --
   --------------
   procedure Add_Text(
      Textbox : in out Gtk_Box;
      Text    : in String;
      First   : in Boolean := False ) is
      Label   : Gtk_Label;
   begin
      Gtk_New( Label, Text );
      if First then
         Pack_Start(Textbox, Label );
      else
         Pack_End( Textbox, Label );
      end if;
   end Add_Text;
   ---------------------
   -- Dialog_Contents --
   ---------------------
   procedure Dialog_Contents(
      This     : in out Object;
      Vbox     : in Gtk_Box ) is
      Textbox  : Gtk_Box;
      Fr       : Gtk_Frame;
   begin
      Gtk_New( Fr );
      Gtk_New_Vbox( Textbox );
      Add( Fr, Textbox );

      Add_Text( Textbox, "GNADE SQL (GSQL) Development IDE", First => True );
      Add_Text( Textbox, "GNADE is located at http://gnade.sourceforge.net/");
      Add_Text( Textbox, "http://purl.org/net/michal.erdmann");
      Add_Text( Textbox, "Copyright (C) 2001-2002 Michael Erdmann");
      Add_Text( Textbox, "Version " & GUI_Window.Version & " $State: Exp $");


      Show_All(Fr);
      Pack_Start( Vbox, Fr );
   end Dialog_Contents;

end GUI_About;
