/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.SeekableFile;
import java.io.IOException;
import java.util.ArrayList;

public class CachedSeekableFile
implements SeekableFile {
    SeekableFile file;
    int CACHE_CAPACITY = 100;
    ArrayList cache = new ArrayList();

    public CachedSeekableFile(SeekableFile seekableFile) {
        this.file = seekableFile;
        this.cache.ensureCapacity(this.CACHE_CAPACITY);
    }

    public void close() throws IOException {
        this.file.close();
        for (int i = 0; i < this.cache.size(); ++i) {
            CacheBlock cacheBlock = (CacheBlock)this.cache.get(i);
            cacheBlock.data = null;
        }
        this.cache.clear();
    }

    public long size() throws IOException {
        return this.file.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[8192];
        int n3 = 0;
        ArrayList arrayList = this.cache;
        synchronized (arrayList) {
            int n4 = n / 8192;
            do {
                int n5;
                if ((n5 = this.findCachedBlock(n4)) < 0) {
                    int n6 = n2 - n3;
                    if (n6 > 8192) {
                        n6 = 8192;
                    }
                    int n7 = this.file.read(byArray2, 0, n6);
                    CacheBlock cacheBlock = new CacheBlock(n4, byArray2, n7);
                    cacheBlock.getBlock(byArray, n3);
                    this.cache.add(cacheBlock);
                    if (this.cache.size() > this.CACHE_CAPACITY) {
                        CacheBlock cacheBlock2 = (CacheBlock)this.cache.remove(0);
                        cacheBlock2.data = null;
                    }
                    n3 += n7;
                } else {
                    CacheBlock cacheBlock = (CacheBlock)this.cache.remove(n5);
                    n3 += cacheBlock.getBlock(byArray, n3);
                    this.cache.add(cacheBlock);
                }
                ++n4;
            } while (n3 < n2);
            if (n3 != n2) {
                throw new AssertionError((Object)("Caching system is broken. Request is " + n2 + " but Response is " + n3));
            }
        }
        return n3;
    }

    private int findCachedBlock(int n) {
        for (int i = 0; i < this.cache.size(); ++i) {
            CacheBlock cacheBlock = (CacheBlock)this.cache.get(i);
            if (cacheBlock.getBlockPos() != n) continue;
            return i;
        }
        return -1;
    }

    public void seek(long l) throws IOException {
        this.file.seek(l);
    }

    class CacheBlock {
        public static final int BLKSZ = 8192;
        int blkpos = 0;
        int size = 0;
        byte[] data = new byte[8192];

        public CacheBlock(int n, byte[] byArray, int n2) {
            if (n2 > 8192) {
                throw new ArrayStoreException("Too large data to store into cache block.");
            }
            this.blkpos = n;
            this.size = n2;
            System.arraycopy(this.data, 0, byArray, 0, this.size);
        }

        public int getBlockPos() {
            return this.blkpos;
        }

        public int getBlock(byte[] byArray, int n) {
            if (byArray.length < this.size) {
                throw new ArrayIndexOutOfBoundsException("Too small Buffer to store cached data.");
            }
            System.arraycopy(this.data, 0, byArray, n, this.size);
            return this.size;
        }
    }
}

