/*
 * Decompiled with CFR 0.152.
 */
package test.net.sourceforge.pmd.testframework;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SimpleRuleSetNameMapper;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.SourceTypeToRuleLanguageMapper;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import test.net.sourceforge.pmd.testframework.TestDescriptor;

public abstract class RuleTst {
    public static final SourceType DEFAULT_SOURCE_TYPE = SourceType.JAVA_15;

    public Rule findRule(String ruleSet, String ruleName) {
        try {
            String rules = new SimpleRuleSetNameMapper(ruleSet).getRuleSets();
            Rule rule = new RuleSetFactory().createRuleSets(rules).getRuleByName(ruleName);
            if (rule == null) {
                Assert.fail((String)("Rule " + ruleName + " not found in ruleset " + ruleSet));
            }
            rule.setRuleSetName(ruleSet);
            return rule;
        }
        catch (RuleSetNotFoundException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't find ruleset " + ruleSet));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(TestDescriptor test) {
        Rule rule = test.getRule();
        if (test.getReinitializeRule()) {
            rule = this.findRule(rule.getRuleSetName(), rule.getName());
        }
        Properties ruleProperties = rule.getProperties();
        Properties oldProperties = (Properties)ruleProperties.clone();
        try {
            int res;
            try {
                if (test.getProperties() != null) {
                    oldProperties = (Properties)ruleProperties.clone();
                    ruleProperties.putAll((Map<?, ?>)test.getProperties());
                }
                res = this.processUsingStringReader(test.getCode(), rule, test.getSourceType()).size();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException('\"' + test.getDescription() + "\" failed");
            }
            Assert.assertEquals((String)('\"' + test.getDescription() + "\" resulted in wrong number of failures,"), (long)test.getNumberOfProblemsExpected(), (long)res);
        }
        finally {
            ruleProperties.clear();
            ruleProperties.putAll((Map<?, ?>)oldProperties);
        }
    }

    private Report processUsingStringReader(String code, Rule rule, SourceType sourceType) throws PMDException {
        Report report = new Report();
        this.runTestFromString(code, rule, report, sourceType);
        return report;
    }

    public void runTestFromString(String code, Rule rule, Report report, SourceType sourceType) throws PMDException {
        PMD p = new PMD();
        p.setJavaVersion(sourceType);
        RuleContext ctx = new RuleContext();
        ctx.setReport(report);
        ctx.setSourceCodeFilename("n/a");
        RuleSet rules = new RuleSet();
        rules.addRule(rule);
        rules.setLanguage(SourceTypeToRuleLanguageMapper.getMappedLanguage(sourceType));
        p.processFile(new StringReader(code), new RuleSets(rules), ctx, sourceType);
    }

    protected String getCleanRuleName(Rule rule) {
        String fullClassName = rule.getClass().getName();
        if (fullClassName.equals(rule.getName())) {
            String packageName = rule.getClass().getPackage().getName();
            return fullClassName.substring(packageName.length() + 1);
        }
        return rule.getName();
    }

    public TestDescriptor[] extractTestsFromXml(Rule rule) {
        String testsFileName = this.getCleanRuleName(rule);
        return this.extractTestsFromXml(rule, testsFileName);
    }

    public TestDescriptor[] extractTestsFromXml(Rule rule, String testsFileName) {
        return this.extractTestsFromXml(rule, testsFileName, "xml/");
    }

    public TestDescriptor[] extractTestsFromXml(Rule rule, String testsFileName, String baseDirectory) {
        Document doc;
        String testXmlFileName = baseDirectory + testsFileName + ".xml";
        InputStream inputStream = this.getClass().getResourceAsStream(testXmlFileName);
        if (inputStream == null) {
            throw new RuntimeException("Couldn't find " + testXmlFileName);
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(inputStream);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + pce.getMessage());
        }
        catch (FactoryConfigurationError fce) {
            fce.printStackTrace();
            throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + fce.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + ioe.getMessage());
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + se.getMessage());
        }
        return this.parseTests(rule, doc);
    }

    private TestDescriptor[] parseTests(Rule rule, Document doc) {
        Element root = doc.getDocumentElement();
        NodeList testCodes = root.getElementsByTagName("test-code");
        TestDescriptor[] tests = new TestDescriptor[testCodes.getLength()];
        for (int i = 0; i < testCodes.getLength(); ++i) {
            String sourceTypeString;
            String reinitializeRuleValue;
            String reinitializeRuleValue2;
            Element testCode = (Element)testCodes.item(i);
            boolean reinitializeRule = false;
            Node reinitializeRuleAttribute = testCode.getAttributes().getNamedItem("reinitializeRule");
            if (reinitializeRuleAttribute != null && ("true".equalsIgnoreCase(reinitializeRuleValue2 = reinitializeRuleAttribute.getNodeValue()) || "1".equalsIgnoreCase(reinitializeRuleValue2))) {
                reinitializeRule = true;
            }
            boolean isRegressionTest = true;
            Node regressionTestAttribute = testCode.getAttributes().getNamedItem("regressionTest");
            if (regressionTestAttribute != null && "false".equalsIgnoreCase(reinitializeRuleValue = regressionTestAttribute.getNodeValue())) {
                isRegressionTest = false;
            }
            NodeList ruleProperties = testCode.getElementsByTagName("rule-property");
            Properties properties = new Properties();
            for (int j = 0; j < ruleProperties.getLength(); ++j) {
                Node ruleProperty = ruleProperties.item(j);
                String propertyName = ruleProperty.getAttributes().getNamedItem("name").getNodeValue();
                properties.setProperty(propertyName, RuleTst.parseTextNode(ruleProperty));
            }
            int expectedProblems = Integer.parseInt(this.getNodeValue(testCode, "expected-problems", true));
            String description = this.getNodeValue(testCode, "description", true);
            String code = this.getNodeValue(testCode, "code", false);
            if (code == null) {
                NodeList coderefs = testCode.getElementsByTagName("code-ref");
                if (coderefs.getLength() == 0) {
                    throw new RuntimeException("Required tag is missing from the test-xml. Supply either a code or a code-ref tag");
                }
                Node coderef = coderefs.item(0);
                String referenceId = coderef.getAttributes().getNamedItem("id").getNodeValue();
                NodeList codeFragments = root.getElementsByTagName("code-fragment");
                for (int j = 0; j < codeFragments.getLength(); ++j) {
                    String fragmentId = codeFragments.item(j).getAttributes().getNamedItem("id").getNodeValue();
                    if (!referenceId.equals(fragmentId)) continue;
                    code = RuleTst.parseTextNode(codeFragments.item(j));
                }
                if (code == null) {
                    throw new RuntimeException("No matching code fragment found for coderef");
                }
            }
            if ((sourceTypeString = this.getNodeValue(testCode, "source-type", false)) == null) {
                tests[i] = new TestDescriptor(code, description, expectedProblems, rule);
            } else {
                SourceType sourceType = SourceType.getSourceTypeForId(sourceTypeString);
                if (sourceType != null) {
                    tests[i] = new TestDescriptor(code, description, expectedProblems, rule, sourceType);
                } else {
                    throw new RuntimeException("Unknown sourceType for test: " + sourceTypeString);
                }
            }
            tests[i].setReinitializeRule(reinitializeRule);
            tests[i].setRegressionTest(isRegressionTest);
            tests[i].setProperties(properties);
        }
        return tests;
    }

    private String getNodeValue(Element parentElm, String nodeName, boolean required) {
        NodeList nodes = parentElm.getElementsByTagName(nodeName);
        if (nodes == null || nodes.getLength() == 0) {
            if (required) {
                throw new RuntimeException("Required tag is missing from the test-xml: " + nodeName);
            }
            return null;
        }
        Node node = nodes.item(0);
        return RuleTst.parseTextNode(node);
    }

    private static String parseTextNode(Node exampleNode) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < exampleNode.getChildNodes().getLength(); ++i) {
            Node node = exampleNode.getChildNodes().item(i);
            if (node.getNodeType() != 4 && node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString().trim();
    }

    public void runTestFromString(String code, Rule rule, Report report) throws PMDException {
        this.runTestFromString(code, rule, report, DEFAULT_SOURCE_TYPE);
    }
}

