/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DStructure;
import dods.dap.NoSuchVariableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import visad.Data;
import visad.DataImpl;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.SimpleSet;
import visad.Tuple;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;

public class StructureVariableAdapter
extends VariableAdapter {
    private final MathType mathType;
    private final VariableAdapter[] adapters;
    private final boolean isFlat;
    private final SimpleSet[] repSets;

    private StructureVariableAdapter(DStructure structure, DAS das, VariableAdapterFactory factory) throws BadFormException, VisADException, RemoteException {
        ArrayList<SimpleSet> setList = new ArrayList<SimpleSet>();
        this.adapters = new VariableAdapter[structure.elementCount()];
        for (int i = 0; i < this.adapters.length; ++i) {
            BaseType var;
            try {
                var = structure.getVar(i);
            }
            catch (NoSuchVariableException e) {
                throw new BadFormException(this.getClass().getName() + ".data(...): " + "DStructure is missing variable " + i + ": " + (Object)((Object)e));
            }
            this.adapters[i] = factory.variableAdapter(var, das);
            SimpleSet[] setArray = this.adapters[i].getRepresentationalSets(false);
            for (int j = 0; j < setArray.length; ++j) {
                setList.add(setArray[j]);
            }
        }
        this.mathType = StructureVariableAdapter.mathType(this.adapters);
        this.isFlat = StructureVariableAdapter.isFlat(this.mathType);
        this.repSets = setList.toArray(new SimpleSet[0]);
    }

    public static StructureVariableAdapter structureVariableAdapter(DStructure structure, DAS das, VariableAdapterFactory factory) throws BadFormException, VisADException, RemoteException {
        return new StructureVariableAdapter(structure, das, factory);
    }

    public MathType getMathType() {
        return this.mathType;
    }

    public SimpleSet[] getRepresentationalSets(boolean copy) {
        return copy ? (SimpleSet[])this.repSets.clone() : this.repSets;
    }

    public DataImpl data(DStructure structure, boolean copy) throws BadFormException, VisADException, RemoteException {
        DataImpl data;
        try {
            if (this.adapters.length == 0) {
                data = null;
            } else if (this.adapters.length == 1) {
                data = this.adapters[0].data(structure.getVar(0), copy);
            } else if (this.isFlat) {
                Real[] components = new Real[this.adapters.length];
                for (int i = 0; i < this.adapters.length; ++i) {
                    components[i] = (Real)this.adapters[i].data(structure.getVar(i), copy);
                }
                data = new RealTuple(components);
            } else {
                Data[] components = new DataImpl[this.adapters.length];
                for (int i = 0; i < this.adapters.length; ++i) {
                    components[i] = this.adapters[i].data(structure.getVar(i), copy);
                }
                data = new Tuple(components);
            }
        }
        catch (NoSuchVariableException e) {
            throw new BadFormException(this.getClass().getName() + ".data(...): " + "DStructure is missing variable: " + (Object)((Object)e));
        }
        return data;
    }
}

