/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.MAVector;

public class MAMatrix {
    private Array a;
    private int nrows;
    private int ncols;
    private Index ima;

    public MAMatrix(int nrows, int ncols) {
        this.a = new ArrayDouble.D2(nrows, ncols);
        this.nrows = nrows;
        this.ncols = ncols;
        this.ima = this.a.getIndex();
    }

    public MAMatrix(Array a) {
        this.a = a;
        if (a.getRank() != 2) {
            throw new IllegalArgumentException("rank != 2, instead = " + a.getRank());
        }
        this.nrows = a.getShape()[0];
        this.ncols = a.getShape()[1];
        this.ima = a.getIndex();
    }

    public int getNrows() {
        return this.nrows;
    }

    public int getNcols() {
        return this.ncols;
    }

    public double getDouble(int i, int j) {
        return this.a.getDouble(this.ima.set(i, j));
    }

    public void setDouble(int i, int j, double val) {
        this.a.setDouble(this.ima.set(i, j), val);
    }

    public MAMatrix copy() {
        return new MAMatrix(this.a.copy());
    }

    public MAMatrix transpose() {
        return new MAMatrix(this.a.transpose(0, 1));
    }

    public MAVector column(int j) {
        return new MAVector(this.a.slice(1, j));
    }

    public MAVector row(int i) {
        return new MAVector(this.a.slice(0, i));
    }

    public MAVector dot(MAVector v) {
        if (this.ncols != v.getNelems()) {
            throw new IllegalArgumentException("MAMatrix.dot " + this.ncols + " != " + v.getNelems());
        }
        ArrayDouble.D1 result = new ArrayDouble.D1(this.nrows);
        Index imr = result.getIndex();
        for (int i = 0; i < this.nrows; ++i) {
            double sum = 0.0;
            for (int k = 0; k < this.ncols; ++k) {
                sum += this.getDouble(i, k) * v.getDouble(k);
            }
            result.setDouble(imr.set(i), sum);
        }
        return new MAVector(result);
    }

    public static MAMatrix multiply(MAMatrix m1, MAMatrix m2) {
        if (m1.getNcols() != m2.getNrows()) {
            throw new IllegalArgumentException("MAMatrix.multiply " + m1.getNcols() + " != " + m2.getNrows());
        }
        int kdims = m1.getNcols();
        ArrayDouble.D2 result = new ArrayDouble.D2(m1.getNrows(), m2.getNcols());
        Index imr = result.getIndex();
        for (int i = 0; i < m1.getNrows(); ++i) {
            for (int j = 0; j < m2.getNcols(); ++j) {
                double sum = 0.0;
                for (int k = 0; k < kdims; ++k) {
                    sum += m1.getDouble(i, k) * m2.getDouble(k, j);
                }
                result.setDouble(imr.set(i, j), sum);
            }
        }
        return new MAMatrix(result);
    }

    public void postMultiplyDiagonal(MAVector diag) {
        if (this.ncols != diag.getNelems()) {
            throw new IllegalArgumentException("MAMatrix.postMultiplyDiagonal " + this.ncols + " != " + diag.getNelems());
        }
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                double val = this.a.getDouble(this.ima.set(i, j)) * diag.getDouble(j);
                this.a.setDouble(this.ima, val);
            }
        }
    }

    public void preMultiplyDiagonal(MAVector diag) {
        if (this.nrows != diag.getNelems()) {
            throw new IllegalArgumentException("MAMatrix.preMultiplyDiagonal " + this.nrows + " != " + diag.getNelems());
        }
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                double val = this.a.getDouble(this.ima.set(i, j)) * diag.getDouble(i);
                this.a.setDouble(this.ima, val);
            }
        }
    }
}

