/* $Id: glue-vhdl.h,v 1.4 2009-09-30 09:16:54 potyra Exp $
 *
 *  Glue layer implementing the foreign interface of fauhdli for FAUmachine,
 *  so that fauhdli can access FAUmachine signals and components.
 *  Must not be called by FAUmachine itself.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_VHDL_H_INCLUDED
#define __GLUE_VHDL_H_INCLUDED

#include <fauhdli.h>

/** Create a glue_vhdl instance.
 *  @param callbacks glue_vhdl will fill the glue-vhdl related callbacks.
 *  @return allocated glue_vhdl instance.
 */
extern void *
glue_vhdl_create(struct glue_vhdl_cb *callbacks);

/** Initialize the state of a glue_vhdl instance.
 *  @param _cpssp glue_vhdl instance.
 *  @param fauhdli fauhdli instance pointer. (opaque to glue_vhdl).
 */
extern void
glue_vhdl_init(void *_cpssp, void *fauhdli);

/** Destroy a glue-vhdl instance.
 *  @param _cpssp pointer to glue_vhdl instance.
 */
extern void
glue_vhdl_destroy(void *_cpssp);

#endif /* __GLUE_VHDL_H_INCLUDED */
