#
# Autogenerated by Thrift
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#

require 'Evernote/EDAM/user_store_types'
require 'Evernote/EDAM/types_types'
require 'Evernote/EDAM/errors_types'
require 'Evernote/EDAM/limits_types'


module Evernote
  module EDAM
    module NoteStore
            #  This structure encapsulates the information about the state of the
            #  user's account for the purpose of "state based" synchronization.
            # <dl>
            #  <dt>currentTime</dt>
            #    <dd>
            #    The server's current date and time.
            #    </dd>
            # 
            #  <dt>fullSyncBefore</dt>
            #    <dd>
            #    The cutoff date and time for client caches to be
            #    updated via incremental synchronization.  Any clients that were last
            #    synched with the server before this date/time must do a full resync of all
            #    objects.  This cutoff point will change over time as archival data is
            #    deleted or special circumstances on the service require resynchronization.
            #    </dd>
            # 
            #  <dt>updateCount</dt>
            #    <dd>
            #    Indicates the total number of transactions that have
            #    been committed within the account.  This reflects (for example) the
            #    number of discrete additions or modifications that have been made to
            #    the data in this account (tags, notes, resources, etc.).
            #    This number is the "high water mark" for Update Sequence Numbers (USN)
            #    within the account.
            #    </dd>
            # 
            #  <dt>uploaded</dt>
            #    <dd>
            #    The total number of bytes that have been uploaded to
            #    this account in the current monthly period.  This can be compared against
            #    Accounting.uploadLimit (from the UserStore) to determine how close the user
            #    is to their monthly upload limit.
            #    </dd>
            #  </dl>
            class SyncState
              include ::Thrift::Struct, ::Thrift::Struct_Union
              CURRENTTIME = 1
              FULLSYNCBEFORE = 2
              UPDATECOUNT = 3
              UPLOADED = 4

              FIELDS = {
                CURRENTTIME => {:type => ::Thrift::Types::I64, :name => 'currentTime'},
                FULLSYNCBEFORE => {:type => ::Thrift::Types::I64, :name => 'fullSyncBefore'},
                UPDATECOUNT => {:type => ::Thrift::Types::I32, :name => 'updateCount'},
                UPLOADED => {:type => ::Thrift::Types::I64, :name => 'uploaded', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field currentTime is unset!') unless @currentTime
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field fullSyncBefore is unset!') unless @fullSyncBefore
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field updateCount is unset!') unless @updateCount
              end

              ::Thrift::Struct.generate_accessors self
            end

            #  This structure is given out by the NoteStore when a client asks to
            #  receive the current state of an account.  The client asks for the server's
            #  state one chunk at a time in order to allow clients to retrieve the state
            #  of a large account without needing to transfer the entire account in
            #  a single message.
            # 
            #  The server always gives SyncChunks using an ascending series of Update
            #  Sequence Numbers (USNs).
            # 
            # <dl>
            #  <dt>currentTime</dt>
            #    <dd>
            #    The server's current date and time.
            #    </dd>
            # 
            #  <dt>chunkHighUSN</dt>
            #    <dd>
            #    The highest USN for any of the data objects represented
            #    in this sync chunk.  If there are no objects in the chunk, this will not be
            #    set.
            #    </dd>
            # 
            #  <dt>updateCount</dt>
            #    <dd>
            #    The total number of updates that have been performed in
            #    the service for this account.  This is equal to the highest USN within the
            #    account at the point that this SyncChunk was generated.  If updateCount
            #    and chunkHighUSN are identical, that means that this is the last chunk
            #    in the account ... there is no more recent information.
            #    </dd>
            # 
            #  <dt>notes</dt>
            #    <dd>
            #    If present, this is a list of non-expunged notes that
            #    have a USN in this chunk.  This will include notes that are "deleted"
            #    but not expunged (i.e. in the trash).  The notes will include their list
            #    of tags and resources, but the resource content and recognition data
            #    will not be supplied.
            #    </dd>
            # 
            #  <dt>notebooks</dt>
            #    <dd>
            #    If present, this is a list of non-expunged notebooks that
            #    have a USN in this chunk.  This will include notebooks that are "deleted"
            #    but not expunged (i.e. in the trash).
            #    </dd>
            # 
            #  <dt>tags</dt>
            #    <dd>
            #    If present, this is a list of the non-expunged tags that have a
            #    USN in this chunk.
            #    </dd>
            # 
            #  <dt>searches</dt>
            #    <dd>
            #    If present, this is a list of non-expunged searches that
            #    have a USN in this chunk.
            #    </dd>
            # 
            #  <dt>resources</dt>
            #    <dd>
            #    If present, this is a list of the non-expunged resources
            #    that have a USN in this chunk.  This will include the metadata for each
            #    resource, but not its binary contents or recognition data, which must be
            #    retrieved separately.
            #    </dd>
            # 
            #  <dt>expungedNotes</dt>
            #    <dd>
            #    If present, the GUIDs of all of the notes that were
            #    permanently expunged in this chunk.
            #    </dd>
            # 
            #  <dt>expungedNotebooks</dt>
            #    <dd>
            #    If present, the GUIDs of all of the notebooks that
            #    were permanently expunged in this chunk.  When a notebook is expunged,
            #    this implies that all of its child notes (and their resources) were
            #    also expunged.
            #    </dd>
            # 
            #  <dt>expungedTags</dt>
            #    <dd>
            #    If present, the GUIDs of all of the tags that were
            #    permanently expunged in this chunk.
            #    </dd>
            # 
            #  <dt>expungedSearches</dt>
            #    <dd>
            #    If present, the GUIDs of all of the saved searches
            #    that were permanently expunged in this chunk.
            #    </dd>
            #  </dl>
            class SyncChunk
              include ::Thrift::Struct, ::Thrift::Struct_Union
              CURRENTTIME = 1
              CHUNKHIGHUSN = 2
              UPDATECOUNT = 3
              NOTES = 4
              NOTEBOOKS = 5
              TAGS = 6
              SEARCHES = 7
              RESOURCES = 8
              EXPUNGEDNOTES = 9
              EXPUNGEDNOTEBOOKS = 10
              EXPUNGEDTAGS = 11
              EXPUNGEDSEARCHES = 12

              FIELDS = {
                CURRENTTIME => {:type => ::Thrift::Types::I64, :name => 'currentTime'},
                CHUNKHIGHUSN => {:type => ::Thrift::Types::I32, :name => 'chunkHighUSN', :optional => true},
                UPDATECOUNT => {:type => ::Thrift::Types::I32, :name => 'updateCount'},
                NOTES => {:type => ::Thrift::Types::LIST, :name => 'notes', :element => {:type => ::Thrift::Types::STRUCT, :class => Evernote::EDAM::Type::Note}, :optional => true},
                NOTEBOOKS => {:type => ::Thrift::Types::LIST, :name => 'notebooks', :element => {:type => ::Thrift::Types::STRUCT, :class => Evernote::EDAM::Type::Notebook}, :optional => true},
                TAGS => {:type => ::Thrift::Types::LIST, :name => 'tags', :element => {:type => ::Thrift::Types::STRUCT, :class => Evernote::EDAM::Type::Tag}, :optional => true},
                SEARCHES => {:type => ::Thrift::Types::LIST, :name => 'searches', :element => {:type => ::Thrift::Types::STRUCT, :class => Evernote::EDAM::Type::SavedSearch}, :optional => true},
                RESOURCES => {:type => ::Thrift::Types::LIST, :name => 'resources', :element => {:type => ::Thrift::Types::STRUCT, :class => Evernote::EDAM::Type::Resource}, :optional => true},
                EXPUNGEDNOTES => {:type => ::Thrift::Types::LIST, :name => 'expungedNotes', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                EXPUNGEDNOTEBOOKS => {:type => ::Thrift::Types::LIST, :name => 'expungedNotebooks', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                EXPUNGEDTAGS => {:type => ::Thrift::Types::LIST, :name => 'expungedTags', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                EXPUNGEDSEARCHES => {:type => ::Thrift::Types::LIST, :name => 'expungedSearches', :element => {:type => ::Thrift::Types::STRING}, :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field currentTime is unset!') unless @currentTime
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field updateCount is unset!') unless @updateCount
              end

              ::Thrift::Struct.generate_accessors self
            end

            #  A list of criteria that are used to indicate which notes are desired from
            #  the account.  This is used in queries to the NoteStore to determine
            #  which notes should be retrieved.
            # 
            # <dl>
            #  <dt>order</dt>
            #    <dd>
            #    The NoteSortOrder value indicating what criterion should be
            #    used to sort the results of the filter.
            #    </dd>
            # 
            #  <dt>ascending</dt>
            #    <dd>
            #    If true, the results will be ascending in the requested
            #    sort order.  If false, the results will be descending.
            #    </dd>
            # 
            #  <dt>words</dt>
            #    <dd>
            #    The string query containing keywords to match, if present.
            #    </dd>
            # 
            #  <dt>notebookGuid</dt>
            #    <dd>
            #    If present, the Guid of the notebook that must contain
            #    the notes.
            #    </dd>
            # 
            #  <dt>tagGuids</dt>
            #    <dd>
            #    If present, the list of tags (by GUID) that must be present
            #    on the notes.
            #    </dd>
            # 
            #  <dt>timeZone</dt>
            #    <dd>
            #    The zone ID for the user, which will be used to interpret
            #    any dates or times in the queries that do not include their desired zone
            #    information.
            #    For example, if a query requests notes created "yesterday", this
            #    will be evaluated from the provided time zone, if provided.
            #    The format must be encoded as a standard zone ID such as
            #    "America/Los_Angeles".
            #    </dd>
            # 
            #  <dt>inactive</dt>
            #    <dd>
            #    If true, then only notes that are not active (i.e. notes in
            #    the Trash) will be returned. Otherwise, only active notes will be returned.
            #    There is no way to find both active and inactive notes in a single query.
            #    </dd>
            #  </dl>
            class NoteFilter
              include ::Thrift::Struct, ::Thrift::Struct_Union
              ORDER = 1
              ASCENDING = 2
              WORDS = 3
              NOTEBOOKGUID = 4
              TAGGUIDS = 5
              TIMEZONE = 6
              INACTIVE = 7

              FIELDS = {
                ORDER => {:type => ::Thrift::Types::I32, :name => 'order', :optional => true},
                ASCENDING => {:type => ::Thrift::Types::BOOL, :name => 'ascending', :optional => true},
                WORDS => {:type => ::Thrift::Types::STRING, :name => 'words', :optional => true},
                NOTEBOOKGUID => {:type => ::Thrift::Types::STRING, :name => 'notebookGuid', :optional => true},
                TAGGUIDS => {:type => ::Thrift::Types::LIST, :name => 'tagGuids', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                TIMEZONE => {:type => ::Thrift::Types::STRING, :name => 'timeZone', :optional => true},
                INACTIVE => {:type => ::Thrift::Types::BOOL, :name => 'inactive', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            #  A small structure for returning a list of notes out of a larger set.
            # 
            # <dl>
            #  <dt>startIndex</dt>
            #    <dd>
            #    The starting index within the overall set of notes.  This
            #    is also the number of notes that are "before" this list in the set.
            #    </dd>
            # 
            #  <dt>totalNotes</dt>
            #    <dd>
            #    The number of notes in the larger set.  This can be used
            #    to calculate how many notes are "after" this note in the set.
            #    (I.e.  remaining = totalNotes - (startIndex + notes.length)  )
            #    </dd>
            # 
            #  <dt>notes</dt>
            #    <dd>
            #    The list of notes from this range.  The Notes will include all
            #    metadata (attributes, resources, etc.), but will not include the ENML
            #    content of the note or the binary contents of any resources.
            #    </dd>
            # 
            #  <dt>stoppedWords</dt>
            #    <dd>
            #    If the NoteList was produced using a text based search
            #    query that included words that are not indexed or searched by the service,
            #    this will include a list of those ignored words.
            #    </dd>
            # 
            #  <dt>searchedWords</dt>
            #    <dd>
            #    If the NoteList was produced using a text based search
            #    query that included viable search words or quoted expressions, this will
            #    include a list of those words.  Any stopped words will not be included
            #    in this list.
            #    </dd>
            #  </dl>
            class NoteList
              include ::Thrift::Struct, ::Thrift::Struct_Union
              STARTINDEX = 1
              TOTALNOTES = 2
              NOTES = 3
              STOPPEDWORDS = 4
              SEARCHEDWORDS = 5

              FIELDS = {
                STARTINDEX => {:type => ::Thrift::Types::I32, :name => 'startIndex'},
                TOTALNOTES => {:type => ::Thrift::Types::I32, :name => 'totalNotes'},
                NOTES => {:type => ::Thrift::Types::LIST, :name => 'notes', :element => {:type => ::Thrift::Types::STRUCT, :class => Evernote::EDAM::Type::Note}},
                STOPPEDWORDS => {:type => ::Thrift::Types::LIST, :name => 'stoppedWords', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                SEARCHEDWORDS => {:type => ::Thrift::Types::LIST, :name => 'searchedWords', :element => {:type => ::Thrift::Types::STRING}, :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field startIndex is unset!') unless @startIndex
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field totalNotes is unset!') unless @totalNotes
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field notes is unset!') unless @notes
              end

              ::Thrift::Struct.generate_accessors self
            end

            #  A data structure representing the number of notes for each notebook
            #  and tag with a non-zero set of applicable notes.
            # 
            # <dl>
            #  <dt>notebookCounts</dt>
            #    <dd>
            #    A mapping from the Notebook GUID to the number of
            #    notes (from some selection) that are in the corresponding notebook.
            #    </dd>
            # 
            #  <dt>tagCounts</dt>
            #    <dd>
            #    A mapping from the Tag GUID to the number of notes (from some
            #    selection) that have the corresponding tag.
            #    </dd>
            # 
            #  <dt>trashCount</dt>
            #    <dd>
            #    If this is set, then this is the number of notes that are in the trash.
            #    If this is not set, then the number of notes in the trash hasn't been
            #    reported.  (I.e. if there are no notes in the trash, this will be set
            #    to 0.)
            #    </dd>
            #  </dl>
            class NoteCollectionCounts
              include ::Thrift::Struct, ::Thrift::Struct_Union
              NOTEBOOKCOUNTS = 1
              TAGCOUNTS = 2
              TRASHCOUNT = 3

              FIELDS = {
                NOTEBOOKCOUNTS => {:type => ::Thrift::Types::MAP, :name => 'notebookCounts', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::I32}, :optional => true},
                TAGCOUNTS => {:type => ::Thrift::Types::MAP, :name => 'tagCounts', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::I32}, :optional => true},
                TRASHCOUNT => {:type => ::Thrift::Types::I32, :name => 'trashCount', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # Information for tracking the display of a particular ad by a client.
            # 
            # <dl>
            #  <dt>adId</dt>
            #    <dd>
            #      The identifier for this ad, from a previous Ad.id given to the client
            #    </dd>
            # 
            #  <dt>impressionCount</dt>
            #    <dd>
            #      The number of times this ad was displayed since the last successful
            #      ad retrieval.  The client should only report times the ad was selected
            #      when the client was visible.
            #    </dd>
            # 
            #  <dt>impressionTime</dt>
            #    <dd>
            #      The number of seconds that the client displayed the advertisement since
            #      the last successful ad retrieval.  This corresponds to the seconds that
            #      the client application was visible.
            #    </dd>
            # </dl>
            class AdImpressions
              include ::Thrift::Struct, ::Thrift::Struct_Union
              ADID = 1
              IMPRESSIONCOUNT = 2
              IMPRESSIONTIME = 3

              FIELDS = {
                ADID => {:type => ::Thrift::Types::I32, :name => 'adId'},
                IMPRESSIONCOUNT => {:type => ::Thrift::Types::I32, :name => 'impressionCount'},
                IMPRESSIONTIME => {:type => ::Thrift::Types::I32, :name => 'impressionTime'}
              }

              def struct_fields; FIELDS; end

              def validate
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field adId is unset!') unless @adId
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field impressionCount is unset!') unless @impressionCount
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field impressionTime is unset!') unless @impressionTime
              end

              ::Thrift::Struct.generate_accessors self
            end

            # Parameters that will be given by a client to the service when it requests
            # a set of advertisements to display.  If any of these values are omitted,
            # the service will use default values.
            # 
            # <dl>
            #  <dt>clientLanguage</dt>
            #    <dd>
            #      The ISO 639-1 language code for the primary language for the client.
            #      If omitted, English will be assumed ('en').
            #    </dd>
            # 
            #  <dt>impressions</dt>
            #    <dd>
            #      A list of the impression counts and total display time for the ads
            #      that were displayed in the last day.
            #    </dd>
            # 
            #  <dt>supportHtml</dt>
            #    <dd>
            #      If true, the client requesting the ads supports ads specified via
            #      general HTML (with rich media, Javascript, etc.).
            #    </dd>
            # 
            #  <dt>clientProperties</dt>
            #    <dd>
            #      If provided, this may contain a set of key/value pairs that identify
            #      the characteristics of a particular client that may be used to help
            #      determine appropriate ads for that client.  These tuples may be used
            #      either to reduce or increase the likelihood that each ad will be
            #      returned.
            #    </dd>
            # </dl>
            class AdParameters
              include ::Thrift::Struct, ::Thrift::Struct_Union
              CLIENTLANGUAGE = 2
              IMPRESSIONS = 4
              SUPPORTHTML = 5
              CLIENTPROPERTIES = 6

              FIELDS = {
                CLIENTLANGUAGE => {:type => ::Thrift::Types::STRING, :name => 'clientLanguage', :optional => true},
                IMPRESSIONS => {:type => ::Thrift::Types::LIST, :name => 'impressions', :element => {:type => ::Thrift::Types::STRUCT, :class => Evernote::EDAM::NoteStore::AdImpressions}, :optional => true},
                SUPPORTHTML => {:type => ::Thrift::Types::BOOL, :name => 'supportHtml', :optional => true},
                CLIENTPROPERTIES => {:type => ::Thrift::Types::MAP, :name => 'clientProperties', :key => {:type => ::Thrift::Types::STRING}, :value => {:type => ::Thrift::Types::STRING}, :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # Parameters that must be given to the NoteStore emailNote call. These allow
            # the caller to specify the note to send, the recipient addresses, etc.
            # 
            # <dl>
            #  <dt>guid</dt>
            #    <dd>
            #      If set, this must be the GUID of a note within the user's account that
            #      should be retrieved from the service and sent as email.  If not set,
            #      the 'note' field must be provided instead.
            #    </dd>
            # 
            #  <dt>note</dt>
            #    <dd>
            #      If the 'guid' field is not set, this field must be provided, including
            #      the full contents of the note note (and all of its Resources) to send.
            #      This can be used for a Note that as not been created in the service,
            #      for example by a local client with local notes.
            #    </dd>
            # 
            #  <dt>toAddresses</dt>
            #    <dd>
            #      If provided, this should contain a list of the SMTP email addresses
            #      that should be included in the "To:" line of the email.
            #      Callers must specify at least one "to" or "cc" email address.
            #    </dd>
            # 
            #  <dt>ccAddresses</dt>
            #    <dd>
            #      If provided, this should contain a list of the SMTP email addresses
            #      that should be included in the "Cc:" line of the email.
            #      Callers must specify at least one "to" or "cc" email address.
            #    </dd>
            # 
            #  <dt>subject</dt>
            #    <dd>
            #      If provided, this should contain the subject line of the email that
            #      will be sent.  If not provided, the title of the note will be used
            #      as the subject of the email.
            #    </dd>
            # 
            #  <dt>message</dt>
            #    <dd>
            #      If provided, this is additional personal text that should be included
            #      into the email as a message from the owner to the recipient(s).
            #    </dd>
            # </dl>
            class NoteEmailParameters
              include ::Thrift::Struct, ::Thrift::Struct_Union
              GUID = 1
              NOTE = 2
              TOADDRESSES = 3
              CCADDRESSES = 4
              SUBJECT = 5
              MESSAGE = 6

              FIELDS = {
                GUID => {:type => ::Thrift::Types::STRING, :name => 'guid', :optional => true},
                NOTE => {:type => ::Thrift::Types::STRUCT, :name => 'note', :class => Evernote::EDAM::Type::Note, :optional => true},
                TOADDRESSES => {:type => ::Thrift::Types::LIST, :name => 'toAddresses', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                CCADDRESSES => {:type => ::Thrift::Types::LIST, :name => 'ccAddresses', :element => {:type => ::Thrift::Types::STRING}, :optional => true},
                SUBJECT => {:type => ::Thrift::Types::STRING, :name => 'subject', :optional => true},
                MESSAGE => {:type => ::Thrift::Types::STRING, :name => 'message', :optional => true}
              }

              def struct_fields; FIELDS; end

              def validate
              end

              ::Thrift::Struct.generate_accessors self
            end

            # Identfying information about previous versions of a note that are backed up
            # within Evernote's servers.  Used in the return value of the listNoteVersions
            # call.
            # 
            # <dl>
            #  <dt>updateSequenceNum</dt>
            #  <dd>
            #    The update sequence number for the Note when it last had this content.
            #    This serves to uniquely identify each version of the note, since USN
            #    values are unique within an account for each update.
            #  </dd>
            #  <dt>updated</dt>
            #  <dd>
            #    The 'updated' time that was set on the Note when it had this version
            #    of the content.  This is the user-modifiable modification time on the
            #    note, so it's not reliable for guaranteeing the order of various
            #    versions.  (E.g. if someone modifies the note, then changes this time
            #    manually into the past and then updates the note again.)
            #  </dd>
            #  <dt>saved</dt>
            #  <dd>
            #    A timestamp that holds the date and time when this version of the note
            #    was backed up by Evernote's servers.  This
            #  </dd>
            #  <dt>title</dt>
            #  <dd>
            #    The title of the note when this particular verison was saved.  (The
            #    current title of the note may differ from this value.)
            #  </dd>
            # </dl>
            class NoteVersionId
              include ::Thrift::Struct, ::Thrift::Struct_Union
              UPDATESEQUENCENUM = 1
              UPDATED = 2
              SAVED = 3
              TITLE = 4

              FIELDS = {
                UPDATESEQUENCENUM => {:type => ::Thrift::Types::I32, :name => 'updateSequenceNum'},
                UPDATED => {:type => ::Thrift::Types::I64, :name => 'updated'},
                SAVED => {:type => ::Thrift::Types::I64, :name => 'saved'},
                TITLE => {:type => ::Thrift::Types::STRING, :name => 'title'}
              }

              def struct_fields; FIELDS; end

              def validate
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field updateSequenceNum is unset!') unless @updateSequenceNum
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field updated is unset!') unless @updated
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field saved is unset!') unless @saved
                raise ::Thrift::ProtocolException.new(::Thrift::ProtocolException::UNKNOWN, 'Required field title is unset!') unless @title
              end

              ::Thrift::Struct.generate_accessors self
            end

          end
        end
      end
