//Provides:caml_string_of_byte_string const
//Requires:MlString
function caml_string_of_byte_string (a) {
  return new MlString (a);
}

//Provides: caml_weak_create
function caml_weak_create (n) {
  var x = [0];
  x.length = n + 2;
  return x;
}
//Provides: caml_weak_set
function caml_weak_set(x, i, v) { x[i] = v; return 0; }
//Provides: caml_weak_get mutable
function caml_weak_get(x, i) { return (x[i]===undefined)?0:x[i]; }
//Provides: caml_weak_copy mutable
//Requires: caml_weak_get
function caml_weak_copy(x, i) {
  var y = caml_weak_get(x, i);
  if (y === 0) return y;
  var z = y[1];
  if (z instanceof Array && z[1] === (z[1]|0)) return [0, z.slice()];
  return y;
}
//Provides: caml_weak_check mutable
function caml_weak_check(x, i) { return x[i]!==undefined && x[i] !==0; }
//Provides: caml_weak_blit
function caml_weak_blit(s, i, d, j, l) {
  for (var k = 0; k < l; k++) d[j + k] = s[i + k];
  return 0;
}

// Unmarshall and unwrapping.

//Provides: caml_unwrap_value_from_string mutable
//Requires: caml_failwith, MlStringFromArray, caml_marshal_constants
//Requires: caml_int64_float_of_bits, caml_int64_of_bytes
var caml_unwrap_value_from_string = function (){
  function ArrayReader (a, i) { this.a = a; this.i = i; }
  ArrayReader.prototype = {
    read8u:function () { return this.a[this.i++]; },
    read8s:function () { return this.a[this.i++] << 24 >> 24; },
    read16u:function () {
      var a = this.a, i = this.i;
      this.i = i + 2;
      return (a[i] << 8) | a[i + 1]
    },
    read16s:function () {
      var a = this.a, i = this.i;
      this.i = i + 2;
      return (a[i] << 24 >> 16) | a[i + 1];
    },
    read32u:function () {
      var a = this.a, i = this.i;
      this.i = i + 4;
      return ((a[i] << 24) | (a[i+1] << 16) | (a[i+2] << 8) | a[i+3]) >>> 0;
    },
    read32s:function () {
      var a = this.a, i = this.i;
      this.i = i + 4;
      return (a[i] << 24) | (a[i+1] << 16) | (a[i+2] << 8) | a[i+3];
    },
    readstr:function (len) {
      var i = this.i;
      this.i = i + len;
      return new MlStringFromArray(this.a.slice(i, i + len));
    }
  }
  function StringReader (s, i) { this.s = s; this.i = i; }
  StringReader.prototype = {
    read8u:function () { return this.s.charCodeAt(this.i++); },
    read8s:function () { return this.s.charCodeAt(this.i++) << 24 >> 24; },
    read16u:function () {
      var s = this.s, i = this.i;
      this.i = i + 2;
      return (s.charCodeAt(i) << 8) | s.charCodeAt(i + 1)
    },
    read16s:function () {
      var s = this.s, i = this.i;
      this.i = i + 2;
      return (s.charCodeAt(i) << 24 >> 16) | s.charCodeAt(i + 1);
    },
    read32u:function () {
      var s = this.s, i = this.i;
      this.i = i + 4;
      return ((s.charCodeAt(i) << 24) | (s.charCodeAt(i+1) << 16) |
              (s.charCodeAt(i+2) << 8) | s.charCodeAt(i+3)) >>> 0;
    },
    read32s:function () {
      var s = this.s, i = this.i;
      this.i = i + 4;
      return (s.charCodeAt(i) << 24) | (s.charCodeAt(i+1) << 16) |
             (s.charCodeAt(i+2) << 8) | s.charCodeAt(i+3);
    },
    readstr:function (len) {
      var i = this.i;
      this.i = i + len;
      return new MlString(this.s.substring(i, i + len));
    }
  }
  function caml_float_of_bytes (a) {
    return caml_int64_float_of_bits (caml_int64_of_bytes (a));
  }
  var late_unwrap_mark = "late_unwrap_mark";
  return function (apply_unwrapper, register_late_occurrence, s, ofs) {
    var reader = s.array?new ArrayReader (s.array, ofs):
                         new StringReader (s.getFullBytes(), ofs);
    var magic = reader.read32u ();
    var block_len = reader.read32u ();
    var num_objects = reader.read32u ();
    var size_32 = reader.read32u ();
    var size_64 = reader.read32u ();
    var stack = [];
    var intern_obj_table = new Array(num_objects+1);
    var obj_counter = 1;
    intern_obj_table[0] = [];
    function intern_rec () {
      var cst = caml_marshal_constants;
      var code = reader.read8u ();
      if (code >= cst.PREFIX_SMALL_INT) {
        if (code >= cst.PREFIX_SMALL_BLOCK) {
          var tag = code & 0xF;
          var size = (code >> 4) & 0x7;
          var v = [tag];
          if (size == 0) return v;
	  intern_obj_table[obj_counter] = v;
          stack.push(obj_counter++, size);
          return v;
        } else
          return (code & 0x3F);
      } else {
        if (code >= cst.PREFIX_SMALL_STRING) {
          var len = code & 0x1F;
          var v = reader.readstr (len);
          intern_obj_table[obj_counter++] = v;
          return v;
        } else {
          switch(code) {
          case cst.CODE_INT8:
            return reader.read8s ();
          case cst.CODE_INT16:
            return reader.read16s ();
          case cst.CODE_INT32:
            return reader.read32s ();
          case cst.CODE_INT64:
            caml_failwith("unwrap_value: integer too large");
            break;
          case cst.CODE_SHARED8:
            var ofs = reader.read8u ();
            return intern_obj_table[obj_counter - ofs];
          case cst.CODE_SHARED16:
            var ofs = reader.read16u ();
            return intern_obj_table[obj_counter - ofs];
          case cst.CODE_SHARED32:
            var ofs = reader.read32u ();
            return intern_obj_table[obj_counter - ofs];
          case cst.CODE_BLOCK32:
            var header = reader.read32u ();
            var tag = header & 0xFF;
            var size = header >> 10;
            var v = [tag];
            if (size == 0) return v;
	    intern_obj_table[obj_counter] = v;
            stack.push(obj_counter++, size);
            return v;
          case cst.CODE_BLOCK64:
            caml_failwith ("unwrap_value: data block too large");
            break;
          case cst.CODE_STRING8:
            var len = reader.read8u();
            var v = reader.readstr (len);
            intern_obj_table[obj_counter++] = v;
            return v;
          case cst.CODE_STRING32:
            var len = reader.read32u();
            var v = reader.readstr (len);
            intern_obj_table[obj_counter++] = v;
            return v;
          case cst.CODE_DOUBLE_LITTLE:
            var t = [];
            for (var i = 0;i < 8;i++) t[7 - i] = reader.read8u ();
            var v = caml_float_of_bytes (t);
            intern_obj_table[obj_counter++] = v;
            return v;
          case cst.CODE_DOUBLE_BIG:
            var t = [];
            for (var i = 0;i < 8;i++) t[i] = reader.read8u ();
            var v = caml_float_of_bytes (t);
            intern_obj_table[obj_counter++] = v;
            return v;
          case cst.CODE_DOUBLE_ARRAY8_LITTLE:
            var len = reader.read8u();
            var v = [0];
            intern_obj_table[obj_counter++] = v;
            for (var i = 1;i <= len;i++) {
              var t = [];
              for (var j = 0;j < 8;j++) t[7 - j] = reader.read8u();
              v[i] = caml_float_of_bytes (t);
            }
            return v;
          case cst.CODE_DOUBLE_ARRAY8_BIG:
            var len = reader.read8u();
            var v = [0];
            intern_obj_table[obj_counter++] = v;
            for (var i = 1;i <= len;i++) {
              var t = [];
              for (var j = 0;j < 8;j++) t[j] = reader.read8u();
              v [i] = caml_float_of_bytes (t);
            }
            return v;
          case cst.CODE_DOUBLE_ARRAY32_LITTLE:
            var len = reader.read32u();
            var v = [0];
            intern_obj_table[obj_counter++] = v;
            for (var i = 1;i <= len;i++) {
              var t = [];
              for (var j = 0;j < 8;j++) t[7 - j] = reader.read8u();
              v[i] = caml_float_of_bytes (t);
            }
            return v;
          case cst.CODE_DOUBLE_ARRAY32_BIG:
            var len = reader.read32u();
            var v = [0];
            for (var i = 1;i <= len;i++) {
              var t = [];
              for (var j = 0;j < 8;j++) t[j] = reader.read8u();
              v [i] = caml_float_of_bytes (t);
            }
            return v;
          case cst.CODE_CODEPOINTER:
          case cst.CODE_INFIXPOINTER:
            caml_failwith ("unwrap_value: code pointer");
            break;
          case cst.CODE_CUSTOM:
            var c, s = "";
            while ((c = reader.read8u ()) != 0) s += String.fromCharCode (c);
            switch(s) {
            case "_j":
              // Int64
              var t = [];
              for (var j = 0;j < 8;j++) t[j] = reader.read8u();
              var v = caml_int64_of_bytes (t);
              if (intern_obj_table) intern_obj_table[obj_counter++] = v;
              return v;
            case "_i":
              // Int32
              var v = reader.read32s ();
              if (intern_obj_table) intern_obj_table[obj_counter++] = v;
              return v;
            default:
              caml_failwith("input_value: unknown custom block identifier");
            }
          default:
            caml_failwith ("unwrap_value: ill-formed message");
          }
        }
      }
    }
    stack.push(0,0);
    while (stack.length > 0) {
      var size = stack.pop();
      var ofs = stack.pop();
      var v = intern_obj_table[ofs];
      var d = v.length;
      if (size + 1 == d) {
        var ancestor = intern_obj_table[stack[stack.length-2]];
        // See Eliom_wrap.ml.
        if (v[0] === 0 && size >= 2 && v[size][2] === intern_obj_table[2]) {
          var unwrapped_v = apply_unwrapper(v[size], v);
          if (unwrapped_v === 0) {
            // No unwrapper is registered, so replace the unwrap
            // marker v[size] by a late_unwrap marker
            //   (unwrapper_id, "late_unwrap_mark")
            v[size] = [0, v[size][1], late_unwrap_mark];
            // And register an occurrence in ancestor
            register_late_occurrence(ancestor, ancestor.length-1, v, v[size][1]);
          } else {
            v = unwrapped_v[1];
          }
          intern_obj_table[ofs] = v;
	  ancestor[ancestor.length-1] = v;
        }
        continue;
      }
      stack.push(ofs, size);
      v[d] = intern_rec ();
      // If the value v[d] is marked for late unwrapping, register an
      // occurrence of it in v.
      if (v[d][0] === 0 && v[d].length >= 2 && v[d][v[d].length-1][2] == late_unwrap_mark) {
        register_late_occurrence(v, d, v[d],   v[d][v[d].length-1][1]);
      }
    }
    s.offset = reader.i;
    if(intern_obj_table[0][0].length != 3)
      caml_failwith ("unwrap_value: incorrect value");
    return intern_obj_table[0][0][2];
  }
}();

