#! /bin/bash

DIMENSIONS=$(xdpyinfo -ext all | sed -ne 's/  dimensions: *\([^ ]*\).*/\1/p')

#If ETERM_BIN is set (by the user), use that. Otherwise, look in the
#standard Debian location, and, finally, see if which knows where
#Eterm is

if [ -z "$ETERM_BIN" ] ; then
  if [ -x /usr/bin/Eterm ] ; then
    ETERM_BIN=/usr/bin/Eterm
  elif which Eterm ; then
    ETERM_BIN=$(which Eterm)
  fi
fi

if [ -x "$ETERM_BIN" ] ; then
#	$ETERM_BIN -g $DIMENSIONS+0+0 -e ./eterm.sh
	$ETERM_BIN  -n 'Debian - Is your distribution this big?' -P /usr/share/debroster/openlogo1.jpg@:s -f black -F '-*-courier-*-*-*-*-*-200-*-*-*-*-utf-8'  -c white -e /usr/share/debroster/dr.sh
elif [ -x /usr/bin/xterm ]; then
#    echo no eterm
    /usr/bin/xterm +bc -cr white +j -ms white +s +sb +si -wf -title 'Debian - Is your distribution this big?' -fn '-*-courier-*-*-*-*-*-200-*-*-*-*-utf-8' -e /usr/share/debroster/dr.sh
else
    echo "No valid terminal application!!"
fi

exit 0
