#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "dependency_alternative_list.hpp"

#include <sstream>

dependency_alternative_list &dependency_alternative_list::operator=(std::string const &str)
{
	clear();
	std::istringstream stream(str);
	for(std::string i; getline(stream, i, '|');)
		push_back(dependency(i));
	return *this;
}

dependency_alternative_list::operator std::string(void) const
{
	std::ostringstream str;
	const_iterator i = begin();
	while(i != end())
	{
		str << *i;
		++i;
		if(i != end())
			str << " | ";
	}
	return str.str();
}

dependency_alternative_list &dependency_alternative_list::operator+=(dependency_alternative_list const &rhs)
{
	insert(end(), rhs.begin(), rhs.end());
	return *this;
}
