% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dbSendQuery}
\alias{dbSendQuery}
\title{Execute a statement on a given database connection.}
\usage{
dbSendQuery(conn, statement, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{statement}{a character vector of length 1 containing SQL.}

\item{...}{Other parameters passed on to methods.}
}
\value{
An object that inherits from \code{\linkS4class{DBIResult}}.
  If the statement generates output (e.g., a \code{SELECT} statement) the
  result set can be used with \code{\link{fetch}} to extract records.
}
\description{
The function \code{dbSendQuery} only submits and synchronously executes the
SQL statement to the database engine.  It does \emph{not} extracts any
records --- for that you need to use the function \code{\link{dbFetch}}, and
then you must call \code{\link{dbClearResult}} when you finish fetching the
records you need.
}
\section{Side Effects}{

The statement is submitted for synchronous execution to the server connected
through the \code{conn} object.  The DBMS executes the statement, possibly
generating vast amounts of data.  Where these data reside is driver-specific:
some drivers may choose to leave the output on the server and transfer them
piecemeal to R, others may transfer all the data to the client -- but not
necessarily to the memory that R manages.  See the individual drivers'
\code{\link{dbSendQuery}} method for implementation details.
}
\examples{
if (require("RSQLite")) {
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
res <- dbSendQuery(con, "SELECT * FROM mtcars WHERE cyl = 4;")
dbFetch(res)
dbClearResult(res)

dbDisconnect(con)
}
}
\seealso{
Other connection methods: \code{\link{dbDisconnect}};
  \code{\link{dbExistsTable}};
  \code{\link{dbGetException}}; \code{\link{dbGetQuery}},
  \code{\link{dbGetQuery,DBIConnection,character-method}};
  \code{\link{dbListFields}}; \code{\link{dbListResults}};
  \code{\link{dbListTables}}; \code{\link{dbReadTable}},
  \code{\link{dbWriteTable}}; \code{\link{dbRemoveTable}}
}

