/*
 * symboltable.cpp
 * Copyright (c) 2009 kbinani
 *
 * This file is part of utauvsti
 *
 * utauvsti is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * utauvsti is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
#include "symboltable.h"

string symboltable_attatch( string symbol ){
    const int TLEN = 149;
    static const string TABLE[TLEN][2] = { { "a", "" },
                                { "i", "" },
                                { "M", "" },
                                { "e", "" },
                                { "o", "" },
                                { "ka", "" },
                                { "k'i", "" },
                                { "kM", "" },
                                { "ke", "" },
                                { "ko", "" },
                                { "sa", "" },
                                { "Si", "" },
                                { "sM", "" },
                                { "se", "" },
                                { "so", "" },
                                { "ta", "" },
                                { "tSi", "" },
                                { "tsM", "" },
                                { "te", "" },
                                { "to", "" },
                                { "na", "" },
                                { "Ji", "" },
                                { "nM", "" },
                                { "ne", "" },
                                { "no", "" },
                                { "ha", "" },
                                { "Ci", "" },
                                { "p\\M", "" },
                                { "he", "" },
                                { "ho", "" },
                                { "ma", "" },
                                { "m'i", "" },
                                { "mM", "" },
                                { "me", "" },
                                { "mo", "" },
                                { "ja", "" },
                                { "jM", "" },
                                { "jo", "" },
                                { "4a", "" },
                                { "4'i", "" },
                                { "4M", "" },
                                { "4e", "" },
                                { "4o", "" },
                                { "wa", "" },
                                { "wi", "" },
                                { "we", "" },
                                { "o", "" },
                                { "a", "" },
                                { "i", "" },
                                { "M", "" },
                                { "e", "" },
                                { "o", "" },
                                { "ga", "" },
                                { "g'i", "" },
                                { "gM", "" },
                                { "ge", "" },
                                { "go", "" },
                                { "dza", "" },
                                { "dZi", "" },
                                { "dzM", "" },
                                { "dze", "" },
                                { "dzo", "" },
                                { "da", "" },
                                { "dZi", "" },
                                { "dzM", "" },
                                { "de", "" },
                                { "do", "" },
                                { "ba", "" },
                                { "b'i", "" },
                                { "bM", "" },
                                { "be", "" },
                                { "bo", "" },
                                { "pa", "" },
                                { "p'i", "" },
                                { "pM", "" },
                                { "pe", "" },
                                { "po", "" },
                                { "je", "" },
                                { "wi", "" },
                                { "we", "" },
                                { "wo", "" },
                                { "k'a", "" },
                                { "k'M", "" },
                                { "k'e", "" },
                                { "k'o", "" },
                                { "Sa", "" },
                                { "SM", "" },
                                { "Se", "" },
                                { "So", "" },
                                { "tSa", "" },
                                { "tSM", "" },
                                { "tSe", "" },
                                { "tSo", "" },
                                { "Ja", "ɂ" },
                                { "JM", "ɂ" },
                                { "Je", "ɂ" },
                                { "Jo", "ɂ" },
                                { "Ca", "Ђ" },
                                { "CM", "Ђ" },
                                { "Ce", "Ђ" },
                                { "Co", "Ђ" },
                                { "p\\'a", "ӂ" },
                                { "p\\'i", "ӂ" },
                                { "p\\'M", "ӂ" },
                                { "p\\e", "ӂ" },
                                { "m'a", "݂" },
                                { "m'M", "݂" },
                                { "m'e", "݂" },
                                { "m'o", "݂" },
                                { "4'a", "" },
                                { "4'M", "" },
                                { "4'e", "肥" },
                                { "4'o", "" },
                                { "g'a", "" },
                                { "g'M", "" },
                                { "g'e", "" },
                                { "g'o", "" },
                                { "dZa", "" },
                                { "dZM", "" },
                                { "dZe", "" },
                                { "dZo", "" },
                                { "b'a", "т" },
                                { "b'M", "т" },
                                { "b'e", "т" },
                                { "b'o", "т" },
                                { "p'a", "҂" },
                                { "p'M", "҂" },
                                { "p'e", "҂" },
                                { "p'o", "҂" },
                                { "p\\a", "ӂ" },
                                { "p\\o", "ӂ" },
                                { "t'a", "Ă" },
                                { "t'i", "Ă" },
                                { "t'M", "Ă" },
                                { "t'e", "Ă" },
                                { "t'o", "Ă" },
                                { "d'a", "ł" },
                                { "d'i", "ł" },
                                { "d'M", "ł" },
                                { "d'e", "ł" },
                                { "d'o", "ł" },
                                { "si", "" },
                                { "dzi", "" },
                                { "tM", "Ƃ" },
                                { "dM", "ǂ" },
                                { "ja", "" },
                                { "jM", "" },
                                { "jo", "" },
                                { "n", "" },
    };

    for( int i = 0; i < TLEN; i++ ){
        if( symbol == TABLE[i][0] ){
            return TABLE[i][1];
        }
    }
    return symbol;
}
