+++
title = "PlatonicOctahedron"
+++

### PlatonicOctahedron

A regular octahedron.

<img src="https://upload.wikimedia.org/wikipedia/commons/f/f1/Uniform_polyhedron-43-t2.png" width="30%" >

<!--
<img src="../3d/PlatonicOctahedron.png" width="30%">
<img src="../cut/PlatonicOctahedron_xy.svg" width="30%">
<img src="../cut/PlatonicOctahedron_xz.svg" width="30%">
-->
#### Constructor

```python
PlatonicOctahedron(L)
```

Parameters:
- L, length of the edge

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class [PlatonicOctahedron]({{% url-src %}}/Sample/HardParticle/Polyhedra.h) inherits from the interface class
{{% ref-class "Sample/Particle" "IFormfactor" %}}.

Form factor computation is based on the generic form factor of a polyhedron provided by {{% link-libformfactor %}}.

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormfactorBasicTest.cpp)
against
$$ V= \dfrac{\sqrt{2}}{3}L^3. $$

#### Related shapes

More general:
- [Bipyramid4](/ref/sample/particle/ff/hard/bipyramid4), if not regular and/or truncated.

#### Example

Scattering by uncorrelated, oriented octahedra for horizontal incidence:

<img src="/img/auto/ff/PlatonicOctahedron.png">

Generated by {{% ref-ex "ff/PlatonicOctahedron.py" %}}.

#### History

Introduced in BornAgain 1.20.
