## BornAgain Python user reference {#mainpage}

Python user reference of <a href="http://www.bornagainproject.org">BornAgain Project</a>,
 an open-source software to simulate and fit
 neutron and x-ray reflectometry and grazing-incidence small-angle scattering.


<div>

Here is a list of classes grouped in several categories to create the sample, describe scattering geometry, run the simulation and perform fitting.

<ul>
<li> \ref simulation "ISimulation" <br>
List of classes to run simulations
     <ul>
     <li> \ref beam "Beam" <br>
          List of classes to describe the beam, and its footprint in the sample plane
     <li> \ref detector "Detector" <br>
          List of classes to describe detectors
          <ul>
               <li> \ref mask "Detector masks"
          </ul>
     </ul>
<li> \ref samples "Samples" <br>
List of classes to describe scattering sample
<li> \ref materials "Materials" <br>
Classes to describe magnetic and non-magnetic materials
<li> \ref formfactors "Form factors" <br>
List of form factors available
     <ul>
     <li> \ref hardParticle "Hard particles"<br>Three-dimenensional particle shapes
     <li> \ref softParticle "Soft particles"<br>Three-dimenensional particle models with smoothly decaying scattering-length distribution
     <li> \ref legacyGrating "Ripples"<br>Ripples, for modelling gratings
     </ul>
<li> \ref distribution "Distribution, decay, and interference functions"<br>
     <ul>
     <li> \ref interference "Interference functions"
     <li> \ref decayFT "Fourier-space decay functions"
     <li> \ref distributionFT  "Fourier-space distribution functions"
     <li> \ref paramDistribution "Parameter distributions"
     </ul>
<li> \ref tools "Tools" <br>
Different tools mainly to deal with intensity data
<li> \ref input_output "Input and output" <br>
Various routines to write intensity data on disk and to import user data.
<li> \ref fitting "Fitting" <br>
Fitting routines
</ul>
<br>

Here is a list of additional classes from internal API.
<ul>
<li> \ref simulation_internal "ISimulation and instrument internals" <br>
<li> \ref samples_internal "Samples internals" <br>
<li> \ref materials_internal "Materials internals" <br>
<li> \ref formfactors_internal "Form factors internals" <br>
<li> \ref distribution_internal "Distribution function internals"
<li> \ref tools_internal "Tools internals" <br>
<li> \ref fitting_internal "Fitting internals" <br>
</ul>

</div>

### See also

* <https://bornagainproject.org>, project homepage;
* <https://github.com/scgmlz/BornAgain>, source repository;

### License

[GNU General Public License v3 or higher](https://github.com/scgmlz/BornAgain/blob/master/COPYING)

Copyright Forschungszentrum Jülich GmbH 2015-


### Authors

Scientific Computing Group at MLZ Garching.

See file [AUTHORS](https://github.com/scgmlz/BornAgain/blob/master/AUTHORS).

### Citation

See file [CITATION](https://github.com/scgmlz/BornAgain/blob/master/CITATION).
