# -*- coding: utf-8 -*-
# Balazar in the Rancid Skull Dungeon
# Copyright (C) 2008 Jean-Baptiste LAMY
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os, sys, cPickle, time
import cerealizer
import soya
import PIL, PIL.Image
import balazar3, balazar3.rooms, balazar3.driver_3d

extra_code   = u""

room_names = []
i = 1
while i < len(sys.argv):
  if   sys.argv[i] == "--path"        : i += 1; soya.path.append(sys.argv[i])
  elif sys.argv[i] == "--room"        : i += 1; room_names.append(sys.argv[i])
  elif sys.argv[i] == "--extra-code"  : i += 1; extra_code = sys.argv[i]
  i += 1

soya.path.append("./balazar3")
soya.set_file_format(cerealizer, [cerealizer, cPickle])
soya.init(width = 640 * 2, height = 480 * 2)
soya.set_quality(2)

if not room_names:
  for filename in os.listdir("./balazar3/rooms"):
    if filename.startswith("room_") and filename.endswith(".py"):
      room_names.append(filename[5:-3])

for room_name in room_names:
  room = balazar3.rooms.Room.get(room_name)

  scene = soya.World()
  scene.atmosphere = soya.Atmosphere()
  scene.atmosphere.ambient = (0.3, 0.3, 0.3, 1.0)

  level = soya.World(scene)
  #body.model = soya.Model.get(room.get_model_name())
  balazar3.driver_3d.build_level_world(level, room)

  camera = soya.Camera(scene)
  f = 1.3
  camera.set_xyz(0.0, 3.5 * f, 2.5 * f)
  camera.look_at(soya.Point(level, 0.0, 0.0, 0.0))

  light = soya.Light(scene)
  light.set_xyz(-2.0, 4.0, 1.0)

  main_loop = soya.MainLoop(scene)
  soya.set_root_widget(camera)
  exec extra_code


  soya.render()
  shot = soya.screenshot()
  shot = shot.resize((640, 480), 1)
  shot.save("./balazar3/room_shots/room_%s.jpeg" % room.name)

  #import time; time.sleep(100)

