/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.constant;

import java.io.DataOutput;
import java.io.IOException;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.constant.ConstantClassInfo;
import org.cojen.classfile.constant.ConstantNameAndTypeInfo;

public class ConstantInterfaceMethodInfo
extends ConstantInfo {
    private final ConstantClassInfo mParentClass;
    private final ConstantNameAndTypeInfo mNameAndType;

    public ConstantInterfaceMethodInfo(ConstantClassInfo parentClass, ConstantNameAndTypeInfo nameAndType) {
        super(11);
        this.mParentClass = parentClass;
        this.mNameAndType = nameAndType;
    }

    public ConstantClassInfo getParentClass() {
        return this.mParentClass;
    }

    public ConstantNameAndTypeInfo getNameAndType() {
        return this.mNameAndType;
    }

    public int hashCode() {
        return this.mNameAndType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstantInterfaceMethodInfo) {
            ConstantInterfaceMethodInfo other = (ConstantInterfaceMethodInfo)obj;
            return this.mParentClass.equals(other.mParentClass) && this.mNameAndType.equals(other.mNameAndType);
        }
        return false;
    }

    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeShort(this.mParentClass.getIndex());
        dout.writeShort(this.mNameAndType.getIndex());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("CONSTANT_InterfaceMethodref_info: ");
        buf.append(this.getParentClass().getType().getFullName());
        ConstantNameAndTypeInfo cnati = this.getNameAndType();
        buf.append(' ');
        buf.append(cnati.getName());
        buf.append(' ');
        buf.append(cnati.getType());
        return buf.toString();
    }
}

