/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class ValueOf
extends SimpleNodeConstructor {
    private int options;

    public ValueOf(Expression expression, boolean bl) {
        this.select = expression;
        this.options = bl ? 1 : 0;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("value-of");
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.select.promote(promotionOffer);
        }
        if (this.separator != null) {
            this.separator = this.separator.promote(promotionOffer);
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof ExprInstruction) {
                    Expression expression = ((ExprInstruction)this.children[n]).promote(promotionOffer);
                    this.children[n] = expression instanceof Instruction ? (Instruction)((Object)expression) : new Sequence(expression, null);
                } else {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                ++n;
            }
        }
    }

    public SequenceType getResultType() {
        return new SequenceType(NodeKindTest.TEXT, 512);
    }

    public void typeCheck(StaticContext staticContext) throws XPathException {
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        SequenceReceiver sequenceReceiver = xPathContext.getController().getReceiver();
        sequenceReceiver.characters(this.expandChildren(xPathContext), this.options);
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            CharSequence charSequence = this.expandChildren(xPathContext);
            Orphan orphan = new Orphan(xPathContext.getController().getNamePool());
            orphan.setNodeKind((short)3);
            orphan.setStringValue(charSequence);
            return orphan;
        }
        catch (TransformerException transformerException) {
            throw new XPathException.Dynamic(transformerException);
        }
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "value-of");
        this.select.display(n + 1, namePool);
    }
}

