/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.tool.re;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.jiapi.reflect.BasicBlock;
import net.sf.jiapi.reflect.BranchInstruction;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.SwitchInstruction;
import net.sf.jiapi.reflect.instruction.ReturnInstruction;
import net.sf.jiapi.tool.re.Loop;
import net.sf.jiapi.tool.re.Node;

public class ControlFlowGraph {
    private Map<Instruction, Node> nodes = new HashMap<Instruction, Node>();
    private Set<Node> allNodes = new HashSet<Node>();
    private final Node root;
    private Map<Node, Loop> loops = new HashMap<Node, Loop>();

    public ControlFlowGraph(List<BasicBlock> bbList) {
        Iterator<BasicBlock> iterator = bbList.iterator();
        this.root = new Node(iterator.next());
        this.nodes.put(this.root.getBasicBlock().getFirstInstruction(), this.root);
        this.allNodes.add(this.root);
        this.allNodes.add(Node.EXIT_NODE);
        while (iterator.hasNext()) {
            BasicBlock bb = iterator.next();
            Node n = new Node(bb);
            this.nodes.put(bb.getFirstInstruction(), n);
            this.allNodes.add(n);
        }
        for (Map.Entry<Instruction, Node> e : this.nodes.entrySet()) {
            Node node = e.getValue();
            BasicBlock bb = node.getBasicBlock();
            Instruction lastIns = bb.getLastInstruction();
            if (lastIns instanceof BranchInstruction) {
                BranchInstruction bIns = (BranchInstruction)lastIns;
                Instruction target = bIns.getTarget();
                Node targetNode = this.nodes.get(target);
                targetNode.addPredessor(node);
                node.addSuccessor(targetNode);
            } else if (!(lastIns instanceof SwitchInstruction) && lastIns instanceof ReturnInstruction) {
                node.addSuccessor(Node.EXIT_NODE);
            }
            if (bb.getNextInstruction() == null) continue;
            Node fallThroughNode = this.nodes.get(bb.getNextInstruction());
            fallThroughNode.addPredessor(node);
            node.addSuccessor(fallThroughNode);
        }
        this.computeDominators();
        this.computePostDominators();
        this.computeNaturalLoops();
    }

    public List<Loop> getLoopList() {
        LinkedList<Loop> loopList = new LinkedList<Loop>();
        for (Map.Entry<Node, Loop> e : this.loops.entrySet()) {
            loopList.add(e.getValue());
        }
        return loopList;
    }

    public Map<Node, Loop> getLoops() {
        return this.loops;
    }

    public Node getRootNode() {
        return this.root;
    }

    public void visitNodes(Visitor v) {
        this.visitNodes(v, this.root);
    }

    public void visitNodes(Visitor v, Node node) {
        if (Node.EXIT_NODE.equals(node)) {
            return;
        }
        v.visit(node);
        Set<Node> directSuccessors = node.getSuccessors();
        for (Node n : directSuccessors) {
            this.visitNodes(v, n);
        }
    }

    private void computeDominators() {
        for (Map.Entry<Instruction, Node> e : this.nodes.entrySet()) {
            Node node = e.getValue();
            node.initDominators(this.allNodes);
        }
        this.root.getDominators().clear();
        this.root.getDominators().add(this.root);
        boolean changed = false;
        do {
            changed = false;
            for (Map.Entry<Instruction, Node> e : this.nodes.entrySet()) {
                Node node = e.getValue();
                if (node.equals(this.root)) continue;
                HashSet<Node> t = new HashSet<Node>();
                for (Node pred : node.getPredessors()) {
                    t.addAll(node.getDominators());
                    node.getDominators().retainAll(pred.getDominators());
                    node.getDominators().add(node);
                    if (node.getDominators().equals(t)) continue;
                    changed = true;
                }
            }
        } while (changed);
    }

    private void computePostDominators() {
        for (Map.Entry<Instruction, Node> e : this.nodes.entrySet()) {
            Node node = e.getValue();
            node.initPostDominators(this.allNodes);
        }
        Node.EXIT_NODE.getPostDominators().clear();
        Node.EXIT_NODE.getPostDominators().add(Node.EXIT_NODE);
        boolean changed = false;
        do {
            changed = false;
            for (Map.Entry<Instruction, Node> e : this.nodes.entrySet()) {
                Node node = e.getValue();
                if (node.equals(Node.EXIT_NODE)) continue;
                HashSet<Node> t = new HashSet<Node>();
                for (Node succ : node.getSuccessors()) {
                    t.addAll(node.getPostDominators());
                    node.getPostDominators().retainAll(succ.getPostDominators());
                    node.getPostDominators().add(node);
                    if (node.getPostDominators().equals(t)) continue;
                    changed = true;
                }
            }
        } while (changed);
    }

    private void computeNaturalLoops() {
        for (Map.Entry<Instruction, Node> e : this.nodes.entrySet()) {
            Node node = e.getValue();
            for (Node succ : node.getSuccessors()) {
                if (!node.getDominators().contains(succ)) continue;
                Loop loop = this.naturalLoopforEdge(succ, node);
                this.loops.put(succ, loop);
            }
        }
    }

    private Loop naturalLoopforEdge(Node header, Node tail) {
        Stack<Node> workList = new Stack<Node>();
        Loop loop = new Loop(header, tail);
        loop.addNode(header);
        if (!header.equals(tail)) {
            loop.addNode(tail);
            workList.push(tail);
        }
        while (!workList.isEmpty()) {
            Node node = (Node)workList.pop();
            for (Node pred : node.getPredessors()) {
                if (loop.contains(pred)) continue;
                loop.addNode(pred);
                workList.push(pred);
            }
        }
        return loop;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ControlFlowGraph:\n");
        ArrayList<Node> nodeList = new ArrayList<Node>();
        for (Map.Entry<Instruction, Node> e : this.nodes.entrySet()) {
            nodeList.add(e.getValue());
        }
        Collections.sort(nodeList, new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                return o1.getId() - o2.getId();
            }
        });
        for (Node n : nodeList) {
            sb.append(n);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static interface Visitor {
        public void visit(Node var1);
    }
}

