/*
 * Decompiled with CFR 0.152.
 */
package com.claritysys.jvm.classfile;

import com.claritysys.jvm.classfile.CfEntry;
import com.claritysys.jvm.classfile.ClassFile;
import com.claritysys.jvm.classfile.ClassFileFormatException;
import com.claritysys.jvm.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class CfFieldOrMethod
extends CfEntry {
    ClassFile classFile;
    int nameIndex;
    int descriptorIndex;
    boolean synthetic;

    public CfFieldOrMethod(ClassFile classFile) {
        this.classFile = classFile;
    }

    public void read(DataInputStream dataIn) throws IOException, ClassFileFormatException {
        this.setAccessFlags(dataIn.readUnsignedShort());
        this.nameIndex = dataIn.readUnsignedShort();
        this.descriptorIndex = dataIn.readUnsignedShort();
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeShort(this.getAccessFlags());
        dout.writeShort(this.nameIndex);
        dout.writeShort(this.descriptorIndex);
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public ConstantPool getConstantPool() {
        return this.classFile.getConstantPool();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public String getName() {
        return this.getConstantPool().getUtf8AsString(this.nameIndex);
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public void setDescriptorIndex(int descriptorIndex) {
        this.descriptorIndex = descriptorIndex;
    }

    public String getSignature() {
        return this.getConstantPool().getUtf8AsString(this.descriptorIndex);
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }
}

